
import Component from '@glimmer/component';
import { HdsApplicationState, HdsBadge, HdsTextBody, HdsCardContainer } from '@hashicorp/design-system-components/components';
import TitleRow from './base/title-row.js';
import { htmlSafe } from '@ember/template';
import { eq } from '../../utils/helpers.js';
import { precompileTemplate } from '@ember/template-compilation';
import { setComponentTemplate } from '@ember/component';

/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */
class SecretsSync extends Component {
  get hasData() {
    return this.args.totalDestinations > 0;
  }
  get description() {
    if (this.hasData) {
      return htmlSafe('Total number of destinations (e.g. third-party integrations) synced with secrets ');
    }
  }
  get linkRoute() {
    if (this.hasData) {
      return 'vault.cluster.sync';
    }
  }
  get totalDestinations() {
    return this.args.totalDestinations || 0;
  }
  get destinationsList() {
    const destinations = this.args.destinations || {};
    return Object.entries(destinations).map(([name, count]) => ({
      name,
      count
    }));
  }
  static {
    setComponentTemplate(precompileTemplate("\n    <HdsCardContainer data-test-vault-reporting-secrets-sync @hasBorder={{true}} class=\"ssu-secrets-sync\" ...attributes>\n      <TitleRow @title=\"Secrets sync\" @description={{this.description}} @linkRoute={{this.linkRoute}} />\n\n      {{#if this.hasData}}\n        <HdsTextBody @size=\"300\" data-test-vault-reporting-secrets-sync-destinations-row>\n          {{this.totalDestinations}}\n          {{if (eq this.totalDestinations 1) \"Destination\" \"Destinations\"}}\n          {{#each this.destinationsList as |destination|}}\n            <HdsBadge class=\"ssu-secrets-sync__badge\" data-test-vault-reporting-secrets-sync-destinations-badge @type=\"outlined\" @size=\"small\" @text=\"{{destination.name}}: {{destination.count}}\" />\n          {{/each}}\n        </HdsTextBody>\n\n      {{else}}\n        <HdsApplicationState data-test-vault-reporting-secrets-sync-empty-state class=\"ssu-secrets-sync__empty-state\" as |A|>\n          {{#if (has-block \"empty\")}}\n            {{yield A to=\"empty\"}}\n          {{else}}\n            <A.Body data-test-vault-reporting-secrets-sync-empty-state-description @text=\"An Enterprise feature that automatically replicates secrets to third-party integrations. It is recommended so organizations can remain consistent with their existing operations.\" />\n\n            <A.Footer as |F|>\n              <F.LinkStandalone data-test-vault-reporting-secrets-sync-empty-state-link @icon=\"docs-link\" @iconPosition=\"trailing\" @text=\"Secrets sync\" @href=\"https://developer.hashicorp.com/vault/docs/sync\" target=\"_blank\" />\n            </A.Footer>\n          {{/if}}\n        </HdsApplicationState>\n      {{/if}}\n\n    </HdsCardContainer>\n  ", {
      strictMode: true,
      scope: () => ({
        HdsCardContainer,
        TitleRow,
        HdsTextBody,
        eq,
        HdsBadge,
        HdsApplicationState
      })
    }), this);
  }
}

export { SecretsSync as default };
//# sourceMappingURL=secrets-sync.js.map
