import type RouterService from '@ember/routing/router-service';
/**
 * Returns a route name that is safe to use with @route.
 * - If the provided route exists, returns it.
 * - If it does not exist, returns the fallback.
 * - If route is undefined/empty, returns undefined.
 *
 * NOTE: The links will render but they won't actually work within this repo. This is
 * intentional so that design/layout can be validated without running into errors.
 */
export declare function safeRoute(router: RouterService, route: string | undefined, fallback?: string): string | undefined;
export default safeRoute;
