/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */
import { type HdsTableColumn } from '@hashicorp/design-system-components/components';
import { type FilterFieldDefinition } from './filter-bar';
import './inventory-table.scss';
import Component from '@glimmer/component';
import { type Filter } from '../../utils/filters.ts';
import type RouterService from '@ember/routing/router-service';
import type ReportingAnalytics from '../../services/reporting-analytics.ts';
export type InventoryTableColumn = HdsTableColumn & {
    key: string;
    cellFormatter?: (data: Record<string, unknown>) => string;
    secondaryKey?: string;
    secondaryCellFormatter?: (data: Record<string, unknown>) => string;
    width?: `${number}px`;
    minWidth?: `${number}px`;
};
export type QuickFilter = {
    label: string;
    description?: string;
    getParams: () => {
        filters?: Filter[];
    };
    count?: number;
};
export interface InventoryTableSignature {
    Args: {
        onFilterApplied: (value: Filter[]) => void;
        onSortApplied: (sort: string[]) => void;
        onPageChange: (pagination: {
            next_page_token?: string;
            previous_page_token?: string;
            page_size: number;
        }) => void;
        onPageSizeChange?: (pageSize: number) => void;
        onColumnsChanged?: (visibleColumnKeys: string[]) => void;
        visibleColumnKeys?: string[];
        pageSize?: number;
        nextPageToken?: string;
        previousPageToken?: string;
        appliedFilters: Filter[];
        appliedSort: string[];
        filterFieldDefinitions: FilterFieldDefinition[];
        columns: InventoryTableColumn[];
        rows: Record<string, unknown>[];
        quickFilters: QuickFilter[];
        isLoading?: boolean;
        isError?: boolean;
        isEmpty?: boolean;
        totalUnfilteredCount: number;
        analyticsPrefix?: string;
    };
    Blocks: {
        default: [];
    };
    Element: HTMLElement;
}
export default class InventoryTable extends Component<InventoryTableSignature> {
    readonly router: RouterService;
    readonly reportingAnalytics: ReportingAnalytics;
    trackAnalyticsEvent: (eventName: string, properties: Record<string, unknown>) => void;
    handleApplyFilters: (filters: Filter[]) => void;
    handleSort: (sortBy: string, sortOrder: "asc" | "desc") => void;
    handlePageChange: (direction: string) => void;
    handlePageSizeChange: (pageSize: number) => void;
    handleColumnsChanged: (visibleColumnKeys: string[]) => void;
    get isDisabledNext(): boolean | undefined;
    get isDisabledPrev(): boolean | undefined;
    get routeName(): string;
    getCellContent: (row: Record<string, unknown> | undefined, key: string, formatter?: (data: Record<string, unknown>) => string) => string;
    getParams: (quickFilter: QuickFilter) => {
        filters?: Filter[];
    };
    hasCount: (quickFilter: QuickFilter) => boolean;
    get sortBy(): {
        key: string;
        order: "asc" | "desc";
    };
    get rows(): Record<string, unknown>[];
    get hasMessage(): boolean | undefined;
    get columnsForFilterBar(): {
        label: string;
        key: string;
        visible: boolean;
    }[];
    get visibleColumns(): InventoryTableColumn[];
}
