
import { HdsIcon, HdsTooltipButton, HdsTag, HdsTextBody, HdsButton, HdsBadgeCount, HdsDropdown, HdsFormTextInputField, HdsSegmentedGroup } from '@hashicorp/design-system-components/components';
import Component from '@glimmer/component';
import { on } from '@ember/modifier';
import { array, fn } from '@ember/helper';
import FilterControlGroup from './filter-bar/filter-control-group.js';
import { tracked } from '@glimmer/tracking';
import { not, eq } from '../../utils/helpers.js';
import { precompileTemplate } from '@ember/template-compilation';
import { setComponentTemplate } from '@ember/component';
import { g, i } from 'decorator-transforms/runtime';

/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */
class FilterBar extends Component {
  static {
    g(this.prototype, "activeSecondaryFilter", [tracked], function () {
      return null;
    });
  }
  #activeSecondaryFilter = (i(this, "activeSecondaryFilter"), void 0);
  static {
    g(this.prototype, "pendingColumnVisibility", [tracked], function () {
      return {};
    });
  }
  #pendingColumnVisibility = (i(this, "pendingColumnVisibility"), void 0);
  setActiveSecondaryFilter = filter => {
    this.activeSecondaryFilter = filter;
  };
  handleUpdateFilters = filters => {
    this.args.onFiltersApplied(Object.values(filters));
  };
  handleClearFilters = () => {
    this.handleUpdateFilters({});
  };
  handleDismissFilter = key => {
    const updated = {
      ...this.appliedFilters
    };
    delete updated[key];
    this.handleUpdateFilters(updated);
  };
  handleColumnToggle = (columnKey, event) => {
    const isChecked = event.target.checked;
    this.pendingColumnVisibility = {
      ...this.pendingColumnVisibility,
      [columnKey]: isChecked
    };
  };
  handleApplyColumns = () => {
    if (!this.args.onColumnsChanged || !this.args.columns) return;
    const updatedVisibleColumns = this.args.columns.filter(col => {
      const columnKey = col.key;
      const isVisible = columnKey in this.pendingColumnVisibility ? this.pendingColumnVisibility[columnKey] : col.visible ?? true;
      return isVisible;
    }).map(col => col.key);
    this.args.onColumnsChanged(updatedVisibleColumns);
    // Clear pending changes after applying
    this.pendingColumnVisibility = {};
  };
  getColumnVisibility = columnKey => {
    if (columnKey in this.pendingColumnVisibility) {
      return this.pendingColumnVisibility[columnKey];
    }
    const column = this.args.columns?.find(col => col.key === columnKey);
    return column?.visible ?? true;
  };
  get hasPendingColumnChanges() {
    return Object.keys(this.pendingColumnVisibility).length > 0;
  }
  get visibleColumnsCount() {
    return this.args.columns?.filter(col => col.visible ?? true).length;
  }
  handleTextInputChange = (name, event) => {
    const {
      value
    } = event.target;
    this.handleUpdateFilters({
      ...this.appliedFilters,
      [name]: {
        operator: '=',
        value: {
          type: 'list',
          value: [value]
        },
        field: name
      }
    });
  };
  getValue = name => {
    return this.appliedFilters?.[name]?.value?.value ?? '';
  };
  getCount = name => {
    const appliedFilter = this.appliedFilters[name];
    if (appliedFilter?.value?.value) {
      if (Array.isArray(appliedFilter.value.value)) {
        return appliedFilter.value.value.length;
      }
      return 1;
    }
    return 0;
  };
  hasCount = name => {
    return this.getCount(name) > 0;
  };
  getDefinitionCount = filter => {
    return filter.controls.reduce((count, control) => {
      if (this.appliedFilters[control.name]) {
        return count + this.getCount(control.name);
      }
      return count;
    }, 0);
  };
  hasDefinitionCount = filter => {
    return this.getDefinitionCount(filter) > 0;
  };
  friendlyAppliedString = appliedFilter => {
    const {
      operator,
      value: valueDefinition
    } = appliedFilter;
    const field = this.args.filterFieldDefinitions.find(f => f.controls.find(c => c.name === appliedFilter.field));
    const label = field?.label || appliedFilter.field;
    const {
      value
    } = valueDefinition;
    const {
      type = 'string'
    } = valueDefinition;
    let formattedValue = value;
    if (type === 'duration' && !Array.isArray(value)) {
      formattedValue = value;
    }
    if (type === 'list' && Array.isArray(value)) {
      formattedValue = value.join(', ');
    }
    return `${label} ${operator} ${formattedValue}`;
  };
  get appliedFilters() {
    const applied = (this.args.appliedFilters || []).reduce((acc, filter) => {
      const {
        field
      } = filter;
      acc[field] = filter;
      return acc;
    }, {});
    return applied;
  }
  get appliedFilterTags() {
    return Object.entries(this.appliedFilters).map(([key, filter]) => ({
      key,
      text: this.friendlyAppliedString(filter)
    }));
  }
  get appliedFiltersCount() {
    return Object.keys(this.appliedFilters).length;
  }
  get hasAppliedFilters() {
    return this.appliedFiltersCount > 0;
  }
  get primaryFilterDefinitions() {
    return this.args.filterFieldDefinitions.filter(filter => filter.level === 'primary');
  }
  get secondaryFilterDefinitions() {
    return this.args.filterFieldDefinitions.filter(filter => filter.level !== 'primary');
  }
  get appliedSecondaryFiltersCount() {
    return this.secondaryFilterDefinitions.reduce((count, filter) => {
      const applied = filter.controls.some(control => this.appliedFilters[control.name]);
      if (applied) {
        return count + 1;
      }
      return count;
    }, 0);
  }
  static {
    setComponentTemplate(precompileTemplate("\n    <div class=\"filter-bar__container\">\n      <HdsSegmentedGroup class=\"filter-bar__filters\" as |SG|>\n        {{#each this.primaryFilterDefinitions as |filterDefinition|}}\n          {{#each filterDefinition.controls as |control|}}\n            {{#if (eq control.type \"search\")}}\n              <HdsFormTextInputField data-test-vault-reporting-filter-bar-search={{control.name}} @type=\"search\" name={{control.name}} placeholder=\"Search\" @value={{this.getValue control.name}} @width=\"300px\" {{on \"change\" (fn this.handleTextInputChange control.name)}} />\n            {{else}}\n              <SG.Dropdown data-test-vault-reporting-filter-bar-primary-dropdown={{control.name}} @listPosition=\"bottom-left\" as |D|>\n                <D.ToggleButton @color=\"secondary\" @text={{filterDefinition.label}} />\n                <D.Generic class=\"filter-bar__primary-filter-controls\">\n                  <FilterControlGroup @controls={{array control}} @appliedFilters={{this.appliedFilters}} @onUpdateFilters={{this.handleUpdateFilters}} />\n                </D.Generic>\n              </SG.Dropdown>\n            {{/if}}\n          {{/each}}\n        {{/each}}\n      </HdsSegmentedGroup>\n      <HdsDropdown @listPosition=\"bottom-left\" data-test-vault-reporting-filter-bar-secondary-dropdown as |D|>\n        <D.ToggleButton data-test-vault-reporting-filter-bar-secondary-toggle @text=\"Filters\" @icon=\"filter\" @color=\"secondary\" @count={{this.appliedSecondaryFiltersCount}} class=\"filter-bar__secondary-toggle\" />\n        <D.Generic class=\"filter-bar__secondary-filters\">\n          <ul class=\"filter-bar__secondary-filter-list\">\n            {{#each this.secondaryFilterDefinitions as |filter|}}\n              <D.Interactive class={{if (eq filter.label this.activeSecondaryFilter.label) \"mock-active\" \"\"}} @trailingIcon=\"chevron-right\" data-test-vault-reporting-filter-bar-secondary-option={{filter.label}} {{on \"click\" (fn this.setActiveSecondaryFilter filter)}}>\n                {{filter.label}}\n                {{#if (this.hasDefinitionCount filter)}}\n                  <HdsBadgeCount @size=\"small\" @type=\"outlined\" @text={{this.getDefinitionCount filter}} />\n                {{/if}}\n              </D.Interactive>\n            {{/each}}\n          </ul>\n          <div class=\"filter-bar__secondary-filter-controls\">\n            {{#if this.activeSecondaryFilter}}\n              <FilterControlGroup @controls={{this.activeSecondaryFilter.controls}} @appliedFilters={{this.appliedFilters}} @onUpdateFilters={{this.handleUpdateFilters}} />\n            {{/if}}\n          </div>\n        </D.Generic>\n      </HdsDropdown>\n      <HdsDropdown @listPosition=\"bottom-left\" data-test-vault-reporting-filter-bar-fields-dropdown as |D|>\n        <D.ToggleButton @count={{this.visibleColumnsCount}} @text=\"Fields\" @color=\"secondary\" aria-label=\"Toggle column visibility options\" />\n        {{#if @columns}}\n          {{#each @columns as |column|}}\n            <D.Checkbox checked={{this.getColumnVisibility column.key}} disabled={{eq column.key \"secretName\"}} {{on \"change\" (fn this.handleColumnToggle column.key)}}>\n              {{column.label}}\n            </D.Checkbox>\n          {{/each}}\n          <D.Footer @hasDivider={{true}}>\n            <HdsButton @text=\"Apply\" @isFullWidth={{true}} @size=\"small\" disabled={{not this.hasPendingColumnChanges}} aria-label=\"Apply column visibility changes to table\" {{on \"click\" this.handleApplyColumns}} />\n          </D.Footer>\n        {{/if}}\n      </HdsDropdown>\n    </div>\n    <div class=\"filter-bar__applied-filters\">\n      {{#if this.hasAppliedFilters}}\n        <HdsTextBody @color=\"strong\" @size=\"200\" @weight=\"semibold\">Applied\n          filters ({{this.appliedFiltersCount}})</HdsTextBody>\n        {{#each this.appliedFilterTags as |appliedFilter|}}\n          <HdsTag data-test-vault-reporting-filter-bar-applied-tag={{appliedFilter.key}} @text={{appliedFilter.text}} @tooltipPlacement=\"right\" @onDismiss={{fn this.handleDismissFilter appliedFilter.key}} />\n        {{/each}}\n        <HdsButton @size=\"medium\" class=\"filter-bar__applied-filters__clear-button\" @text=\"Clear all\" @isInline={{true}} @color=\"tertiary\" @icon=\"x\" {{on \"click\" this.handleClearFilters}} />\n      {{else}}\n        <HdsTextBody @color=\"strong\" @size=\"200\" class=\"filter-bar__applied-filters-zero-state\">No filters applied\n          <HdsTooltipButton class=\"filter-bar__applied-filters-zero-state__tooltip\" @text=\"Use the filter bar to refine your results.\" aria-label=\"More information\">\n            <HdsIcon @name=\"info\" />\n          </HdsTooltipButton></HdsTextBody>\n      {{/if}}\n\n    </div>\n  ", {
      strictMode: true,
      scope: () => ({
        HdsSegmentedGroup,
        eq,
        HdsFormTextInputField,
        on,
        fn,
        FilterControlGroup,
        array,
        HdsDropdown,
        HdsBadgeCount,
        HdsButton,
        not,
        HdsTextBody,
        HdsTag,
        HdsTooltipButton,
        HdsIcon
      })
    }), this);
  }
}

export { FilterBar as default };
//# sourceMappingURL=filter-bar.js.map
