/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */
import Component from '@glimmer/component';
import { type Filter } from '../../utils/filters.ts';
import './filter-bar.scss';
type StripFilterPrefix<S extends string> = S extends `filter${infer Rest}` ? Rest extends `${infer First}${infer Tail}` ? Tail extends `${infer Middle}Absolute` ? `${Lowercase<First>}${Middle}` : `${Lowercase<First>}${Tail}` : Rest : S;
export type FilterFieldName<T> = {
    [K in keyof T as StripFilterPrefix<K & string>]: K;
};
export interface FilterFieldControl<T = Record<string, unknown>> {
    name: Extract<keyof FilterFieldName<T>, string>;
    label?: string;
    type: 'text' | 'boolean' | 'single-select' | 'multi-select' | 'lookback' | 'search' | 'searchable-multi-select';
    dependsOn?: (form: Record<string, Filter>) => boolean;
    placeholder?: string;
    options?: {
        name: string;
        value: string;
    }[];
    onSearch?: (search: string) => Promise<{
        name: string;
        value: string;
    }[]>;
}
export interface FilterFieldDefinition<T = Record<string, unknown>> {
    label: string;
    level?: 'primary' | 'secondary';
    controls: FilterFieldControl<T>[];
}
export interface FilterBarSignature {
    Args: {
        onFiltersApplied: (filters: Filter[]) => void;
        appliedFilters?: Filter[];
        filterFieldDefinitions: FilterFieldDefinition[];
        columns?: {
            label: string;
            key: string;
            visible?: boolean;
        }[];
        onColumnsChanged?: (visibleColumnKeys: string[]) => void;
    };
    Blocks: {
        default: [];
    };
    Element: HTMLElement;
}
export default class FilterBar extends Component<FilterBarSignature> {
    activeSecondaryFilter: FilterFieldDefinition | null;
    pendingColumnVisibility: Record<string, boolean>;
    setActiveSecondaryFilter: (filter: FilterFieldDefinition | null) => void;
    handleUpdateFilters: (filters: Record<string, Filter>) => void;
    handleClearFilters: () => void;
    handleDismissFilter: (key: string) => void;
    handleColumnToggle: (columnKey: string, event: Event) => void;
    handleApplyColumns: () => void;
    getColumnVisibility: (columnKey: string) => boolean | undefined;
    get hasPendingColumnChanges(): boolean;
    get visibleColumnsCount(): number | undefined;
    handleTextInputChange: (name: string, event: Event) => void;
    getValue: (name: string) => string;
    getCount: (name: string) => number;
    hasCount: (name: string) => boolean;
    getDefinitionCount: (filter: FilterFieldDefinition) => number;
    hasDefinitionCount: (filter: FilterFieldDefinition) => boolean;
    friendlyAppliedString: (appliedFilter: Filter) => string;
    get appliedFilters(): Record<string, Filter<Record<string, unknown>>>;
    get appliedFilterTags(): {
        key: string;
        text: string;
    }[];
    get appliedFiltersCount(): number;
    get hasAppliedFilters(): boolean;
    get primaryFilterDefinitions(): FilterFieldDefinition<Record<string, unknown>>[];
    get secondaryFilterDefinitions(): FilterFieldDefinition<Record<string, unknown>>[];
    get appliedSecondaryFiltersCount(): number;
}
export {};
