/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */

import { fillIn, click } from '@ember/test-helpers';
import { GENERAL } from 'vault/tests/helpers/general-selectors';

export const mountBackend = async (type, path) => {
  await click(GENERAL.cardContainer(type));
  if (path) {
    await fillIn(GENERAL.inputByAttr('path'), path);
    await click(GENERAL.submitButton);
  } else {
    // save with default path
    await click(GENERAL.submitButton);
  }
};
