// There is a fixed list of named character references which will not be expanded in the future.
// This file is based on https://html.spec.whatwg.org/multipage/named-characters.html#named-character-references
// with some modifications to reduce the file size of the original JSON.
export const htmlEntities = {
    AElig: { p: [198], c: "\u00C6" },
    "AElig;": { p: [198], c: "\u00C6" },
    AMP: { p: [38], c: "\u0026" },
    "AMP;": { p: [38], c: "\u0026" },
    Aacute: { p: [193], c: "\u00C1" },
    "Aacute;": { p: [193], c: "\u00C1" },
    "Abreve;": { p: [258], c: "\u0102" },
    Acirc: { p: [194], c: "\u00C2" },
    "Acirc;": { p: [194], c: "\u00C2" },
    "Acy;": { p: [1040], c: "\u0410" },
    "Afr;": { p: [120068], c: "\uD835\uDD04" },
    Agrave: { p: [192], c: "\u00C0" },
    "Agrave;": { p: [192], c: "\u00C0" },
    "Alpha;": { p: [913], c: "\u0391" },
    "Amacr;": { p: [256], c: "\u0100" },
    "And;": { p: [10835], c: "\u2A53" },
    "Aogon;": { p: [260], c: "\u0104" },
    "Aopf;": { p: [120120], c: "\uD835\uDD38" },
    "ApplyFunction;": { p: [8289], c: "\u2061" },
    Aring: { p: [197], c: "\u00C5" },
    "Aring;": { p: [197], c: "\u00C5" },
    "Ascr;": { p: [119964], c: "\uD835\uDC9C" },
    "Assign;": { p: [8788], c: "\u2254" },
    Atilde: { p: [195], c: "\u00C3" },
    "Atilde;": { p: [195], c: "\u00C3" },
    Auml: { p: [196], c: "\u00C4" },
    "Auml;": { p: [196], c: "\u00C4" },
    "Backslash;": { p: [8726], c: "\u2216" },
    "Barv;": { p: [10983], c: "\u2AE7" },
    "Barwed;": { p: [8966], c: "\u2306" },
    "Bcy;": { p: [1041], c: "\u0411" },
    "Because;": { p: [8757], c: "\u2235" },
    "Bernoullis;": { p: [8492], c: "\u212C" },
    "Beta;": { p: [914], c: "\u0392" },
    "Bfr;": { p: [120069], c: "\uD835\uDD05" },
    "Bopf;": { p: [120121], c: "\uD835\uDD39" },
    "Breve;": { p: [728], c: "\u02D8" },
    "Bscr;": { p: [8492], c: "\u212C" },
    "Bumpeq;": { p: [8782], c: "\u224E" },
    "CHcy;": { p: [1063], c: "\u0427" },
    COPY: { p: [169], c: "\u00A9" },
    "COPY;": { p: [169], c: "\u00A9" },
    "Cacute;": { p: [262], c: "\u0106" },
    "Cap;": { p: [8914], c: "\u22D2" },
    "CapitalDifferentialD;": { p: [8517], c: "\u2145" },
    "Cayleys;": { p: [8493], c: "\u212D" },
    "Ccaron;": { p: [268], c: "\u010C" },
    Ccedil: { p: [199], c: "\u00C7" },
    "Ccedil;": { p: [199], c: "\u00C7" },
    "Ccirc;": { p: [264], c: "\u0108" },
    "Cconint;": { p: [8752], c: "\u2230" },
    "Cdot;": { p: [266], c: "\u010A" },
    "Cedilla;": { p: [184], c: "\u00B8" },
    "CenterDot;": { p: [183], c: "\u00B7" },
    "Cfr;": { p: [8493], c: "\u212D" },
    "Chi;": { p: [935], c: "\u03A7" },
    "CircleDot;": { p: [8857], c: "\u2299" },
    "CircleMinus;": { p: [8854], c: "\u2296" },
    "CirclePlus;": { p: [8853], c: "\u2295" },
    "CircleTimes;": { p: [8855], c: "\u2297" },
    "ClockwiseContourIntegral;": {
        p: [8754],
        c: "\u2232",
    },
    "CloseCurlyDoubleQuote;": { p: [8221], c: "\u201D" },
    "CloseCurlyQuote;": { p: [8217], c: "\u2019" },
    "Colon;": { p: [8759], c: "\u2237" },
    "Colone;": { p: [10868], c: "\u2A74" },
    "Congruent;": { p: [8801], c: "\u2261" },
    "Conint;": { p: [8751], c: "\u222F" },
    "ContourIntegral;": { p: [8750], c: "\u222E" },
    "Copf;": { p: [8450], c: "\u2102" },
    "Coproduct;": { p: [8720], c: "\u2210" },
    "CounterClockwiseContourIntegral;": {
        p: [8755],
        c: "\u2233",
    },
    "Cross;": { p: [10799], c: "\u2A2F" },
    "Cscr;": { p: [119966], c: "\uD835\uDC9E" },
    "Cup;": { p: [8915], c: "\u22D3" },
    "CupCap;": { p: [8781], c: "\u224D" },
    "DD;": { p: [8517], c: "\u2145" },
    "DDotrahd;": { p: [10513], c: "\u2911" },
    "DJcy;": { p: [1026], c: "\u0402" },
    "DScy;": { p: [1029], c: "\u0405" },
    "DZcy;": { p: [1039], c: "\u040F" },
    "Dagger;": { p: [8225], c: "\u2021" },
    "Darr;": { p: [8609], c: "\u21A1" },
    "Dashv;": { p: [10980], c: "\u2AE4" },
    "Dcaron;": { p: [270], c: "\u010E" },
    "Dcy;": { p: [1044], c: "\u0414" },
    "Del;": { p: [8711], c: "\u2207" },
    "Delta;": { p: [916], c: "\u0394" },
    "Dfr;": { p: [120071], c: "\uD835\uDD07" },
    "DiacriticalAcute;": { p: [180], c: "\u00B4" },
    "DiacriticalDot;": { p: [729], c: "\u02D9" },
    "DiacriticalDoubleAcute;": { p: [733], c: "\u02DD" },
    "DiacriticalGrave;": { p: [96], c: "\u0060" },
    "DiacriticalTilde;": { p: [732], c: "\u02DC" },
    "Diamond;": { p: [8900], c: "\u22C4" },
    "DifferentialD;": { p: [8518], c: "\u2146" },
    "Dopf;": { p: [120123], c: "\uD835\uDD3B" },
    "Dot;": { p: [168], c: "\u00A8" },
    "DotDot;": { p: [8412], c: "\u20DC" },
    "DotEqual;": { p: [8784], c: "\u2250" },
    "DoubleContourIntegral;": { p: [8751], c: "\u222F" },
    "DoubleDot;": { p: [168], c: "\u00A8" },
    "DoubleDownArrow;": { p: [8659], c: "\u21D3" },
    "DoubleLeftArrow;": { p: [8656], c: "\u21D0" },
    "DoubleLeftRightArrow;": { p: [8660], c: "\u21D4" },
    "DoubleLeftTee;": { p: [10980], c: "\u2AE4" },
    "DoubleLongLeftArrow;": { p: [10232], c: "\u27F8" },
    "DoubleLongLeftRightArrow;": {
        p: [10234],
        c: "\u27FA",
    },
    "DoubleLongRightArrow;": { p: [10233], c: "\u27F9" },
    "DoubleRightArrow;": { p: [8658], c: "\u21D2" },
    "DoubleRightTee;": { p: [8872], c: "\u22A8" },
    "DoubleUpArrow;": { p: [8657], c: "\u21D1" },
    "DoubleUpDownArrow;": { p: [8661], c: "\u21D5" },
    "DoubleVerticalBar;": { p: [8741], c: "\u2225" },
    "DownArrow;": { p: [8595], c: "\u2193" },
    "DownArrowBar;": { p: [10515], c: "\u2913" },
    "DownArrowUpArrow;": { p: [8693], c: "\u21F5" },
    "DownBreve;": { p: [785], c: "\u0311" },
    "DownLeftRightVector;": { p: [10576], c: "\u2950" },
    "DownLeftTeeVector;": { p: [10590], c: "\u295E" },
    "DownLeftVector;": { p: [8637], c: "\u21BD" },
    "DownLeftVectorBar;": { p: [10582], c: "\u2956" },
    "DownRightTeeVector;": { p: [10591], c: "\u295F" },
    "DownRightVector;": { p: [8641], c: "\u21C1" },
    "DownRightVectorBar;": { p: [10583], c: "\u2957" },
    "DownTee;": { p: [8868], c: "\u22A4" },
    "DownTeeArrow;": { p: [8615], c: "\u21A7" },
    "Downarrow;": { p: [8659], c: "\u21D3" },
    "Dscr;": { p: [119967], c: "\uD835\uDC9F" },
    "Dstrok;": { p: [272], c: "\u0110" },
    "ENG;": { p: [330], c: "\u014A" },
    ETH: { p: [208], c: "\u00D0" },
    "ETH;": { p: [208], c: "\u00D0" },
    Eacute: { p: [201], c: "\u00C9" },
    "Eacute;": { p: [201], c: "\u00C9" },
    "Ecaron;": { p: [282], c: "\u011A" },
    Ecirc: { p: [202], c: "\u00CA" },
    "Ecirc;": { p: [202], c: "\u00CA" },
    "Ecy;": { p: [1069], c: "\u042D" },
    "Edot;": { p: [278], c: "\u0116" },
    "Efr;": { p: [120072], c: "\uD835\uDD08" },
    Egrave: { p: [200], c: "\u00C8" },
    "Egrave;": { p: [200], c: "\u00C8" },
    "Element;": { p: [8712], c: "\u2208" },
    "Emacr;": { p: [274], c: "\u0112" },
    "EmptySmallSquare;": { p: [9723], c: "\u25FB" },
    "EmptyVerySmallSquare;": { p: [9643], c: "\u25AB" },
    "Eogon;": { p: [280], c: "\u0118" },
    "Eopf;": { p: [120124], c: "\uD835\uDD3C" },
    "Epsilon;": { p: [917], c: "\u0395" },
    "Equal;": { p: [10869], c: "\u2A75" },
    "EqualTilde;": { p: [8770], c: "\u2242" },
    "Equilibrium;": { p: [8652], c: "\u21CC" },
    "Escr;": { p: [8496], c: "\u2130" },
    "Esim;": { p: [10867], c: "\u2A73" },
    "Eta;": { p: [919], c: "\u0397" },
    Euml: { p: [203], c: "\u00CB" },
    "Euml;": { p: [203], c: "\u00CB" },
    "Exists;": { p: [8707], c: "\u2203" },
    "ExponentialE;": { p: [8519], c: "\u2147" },
    "Fcy;": { p: [1060], c: "\u0424" },
    "Ffr;": { p: [120073], c: "\uD835\uDD09" },
    "FilledSmallSquare;": { p: [9724], c: "\u25FC" },
    "FilledVerySmallSquare;": { p: [9642], c: "\u25AA" },
    "Fopf;": { p: [120125], c: "\uD835\uDD3D" },
    "ForAll;": { p: [8704], c: "\u2200" },
    "Fouriertrf;": { p: [8497], c: "\u2131" },
    "Fscr;": { p: [8497], c: "\u2131" },
    "GJcy;": { p: [1027], c: "\u0403" },
    GT: { p: [62], c: "\u003E" },
    "GT;": { p: [62], c: "\u003E" },
    "Gamma;": { p: [915], c: "\u0393" },
    "Gammad;": { p: [988], c: "\u03DC" },
    "Gbreve;": { p: [286], c: "\u011E" },
    "Gcedil;": { p: [290], c: "\u0122" },
    "Gcirc;": { p: [284], c: "\u011C" },
    "Gcy;": { p: [1043], c: "\u0413" },
    "Gdot;": { p: [288], c: "\u0120" },
    "Gfr;": { p: [120074], c: "\uD835\uDD0A" },
    "Gg;": { p: [8921], c: "\u22D9" },
    "Gopf;": { p: [120126], c: "\uD835\uDD3E" },
    "GreaterEqual;": { p: [8805], c: "\u2265" },
    "GreaterEqualLess;": { p: [8923], c: "\u22DB" },
    "GreaterFullEqual;": { p: [8807], c: "\u2267" },
    "GreaterGreater;": { p: [10914], c: "\u2AA2" },
    "GreaterLess;": { p: [8823], c: "\u2277" },
    "GreaterSlantEqual;": { p: [10878], c: "\u2A7E" },
    "GreaterTilde;": { p: [8819], c: "\u2273" },
    "Gscr;": { p: [119970], c: "\uD835\uDCA2" },
    "Gt;": { p: [8811], c: "\u226B" },
    "HARDcy;": { p: [1066], c: "\u042A" },
    "Hacek;": { p: [711], c: "\u02C7" },
    "Hat;": { p: [94], c: "\u005E" },
    "Hcirc;": { p: [292], c: "\u0124" },
    "Hfr;": { p: [8460], c: "\u210C" },
    "HilbertSpace;": { p: [8459], c: "\u210B" },
    "Hopf;": { p: [8461], c: "\u210D" },
    "HorizontalLine;": { p: [9472], c: "\u2500" },
    "Hscr;": { p: [8459], c: "\u210B" },
    "Hstrok;": { p: [294], c: "\u0126" },
    "HumpDownHump;": { p: [8782], c: "\u224E" },
    "HumpEqual;": { p: [8783], c: "\u224F" },
    "IEcy;": { p: [1045], c: "\u0415" },
    "IJlig;": { p: [306], c: "\u0132" },
    "IOcy;": { p: [1025], c: "\u0401" },
    Iacute: { p: [205], c: "\u00CD" },
    "Iacute;": { p: [205], c: "\u00CD" },
    Icirc: { p: [206], c: "\u00CE" },
    "Icirc;": { p: [206], c: "\u00CE" },
    "Icy;": { p: [1048], c: "\u0418" },
    "Idot;": { p: [304], c: "\u0130" },
    "Ifr;": { p: [8465], c: "\u2111" },
    Igrave: { p: [204], c: "\u00CC" },
    "Igrave;": { p: [204], c: "\u00CC" },
    "Im;": { p: [8465], c: "\u2111" },
    "Imacr;": { p: [298], c: "\u012A" },
    "ImaginaryI;": { p: [8520], c: "\u2148" },
    "Implies;": { p: [8658], c: "\u21D2" },
    "Int;": { p: [8748], c: "\u222C" },
    "Integral;": { p: [8747], c: "\u222B" },
    "Intersection;": { p: [8898], c: "\u22C2" },
    "InvisibleComma;": { p: [8291], c: "\u2063" },
    "InvisibleTimes;": { p: [8290], c: "\u2062" },
    "Iogon;": { p: [302], c: "\u012E" },
    "Iopf;": { p: [120128], c: "\uD835\uDD40" },
    "Iota;": { p: [921], c: "\u0399" },
    "Iscr;": { p: [8464], c: "\u2110" },
    "Itilde;": { p: [296], c: "\u0128" },
    "Iukcy;": { p: [1030], c: "\u0406" },
    Iuml: { p: [207], c: "\u00CF" },
    "Iuml;": { p: [207], c: "\u00CF" },
    "Jcirc;": { p: [308], c: "\u0134" },
    "Jcy;": { p: [1049], c: "\u0419" },
    "Jfr;": { p: [120077], c: "\uD835\uDD0D" },
    "Jopf;": { p: [120129], c: "\uD835\uDD41" },
    "Jscr;": { p: [119973], c: "\uD835\uDCA5" },
    "Jsercy;": { p: [1032], c: "\u0408" },
    "Jukcy;": { p: [1028], c: "\u0404" },
    "KHcy;": { p: [1061], c: "\u0425" },
    "KJcy;": { p: [1036], c: "\u040C" },
    "Kappa;": { p: [922], c: "\u039A" },
    "Kcedil;": { p: [310], c: "\u0136" },
    "Kcy;": { p: [1050], c: "\u041A" },
    "Kfr;": { p: [120078], c: "\uD835\uDD0E" },
    "Kopf;": { p: [120130], c: "\uD835\uDD42" },
    "Kscr;": { p: [119974], c: "\uD835\uDCA6" },
    "LJcy;": { p: [1033], c: "\u0409" },
    LT: { p: [60], c: "\u003C" },
    "LT;": { p: [60], c: "\u003C" },
    "Lacute;": { p: [313], c: "\u0139" },
    "Lambda;": { p: [923], c: "\u039B" },
    "Lang;": { p: [10218], c: "\u27EA" },
    "Laplacetrf;": { p: [8466], c: "\u2112" },
    "Larr;": { p: [8606], c: "\u219E" },
    "Lcaron;": { p: [317], c: "\u013D" },
    "Lcedil;": { p: [315], c: "\u013B" },
    "Lcy;": { p: [1051], c: "\u041B" },
    "LeftAngleBracket;": { p: [10216], c: "\u27E8" },
    "LeftArrow;": { p: [8592], c: "\u2190" },
    "LeftArrowBar;": { p: [8676], c: "\u21E4" },
    "LeftArrowRightArrow;": { p: [8646], c: "\u21C6" },
    "LeftCeiling;": { p: [8968], c: "\u2308" },
    "LeftDoubleBracket;": { p: [10214], c: "\u27E6" },
    "LeftDownTeeVector;": { p: [10593], c: "\u2961" },
    "LeftDownVector;": { p: [8643], c: "\u21C3" },
    "LeftDownVectorBar;": { p: [10585], c: "\u2959" },
    "LeftFloor;": { p: [8970], c: "\u230A" },
    "LeftRightArrow;": { p: [8596], c: "\u2194" },
    "LeftRightVector;": { p: [10574], c: "\u294E" },
    "LeftTee;": { p: [8867], c: "\u22A3" },
    "LeftTeeArrow;": { p: [8612], c: "\u21A4" },
    "LeftTeeVector;": { p: [10586], c: "\u295A" },
    "LeftTriangle;": { p: [8882], c: "\u22B2" },
    "LeftTriangleBar;": { p: [10703], c: "\u29CF" },
    "LeftTriangleEqual;": { p: [8884], c: "\u22B4" },
    "LeftUpDownVector;": { p: [10577], c: "\u2951" },
    "LeftUpTeeVector;": { p: [10592], c: "\u2960" },
    "LeftUpVector;": { p: [8639], c: "\u21BF" },
    "LeftUpVectorBar;": { p: [10584], c: "\u2958" },
    "LeftVector;": { p: [8636], c: "\u21BC" },
    "LeftVectorBar;": { p: [10578], c: "\u2952" },
    "Leftarrow;": { p: [8656], c: "\u21D0" },
    "Leftrightarrow;": { p: [8660], c: "\u21D4" },
    "LessEqualGreater;": { p: [8922], c: "\u22DA" },
    "LessFullEqual;": { p: [8806], c: "\u2266" },
    "LessGreater;": { p: [8822], c: "\u2276" },
    "LessLess;": { p: [10913], c: "\u2AA1" },
    "LessSlantEqual;": { p: [10877], c: "\u2A7D" },
    "LessTilde;": { p: [8818], c: "\u2272" },
    "Lfr;": { p: [120079], c: "\uD835\uDD0F" },
    "Ll;": { p: [8920], c: "\u22D8" },
    "Lleftarrow;": { p: [8666], c: "\u21DA" },
    "Lmidot;": { p: [319], c: "\u013F" },
    "LongLeftArrow;": { p: [10229], c: "\u27F5" },
    "LongLeftRightArrow;": { p: [10231], c: "\u27F7" },
    "LongRightArrow;": { p: [10230], c: "\u27F6" },
    "Longleftarrow;": { p: [10232], c: "\u27F8" },
    "Longleftrightarrow;": { p: [10234], c: "\u27FA" },
    "Longrightarrow;": { p: [10233], c: "\u27F9" },
    "Lopf;": { p: [120131], c: "\uD835\uDD43" },
    "LowerLeftArrow;": { p: [8601], c: "\u2199" },
    "LowerRightArrow;": { p: [8600], c: "\u2198" },
    "Lscr;": { p: [8466], c: "\u2112" },
    "Lsh;": { p: [8624], c: "\u21B0" },
    "Lstrok;": { p: [321], c: "\u0141" },
    "Lt;": { p: [8810], c: "\u226A" },
    "Map;": { p: [10501], c: "\u2905" },
    "Mcy;": { p: [1052], c: "\u041C" },
    "MediumSpace;": { p: [8287], c: "\u205F" },
    "Mellintrf;": { p: [8499], c: "\u2133" },
    "Mfr;": { p: [120080], c: "\uD835\uDD10" },
    "MinusPlus;": { p: [8723], c: "\u2213" },
    "Mopf;": { p: [120132], c: "\uD835\uDD44" },
    "Mscr;": { p: [8499], c: "\u2133" },
    "Mu;": { p: [924], c: "\u039C" },
    "NJcy;": { p: [1034], c: "\u040A" },
    "Nacute;": { p: [323], c: "\u0143" },
    "Ncaron;": { p: [327], c: "\u0147" },
    "Ncedil;": { p: [325], c: "\u0145" },
    "Ncy;": { p: [1053], c: "\u041D" },
    "NegativeMediumSpace;": { p: [8203], c: "\u200B" },
    "NegativeThickSpace;": { p: [8203], c: "\u200B" },
    "NegativeThinSpace;": { p: [8203], c: "\u200B" },
    "NegativeVeryThinSpace;": { p: [8203], c: "\u200B" },
    "NestedGreaterGreater;": { p: [8811], c: "\u226B" },
    "NestedLessLess;": { p: [8810], c: "\u226A" },
    "NewLine;": { p: [10], c: "\u000A" },
    "Nfr;": { p: [120081], c: "\uD835\uDD11" },
    "NoBreak;": { p: [8288], c: "\u2060" },
    "NonBreakingSpace;": { p: [160], c: "\u00A0" },
    "Nopf;": { p: [8469], c: "\u2115" },
    "Not;": { p: [10988], c: "\u2AEC" },
    "NotCongruent;": { p: [8802], c: "\u2262" },
    "NotCupCap;": { p: [8813], c: "\u226D" },
    "NotDoubleVerticalBar;": { p: [8742], c: "\u2226" },
    "NotElement;": { p: [8713], c: "\u2209" },
    "NotEqual;": { p: [8800], c: "\u2260" },
    "NotEqualTilde;": {
        p: [8770, 824],
        c: "\u2242\u0338",
    },
    "NotExists;": { p: [8708], c: "\u2204" },
    "NotGreater;": { p: [8815], c: "\u226F" },
    "NotGreaterEqual;": { p: [8817], c: "\u2271" },
    "NotGreaterFullEqual;": {
        p: [8807, 824],
        c: "\u2267\u0338",
    },
    "NotGreaterGreater;": {
        p: [8811, 824],
        c: "\u226B\u0338",
    },
    "NotGreaterLess;": { p: [8825], c: "\u2279" },
    "NotGreaterSlantEqual;": {
        p: [10878, 824],
        c: "\u2A7E\u0338",
    },
    "NotGreaterTilde;": { p: [8821], c: "\u2275" },
    "NotHumpDownHump;": {
        p: [8782, 824],
        c: "\u224E\u0338",
    },
    "NotHumpEqual;": {
        p: [8783, 824],
        c: "\u224F\u0338",
    },
    "NotLeftTriangle;": { p: [8938], c: "\u22EA" },
    "NotLeftTriangleBar;": {
        p: [10703, 824],
        c: "\u29CF\u0338",
    },
    "NotLeftTriangleEqual;": { p: [8940], c: "\u22EC" },
    "NotLess;": { p: [8814], c: "\u226E" },
    "NotLessEqual;": { p: [8816], c: "\u2270" },
    "NotLessGreater;": { p: [8824], c: "\u2278" },
    "NotLessLess;": {
        p: [8810, 824],
        c: "\u226A\u0338",
    },
    "NotLessSlantEqual;": {
        p: [10877, 824],
        c: "\u2A7D\u0338",
    },
    "NotLessTilde;": { p: [8820], c: "\u2274" },
    "NotNestedGreaterGreater;": {
        p: [10914, 824],
        c: "\u2AA2\u0338",
    },
    "NotNestedLessLess;": {
        p: [10913, 824],
        c: "\u2AA1\u0338",
    },
    "NotPrecedes;": { p: [8832], c: "\u2280" },
    "NotPrecedesEqual;": {
        p: [10927, 824],
        c: "\u2AAF\u0338",
    },
    "NotPrecedesSlantEqual;": { p: [8928], c: "\u22E0" },
    "NotReverseElement;": { p: [8716], c: "\u220C" },
    "NotRightTriangle;": { p: [8939], c: "\u22EB" },
    "NotRightTriangleBar;": {
        p: [10704, 824],
        c: "\u29D0\u0338",
    },
    "NotRightTriangleEqual;": { p: [8941], c: "\u22ED" },
    "NotSquareSubset;": {
        p: [8847, 824],
        c: "\u228F\u0338",
    },
    "NotSquareSubsetEqual;": { p: [8930], c: "\u22E2" },
    "NotSquareSuperset;": {
        p: [8848, 824],
        c: "\u2290\u0338",
    },
    "NotSquareSupersetEqual;": {
        p: [8931],
        c: "\u22E3",
    },
    "NotSubset;": { p: [8834, 8402], c: "\u2282\u20D2" },
    "NotSubsetEqual;": { p: [8840], c: "\u2288" },
    "NotSucceeds;": { p: [8833], c: "\u2281" },
    "NotSucceedsEqual;": {
        p: [10928, 824],
        c: "\u2AB0\u0338",
    },
    "NotSucceedsSlantEqual;": { p: [8929], c: "\u22E1" },
    "NotSucceedsTilde;": {
        p: [8831, 824],
        c: "\u227F\u0338",
    },
    "NotSuperset;": {
        p: [8835, 8402],
        c: "\u2283\u20D2",
    },
    "NotSupersetEqual;": { p: [8841], c: "\u2289" },
    "NotTilde;": { p: [8769], c: "\u2241" },
    "NotTildeEqual;": { p: [8772], c: "\u2244" },
    "NotTildeFullEqual;": { p: [8775], c: "\u2247" },
    "NotTildeTilde;": { p: [8777], c: "\u2249" },
    "NotVerticalBar;": { p: [8740], c: "\u2224" },
    "Nscr;": { p: [119977], c: "\uD835\uDCA9" },
    Ntilde: { p: [209], c: "\u00D1" },
    "Ntilde;": { p: [209], c: "\u00D1" },
    "Nu;": { p: [925], c: "\u039D" },
    "OElig;": { p: [338], c: "\u0152" },
    Oacute: { p: [211], c: "\u00D3" },
    "Oacute;": { p: [211], c: "\u00D3" },
    Ocirc: { p: [212], c: "\u00D4" },
    "Ocirc;": { p: [212], c: "\u00D4" },
    "Ocy;": { p: [1054], c: "\u041E" },
    "Odblac;": { p: [336], c: "\u0150" },
    "Ofr;": { p: [120082], c: "\uD835\uDD12" },
    Ograve: { p: [210], c: "\u00D2" },
    "Ograve;": { p: [210], c: "\u00D2" },
    "Omacr;": { p: [332], c: "\u014C" },
    "Omega;": { p: [937], c: "\u03A9" },
    "Omicron;": { p: [927], c: "\u039F" },
    "Oopf;": { p: [120134], c: "\uD835\uDD46" },
    "OpenCurlyDoubleQuote;": { p: [8220], c: "\u201C" },
    "OpenCurlyQuote;": { p: [8216], c: "\u2018" },
    "Or;": { p: [10836], c: "\u2A54" },
    "Oscr;": { p: [119978], c: "\uD835\uDCAA" },
    Oslash: { p: [216], c: "\u00D8" },
    "Oslash;": { p: [216], c: "\u00D8" },
    Otilde: { p: [213], c: "\u00D5" },
    "Otilde;": { p: [213], c: "\u00D5" },
    "Otimes;": { p: [10807], c: "\u2A37" },
    Ouml: { p: [214], c: "\u00D6" },
    "Ouml;": { p: [214], c: "\u00D6" },
    "OverBar;": { p: [8254], c: "\u203E" },
    "OverBrace;": { p: [9182], c: "\u23DE" },
    "OverBracket;": { p: [9140], c: "\u23B4" },
    "OverParenthesis;": { p: [9180], c: "\u23DC" },
    "PartialD;": { p: [8706], c: "\u2202" },
    "Pcy;": { p: [1055], c: "\u041F" },
    "Pfr;": { p: [120083], c: "\uD835\uDD13" },
    "Phi;": { p: [934], c: "\u03A6" },
    "Pi;": { p: [928], c: "\u03A0" },
    "PlusMinus;": { p: [177], c: "\u00B1" },
    "Poincareplane;": { p: [8460], c: "\u210C" },
    "Popf;": { p: [8473], c: "\u2119" },
    "Pr;": { p: [10939], c: "\u2ABB" },
    "Precedes;": { p: [8826], c: "\u227A" },
    "PrecedesEqual;": { p: [10927], c: "\u2AAF" },
    "PrecedesSlantEqual;": { p: [8828], c: "\u227C" },
    "PrecedesTilde;": { p: [8830], c: "\u227E" },
    "Prime;": { p: [8243], c: "\u2033" },
    "Product;": { p: [8719], c: "\u220F" },
    "Proportion;": { p: [8759], c: "\u2237" },
    "Proportional;": { p: [8733], c: "\u221D" },
    "Pscr;": { p: [119979], c: "\uD835\uDCAB" },
    "Psi;": { p: [936], c: "\u03A8" },
    QUOT: { p: [34], c: "\u0022" },
    "QUOT;": { p: [34], c: "\u0022" },
    "Qfr;": { p: [120084], c: "\uD835\uDD14" },
    "Qopf;": { p: [8474], c: "\u211A" },
    "Qscr;": { p: [119980], c: "\uD835\uDCAC" },
    "RBarr;": { p: [10512], c: "\u2910" },
    REG: { p: [174], c: "\u00AE" },
    "REG;": { p: [174], c: "\u00AE" },
    "Racute;": { p: [340], c: "\u0154" },
    "Rang;": { p: [10219], c: "\u27EB" },
    "Rarr;": { p: [8608], c: "\u21A0" },
    "Rarrtl;": { p: [10518], c: "\u2916" },
    "Rcaron;": { p: [344], c: "\u0158" },
    "Rcedil;": { p: [342], c: "\u0156" },
    "Rcy;": { p: [1056], c: "\u0420" },
    "Re;": { p: [8476], c: "\u211C" },
    "ReverseElement;": { p: [8715], c: "\u220B" },
    "ReverseEquilibrium;": { p: [8651], c: "\u21CB" },
    "ReverseUpEquilibrium;": { p: [10607], c: "\u296F" },
    "Rfr;": { p: [8476], c: "\u211C" },
    "Rho;": { p: [929], c: "\u03A1" },
    "RightAngleBracket;": { p: [10217], c: "\u27E9" },
    "RightArrow;": { p: [8594], c: "\u2192" },
    "RightArrowBar;": { p: [8677], c: "\u21E5" },
    "RightArrowLeftArrow;": { p: [8644], c: "\u21C4" },
    "RightCeiling;": { p: [8969], c: "\u2309" },
    "RightDoubleBracket;": { p: [10215], c: "\u27E7" },
    "RightDownTeeVector;": { p: [10589], c: "\u295D" },
    "RightDownVector;": { p: [8642], c: "\u21C2" },
    "RightDownVectorBar;": { p: [10581], c: "\u2955" },
    "RightFloor;": { p: [8971], c: "\u230B" },
    "RightTee;": { p: [8866], c: "\u22A2" },
    "RightTeeArrow;": { p: [8614], c: "\u21A6" },
    "RightTeeVector;": { p: [10587], c: "\u295B" },
    "RightTriangle;": { p: [8883], c: "\u22B3" },
    "RightTriangleBar;": { p: [10704], c: "\u29D0" },
    "RightTriangleEqual;": { p: [8885], c: "\u22B5" },
    "RightUpDownVector;": { p: [10575], c: "\u294F" },
    "RightUpTeeVector;": { p: [10588], c: "\u295C" },
    "RightUpVector;": { p: [8638], c: "\u21BE" },
    "RightUpVectorBar;": { p: [10580], c: "\u2954" },
    "RightVector;": { p: [8640], c: "\u21C0" },
    "RightVectorBar;": { p: [10579], c: "\u2953" },
    "Rightarrow;": { p: [8658], c: "\u21D2" },
    "Ropf;": { p: [8477], c: "\u211D" },
    "RoundImplies;": { p: [10608], c: "\u2970" },
    "Rrightarrow;": { p: [8667], c: "\u21DB" },
    "Rscr;": { p: [8475], c: "\u211B" },
    "Rsh;": { p: [8625], c: "\u21B1" },
    "RuleDelayed;": { p: [10740], c: "\u29F4" },
    "SHCHcy;": { p: [1065], c: "\u0429" },
    "SHcy;": { p: [1064], c: "\u0428" },
    "SOFTcy;": { p: [1068], c: "\u042C" },
    "Sacute;": { p: [346], c: "\u015A" },
    "Sc;": { p: [10940], c: "\u2ABC" },
    "Scaron;": { p: [352], c: "\u0160" },
    "Scedil;": { p: [350], c: "\u015E" },
    "Scirc;": { p: [348], c: "\u015C" },
    "Scy;": { p: [1057], c: "\u0421" },
    "Sfr;": { p: [120086], c: "\uD835\uDD16" },
    "ShortDownArrow;": { p: [8595], c: "\u2193" },
    "ShortLeftArrow;": { p: [8592], c: "\u2190" },
    "ShortRightArrow;": { p: [8594], c: "\u2192" },
    "ShortUpArrow;": { p: [8593], c: "\u2191" },
    "Sigma;": { p: [931], c: "\u03A3" },
    "SmallCircle;": { p: [8728], c: "\u2218" },
    "Sopf;": { p: [120138], c: "\uD835\uDD4A" },
    "Sqrt;": { p: [8730], c: "\u221A" },
    "Square;": { p: [9633], c: "\u25A1" },
    "SquareIntersection;": { p: [8851], c: "\u2293" },
    "SquareSubset;": { p: [8847], c: "\u228F" },
    "SquareSubsetEqual;": { p: [8849], c: "\u2291" },
    "SquareSuperset;": { p: [8848], c: "\u2290" },
    "SquareSupersetEqual;": { p: [8850], c: "\u2292" },
    "SquareUnion;": { p: [8852], c: "\u2294" },
    "Sscr;": { p: [119982], c: "\uD835\uDCAE" },
    "Star;": { p: [8902], c: "\u22C6" },
    "Sub;": { p: [8912], c: "\u22D0" },
    "Subset;": { p: [8912], c: "\u22D0" },
    "SubsetEqual;": { p: [8838], c: "\u2286" },
    "Succeeds;": { p: [8827], c: "\u227B" },
    "SucceedsEqual;": { p: [10928], c: "\u2AB0" },
    "SucceedsSlantEqual;": { p: [8829], c: "\u227D" },
    "SucceedsTilde;": { p: [8831], c: "\u227F" },
    "SuchThat;": { p: [8715], c: "\u220B" },
    "Sum;": { p: [8721], c: "\u2211" },
    "Sup;": { p: [8913], c: "\u22D1" },
    "Superset;": { p: [8835], c: "\u2283" },
    "SupersetEqual;": { p: [8839], c: "\u2287" },
    "Supset;": { p: [8913], c: "\u22D1" },
    THORN: { p: [222], c: "\u00DE" },
    "THORN;": { p: [222], c: "\u00DE" },
    "TRADE;": { p: [8482], c: "\u2122" },
    "TSHcy;": { p: [1035], c: "\u040B" },
    "TScy;": { p: [1062], c: "\u0426" },
    "Tab;": { p: [9], c: "\u0009" },
    "Tau;": { p: [932], c: "\u03A4" },
    "Tcaron;": { p: [356], c: "\u0164" },
    "Tcedil;": { p: [354], c: "\u0162" },
    "Tcy;": { p: [1058], c: "\u0422" },
    "Tfr;": { p: [120087], c: "\uD835\uDD17" },
    "Therefore;": { p: [8756], c: "\u2234" },
    "Theta;": { p: [920], c: "\u0398" },
    "ThickSpace;": {
        p: [8287, 8202],
        c: "\u205F\u200A",
    },
    "ThinSpace;": { p: [8201], c: "\u2009" },
    "Tilde;": { p: [8764], c: "\u223C" },
    "TildeEqual;": { p: [8771], c: "\u2243" },
    "TildeFullEqual;": { p: [8773], c: "\u2245" },
    "TildeTilde;": { p: [8776], c: "\u2248" },
    "Topf;": { p: [120139], c: "\uD835\uDD4B" },
    "TripleDot;": { p: [8411], c: "\u20DB" },
    "Tscr;": { p: [119983], c: "\uD835\uDCAF" },
    "Tstrok;": { p: [358], c: "\u0166" },
    Uacute: { p: [218], c: "\u00DA" },
    "Uacute;": { p: [218], c: "\u00DA" },
    "Uarr;": { p: [8607], c: "\u219F" },
    "Uarrocir;": { p: [10569], c: "\u2949" },
    "Ubrcy;": { p: [1038], c: "\u040E" },
    "Ubreve;": { p: [364], c: "\u016C" },
    Ucirc: { p: [219], c: "\u00DB" },
    "Ucirc;": { p: [219], c: "\u00DB" },
    "Ucy;": { p: [1059], c: "\u0423" },
    "Udblac;": { p: [368], c: "\u0170" },
    "Ufr;": { p: [120088], c: "\uD835\uDD18" },
    Ugrave: { p: [217], c: "\u00D9" },
    "Ugrave;": { p: [217], c: "\u00D9" },
    "Umacr;": { p: [362], c: "\u016A" },
    "UnderBar;": { p: [95], c: "\u005F" },
    "UnderBrace;": { p: [9183], c: "\u23DF" },
    "UnderBracket;": { p: [9141], c: "\u23B5" },
    "UnderParenthesis;": { p: [9181], c: "\u23DD" },
    "Union;": { p: [8899], c: "\u22C3" },
    "UnionPlus;": { p: [8846], c: "\u228E" },
    "Uogon;": { p: [370], c: "\u0172" },
    "Uopf;": { p: [120140], c: "\uD835\uDD4C" },
    "UpArrow;": { p: [8593], c: "\u2191" },
    "UpArrowBar;": { p: [10514], c: "\u2912" },
    "UpArrowDownArrow;": { p: [8645], c: "\u21C5" },
    "UpDownArrow;": { p: [8597], c: "\u2195" },
    "UpEquilibrium;": { p: [10606], c: "\u296E" },
    "UpTee;": { p: [8869], c: "\u22A5" },
    "UpTeeArrow;": { p: [8613], c: "\u21A5" },
    "Uparrow;": { p: [8657], c: "\u21D1" },
    "Updownarrow;": { p: [8661], c: "\u21D5" },
    "UpperLeftArrow;": { p: [8598], c: "\u2196" },
    "UpperRightArrow;": { p: [8599], c: "\u2197" },
    "Upsi;": { p: [978], c: "\u03D2" },
    "Upsilon;": { p: [933], c: "\u03A5" },
    "Uring;": { p: [366], c: "\u016E" },
    "Uscr;": { p: [119984], c: "\uD835\uDCB0" },
    "Utilde;": { p: [360], c: "\u0168" },
    Uuml: { p: [220], c: "\u00DC" },
    "Uuml;": { p: [220], c: "\u00DC" },
    "VDash;": { p: [8875], c: "\u22AB" },
    "Vbar;": { p: [10987], c: "\u2AEB" },
    "Vcy;": { p: [1042], c: "\u0412" },
    "Vdash;": { p: [8873], c: "\u22A9" },
    "Vdashl;": { p: [10982], c: "\u2AE6" },
    "Vee;": { p: [8897], c: "\u22C1" },
    "Verbar;": { p: [8214], c: "\u2016" },
    "Vert;": { p: [8214], c: "\u2016" },
    "VerticalBar;": { p: [8739], c: "\u2223" },
    "VerticalLine;": { p: [124], c: "\u007C" },
    "VerticalSeparator;": { p: [10072], c: "\u2758" },
    "VerticalTilde;": { p: [8768], c: "\u2240" },
    "VeryThinSpace;": { p: [8202], c: "\u200A" },
    "Vfr;": { p: [120089], c: "\uD835\uDD19" },
    "Vopf;": { p: [120141], c: "\uD835\uDD4D" },
    "Vscr;": { p: [119985], c: "\uD835\uDCB1" },
    "Vvdash;": { p: [8874], c: "\u22AA" },
    "Wcirc;": { p: [372], c: "\u0174" },
    "Wedge;": { p: [8896], c: "\u22C0" },
    "Wfr;": { p: [120090], c: "\uD835\uDD1A" },
    "Wopf;": { p: [120142], c: "\uD835\uDD4E" },
    "Wscr;": { p: [119986], c: "\uD835\uDCB2" },
    "Xfr;": { p: [120091], c: "\uD835\uDD1B" },
    "Xi;": { p: [926], c: "\u039E" },
    "Xopf;": { p: [120143], c: "\uD835\uDD4F" },
    "Xscr;": { p: [119987], c: "\uD835\uDCB3" },
    "YAcy;": { p: [1071], c: "\u042F" },
    "YIcy;": { p: [1031], c: "\u0407" },
    "YUcy;": { p: [1070], c: "\u042E" },
    Yacute: { p: [221], c: "\u00DD" },
    "Yacute;": { p: [221], c: "\u00DD" },
    "Ycirc;": { p: [374], c: "\u0176" },
    "Ycy;": { p: [1067], c: "\u042B" },
    "Yfr;": { p: [120092], c: "\uD835\uDD1C" },
    "Yopf;": { p: [120144], c: "\uD835\uDD50" },
    "Yscr;": { p: [119988], c: "\uD835\uDCB4" },
    "Yuml;": { p: [376], c: "\u0178" },
    "ZHcy;": { p: [1046], c: "\u0416" },
    "Zacute;": { p: [377], c: "\u0179" },
    "Zcaron;": { p: [381], c: "\u017D" },
    "Zcy;": { p: [1047], c: "\u0417" },
    "Zdot;": { p: [379], c: "\u017B" },
    "ZeroWidthSpace;": { p: [8203], c: "\u200B" },
    "Zeta;": { p: [918], c: "\u0396" },
    "Zfr;": { p: [8488], c: "\u2128" },
    "Zopf;": { p: [8484], c: "\u2124" },
    "Zscr;": { p: [119989], c: "\uD835\uDCB5" },
    aacute: { p: [225], c: "\u00E1" },
    "aacute;": { p: [225], c: "\u00E1" },
    "abreve;": { p: [259], c: "\u0103" },
    "ac;": { p: [8766], c: "\u223E" },
    "acE;": { p: [8766, 819], c: "\u223E\u0333" },
    "acd;": { p: [8767], c: "\u223F" },
    acirc: { p: [226], c: "\u00E2" },
    "acirc;": { p: [226], c: "\u00E2" },
    acute: { p: [180], c: "\u00B4" },
    "acute;": { p: [180], c: "\u00B4" },
    "acy;": { p: [1072], c: "\u0430" },
    aelig: { p: [230], c: "\u00E6" },
    "aelig;": { p: [230], c: "\u00E6" },
    "af;": { p: [8289], c: "\u2061" },
    "afr;": { p: [120094], c: "\uD835\uDD1E" },
    agrave: { p: [224], c: "\u00E0" },
    "agrave;": { p: [224], c: "\u00E0" },
    "alefsym;": { p: [8501], c: "\u2135" },
    "aleph;": { p: [8501], c: "\u2135" },
    "alpha;": { p: [945], c: "\u03B1" },
    "amacr;": { p: [257], c: "\u0101" },
    "amalg;": { p: [10815], c: "\u2A3F" },
    amp: { p: [38], c: "\u0026" },
    "amp;": { p: [38], c: "\u0026" },
    "and;": { p: [8743], c: "\u2227" },
    "andand;": { p: [10837], c: "\u2A55" },
    "andd;": { p: [10844], c: "\u2A5C" },
    "andslope;": { p: [10840], c: "\u2A58" },
    "andv;": { p: [10842], c: "\u2A5A" },
    "ang;": { p: [8736], c: "\u2220" },
    "ange;": { p: [10660], c: "\u29A4" },
    "angle;": { p: [8736], c: "\u2220" },
    "angmsd;": { p: [8737], c: "\u2221" },
    "angmsdaa;": { p: [10664], c: "\u29A8" },
    "angmsdab;": { p: [10665], c: "\u29A9" },
    "angmsdac;": { p: [10666], c: "\u29AA" },
    "angmsdad;": { p: [10667], c: "\u29AB" },
    "angmsdae;": { p: [10668], c: "\u29AC" },
    "angmsdaf;": { p: [10669], c: "\u29AD" },
    "angmsdag;": { p: [10670], c: "\u29AE" },
    "angmsdah;": { p: [10671], c: "\u29AF" },
    "angrt;": { p: [8735], c: "\u221F" },
    "angrtvb;": { p: [8894], c: "\u22BE" },
    "angrtvbd;": { p: [10653], c: "\u299D" },
    "angsph;": { p: [8738], c: "\u2222" },
    "angst;": { p: [197], c: "\u00C5" },
    "angzarr;": { p: [9084], c: "\u237C" },
    "aogon;": { p: [261], c: "\u0105" },
    "aopf;": { p: [120146], c: "\uD835\uDD52" },
    "ap;": { p: [8776], c: "\u2248" },
    "apE;": { p: [10864], c: "\u2A70" },
    "apacir;": { p: [10863], c: "\u2A6F" },
    "ape;": { p: [8778], c: "\u224A" },
    "apid;": { p: [8779], c: "\u224B" },
    "apos;": { p: [39], c: "\u0027" },
    "approx;": { p: [8776], c: "\u2248" },
    "approxeq;": { p: [8778], c: "\u224A" },
    aring: { p: [229], c: "\u00E5" },
    "aring;": { p: [229], c: "\u00E5" },
    "ascr;": { p: [119990], c: "\uD835\uDCB6" },
    "ast;": { p: [42], c: "\u002A" },
    "asymp;": { p: [8776], c: "\u2248" },
    "asympeq;": { p: [8781], c: "\u224D" },
    atilde: { p: [227], c: "\u00E3" },
    "atilde;": { p: [227], c: "\u00E3" },
    auml: { p: [228], c: "\u00E4" },
    "auml;": { p: [228], c: "\u00E4" },
    "awconint;": { p: [8755], c: "\u2233" },
    "awint;": { p: [10769], c: "\u2A11" },
    "bNot;": { p: [10989], c: "\u2AED" },
    "backcong;": { p: [8780], c: "\u224C" },
    "backepsilon;": { p: [1014], c: "\u03F6" },
    "backprime;": { p: [8245], c: "\u2035" },
    "backsim;": { p: [8765], c: "\u223D" },
    "backsimeq;": { p: [8909], c: "\u22CD" },
    "barvee;": { p: [8893], c: "\u22BD" },
    "barwed;": { p: [8965], c: "\u2305" },
    "barwedge;": { p: [8965], c: "\u2305" },
    "bbrk;": { p: [9141], c: "\u23B5" },
    "bbrktbrk;": { p: [9142], c: "\u23B6" },
    "bcong;": { p: [8780], c: "\u224C" },
    "bcy;": { p: [1073], c: "\u0431" },
    "bdquo;": { p: [8222], c: "\u201E" },
    "becaus;": { p: [8757], c: "\u2235" },
    "because;": { p: [8757], c: "\u2235" },
    "bemptyv;": { p: [10672], c: "\u29B0" },
    "bepsi;": { p: [1014], c: "\u03F6" },
    "bernou;": { p: [8492], c: "\u212C" },
    "beta;": { p: [946], c: "\u03B2" },
    "beth;": { p: [8502], c: "\u2136" },
    "between;": { p: [8812], c: "\u226C" },
    "bfr;": { p: [120095], c: "\uD835\uDD1F" },
    "bigcap;": { p: [8898], c: "\u22C2" },
    "bigcirc;": { p: [9711], c: "\u25EF" },
    "bigcup;": { p: [8899], c: "\u22C3" },
    "bigodot;": { p: [10752], c: "\u2A00" },
    "bigoplus;": { p: [10753], c: "\u2A01" },
    "bigotimes;": { p: [10754], c: "\u2A02" },
    "bigsqcup;": { p: [10758], c: "\u2A06" },
    "bigstar;": { p: [9733], c: "\u2605" },
    "bigtriangledown;": { p: [9661], c: "\u25BD" },
    "bigtriangleup;": { p: [9651], c: "\u25B3" },
    "biguplus;": { p: [10756], c: "\u2A04" },
    "bigvee;": { p: [8897], c: "\u22C1" },
    "bigwedge;": { p: [8896], c: "\u22C0" },
    "bkarow;": { p: [10509], c: "\u290D" },
    "blacklozenge;": { p: [10731], c: "\u29EB" },
    "blacksquare;": { p: [9642], c: "\u25AA" },
    "blacktriangle;": { p: [9652], c: "\u25B4" },
    "blacktriangledown;": { p: [9662], c: "\u25BE" },
    "blacktriangleleft;": { p: [9666], c: "\u25C2" },
    "blacktriangleright;": { p: [9656], c: "\u25B8" },
    "blank;": { p: [9251], c: "\u2423" },
    "blk12;": { p: [9618], c: "\u2592" },
    "blk14;": { p: [9617], c: "\u2591" },
    "blk34;": { p: [9619], c: "\u2593" },
    "block;": { p: [9608], c: "\u2588" },
    "bne;": { p: [61, 8421], c: "\u003D\u20E5" },
    "bnequiv;": { p: [8801, 8421], c: "\u2261\u20E5" },
    "bnot;": { p: [8976], c: "\u2310" },
    "bopf;": { p: [120147], c: "\uD835\uDD53" },
    "bot;": { p: [8869], c: "\u22A5" },
    "bottom;": { p: [8869], c: "\u22A5" },
    "bowtie;": { p: [8904], c: "\u22C8" },
    "boxDL;": { p: [9559], c: "\u2557" },
    "boxDR;": { p: [9556], c: "\u2554" },
    "boxDl;": { p: [9558], c: "\u2556" },
    "boxDr;": { p: [9555], c: "\u2553" },
    "boxH;": { p: [9552], c: "\u2550" },
    "boxHD;": { p: [9574], c: "\u2566" },
    "boxHU;": { p: [9577], c: "\u2569" },
    "boxHd;": { p: [9572], c: "\u2564" },
    "boxHu;": { p: [9575], c: "\u2567" },
    "boxUL;": { p: [9565], c: "\u255D" },
    "boxUR;": { p: [9562], c: "\u255A" },
    "boxUl;": { p: [9564], c: "\u255C" },
    "boxUr;": { p: [9561], c: "\u2559" },
    "boxV;": { p: [9553], c: "\u2551" },
    "boxVH;": { p: [9580], c: "\u256C" },
    "boxVL;": { p: [9571], c: "\u2563" },
    "boxVR;": { p: [9568], c: "\u2560" },
    "boxVh;": { p: [9579], c: "\u256B" },
    "boxVl;": { p: [9570], c: "\u2562" },
    "boxVr;": { p: [9567], c: "\u255F" },
    "boxbox;": { p: [10697], c: "\u29C9" },
    "boxdL;": { p: [9557], c: "\u2555" },
    "boxdR;": { p: [9554], c: "\u2552" },
    "boxdl;": { p: [9488], c: "\u2510" },
    "boxdr;": { p: [9484], c: "\u250C" },
    "boxh;": { p: [9472], c: "\u2500" },
    "boxhD;": { p: [9573], c: "\u2565" },
    "boxhU;": { p: [9576], c: "\u2568" },
    "boxhd;": { p: [9516], c: "\u252C" },
    "boxhu;": { p: [9524], c: "\u2534" },
    "boxminus;": { p: [8863], c: "\u229F" },
    "boxplus;": { p: [8862], c: "\u229E" },
    "boxtimes;": { p: [8864], c: "\u22A0" },
    "boxuL;": { p: [9563], c: "\u255B" },
    "boxuR;": { p: [9560], c: "\u2558" },
    "boxul;": { p: [9496], c: "\u2518" },
    "boxur;": { p: [9492], c: "\u2514" },
    "boxv;": { p: [9474], c: "\u2502" },
    "boxvH;": { p: [9578], c: "\u256A" },
    "boxvL;": { p: [9569], c: "\u2561" },
    "boxvR;": { p: [9566], c: "\u255E" },
    "boxvh;": { p: [9532], c: "\u253C" },
    "boxvl;": { p: [9508], c: "\u2524" },
    "boxvr;": { p: [9500], c: "\u251C" },
    "bprime;": { p: [8245], c: "\u2035" },
    "breve;": { p: [728], c: "\u02D8" },
    brvbar: { p: [166], c: "\u00A6" },
    "brvbar;": { p: [166], c: "\u00A6" },
    "bscr;": { p: [119991], c: "\uD835\uDCB7" },
    "bsemi;": { p: [8271], c: "\u204F" },
    "bsim;": { p: [8765], c: "\u223D" },
    "bsime;": { p: [8909], c: "\u22CD" },
    "bsol;": { p: [92], c: "\u005C" },
    "bsolb;": { p: [10693], c: "\u29C5" },
    "bsolhsub;": { p: [10184], c: "\u27C8" },
    "bull;": { p: [8226], c: "\u2022" },
    "bullet;": { p: [8226], c: "\u2022" },
    "bump;": { p: [8782], c: "\u224E" },
    "bumpE;": { p: [10926], c: "\u2AAE" },
    "bumpe;": { p: [8783], c: "\u224F" },
    "bumpeq;": { p: [8783], c: "\u224F" },
    "cacute;": { p: [263], c: "\u0107" },
    "cap;": { p: [8745], c: "\u2229" },
    "capand;": { p: [10820], c: "\u2A44" },
    "capbrcup;": { p: [10825], c: "\u2A49" },
    "capcap;": { p: [10827], c: "\u2A4B" },
    "capcup;": { p: [10823], c: "\u2A47" },
    "capdot;": { p: [10816], c: "\u2A40" },
    "caps;": { p: [8745, 65024], c: "\u2229\uFE00" },
    "caret;": { p: [8257], c: "\u2041" },
    "caron;": { p: [711], c: "\u02C7" },
    "ccaps;": { p: [10829], c: "\u2A4D" },
    "ccaron;": { p: [269], c: "\u010D" },
    ccedil: { p: [231], c: "\u00E7" },
    "ccedil;": { p: [231], c: "\u00E7" },
    "ccirc;": { p: [265], c: "\u0109" },
    "ccups;": { p: [10828], c: "\u2A4C" },
    "ccupssm;": { p: [10832], c: "\u2A50" },
    "cdot;": { p: [267], c: "\u010B" },
    cedil: { p: [184], c: "\u00B8" },
    "cedil;": { p: [184], c: "\u00B8" },
    "cemptyv;": { p: [10674], c: "\u29B2" },
    cent: { p: [162], c: "\u00A2" },
    "cent;": { p: [162], c: "\u00A2" },
    "centerdot;": { p: [183], c: "\u00B7" },
    "cfr;": { p: [120096], c: "\uD835\uDD20" },
    "chcy;": { p: [1095], c: "\u0447" },
    "check;": { p: [10003], c: "\u2713" },
    "checkmark;": { p: [10003], c: "\u2713" },
    "chi;": { p: [967], c: "\u03C7" },
    "cir;": { p: [9675], c: "\u25CB" },
    "cirE;": { p: [10691], c: "\u29C3" },
    "circ;": { p: [710], c: "\u02C6" },
    "circeq;": { p: [8791], c: "\u2257" },
    "circlearrowleft;": { p: [8634], c: "\u21BA" },
    "circlearrowright;": { p: [8635], c: "\u21BB" },
    "circledR;": { p: [174], c: "\u00AE" },
    "circledS;": { p: [9416], c: "\u24C8" },
    "circledast;": { p: [8859], c: "\u229B" },
    "circledcirc;": { p: [8858], c: "\u229A" },
    "circleddash;": { p: [8861], c: "\u229D" },
    "cire;": { p: [8791], c: "\u2257" },
    "cirfnint;": { p: [10768], c: "\u2A10" },
    "cirmid;": { p: [10991], c: "\u2AEF" },
    "cirscir;": { p: [10690], c: "\u29C2" },
    "clubs;": { p: [9827], c: "\u2663" },
    "clubsuit;": { p: [9827], c: "\u2663" },
    "colon;": { p: [58], c: "\u003A" },
    "colone;": { p: [8788], c: "\u2254" },
    "coloneq;": { p: [8788], c: "\u2254" },
    "comma;": { p: [44], c: "\u002C" },
    "commat;": { p: [64], c: "\u0040" },
    "comp;": { p: [8705], c: "\u2201" },
    "compfn;": { p: [8728], c: "\u2218" },
    "complement;": { p: [8705], c: "\u2201" },
    "complexes;": { p: [8450], c: "\u2102" },
    "cong;": { p: [8773], c: "\u2245" },
    "congdot;": { p: [10861], c: "\u2A6D" },
    "conint;": { p: [8750], c: "\u222E" },
    "copf;": { p: [120148], c: "\uD835\uDD54" },
    "coprod;": { p: [8720], c: "\u2210" },
    copy: { p: [169], c: "\u00A9" },
    "copy;": { p: [169], c: "\u00A9" },
    "copysr;": { p: [8471], c: "\u2117" },
    "crarr;": { p: [8629], c: "\u21B5" },
    "cross;": { p: [10007], c: "\u2717" },
    "cscr;": { p: [119992], c: "\uD835\uDCB8" },
    "csub;": { p: [10959], c: "\u2ACF" },
    "csube;": { p: [10961], c: "\u2AD1" },
    "csup;": { p: [10960], c: "\u2AD0" },
    "csupe;": { p: [10962], c: "\u2AD2" },
    "ctdot;": { p: [8943], c: "\u22EF" },
    "cudarrl;": { p: [10552], c: "\u2938" },
    "cudarrr;": { p: [10549], c: "\u2935" },
    "cuepr;": { p: [8926], c: "\u22DE" },
    "cuesc;": { p: [8927], c: "\u22DF" },
    "cularr;": { p: [8630], c: "\u21B6" },
    "cularrp;": { p: [10557], c: "\u293D" },
    "cup;": { p: [8746], c: "\u222A" },
    "cupbrcap;": { p: [10824], c: "\u2A48" },
    "cupcap;": { p: [10822], c: "\u2A46" },
    "cupcup;": { p: [10826], c: "\u2A4A" },
    "cupdot;": { p: [8845], c: "\u228D" },
    "cupor;": { p: [10821], c: "\u2A45" },
    "cups;": { p: [8746, 65024], c: "\u222A\uFE00" },
    "curarr;": { p: [8631], c: "\u21B7" },
    "curarrm;": { p: [10556], c: "\u293C" },
    "curlyeqprec;": { p: [8926], c: "\u22DE" },
    "curlyeqsucc;": { p: [8927], c: "\u22DF" },
    "curlyvee;": { p: [8910], c: "\u22CE" },
    "curlywedge;": { p: [8911], c: "\u22CF" },
    curren: { p: [164], c: "\u00A4" },
    "curren;": { p: [164], c: "\u00A4" },
    "curvearrowleft;": { p: [8630], c: "\u21B6" },
    "curvearrowright;": { p: [8631], c: "\u21B7" },
    "cuvee;": { p: [8910], c: "\u22CE" },
    "cuwed;": { p: [8911], c: "\u22CF" },
    "cwconint;": { p: [8754], c: "\u2232" },
    "cwint;": { p: [8753], c: "\u2231" },
    "cylcty;": { p: [9005], c: "\u232D" },
    "dArr;": { p: [8659], c: "\u21D3" },
    "dHar;": { p: [10597], c: "\u2965" },
    "dagger;": { p: [8224], c: "\u2020" },
    "daleth;": { p: [8504], c: "\u2138" },
    "darr;": { p: [8595], c: "\u2193" },
    "dash;": { p: [8208], c: "\u2010" },
    "dashv;": { p: [8867], c: "\u22A3" },
    "dbkarow;": { p: [10511], c: "\u290F" },
    "dblac;": { p: [733], c: "\u02DD" },
    "dcaron;": { p: [271], c: "\u010F" },
    "dcy;": { p: [1076], c: "\u0434" },
    "dd;": { p: [8518], c: "\u2146" },
    "ddagger;": { p: [8225], c: "\u2021" },
    "ddarr;": { p: [8650], c: "\u21CA" },
    "ddotseq;": { p: [10871], c: "\u2A77" },
    deg: { p: [176], c: "\u00B0" },
    "deg;": { p: [176], c: "\u00B0" },
    "delta;": { p: [948], c: "\u03B4" },
    "demptyv;": { p: [10673], c: "\u29B1" },
    "dfisht;": { p: [10623], c: "\u297F" },
    "dfr;": { p: [120097], c: "\uD835\uDD21" },
    "dharl;": { p: [8643], c: "\u21C3" },
    "dharr;": { p: [8642], c: "\u21C2" },
    "diam;": { p: [8900], c: "\u22C4" },
    "diamond;": { p: [8900], c: "\u22C4" },
    "diamondsuit;": { p: [9830], c: "\u2666" },
    "diams;": { p: [9830], c: "\u2666" },
    "die;": { p: [168], c: "\u00A8" },
    "digamma;": { p: [989], c: "\u03DD" },
    "disin;": { p: [8946], c: "\u22F2" },
    "div;": { p: [247], c: "\u00F7" },
    divide: { p: [247], c: "\u00F7" },
    "divide;": { p: [247], c: "\u00F7" },
    "divideontimes;": { p: [8903], c: "\u22C7" },
    "divonx;": { p: [8903], c: "\u22C7" },
    "djcy;": { p: [1106], c: "\u0452" },
    "dlcorn;": { p: [8990], c: "\u231E" },
    "dlcrop;": { p: [8973], c: "\u230D" },
    "dollar;": { p: [36], c: "\u0024" },
    "dopf;": { p: [120149], c: "\uD835\uDD55" },
    "dot;": { p: [729], c: "\u02D9" },
    "doteq;": { p: [8784], c: "\u2250" },
    "doteqdot;": { p: [8785], c: "\u2251" },
    "dotminus;": { p: [8760], c: "\u2238" },
    "dotplus;": { p: [8724], c: "\u2214" },
    "dotsquare;": { p: [8865], c: "\u22A1" },
    "doublebarwedge;": { p: [8966], c: "\u2306" },
    "downarrow;": { p: [8595], c: "\u2193" },
    "downdownarrows;": { p: [8650], c: "\u21CA" },
    "downharpoonleft;": { p: [8643], c: "\u21C3" },
    "downharpoonright;": { p: [8642], c: "\u21C2" },
    "drbkarow;": { p: [10512], c: "\u2910" },
    "drcorn;": { p: [8991], c: "\u231F" },
    "drcrop;": { p: [8972], c: "\u230C" },
    "dscr;": { p: [119993], c: "\uD835\uDCB9" },
    "dscy;": { p: [1109], c: "\u0455" },
    "dsol;": { p: [10742], c: "\u29F6" },
    "dstrok;": { p: [273], c: "\u0111" },
    "dtdot;": { p: [8945], c: "\u22F1" },
    "dtri;": { p: [9663], c: "\u25BF" },
    "dtrif;": { p: [9662], c: "\u25BE" },
    "duarr;": { p: [8693], c: "\u21F5" },
    "duhar;": { p: [10607], c: "\u296F" },
    "dwangle;": { p: [10662], c: "\u29A6" },
    "dzcy;": { p: [1119], c: "\u045F" },
    "dzigrarr;": { p: [10239], c: "\u27FF" },
    "eDDot;": { p: [10871], c: "\u2A77" },
    "eDot;": { p: [8785], c: "\u2251" },
    eacute: { p: [233], c: "\u00E9" },
    "eacute;": { p: [233], c: "\u00E9" },
    "easter;": { p: [10862], c: "\u2A6E" },
    "ecaron;": { p: [283], c: "\u011B" },
    "ecir;": { p: [8790], c: "\u2256" },
    ecirc: { p: [234], c: "\u00EA" },
    "ecirc;": { p: [234], c: "\u00EA" },
    "ecolon;": { p: [8789], c: "\u2255" },
    "ecy;": { p: [1101], c: "\u044D" },
    "edot;": { p: [279], c: "\u0117" },
    "ee;": { p: [8519], c: "\u2147" },
    "efDot;": { p: [8786], c: "\u2252" },
    "efr;": { p: [120098], c: "\uD835\uDD22" },
    "eg;": { p: [10906], c: "\u2A9A" },
    egrave: { p: [232], c: "\u00E8" },
    "egrave;": { p: [232], c: "\u00E8" },
    "egs;": { p: [10902], c: "\u2A96" },
    "egsdot;": { p: [10904], c: "\u2A98" },
    "el;": { p: [10905], c: "\u2A99" },
    "elinters;": { p: [9191], c: "\u23E7" },
    "ell;": { p: [8467], c: "\u2113" },
    "els;": { p: [10901], c: "\u2A95" },
    "elsdot;": { p: [10903], c: "\u2A97" },
    "emacr;": { p: [275], c: "\u0113" },
    "empty;": { p: [8709], c: "\u2205" },
    "emptyset;": { p: [8709], c: "\u2205" },
    "emptyv;": { p: [8709], c: "\u2205" },
    "emsp13;": { p: [8196], c: "\u2004" },
    "emsp14;": { p: [8197], c: "\u2005" },
    "emsp;": { p: [8195], c: "\u2003" },
    "eng;": { p: [331], c: "\u014B" },
    "ensp;": { p: [8194], c: "\u2002" },
    "eogon;": { p: [281], c: "\u0119" },
    "eopf;": { p: [120150], c: "\uD835\uDD56" },
    "epar;": { p: [8917], c: "\u22D5" },
    "eparsl;": { p: [10723], c: "\u29E3" },
    "eplus;": { p: [10865], c: "\u2A71" },
    "epsi;": { p: [949], c: "\u03B5" },
    "epsilon;": { p: [949], c: "\u03B5" },
    "epsiv;": { p: [1013], c: "\u03F5" },
    "eqcirc;": { p: [8790], c: "\u2256" },
    "eqcolon;": { p: [8789], c: "\u2255" },
    "eqsim;": { p: [8770], c: "\u2242" },
    "eqslantgtr;": { p: [10902], c: "\u2A96" },
    "eqslantless;": { p: [10901], c: "\u2A95" },
    "equals;": { p: [61], c: "\u003D" },
    "equest;": { p: [8799], c: "\u225F" },
    "equiv;": { p: [8801], c: "\u2261" },
    "equivDD;": { p: [10872], c: "\u2A78" },
    "eqvparsl;": { p: [10725], c: "\u29E5" },
    "erDot;": { p: [8787], c: "\u2253" },
    "erarr;": { p: [10609], c: "\u2971" },
    "escr;": { p: [8495], c: "\u212F" },
    "esdot;": { p: [8784], c: "\u2250" },
    "esim;": { p: [8770], c: "\u2242" },
    "eta;": { p: [951], c: "\u03B7" },
    eth: { p: [240], c: "\u00F0" },
    "eth;": { p: [240], c: "\u00F0" },
    euml: { p: [235], c: "\u00EB" },
    "euml;": { p: [235], c: "\u00EB" },
    "euro;": { p: [8364], c: "\u20AC" },
    "excl;": { p: [33], c: "\u0021" },
    "exist;": { p: [8707], c: "\u2203" },
    "expectation;": { p: [8496], c: "\u2130" },
    "exponentiale;": { p: [8519], c: "\u2147" },
    "fallingdotseq;": { p: [8786], c: "\u2252" },
    "fcy;": { p: [1092], c: "\u0444" },
    "female;": { p: [9792], c: "\u2640" },
    "ffilig;": { p: [64259], c: "\uFB03" },
    "fflig;": { p: [64256], c: "\uFB00" },
    "ffllig;": { p: [64260], c: "\uFB04" },
    "ffr;": { p: [120099], c: "\uD835\uDD23" },
    "filig;": { p: [64257], c: "\uFB01" },
    "fjlig;": { p: [102, 106], c: "\u0066\u006A" },
    "flat;": { p: [9837], c: "\u266D" },
    "fllig;": { p: [64258], c: "\uFB02" },
    "fltns;": { p: [9649], c: "\u25B1" },
    "fnof;": { p: [402], c: "\u0192" },
    "fopf;": { p: [120151], c: "\uD835\uDD57" },
    "forall;": { p: [8704], c: "\u2200" },
    "fork;": { p: [8916], c: "\u22D4" },
    "forkv;": { p: [10969], c: "\u2AD9" },
    "fpartint;": { p: [10765], c: "\u2A0D" },
    frac12: { p: [189], c: "\u00BD" },
    "frac12;": { p: [189], c: "\u00BD" },
    "frac13;": { p: [8531], c: "\u2153" },
    frac14: { p: [188], c: "\u00BC" },
    "frac14;": { p: [188], c: "\u00BC" },
    "frac15;": { p: [8533], c: "\u2155" },
    "frac16;": { p: [8537], c: "\u2159" },
    "frac18;": { p: [8539], c: "\u215B" },
    "frac23;": { p: [8532], c: "\u2154" },
    "frac25;": { p: [8534], c: "\u2156" },
    frac34: { p: [190], c: "\u00BE" },
    "frac34;": { p: [190], c: "\u00BE" },
    "frac35;": { p: [8535], c: "\u2157" },
    "frac38;": { p: [8540], c: "\u215C" },
    "frac45;": { p: [8536], c: "\u2158" },
    "frac56;": { p: [8538], c: "\u215A" },
    "frac58;": { p: [8541], c: "\u215D" },
    "frac78;": { p: [8542], c: "\u215E" },
    "frasl;": { p: [8260], c: "\u2044" },
    "frown;": { p: [8994], c: "\u2322" },
    "fscr;": { p: [119995], c: "\uD835\uDCBB" },
    "gE;": { p: [8807], c: "\u2267" },
    "gEl;": { p: [10892], c: "\u2A8C" },
    "gacute;": { p: [501], c: "\u01F5" },
    "gamma;": { p: [947], c: "\u03B3" },
    "gammad;": { p: [989], c: "\u03DD" },
    "gap;": { p: [10886], c: "\u2A86" },
    "gbreve;": { p: [287], c: "\u011F" },
    "gcirc;": { p: [285], c: "\u011D" },
    "gcy;": { p: [1075], c: "\u0433" },
    "gdot;": { p: [289], c: "\u0121" },
    "ge;": { p: [8805], c: "\u2265" },
    "gel;": { p: [8923], c: "\u22DB" },
    "geq;": { p: [8805], c: "\u2265" },
    "geqq;": { p: [8807], c: "\u2267" },
    "geqslant;": { p: [10878], c: "\u2A7E" },
    "ges;": { p: [10878], c: "\u2A7E" },
    "gescc;": { p: [10921], c: "\u2AA9" },
    "gesdot;": { p: [10880], c: "\u2A80" },
    "gesdoto;": { p: [10882], c: "\u2A82" },
    "gesdotol;": { p: [10884], c: "\u2A84" },
    "gesl;": { p: [8923, 65024], c: "\u22DB\uFE00" },
    "gesles;": { p: [10900], c: "\u2A94" },
    "gfr;": { p: [120100], c: "\uD835\uDD24" },
    "gg;": { p: [8811], c: "\u226B" },
    "ggg;": { p: [8921], c: "\u22D9" },
    "gimel;": { p: [8503], c: "\u2137" },
    "gjcy;": { p: [1107], c: "\u0453" },
    "gl;": { p: [8823], c: "\u2277" },
    "glE;": { p: [10898], c: "\u2A92" },
    "gla;": { p: [10917], c: "\u2AA5" },
    "glj;": { p: [10916], c: "\u2AA4" },
    "gnE;": { p: [8809], c: "\u2269" },
    "gnap;": { p: [10890], c: "\u2A8A" },
    "gnapprox;": { p: [10890], c: "\u2A8A" },
    "gne;": { p: [10888], c: "\u2A88" },
    "gneq;": { p: [10888], c: "\u2A88" },
    "gneqq;": { p: [8809], c: "\u2269" },
    "gnsim;": { p: [8935], c: "\u22E7" },
    "gopf;": { p: [120152], c: "\uD835\uDD58" },
    "grave;": { p: [96], c: "\u0060" },
    "gscr;": { p: [8458], c: "\u210A" },
    "gsim;": { p: [8819], c: "\u2273" },
    "gsime;": { p: [10894], c: "\u2A8E" },
    "gsiml;": { p: [10896], c: "\u2A90" },
    gt: { p: [62], c: "\u003E" },
    "gt;": { p: [62], c: "\u003E" },
    "gtcc;": { p: [10919], c: "\u2AA7" },
    "gtcir;": { p: [10874], c: "\u2A7A" },
    "gtdot;": { p: [8919], c: "\u22D7" },
    "gtlPar;": { p: [10645], c: "\u2995" },
    "gtquest;": { p: [10876], c: "\u2A7C" },
    "gtrapprox;": { p: [10886], c: "\u2A86" },
    "gtrarr;": { p: [10616], c: "\u2978" },
    "gtrdot;": { p: [8919], c: "\u22D7" },
    "gtreqless;": { p: [8923], c: "\u22DB" },
    "gtreqqless;": { p: [10892], c: "\u2A8C" },
    "gtrless;": { p: [8823], c: "\u2277" },
    "gtrsim;": { p: [8819], c: "\u2273" },
    "gvertneqq;": {
        p: [8809, 65024],
        c: "\u2269\uFE00",
    },
    "gvnE;": { p: [8809, 65024], c: "\u2269\uFE00" },
    "hArr;": { p: [8660], c: "\u21D4" },
    "hairsp;": { p: [8202], c: "\u200A" },
    "half;": { p: [189], c: "\u00BD" },
    "hamilt;": { p: [8459], c: "\u210B" },
    "hardcy;": { p: [1098], c: "\u044A" },
    "harr;": { p: [8596], c: "\u2194" },
    "harrcir;": { p: [10568], c: "\u2948" },
    "harrw;": { p: [8621], c: "\u21AD" },
    "hbar;": { p: [8463], c: "\u210F" },
    "hcirc;": { p: [293], c: "\u0125" },
    "hearts;": { p: [9829], c: "\u2665" },
    "heartsuit;": { p: [9829], c: "\u2665" },
    "hellip;": { p: [8230], c: "\u2026" },
    "hercon;": { p: [8889], c: "\u22B9" },
    "hfr;": { p: [120101], c: "\uD835\uDD25" },
    "hksearow;": { p: [10533], c: "\u2925" },
    "hkswarow;": { p: [10534], c: "\u2926" },
    "hoarr;": { p: [8703], c: "\u21FF" },
    "homtht;": { p: [8763], c: "\u223B" },
    "hookleftarrow;": { p: [8617], c: "\u21A9" },
    "hookrightarrow;": { p: [8618], c: "\u21AA" },
    "hopf;": { p: [120153], c: "\uD835\uDD59" },
    "horbar;": { p: [8213], c: "\u2015" },
    "hscr;": { p: [119997], c: "\uD835\uDCBD" },
    "hslash;": { p: [8463], c: "\u210F" },
    "hstrok;": { p: [295], c: "\u0127" },
    "hybull;": { p: [8259], c: "\u2043" },
    "hyphen;": { p: [8208], c: "\u2010" },
    iacute: { p: [237], c: "\u00ED" },
    "iacute;": { p: [237], c: "\u00ED" },
    "ic;": { p: [8291], c: "\u2063" },
    icirc: { p: [238], c: "\u00EE" },
    "icirc;": { p: [238], c: "\u00EE" },
    "icy;": { p: [1080], c: "\u0438" },
    "iecy;": { p: [1077], c: "\u0435" },
    iexcl: { p: [161], c: "\u00A1" },
    "iexcl;": { p: [161], c: "\u00A1" },
    "iff;": { p: [8660], c: "\u21D4" },
    "ifr;": { p: [120102], c: "\uD835\uDD26" },
    igrave: { p: [236], c: "\u00EC" },
    "igrave;": { p: [236], c: "\u00EC" },
    "ii;": { p: [8520], c: "\u2148" },
    "iiiint;": { p: [10764], c: "\u2A0C" },
    "iiint;": { p: [8749], c: "\u222D" },
    "iinfin;": { p: [10716], c: "\u29DC" },
    "iiota;": { p: [8489], c: "\u2129" },
    "ijlig;": { p: [307], c: "\u0133" },
    "imacr;": { p: [299], c: "\u012B" },
    "image;": { p: [8465], c: "\u2111" },
    "imagline;": { p: [8464], c: "\u2110" },
    "imagpart;": { p: [8465], c: "\u2111" },
    "imath;": { p: [305], c: "\u0131" },
    "imof;": { p: [8887], c: "\u22B7" },
    "imped;": { p: [437], c: "\u01B5" },
    "in;": { p: [8712], c: "\u2208" },
    "incare;": { p: [8453], c: "\u2105" },
    "infin;": { p: [8734], c: "\u221E" },
    "infintie;": { p: [10717], c: "\u29DD" },
    "inodot;": { p: [305], c: "\u0131" },
    "int;": { p: [8747], c: "\u222B" },
    "intcal;": { p: [8890], c: "\u22BA" },
    "integers;": { p: [8484], c: "\u2124" },
    "intercal;": { p: [8890], c: "\u22BA" },
    "intlarhk;": { p: [10775], c: "\u2A17" },
    "intprod;": { p: [10812], c: "\u2A3C" },
    "iocy;": { p: [1105], c: "\u0451" },
    "iogon;": { p: [303], c: "\u012F" },
    "iopf;": { p: [120154], c: "\uD835\uDD5A" },
    "iota;": { p: [953], c: "\u03B9" },
    "iprod;": { p: [10812], c: "\u2A3C" },
    iquest: { p: [191], c: "\u00BF" },
    "iquest;": { p: [191], c: "\u00BF" },
    "iscr;": { p: [119998], c: "\uD835\uDCBE" },
    "isin;": { p: [8712], c: "\u2208" },
    "isinE;": { p: [8953], c: "\u22F9" },
    "isindot;": { p: [8949], c: "\u22F5" },
    "isins;": { p: [8948], c: "\u22F4" },
    "isinsv;": { p: [8947], c: "\u22F3" },
    "isinv;": { p: [8712], c: "\u2208" },
    "it;": { p: [8290], c: "\u2062" },
    "itilde;": { p: [297], c: "\u0129" },
    "iukcy;": { p: [1110], c: "\u0456" },
    iuml: { p: [239], c: "\u00EF" },
    "iuml;": { p: [239], c: "\u00EF" },
    "jcirc;": { p: [309], c: "\u0135" },
    "jcy;": { p: [1081], c: "\u0439" },
    "jfr;": { p: [120103], c: "\uD835\uDD27" },
    "jmath;": { p: [567], c: "\u0237" },
    "jopf;": { p: [120155], c: "\uD835\uDD5B" },
    "jscr;": { p: [119999], c: "\uD835\uDCBF" },
    "jsercy;": { p: [1112], c: "\u0458" },
    "jukcy;": { p: [1108], c: "\u0454" },
    "kappa;": { p: [954], c: "\u03BA" },
    "kappav;": { p: [1008], c: "\u03F0" },
    "kcedil;": { p: [311], c: "\u0137" },
    "kcy;": { p: [1082], c: "\u043A" },
    "kfr;": { p: [120104], c: "\uD835\uDD28" },
    "kgreen;": { p: [312], c: "\u0138" },
    "khcy;": { p: [1093], c: "\u0445" },
    "kjcy;": { p: [1116], c: "\u045C" },
    "kopf;": { p: [120156], c: "\uD835\uDD5C" },
    "kscr;": { p: [120000], c: "\uD835\uDCC0" },
    "lAarr;": { p: [8666], c: "\u21DA" },
    "lArr;": { p: [8656], c: "\u21D0" },
    "lAtail;": { p: [10523], c: "\u291B" },
    "lBarr;": { p: [10510], c: "\u290E" },
    "lE;": { p: [8806], c: "\u2266" },
    "lEg;": { p: [10891], c: "\u2A8B" },
    "lHar;": { p: [10594], c: "\u2962" },
    "lacute;": { p: [314], c: "\u013A" },
    "laemptyv;": { p: [10676], c: "\u29B4" },
    "lagran;": { p: [8466], c: "\u2112" },
    "lambda;": { p: [955], c: "\u03BB" },
    "lang;": { p: [10216], c: "\u27E8" },
    "langd;": { p: [10641], c: "\u2991" },
    "langle;": { p: [10216], c: "\u27E8" },
    "lap;": { p: [10885], c: "\u2A85" },
    laquo: { p: [171], c: "\u00AB" },
    "laquo;": { p: [171], c: "\u00AB" },
    "larr;": { p: [8592], c: "\u2190" },
    "larrb;": { p: [8676], c: "\u21E4" },
    "larrbfs;": { p: [10527], c: "\u291F" },
    "larrfs;": { p: [10525], c: "\u291D" },
    "larrhk;": { p: [8617], c: "\u21A9" },
    "larrlp;": { p: [8619], c: "\u21AB" },
    "larrpl;": { p: [10553], c: "\u2939" },
    "larrsim;": { p: [10611], c: "\u2973" },
    "larrtl;": { p: [8610], c: "\u21A2" },
    "lat;": { p: [10923], c: "\u2AAB" },
    "latail;": { p: [10521], c: "\u2919" },
    "late;": { p: [10925], c: "\u2AAD" },
    "lates;": { p: [10925, 65024], c: "\u2AAD\uFE00" },
    "lbarr;": { p: [10508], c: "\u290C" },
    "lbbrk;": { p: [10098], c: "\u2772" },
    "lbrace;": { p: [123], c: "\u007B" },
    "lbrack;": { p: [91], c: "\u005B" },
    "lbrke;": { p: [10635], c: "\u298B" },
    "lbrksld;": { p: [10639], c: "\u298F" },
    "lbrkslu;": { p: [10637], c: "\u298D" },
    "lcaron;": { p: [318], c: "\u013E" },
    "lcedil;": { p: [316], c: "\u013C" },
    "lceil;": { p: [8968], c: "\u2308" },
    "lcub;": { p: [123], c: "\u007B" },
    "lcy;": { p: [1083], c: "\u043B" },
    "ldca;": { p: [10550], c: "\u2936" },
    "ldquo;": { p: [8220], c: "\u201C" },
    "ldquor;": { p: [8222], c: "\u201E" },
    "ldrdhar;": { p: [10599], c: "\u2967" },
    "ldrushar;": { p: [10571], c: "\u294B" },
    "ldsh;": { p: [8626], c: "\u21B2" },
    "le;": { p: [8804], c: "\u2264" },
    "leftarrow;": { p: [8592], c: "\u2190" },
    "leftarrowtail;": { p: [8610], c: "\u21A2" },
    "leftharpoondown;": { p: [8637], c: "\u21BD" },
    "leftharpoonup;": { p: [8636], c: "\u21BC" },
    "leftleftarrows;": { p: [8647], c: "\u21C7" },
    "leftrightarrow;": { p: [8596], c: "\u2194" },
    "leftrightarrows;": { p: [8646], c: "\u21C6" },
    "leftrightharpoons;": { p: [8651], c: "\u21CB" },
    "leftrightsquigarrow;": { p: [8621], c: "\u21AD" },
    "leftthreetimes;": { p: [8907], c: "\u22CB" },
    "leg;": { p: [8922], c: "\u22DA" },
    "leq;": { p: [8804], c: "\u2264" },
    "leqq;": { p: [8806], c: "\u2266" },
    "leqslant;": { p: [10877], c: "\u2A7D" },
    "les;": { p: [10877], c: "\u2A7D" },
    "lescc;": { p: [10920], c: "\u2AA8" },
    "lesdot;": { p: [10879], c: "\u2A7F" },
    "lesdoto;": { p: [10881], c: "\u2A81" },
    "lesdotor;": { p: [10883], c: "\u2A83" },
    "lesg;": { p: [8922, 65024], c: "\u22DA\uFE00" },
    "lesges;": { p: [10899], c: "\u2A93" },
    "lessapprox;": { p: [10885], c: "\u2A85" },
    "lessdot;": { p: [8918], c: "\u22D6" },
    "lesseqgtr;": { p: [8922], c: "\u22DA" },
    "lesseqqgtr;": { p: [10891], c: "\u2A8B" },
    "lessgtr;": { p: [8822], c: "\u2276" },
    "lesssim;": { p: [8818], c: "\u2272" },
    "lfisht;": { p: [10620], c: "\u297C" },
    "lfloor;": { p: [8970], c: "\u230A" },
    "lfr;": { p: [120105], c: "\uD835\uDD29" },
    "lg;": { p: [8822], c: "\u2276" },
    "lgE;": { p: [10897], c: "\u2A91" },
    "lhard;": { p: [8637], c: "\u21BD" },
    "lharu;": { p: [8636], c: "\u21BC" },
    "lharul;": { p: [10602], c: "\u296A" },
    "lhblk;": { p: [9604], c: "\u2584" },
    "ljcy;": { p: [1113], c: "\u0459" },
    "ll;": { p: [8810], c: "\u226A" },
    "llarr;": { p: [8647], c: "\u21C7" },
    "llcorner;": { p: [8990], c: "\u231E" },
    "llhard;": { p: [10603], c: "\u296B" },
    "lltri;": { p: [9722], c: "\u25FA" },
    "lmidot;": { p: [320], c: "\u0140" },
    "lmoust;": { p: [9136], c: "\u23B0" },
    "lmoustache;": { p: [9136], c: "\u23B0" },
    "lnE;": { p: [8808], c: "\u2268" },
    "lnap;": { p: [10889], c: "\u2A89" },
    "lnapprox;": { p: [10889], c: "\u2A89" },
    "lne;": { p: [10887], c: "\u2A87" },
    "lneq;": { p: [10887], c: "\u2A87" },
    "lneqq;": { p: [8808], c: "\u2268" },
    "lnsim;": { p: [8934], c: "\u22E6" },
    "loang;": { p: [10220], c: "\u27EC" },
    "loarr;": { p: [8701], c: "\u21FD" },
    "lobrk;": { p: [10214], c: "\u27E6" },
    "longleftarrow;": { p: [10229], c: "\u27F5" },
    "longleftrightarrow;": { p: [10231], c: "\u27F7" },
    "longmapsto;": { p: [10236], c: "\u27FC" },
    "longrightarrow;": { p: [10230], c: "\u27F6" },
    "looparrowleft;": { p: [8619], c: "\u21AB" },
    "looparrowright;": { p: [8620], c: "\u21AC" },
    "lopar;": { p: [10629], c: "\u2985" },
    "lopf;": { p: [120157], c: "\uD835\uDD5D" },
    "loplus;": { p: [10797], c: "\u2A2D" },
    "lotimes;": { p: [10804], c: "\u2A34" },
    "lowast;": { p: [8727], c: "\u2217" },
    "lowbar;": { p: [95], c: "\u005F" },
    "loz;": { p: [9674], c: "\u25CA" },
    "lozenge;": { p: [9674], c: "\u25CA" },
    "lozf;": { p: [10731], c: "\u29EB" },
    "lpar;": { p: [40], c: "\u0028" },
    "lparlt;": { p: [10643], c: "\u2993" },
    "lrarr;": { p: [8646], c: "\u21C6" },
    "lrcorner;": { p: [8991], c: "\u231F" },
    "lrhar;": { p: [8651], c: "\u21CB" },
    "lrhard;": { p: [10605], c: "\u296D" },
    "lrm;": { p: [8206], c: "\u200E" },
    "lrtri;": { p: [8895], c: "\u22BF" },
    "lsaquo;": { p: [8249], c: "\u2039" },
    "lscr;": { p: [120001], c: "\uD835\uDCC1" },
    "lsh;": { p: [8624], c: "\u21B0" },
    "lsim;": { p: [8818], c: "\u2272" },
    "lsime;": { p: [10893], c: "\u2A8D" },
    "lsimg;": { p: [10895], c: "\u2A8F" },
    "lsqb;": { p: [91], c: "\u005B" },
    "lsquo;": { p: [8216], c: "\u2018" },
    "lsquor;": { p: [8218], c: "\u201A" },
    "lstrok;": { p: [322], c: "\u0142" },
    lt: { p: [60], c: "\u003C" },
    "lt;": { p: [60], c: "\u003C" },
    "ltcc;": { p: [10918], c: "\u2AA6" },
    "ltcir;": { p: [10873], c: "\u2A79" },
    "ltdot;": { p: [8918], c: "\u22D6" },
    "lthree;": { p: [8907], c: "\u22CB" },
    "ltimes;": { p: [8905], c: "\u22C9" },
    "ltlarr;": { p: [10614], c: "\u2976" },
    "ltquest;": { p: [10875], c: "\u2A7B" },
    "ltrPar;": { p: [10646], c: "\u2996" },
    "ltri;": { p: [9667], c: "\u25C3" },
    "ltrie;": { p: [8884], c: "\u22B4" },
    "ltrif;": { p: [9666], c: "\u25C2" },
    "lurdshar;": { p: [10570], c: "\u294A" },
    "luruhar;": { p: [10598], c: "\u2966" },
    "lvertneqq;": {
        p: [8808, 65024],
        c: "\u2268\uFE00",
    },
    "lvnE;": { p: [8808, 65024], c: "\u2268\uFE00" },
    "mDDot;": { p: [8762], c: "\u223A" },
    macr: { p: [175], c: "\u00AF" },
    "macr;": { p: [175], c: "\u00AF" },
    "male;": { p: [9794], c: "\u2642" },
    "malt;": { p: [10016], c: "\u2720" },
    "maltese;": { p: [10016], c: "\u2720" },
    "map;": { p: [8614], c: "\u21A6" },
    "mapsto;": { p: [8614], c: "\u21A6" },
    "mapstodown;": { p: [8615], c: "\u21A7" },
    "mapstoleft;": { p: [8612], c: "\u21A4" },
    "mapstoup;": { p: [8613], c: "\u21A5" },
    "marker;": { p: [9646], c: "\u25AE" },
    "mcomma;": { p: [10793], c: "\u2A29" },
    "mcy;": { p: [1084], c: "\u043C" },
    "mdash;": { p: [8212], c: "\u2014" },
    "measuredangle;": { p: [8737], c: "\u2221" },
    "mfr;": { p: [120106], c: "\uD835\uDD2A" },
    "mho;": { p: [8487], c: "\u2127" },
    micro: { p: [181], c: "\u00B5" },
    "micro;": { p: [181], c: "\u00B5" },
    "mid;": { p: [8739], c: "\u2223" },
    "midast;": { p: [42], c: "\u002A" },
    "midcir;": { p: [10992], c: "\u2AF0" },
    middot: { p: [183], c: "\u00B7" },
    "middot;": { p: [183], c: "\u00B7" },
    "minus;": { p: [8722], c: "\u2212" },
    "minusb;": { p: [8863], c: "\u229F" },
    "minusd;": { p: [8760], c: "\u2238" },
    "minusdu;": { p: [10794], c: "\u2A2A" },
    "mlcp;": { p: [10971], c: "\u2ADB" },
    "mldr;": { p: [8230], c: "\u2026" },
    "mnplus;": { p: [8723], c: "\u2213" },
    "models;": { p: [8871], c: "\u22A7" },
    "mopf;": { p: [120158], c: "\uD835\uDD5E" },
    "mp;": { p: [8723], c: "\u2213" },
    "mscr;": { p: [120002], c: "\uD835\uDCC2" },
    "mstpos;": { p: [8766], c: "\u223E" },
    "mu;": { p: [956], c: "\u03BC" },
    "multimap;": { p: [8888], c: "\u22B8" },
    "mumap;": { p: [8888], c: "\u22B8" },
    "nGg;": { p: [8921, 824], c: "\u22D9\u0338" },
    "nGt;": { p: [8811, 8402], c: "\u226B\u20D2" },
    "nGtv;": { p: [8811, 824], c: "\u226B\u0338" },
    "nLeftarrow;": { p: [8653], c: "\u21CD" },
    "nLeftrightarrow;": { p: [8654], c: "\u21CE" },
    "nLl;": { p: [8920, 824], c: "\u22D8\u0338" },
    "nLt;": { p: [8810, 8402], c: "\u226A\u20D2" },
    "nLtv;": { p: [8810, 824], c: "\u226A\u0338" },
    "nRightarrow;": { p: [8655], c: "\u21CF" },
    "nVDash;": { p: [8879], c: "\u22AF" },
    "nVdash;": { p: [8878], c: "\u22AE" },
    "nabla;": { p: [8711], c: "\u2207" },
    "nacute;": { p: [324], c: "\u0144" },
    "nang;": { p: [8736, 8402], c: "\u2220\u20D2" },
    "nap;": { p: [8777], c: "\u2249" },
    "napE;": { p: [10864, 824], c: "\u2A70\u0338" },
    "napid;": { p: [8779, 824], c: "\u224B\u0338" },
    "napos;": { p: [329], c: "\u0149" },
    "napprox;": { p: [8777], c: "\u2249" },
    "natur;": { p: [9838], c: "\u266E" },
    "natural;": { p: [9838], c: "\u266E" },
    "naturals;": { p: [8469], c: "\u2115" },
    nbsp: { p: [160], c: "\u00A0" },
    "nbsp;": { p: [160], c: "\u00A0" },
    "nbump;": { p: [8782, 824], c: "\u224E\u0338" },
    "nbumpe;": { p: [8783, 824], c: "\u224F\u0338" },
    "ncap;": { p: [10819], c: "\u2A43" },
    "ncaron;": { p: [328], c: "\u0148" },
    "ncedil;": { p: [326], c: "\u0146" },
    "ncong;": { p: [8775], c: "\u2247" },
    "ncongdot;": { p: [10861, 824], c: "\u2A6D\u0338" },
    "ncup;": { p: [10818], c: "\u2A42" },
    "ncy;": { p: [1085], c: "\u043D" },
    "ndash;": { p: [8211], c: "\u2013" },
    "ne;": { p: [8800], c: "\u2260" },
    "neArr;": { p: [8663], c: "\u21D7" },
    "nearhk;": { p: [10532], c: "\u2924" },
    "nearr;": { p: [8599], c: "\u2197" },
    "nearrow;": { p: [8599], c: "\u2197" },
    "nedot;": { p: [8784, 824], c: "\u2250\u0338" },
    "nequiv;": { p: [8802], c: "\u2262" },
    "nesear;": { p: [10536], c: "\u2928" },
    "nesim;": { p: [8770, 824], c: "\u2242\u0338" },
    "nexist;": { p: [8708], c: "\u2204" },
    "nexists;": { p: [8708], c: "\u2204" },
    "nfr;": { p: [120107], c: "\uD835\uDD2B" },
    "ngE;": { p: [8807, 824], c: "\u2267\u0338" },
    "nge;": { p: [8817], c: "\u2271" },
    "ngeq;": { p: [8817], c: "\u2271" },
    "ngeqq;": { p: [8807, 824], c: "\u2267\u0338" },
    "ngeqslant;": { p: [10878, 824], c: "\u2A7E\u0338" },
    "nges;": { p: [10878, 824], c: "\u2A7E\u0338" },
    "ngsim;": { p: [8821], c: "\u2275" },
    "ngt;": { p: [8815], c: "\u226F" },
    "ngtr;": { p: [8815], c: "\u226F" },
    "nhArr;": { p: [8654], c: "\u21CE" },
    "nharr;": { p: [8622], c: "\u21AE" },
    "nhpar;": { p: [10994], c: "\u2AF2" },
    "ni;": { p: [8715], c: "\u220B" },
    "nis;": { p: [8956], c: "\u22FC" },
    "nisd;": { p: [8954], c: "\u22FA" },
    "niv;": { p: [8715], c: "\u220B" },
    "njcy;": { p: [1114], c: "\u045A" },
    "nlArr;": { p: [8653], c: "\u21CD" },
    "nlE;": { p: [8806, 824], c: "\u2266\u0338" },
    "nlarr;": { p: [8602], c: "\u219A" },
    "nldr;": { p: [8229], c: "\u2025" },
    "nle;": { p: [8816], c: "\u2270" },
    "nleftarrow;": { p: [8602], c: "\u219A" },
    "nleftrightarrow;": { p: [8622], c: "\u21AE" },
    "nleq;": { p: [8816], c: "\u2270" },
    "nleqq;": { p: [8806, 824], c: "\u2266\u0338" },
    "nleqslant;": { p: [10877, 824], c: "\u2A7D\u0338" },
    "nles;": { p: [10877, 824], c: "\u2A7D\u0338" },
    "nless;": { p: [8814], c: "\u226E" },
    "nlsim;": { p: [8820], c: "\u2274" },
    "nlt;": { p: [8814], c: "\u226E" },
    "nltri;": { p: [8938], c: "\u22EA" },
    "nltrie;": { p: [8940], c: "\u22EC" },
    "nmid;": { p: [8740], c: "\u2224" },
    "nopf;": { p: [120159], c: "\uD835\uDD5F" },
    not: { p: [172], c: "\u00AC" },
    "not;": { p: [172], c: "\u00AC" },
    "notin;": { p: [8713], c: "\u2209" },
    "notinE;": { p: [8953, 824], c: "\u22F9\u0338" },
    "notindot;": { p: [8949, 824], c: "\u22F5\u0338" },
    "notinva;": { p: [8713], c: "\u2209" },
    "notinvb;": { p: [8951], c: "\u22F7" },
    "notinvc;": { p: [8950], c: "\u22F6" },
    "notni;": { p: [8716], c: "\u220C" },
    "notniva;": { p: [8716], c: "\u220C" },
    "notnivb;": { p: [8958], c: "\u22FE" },
    "notnivc;": { p: [8957], c: "\u22FD" },
    "npar;": { p: [8742], c: "\u2226" },
    "nparallel;": { p: [8742], c: "\u2226" },
    "nparsl;": { p: [11005, 8421], c: "\u2AFD\u20E5" },
    "npart;": { p: [8706, 824], c: "\u2202\u0338" },
    "npolint;": { p: [10772], c: "\u2A14" },
    "npr;": { p: [8832], c: "\u2280" },
    "nprcue;": { p: [8928], c: "\u22E0" },
    "npre;": { p: [10927, 824], c: "\u2AAF\u0338" },
    "nprec;": { p: [8832], c: "\u2280" },
    "npreceq;": { p: [10927, 824], c: "\u2AAF\u0338" },
    "nrArr;": { p: [8655], c: "\u21CF" },
    "nrarr;": { p: [8603], c: "\u219B" },
    "nrarrc;": { p: [10547, 824], c: "\u2933\u0338" },
    "nrarrw;": { p: [8605, 824], c: "\u219D\u0338" },
    "nrightarrow;": { p: [8603], c: "\u219B" },
    "nrtri;": { p: [8939], c: "\u22EB" },
    "nrtrie;": { p: [8941], c: "\u22ED" },
    "nsc;": { p: [8833], c: "\u2281" },
    "nsccue;": { p: [8929], c: "\u22E1" },
    "nsce;": { p: [10928, 824], c: "\u2AB0\u0338" },
    "nscr;": { p: [120003], c: "\uD835\uDCC3" },
    "nshortmid;": { p: [8740], c: "\u2224" },
    "nshortparallel;": { p: [8742], c: "\u2226" },
    "nsim;": { p: [8769], c: "\u2241" },
    "nsime;": { p: [8772], c: "\u2244" },
    "nsimeq;": { p: [8772], c: "\u2244" },
    "nsmid;": { p: [8740], c: "\u2224" },
    "nspar;": { p: [8742], c: "\u2226" },
    "nsqsube;": { p: [8930], c: "\u22E2" },
    "nsqsupe;": { p: [8931], c: "\u22E3" },
    "nsub;": { p: [8836], c: "\u2284" },
    "nsubE;": { p: [10949, 824], c: "\u2AC5\u0338" },
    "nsube;": { p: [8840], c: "\u2288" },
    "nsubset;": { p: [8834, 8402], c: "\u2282\u20D2" },
    "nsubseteq;": { p: [8840], c: "\u2288" },
    "nsubseteqq;": {
        p: [10949, 824],
        c: "\u2AC5\u0338",
    },
    "nsucc;": { p: [8833], c: "\u2281" },
    "nsucceq;": { p: [10928, 824], c: "\u2AB0\u0338" },
    "nsup;": { p: [8837], c: "\u2285" },
    "nsupE;": { p: [10950, 824], c: "\u2AC6\u0338" },
    "nsupe;": { p: [8841], c: "\u2289" },
    "nsupset;": { p: [8835, 8402], c: "\u2283\u20D2" },
    "nsupseteq;": { p: [8841], c: "\u2289" },
    "nsupseteqq;": {
        p: [10950, 824],
        c: "\u2AC6\u0338",
    },
    "ntgl;": { p: [8825], c: "\u2279" },
    ntilde: { p: [241], c: "\u00F1" },
    "ntilde;": { p: [241], c: "\u00F1" },
    "ntlg;": { p: [8824], c: "\u2278" },
    "ntriangleleft;": { p: [8938], c: "\u22EA" },
    "ntrianglelefteq;": { p: [8940], c: "\u22EC" },
    "ntriangleright;": { p: [8939], c: "\u22EB" },
    "ntrianglerighteq;": { p: [8941], c: "\u22ED" },
    "nu;": { p: [957], c: "\u03BD" },
    "num;": { p: [35], c: "\u0023" },
    "numero;": { p: [8470], c: "\u2116" },
    "numsp;": { p: [8199], c: "\u2007" },
    "nvDash;": { p: [8877], c: "\u22AD" },
    "nvHarr;": { p: [10500], c: "\u2904" },
    "nvap;": { p: [8781, 8402], c: "\u224D\u20D2" },
    "nvdash;": { p: [8876], c: "\u22AC" },
    "nvge;": { p: [8805, 8402], c: "\u2265\u20D2" },
    "nvgt;": { p: [62, 8402], c: "\u003E\u20D2" },
    "nvinfin;": { p: [10718], c: "\u29DE" },
    "nvlArr;": { p: [10498], c: "\u2902" },
    "nvle;": { p: [8804, 8402], c: "\u2264\u20D2" },
    "nvlt;": { p: [60, 8402], c: "\u003C\u20D2" },
    "nvltrie;": { p: [8884, 8402], c: "\u22B4\u20D2" },
    "nvrArr;": { p: [10499], c: "\u2903" },
    "nvrtrie;": { p: [8885, 8402], c: "\u22B5\u20D2" },
    "nvsim;": { p: [8764, 8402], c: "\u223C\u20D2" },
    "nwArr;": { p: [8662], c: "\u21D6" },
    "nwarhk;": { p: [10531], c: "\u2923" },
    "nwarr;": { p: [8598], c: "\u2196" },
    "nwarrow;": { p: [8598], c: "\u2196" },
    "nwnear;": { p: [10535], c: "\u2927" },
    "oS;": { p: [9416], c: "\u24C8" },
    oacute: { p: [243], c: "\u00F3" },
    "oacute;": { p: [243], c: "\u00F3" },
    "oast;": { p: [8859], c: "\u229B" },
    "ocir;": { p: [8858], c: "\u229A" },
    ocirc: { p: [244], c: "\u00F4" },
    "ocirc;": { p: [244], c: "\u00F4" },
    "ocy;": { p: [1086], c: "\u043E" },
    "odash;": { p: [8861], c: "\u229D" },
    "odblac;": { p: [337], c: "\u0151" },
    "odiv;": { p: [10808], c: "\u2A38" },
    "odot;": { p: [8857], c: "\u2299" },
    "odsold;": { p: [10684], c: "\u29BC" },
    "oelig;": { p: [339], c: "\u0153" },
    "ofcir;": { p: [10687], c: "\u29BF" },
    "ofr;": { p: [120108], c: "\uD835\uDD2C" },
    "ogon;": { p: [731], c: "\u02DB" },
    ograve: { p: [242], c: "\u00F2" },
    "ograve;": { p: [242], c: "\u00F2" },
    "ogt;": { p: [10689], c: "\u29C1" },
    "ohbar;": { p: [10677], c: "\u29B5" },
    "ohm;": { p: [937], c: "\u03A9" },
    "oint;": { p: [8750], c: "\u222E" },
    "olarr;": { p: [8634], c: "\u21BA" },
    "olcir;": { p: [10686], c: "\u29BE" },
    "olcross;": { p: [10683], c: "\u29BB" },
    "oline;": { p: [8254], c: "\u203E" },
    "olt;": { p: [10688], c: "\u29C0" },
    "omacr;": { p: [333], c: "\u014D" },
    "omega;": { p: [969], c: "\u03C9" },
    "omicron;": { p: [959], c: "\u03BF" },
    "omid;": { p: [10678], c: "\u29B6" },
    "ominus;": { p: [8854], c: "\u2296" },
    "oopf;": { p: [120160], c: "\uD835\uDD60" },
    "opar;": { p: [10679], c: "\u29B7" },
    "operp;": { p: [10681], c: "\u29B9" },
    "oplus;": { p: [8853], c: "\u2295" },
    "or;": { p: [8744], c: "\u2228" },
    "orarr;": { p: [8635], c: "\u21BB" },
    "ord;": { p: [10845], c: "\u2A5D" },
    "order;": { p: [8500], c: "\u2134" },
    "orderof;": { p: [8500], c: "\u2134" },
    ordf: { p: [170], c: "\u00AA" },
    "ordf;": { p: [170], c: "\u00AA" },
    ordm: { p: [186], c: "\u00BA" },
    "ordm;": { p: [186], c: "\u00BA" },
    "origof;": { p: [8886], c: "\u22B6" },
    "oror;": { p: [10838], c: "\u2A56" },
    "orslope;": { p: [10839], c: "\u2A57" },
    "orv;": { p: [10843], c: "\u2A5B" },
    "oscr;": { p: [8500], c: "\u2134" },
    oslash: { p: [248], c: "\u00F8" },
    "oslash;": { p: [248], c: "\u00F8" },
    "osol;": { p: [8856], c: "\u2298" },
    otilde: { p: [245], c: "\u00F5" },
    "otilde;": { p: [245], c: "\u00F5" },
    "otimes;": { p: [8855], c: "\u2297" },
    "otimesas;": { p: [10806], c: "\u2A36" },
    ouml: { p: [246], c: "\u00F6" },
    "ouml;": { p: [246], c: "\u00F6" },
    "ovbar;": { p: [9021], c: "\u233D" },
    "par;": { p: [8741], c: "\u2225" },
    para: { p: [182], c: "\u00B6" },
    "para;": { p: [182], c: "\u00B6" },
    "parallel;": { p: [8741], c: "\u2225" },
    "parsim;": { p: [10995], c: "\u2AF3" },
    "parsl;": { p: [11005], c: "\u2AFD" },
    "part;": { p: [8706], c: "\u2202" },
    "pcy;": { p: [1087], c: "\u043F" },
    "percnt;": { p: [37], c: "\u0025" },
    "period;": { p: [46], c: "\u002E" },
    "permil;": { p: [8240], c: "\u2030" },
    "perp;": { p: [8869], c: "\u22A5" },
    "pertenk;": { p: [8241], c: "\u2031" },
    "pfr;": { p: [120109], c: "\uD835\uDD2D" },
    "phi;": { p: [966], c: "\u03C6" },
    "phiv;": { p: [981], c: "\u03D5" },
    "phmmat;": { p: [8499], c: "\u2133" },
    "phone;": { p: [9742], c: "\u260E" },
    "pi;": { p: [960], c: "\u03C0" },
    "pitchfork;": { p: [8916], c: "\u22D4" },
    "piv;": { p: [982], c: "\u03D6" },
    "planck;": { p: [8463], c: "\u210F" },
    "planckh;": { p: [8462], c: "\u210E" },
    "plankv;": { p: [8463], c: "\u210F" },
    "plus;": { p: [43], c: "\u002B" },
    "plusacir;": { p: [10787], c: "\u2A23" },
    "plusb;": { p: [8862], c: "\u229E" },
    "pluscir;": { p: [10786], c: "\u2A22" },
    "plusdo;": { p: [8724], c: "\u2214" },
    "plusdu;": { p: [10789], c: "\u2A25" },
    "pluse;": { p: [10866], c: "\u2A72" },
    plusmn: { p: [177], c: "\u00B1" },
    "plusmn;": { p: [177], c: "\u00B1" },
    "plussim;": { p: [10790], c: "\u2A26" },
    "plustwo;": { p: [10791], c: "\u2A27" },
    "pm;": { p: [177], c: "\u00B1" },
    "pointint;": { p: [10773], c: "\u2A15" },
    "popf;": { p: [120161], c: "\uD835\uDD61" },
    pound: { p: [163], c: "\u00A3" },
    "pound;": { p: [163], c: "\u00A3" },
    "pr;": { p: [8826], c: "\u227A" },
    "prE;": { p: [10931], c: "\u2AB3" },
    "prap;": { p: [10935], c: "\u2AB7" },
    "prcue;": { p: [8828], c: "\u227C" },
    "pre;": { p: [10927], c: "\u2AAF" },
    "prec;": { p: [8826], c: "\u227A" },
    "precapprox;": { p: [10935], c: "\u2AB7" },
    "preccurlyeq;": { p: [8828], c: "\u227C" },
    "preceq;": { p: [10927], c: "\u2AAF" },
    "precnapprox;": { p: [10937], c: "\u2AB9" },
    "precneqq;": { p: [10933], c: "\u2AB5" },
    "precnsim;": { p: [8936], c: "\u22E8" },
    "precsim;": { p: [8830], c: "\u227E" },
    "prime;": { p: [8242], c: "\u2032" },
    "primes;": { p: [8473], c: "\u2119" },
    "prnE;": { p: [10933], c: "\u2AB5" },
    "prnap;": { p: [10937], c: "\u2AB9" },
    "prnsim;": { p: [8936], c: "\u22E8" },
    "prod;": { p: [8719], c: "\u220F" },
    "profalar;": { p: [9006], c: "\u232E" },
    "profline;": { p: [8978], c: "\u2312" },
    "profsurf;": { p: [8979], c: "\u2313" },
    "prop;": { p: [8733], c: "\u221D" },
    "propto;": { p: [8733], c: "\u221D" },
    "prsim;": { p: [8830], c: "\u227E" },
    "prurel;": { p: [8880], c: "\u22B0" },
    "pscr;": { p: [120005], c: "\uD835\uDCC5" },
    "psi;": { p: [968], c: "\u03C8" },
    "puncsp;": { p: [8200], c: "\u2008" },
    "qfr;": { p: [120110], c: "\uD835\uDD2E" },
    "qint;": { p: [10764], c: "\u2A0C" },
    "qopf;": { p: [120162], c: "\uD835\uDD62" },
    "qprime;": { p: [8279], c: "\u2057" },
    "qscr;": { p: [120006], c: "\uD835\uDCC6" },
    "quaternions;": { p: [8461], c: "\u210D" },
    "quatint;": { p: [10774], c: "\u2A16" },
    "quest;": { p: [63], c: "\u003F" },
    "questeq;": { p: [8799], c: "\u225F" },
    quot: { p: [34], c: "\u0022" },
    "quot;": { p: [34], c: "\u0022" },
    "rAarr;": { p: [8667], c: "\u21DB" },
    "rArr;": { p: [8658], c: "\u21D2" },
    "rAtail;": { p: [10524], c: "\u291C" },
    "rBarr;": { p: [10511], c: "\u290F" },
    "rHar;": { p: [10596], c: "\u2964" },
    "race;": { p: [8765, 817], c: "\u223D\u0331" },
    "racute;": { p: [341], c: "\u0155" },
    "radic;": { p: [8730], c: "\u221A" },
    "raemptyv;": { p: [10675], c: "\u29B3" },
    "rang;": { p: [10217], c: "\u27E9" },
    "rangd;": { p: [10642], c: "\u2992" },
    "range;": { p: [10661], c: "\u29A5" },
    "rangle;": { p: [10217], c: "\u27E9" },
    raquo: { p: [187], c: "\u00BB" },
    "raquo;": { p: [187], c: "\u00BB" },
    "rarr;": { p: [8594], c: "\u2192" },
    "rarrap;": { p: [10613], c: "\u2975" },
    "rarrb;": { p: [8677], c: "\u21E5" },
    "rarrbfs;": { p: [10528], c: "\u2920" },
    "rarrc;": { p: [10547], c: "\u2933" },
    "rarrfs;": { p: [10526], c: "\u291E" },
    "rarrhk;": { p: [8618], c: "\u21AA" },
    "rarrlp;": { p: [8620], c: "\u21AC" },
    "rarrpl;": { p: [10565], c: "\u2945" },
    "rarrsim;": { p: [10612], c: "\u2974" },
    "rarrtl;": { p: [8611], c: "\u21A3" },
    "rarrw;": { p: [8605], c: "\u219D" },
    "ratail;": { p: [10522], c: "\u291A" },
    "ratio;": { p: [8758], c: "\u2236" },
    "rationals;": { p: [8474], c: "\u211A" },
    "rbarr;": { p: [10509], c: "\u290D" },
    "rbbrk;": { p: [10099], c: "\u2773" },
    "rbrace;": { p: [125], c: "\u007D" },
    "rbrack;": { p: [93], c: "\u005D" },
    "rbrke;": { p: [10636], c: "\u298C" },
    "rbrksld;": { p: [10638], c: "\u298E" },
    "rbrkslu;": { p: [10640], c: "\u2990" },
    "rcaron;": { p: [345], c: "\u0159" },
    "rcedil;": { p: [343], c: "\u0157" },
    "rceil;": { p: [8969], c: "\u2309" },
    "rcub;": { p: [125], c: "\u007D" },
    "rcy;": { p: [1088], c: "\u0440" },
    "rdca;": { p: [10551], c: "\u2937" },
    "rdldhar;": { p: [10601], c: "\u2969" },
    "rdquo;": { p: [8221], c: "\u201D" },
    "rdquor;": { p: [8221], c: "\u201D" },
    "rdsh;": { p: [8627], c: "\u21B3" },
    "real;": { p: [8476], c: "\u211C" },
    "realine;": { p: [8475], c: "\u211B" },
    "realpart;": { p: [8476], c: "\u211C" },
    "reals;": { p: [8477], c: "\u211D" },
    "rect;": { p: [9645], c: "\u25AD" },
    reg: { p: [174], c: "\u00AE" },
    "reg;": { p: [174], c: "\u00AE" },
    "rfisht;": { p: [10621], c: "\u297D" },
    "rfloor;": { p: [8971], c: "\u230B" },
    "rfr;": { p: [120111], c: "\uD835\uDD2F" },
    "rhard;": { p: [8641], c: "\u21C1" },
    "rharu;": { p: [8640], c: "\u21C0" },
    "rharul;": { p: [10604], c: "\u296C" },
    "rho;": { p: [961], c: "\u03C1" },
    "rhov;": { p: [1009], c: "\u03F1" },
    "rightarrow;": { p: [8594], c: "\u2192" },
    "rightarrowtail;": { p: [8611], c: "\u21A3" },
    "rightharpoondown;": { p: [8641], c: "\u21C1" },
    "rightharpoonup;": { p: [8640], c: "\u21C0" },
    "rightleftarrows;": { p: [8644], c: "\u21C4" },
    "rightleftharpoons;": { p: [8652], c: "\u21CC" },
    "rightrightarrows;": { p: [8649], c: "\u21C9" },
    "rightsquigarrow;": { p: [8605], c: "\u219D" },
    "rightthreetimes;": { p: [8908], c: "\u22CC" },
    "ring;": { p: [730], c: "\u02DA" },
    "risingdotseq;": { p: [8787], c: "\u2253" },
    "rlarr;": { p: [8644], c: "\u21C4" },
    "rlhar;": { p: [8652], c: "\u21CC" },
    "rlm;": { p: [8207], c: "\u200F" },
    "rmoust;": { p: [9137], c: "\u23B1" },
    "rmoustache;": { p: [9137], c: "\u23B1" },
    "rnmid;": { p: [10990], c: "\u2AEE" },
    "roang;": { p: [10221], c: "\u27ED" },
    "roarr;": { p: [8702], c: "\u21FE" },
    "robrk;": { p: [10215], c: "\u27E7" },
    "ropar;": { p: [10630], c: "\u2986" },
    "ropf;": { p: [120163], c: "\uD835\uDD63" },
    "roplus;": { p: [10798], c: "\u2A2E" },
    "rotimes;": { p: [10805], c: "\u2A35" },
    "rpar;": { p: [41], c: "\u0029" },
    "rpargt;": { p: [10644], c: "\u2994" },
    "rppolint;": { p: [10770], c: "\u2A12" },
    "rrarr;": { p: [8649], c: "\u21C9" },
    "rsaquo;": { p: [8250], c: "\u203A" },
    "rscr;": { p: [120007], c: "\uD835\uDCC7" },
    "rsh;": { p: [8625], c: "\u21B1" },
    "rsqb;": { p: [93], c: "\u005D" },
    "rsquo;": { p: [8217], c: "\u2019" },
    "rsquor;": { p: [8217], c: "\u2019" },
    "rthree;": { p: [8908], c: "\u22CC" },
    "rtimes;": { p: [8906], c: "\u22CA" },
    "rtri;": { p: [9657], c: "\u25B9" },
    "rtrie;": { p: [8885], c: "\u22B5" },
    "rtrif;": { p: [9656], c: "\u25B8" },
    "rtriltri;": { p: [10702], c: "\u29CE" },
    "ruluhar;": { p: [10600], c: "\u2968" },
    "rx;": { p: [8478], c: "\u211E" },
    "sacute;": { p: [347], c: "\u015B" },
    "sbquo;": { p: [8218], c: "\u201A" },
    "sc;": { p: [8827], c: "\u227B" },
    "scE;": { p: [10932], c: "\u2AB4" },
    "scap;": { p: [10936], c: "\u2AB8" },
    "scaron;": { p: [353], c: "\u0161" },
    "sccue;": { p: [8829], c: "\u227D" },
    "sce;": { p: [10928], c: "\u2AB0" },
    "scedil;": { p: [351], c: "\u015F" },
    "scirc;": { p: [349], c: "\u015D" },
    "scnE;": { p: [10934], c: "\u2AB6" },
    "scnap;": { p: [10938], c: "\u2ABA" },
    "scnsim;": { p: [8937], c: "\u22E9" },
    "scpolint;": { p: [10771], c: "\u2A13" },
    "scsim;": { p: [8831], c: "\u227F" },
    "scy;": { p: [1089], c: "\u0441" },
    "sdot;": { p: [8901], c: "\u22C5" },
    "sdotb;": { p: [8865], c: "\u22A1" },
    "sdote;": { p: [10854], c: "\u2A66" },
    "seArr;": { p: [8664], c: "\u21D8" },
    "searhk;": { p: [10533], c: "\u2925" },
    "searr;": { p: [8600], c: "\u2198" },
    "searrow;": { p: [8600], c: "\u2198" },
    sect: { p: [167], c: "\u00A7" },
    "sect;": { p: [167], c: "\u00A7" },
    "semi;": { p: [59], c: "\u003B" },
    "seswar;": { p: [10537], c: "\u2929" },
    "setminus;": { p: [8726], c: "\u2216" },
    "setmn;": { p: [8726], c: "\u2216" },
    "sext;": { p: [10038], c: "\u2736" },
    "sfr;": { p: [120112], c: "\uD835\uDD30" },
    "sfrown;": { p: [8994], c: "\u2322" },
    "sharp;": { p: [9839], c: "\u266F" },
    "shchcy;": { p: [1097], c: "\u0449" },
    "shcy;": { p: [1096], c: "\u0448" },
    "shortmid;": { p: [8739], c: "\u2223" },
    "shortparallel;": { p: [8741], c: "\u2225" },
    shy: { p: [173], c: "\u00AD" },
    "shy;": { p: [173], c: "\u00AD" },
    "sigma;": { p: [963], c: "\u03C3" },
    "sigmaf;": { p: [962], c: "\u03C2" },
    "sigmav;": { p: [962], c: "\u03C2" },
    "sim;": { p: [8764], c: "\u223C" },
    "simdot;": { p: [10858], c: "\u2A6A" },
    "sime;": { p: [8771], c: "\u2243" },
    "simeq;": { p: [8771], c: "\u2243" },
    "simg;": { p: [10910], c: "\u2A9E" },
    "simgE;": { p: [10912], c: "\u2AA0" },
    "siml;": { p: [10909], c: "\u2A9D" },
    "simlE;": { p: [10911], c: "\u2A9F" },
    "simne;": { p: [8774], c: "\u2246" },
    "simplus;": { p: [10788], c: "\u2A24" },
    "simrarr;": { p: [10610], c: "\u2972" },
    "slarr;": { p: [8592], c: "\u2190" },
    "smallsetminus;": { p: [8726], c: "\u2216" },
    "smashp;": { p: [10803], c: "\u2A33" },
    "smeparsl;": { p: [10724], c: "\u29E4" },
    "smid;": { p: [8739], c: "\u2223" },
    "smile;": { p: [8995], c: "\u2323" },
    "smt;": { p: [10922], c: "\u2AAA" },
    "smte;": { p: [10924], c: "\u2AAC" },
    "smtes;": { p: [10924, 65024], c: "\u2AAC\uFE00" },
    "softcy;": { p: [1100], c: "\u044C" },
    "sol;": { p: [47], c: "\u002F" },
    "solb;": { p: [10692], c: "\u29C4" },
    "solbar;": { p: [9023], c: "\u233F" },
    "sopf;": { p: [120164], c: "\uD835\uDD64" },
    "spades;": { p: [9824], c: "\u2660" },
    "spadesuit;": { p: [9824], c: "\u2660" },
    "spar;": { p: [8741], c: "\u2225" },
    "sqcap;": { p: [8851], c: "\u2293" },
    "sqcaps;": { p: [8851, 65024], c: "\u2293\uFE00" },
    "sqcup;": { p: [8852], c: "\u2294" },
    "sqcups;": { p: [8852, 65024], c: "\u2294\uFE00" },
    "sqsub;": { p: [8847], c: "\u228F" },
    "sqsube;": { p: [8849], c: "\u2291" },
    "sqsubset;": { p: [8847], c: "\u228F" },
    "sqsubseteq;": { p: [8849], c: "\u2291" },
    "sqsup;": { p: [8848], c: "\u2290" },
    "sqsupe;": { p: [8850], c: "\u2292" },
    "sqsupset;": { p: [8848], c: "\u2290" },
    "sqsupseteq;": { p: [8850], c: "\u2292" },
    "squ;": { p: [9633], c: "\u25A1" },
    "square;": { p: [9633], c: "\u25A1" },
    "squarf;": { p: [9642], c: "\u25AA" },
    "squf;": { p: [9642], c: "\u25AA" },
    "srarr;": { p: [8594], c: "\u2192" },
    "sscr;": { p: [120008], c: "\uD835\uDCC8" },
    "ssetmn;": { p: [8726], c: "\u2216" },
    "ssmile;": { p: [8995], c: "\u2323" },
    "sstarf;": { p: [8902], c: "\u22C6" },
    "star;": { p: [9734], c: "\u2606" },
    "starf;": { p: [9733], c: "\u2605" },
    "straightepsilon;": { p: [1013], c: "\u03F5" },
    "straightphi;": { p: [981], c: "\u03D5" },
    "strns;": { p: [175], c: "\u00AF" },
    "sub;": { p: [8834], c: "\u2282" },
    "subE;": { p: [10949], c: "\u2AC5" },
    "subdot;": { p: [10941], c: "\u2ABD" },
    "sube;": { p: [8838], c: "\u2286" },
    "subedot;": { p: [10947], c: "\u2AC3" },
    "submult;": { p: [10945], c: "\u2AC1" },
    "subnE;": { p: [10955], c: "\u2ACB" },
    "subne;": { p: [8842], c: "\u228A" },
    "subplus;": { p: [10943], c: "\u2ABF" },
    "subrarr;": { p: [10617], c: "\u2979" },
    "subset;": { p: [8834], c: "\u2282" },
    "subseteq;": { p: [8838], c: "\u2286" },
    "subseteqq;": { p: [10949], c: "\u2AC5" },
    "subsetneq;": { p: [8842], c: "\u228A" },
    "subsetneqq;": { p: [10955], c: "\u2ACB" },
    "subsim;": { p: [10951], c: "\u2AC7" },
    "subsub;": { p: [10965], c: "\u2AD5" },
    "subsup;": { p: [10963], c: "\u2AD3" },
    "succ;": { p: [8827], c: "\u227B" },
    "succapprox;": { p: [10936], c: "\u2AB8" },
    "succcurlyeq;": { p: [8829], c: "\u227D" },
    "succeq;": { p: [10928], c: "\u2AB0" },
    "succnapprox;": { p: [10938], c: "\u2ABA" },
    "succneqq;": { p: [10934], c: "\u2AB6" },
    "succnsim;": { p: [8937], c: "\u22E9" },
    "succsim;": { p: [8831], c: "\u227F" },
    "sum;": { p: [8721], c: "\u2211" },
    "sung;": { p: [9834], c: "\u266A" },
    sup1: { p: [185], c: "\u00B9" },
    "sup1;": { p: [185], c: "\u00B9" },
    sup2: { p: [178], c: "\u00B2" },
    "sup2;": { p: [178], c: "\u00B2" },
    sup3: { p: [179], c: "\u00B3" },
    "sup3;": { p: [179], c: "\u00B3" },
    "sup;": { p: [8835], c: "\u2283" },
    "supE;": { p: [10950], c: "\u2AC6" },
    "supdot;": { p: [10942], c: "\u2ABE" },
    "supdsub;": { p: [10968], c: "\u2AD8" },
    "supe;": { p: [8839], c: "\u2287" },
    "supedot;": { p: [10948], c: "\u2AC4" },
    "suphsol;": { p: [10185], c: "\u27C9" },
    "suphsub;": { p: [10967], c: "\u2AD7" },
    "suplarr;": { p: [10619], c: "\u297B" },
    "supmult;": { p: [10946], c: "\u2AC2" },
    "supnE;": { p: [10956], c: "\u2ACC" },
    "supne;": { p: [8843], c: "\u228B" },
    "supplus;": { p: [10944], c: "\u2AC0" },
    "supset;": { p: [8835], c: "\u2283" },
    "supseteq;": { p: [8839], c: "\u2287" },
    "supseteqq;": { p: [10950], c: "\u2AC6" },
    "supsetneq;": { p: [8843], c: "\u228B" },
    "supsetneqq;": { p: [10956], c: "\u2ACC" },
    "supsim;": { p: [10952], c: "\u2AC8" },
    "supsub;": { p: [10964], c: "\u2AD4" },
    "supsup;": { p: [10966], c: "\u2AD6" },
    "swArr;": { p: [8665], c: "\u21D9" },
    "swarhk;": { p: [10534], c: "\u2926" },
    "swarr;": { p: [8601], c: "\u2199" },
    "swarrow;": { p: [8601], c: "\u2199" },
    "swnwar;": { p: [10538], c: "\u292A" },
    szlig: { p: [223], c: "\u00DF" },
    "szlig;": { p: [223], c: "\u00DF" },
    "target;": { p: [8982], c: "\u2316" },
    "tau;": { p: [964], c: "\u03C4" },
    "tbrk;": { p: [9140], c: "\u23B4" },
    "tcaron;": { p: [357], c: "\u0165" },
    "tcedil;": { p: [355], c: "\u0163" },
    "tcy;": { p: [1090], c: "\u0442" },
    "tdot;": { p: [8411], c: "\u20DB" },
    "telrec;": { p: [8981], c: "\u2315" },
    "tfr;": { p: [120113], c: "\uD835\uDD31" },
    "there4;": { p: [8756], c: "\u2234" },
    "therefore;": { p: [8756], c: "\u2234" },
    "theta;": { p: [952], c: "\u03B8" },
    "thetasym;": { p: [977], c: "\u03D1" },
    "thetav;": { p: [977], c: "\u03D1" },
    "thickapprox;": { p: [8776], c: "\u2248" },
    "thicksim;": { p: [8764], c: "\u223C" },
    "thinsp;": { p: [8201], c: "\u2009" },
    "thkap;": { p: [8776], c: "\u2248" },
    "thksim;": { p: [8764], c: "\u223C" },
    thorn: { p: [254], c: "\u00FE" },
    "thorn;": { p: [254], c: "\u00FE" },
    "tilde;": { p: [732], c: "\u02DC" },
    times: { p: [215], c: "\u00D7" },
    "times;": { p: [215], c: "\u00D7" },
    "timesb;": { p: [8864], c: "\u22A0" },
    "timesbar;": { p: [10801], c: "\u2A31" },
    "timesd;": { p: [10800], c: "\u2A30" },
    "tint;": { p: [8749], c: "\u222D" },
    "toea;": { p: [10536], c: "\u2928" },
    "top;": { p: [8868], c: "\u22A4" },
    "topbot;": { p: [9014], c: "\u2336" },
    "topcir;": { p: [10993], c: "\u2AF1" },
    "topf;": { p: [120165], c: "\uD835\uDD65" },
    "topfork;": { p: [10970], c: "\u2ADA" },
    "tosa;": { p: [10537], c: "\u2929" },
    "tprime;": { p: [8244], c: "\u2034" },
    "trade;": { p: [8482], c: "\u2122" },
    "triangle;": { p: [9653], c: "\u25B5" },
    "triangledown;": { p: [9663], c: "\u25BF" },
    "triangleleft;": { p: [9667], c: "\u25C3" },
    "trianglelefteq;": { p: [8884], c: "\u22B4" },
    "triangleq;": { p: [8796], c: "\u225C" },
    "triangleright;": { p: [9657], c: "\u25B9" },
    "trianglerighteq;": { p: [8885], c: "\u22B5" },
    "tridot;": { p: [9708], c: "\u25EC" },
    "trie;": { p: [8796], c: "\u225C" },
    "triminus;": { p: [10810], c: "\u2A3A" },
    "triplus;": { p: [10809], c: "\u2A39" },
    "trisb;": { p: [10701], c: "\u29CD" },
    "tritime;": { p: [10811], c: "\u2A3B" },
    "trpezium;": { p: [9186], c: "\u23E2" },
    "tscr;": { p: [120009], c: "\uD835\uDCC9" },
    "tscy;": { p: [1094], c: "\u0446" },
    "tshcy;": { p: [1115], c: "\u045B" },
    "tstrok;": { p: [359], c: "\u0167" },
    "twixt;": { p: [8812], c: "\u226C" },
    "twoheadleftarrow;": { p: [8606], c: "\u219E" },
    "twoheadrightarrow;": { p: [8608], c: "\u21A0" },
    "uArr;": { p: [8657], c: "\u21D1" },
    "uHar;": { p: [10595], c: "\u2963" },
    uacute: { p: [250], c: "\u00FA" },
    "uacute;": { p: [250], c: "\u00FA" },
    "uarr;": { p: [8593], c: "\u2191" },
    "ubrcy;": { p: [1118], c: "\u045E" },
    "ubreve;": { p: [365], c: "\u016D" },
    ucirc: { p: [251], c: "\u00FB" },
    "ucirc;": { p: [251], c: "\u00FB" },
    "ucy;": { p: [1091], c: "\u0443" },
    "udarr;": { p: [8645], c: "\u21C5" },
    "udblac;": { p: [369], c: "\u0171" },
    "udhar;": { p: [10606], c: "\u296E" },
    "ufisht;": { p: [10622], c: "\u297E" },
    "ufr;": { p: [120114], c: "\uD835\uDD32" },
    ugrave: { p: [249], c: "\u00F9" },
    "ugrave;": { p: [249], c: "\u00F9" },
    "uharl;": { p: [8639], c: "\u21BF" },
    "uharr;": { p: [8638], c: "\u21BE" },
    "uhblk;": { p: [9600], c: "\u2580" },
    "ulcorn;": { p: [8988], c: "\u231C" },
    "ulcorner;": { p: [8988], c: "\u231C" },
    "ulcrop;": { p: [8975], c: "\u230F" },
    "ultri;": { p: [9720], c: "\u25F8" },
    "umacr;": { p: [363], c: "\u016B" },
    uml: { p: [168], c: "\u00A8" },
    "uml;": { p: [168], c: "\u00A8" },
    "uogon;": { p: [371], c: "\u0173" },
    "uopf;": { p: [120166], c: "\uD835\uDD66" },
    "uparrow;": { p: [8593], c: "\u2191" },
    "updownarrow;": { p: [8597], c: "\u2195" },
    "upharpoonleft;": { p: [8639], c: "\u21BF" },
    "upharpoonright;": { p: [8638], c: "\u21BE" },
    "uplus;": { p: [8846], c: "\u228E" },
    "upsi;": { p: [965], c: "\u03C5" },
    "upsih;": { p: [978], c: "\u03D2" },
    "upsilon;": { p: [965], c: "\u03C5" },
    "upuparrows;": { p: [8648], c: "\u21C8" },
    "urcorn;": { p: [8989], c: "\u231D" },
    "urcorner;": { p: [8989], c: "\u231D" },
    "urcrop;": { p: [8974], c: "\u230E" },
    "uring;": { p: [367], c: "\u016F" },
    "urtri;": { p: [9721], c: "\u25F9" },
    "uscr;": { p: [120010], c: "\uD835\uDCCA" },
    "utdot;": { p: [8944], c: "\u22F0" },
    "utilde;": { p: [361], c: "\u0169" },
    "utri;": { p: [9653], c: "\u25B5" },
    "utrif;": { p: [9652], c: "\u25B4" },
    "uuarr;": { p: [8648], c: "\u21C8" },
    uuml: { p: [252], c: "\u00FC" },
    "uuml;": { p: [252], c: "\u00FC" },
    "uwangle;": { p: [10663], c: "\u29A7" },
    "vArr;": { p: [8661], c: "\u21D5" },
    "vBar;": { p: [10984], c: "\u2AE8" },
    "vBarv;": { p: [10985], c: "\u2AE9" },
    "vDash;": { p: [8872], c: "\u22A8" },
    "vangrt;": { p: [10652], c: "\u299C" },
    "varepsilon;": { p: [1013], c: "\u03F5" },
    "varkappa;": { p: [1008], c: "\u03F0" },
    "varnothing;": { p: [8709], c: "\u2205" },
    "varphi;": { p: [981], c: "\u03D5" },
    "varpi;": { p: [982], c: "\u03D6" },
    "varpropto;": { p: [8733], c: "\u221D" },
    "varr;": { p: [8597], c: "\u2195" },
    "varrho;": { p: [1009], c: "\u03F1" },
    "varsigma;": { p: [962], c: "\u03C2" },
    "varsubsetneq;": {
        p: [8842, 65024],
        c: "\u228A\uFE00",
    },
    "varsubsetneqq;": {
        p: [10955, 65024],
        c: "\u2ACB\uFE00",
    },
    "varsupsetneq;": {
        p: [8843, 65024],
        c: "\u228B\uFE00",
    },
    "varsupsetneqq;": {
        p: [10956, 65024],
        c: "\u2ACC\uFE00",
    },
    "vartheta;": { p: [977], c: "\u03D1" },
    "vartriangleleft;": { p: [8882], c: "\u22B2" },
    "vartriangleright;": { p: [8883], c: "\u22B3" },
    "vcy;": { p: [1074], c: "\u0432" },
    "vdash;": { p: [8866], c: "\u22A2" },
    "vee;": { p: [8744], c: "\u2228" },
    "veebar;": { p: [8891], c: "\u22BB" },
    "veeeq;": { p: [8794], c: "\u225A" },
    "vellip;": { p: [8942], c: "\u22EE" },
    "verbar;": { p: [124], c: "\u007C" },
    "vert;": { p: [124], c: "\u007C" },
    "vfr;": { p: [120115], c: "\uD835\uDD33" },
    "vltri;": { p: [8882], c: "\u22B2" },
    "vnsub;": { p: [8834, 8402], c: "\u2282\u20D2" },
    "vnsup;": { p: [8835, 8402], c: "\u2283\u20D2" },
    "vopf;": { p: [120167], c: "\uD835\uDD67" },
    "vprop;": { p: [8733], c: "\u221D" },
    "vrtri;": { p: [8883], c: "\u22B3" },
    "vscr;": { p: [120011], c: "\uD835\uDCCB" },
    "vsubnE;": { p: [10955, 65024], c: "\u2ACB\uFE00" },
    "vsubne;": { p: [8842, 65024], c: "\u228A\uFE00" },
    "vsupnE;": { p: [10956, 65024], c: "\u2ACC\uFE00" },
    "vsupne;": { p: [8843, 65024], c: "\u228B\uFE00" },
    "vzigzag;": { p: [10650], c: "\u299A" },
    "wcirc;": { p: [373], c: "\u0175" },
    "wedbar;": { p: [10847], c: "\u2A5F" },
    "wedge;": { p: [8743], c: "\u2227" },
    "wedgeq;": { p: [8793], c: "\u2259" },
    "weierp;": { p: [8472], c: "\u2118" },
    "wfr;": { p: [120116], c: "\uD835\uDD34" },
    "wopf;": { p: [120168], c: "\uD835\uDD68" },
    "wp;": { p: [8472], c: "\u2118" },
    "wr;": { p: [8768], c: "\u2240" },
    "wreath;": { p: [8768], c: "\u2240" },
    "wscr;": { p: [120012], c: "\uD835\uDCCC" },
    "xcap;": { p: [8898], c: "\u22C2" },
    "xcirc;": { p: [9711], c: "\u25EF" },
    "xcup;": { p: [8899], c: "\u22C3" },
    "xdtri;": { p: [9661], c: "\u25BD" },
    "xfr;": { p: [120117], c: "\uD835\uDD35" },
    "xhArr;": { p: [10234], c: "\u27FA" },
    "xharr;": { p: [10231], c: "\u27F7" },
    "xi;": { p: [958], c: "\u03BE" },
    "xlArr;": { p: [10232], c: "\u27F8" },
    "xlarr;": { p: [10229], c: "\u27F5" },
    "xmap;": { p: [10236], c: "\u27FC" },
    "xnis;": { p: [8955], c: "\u22FB" },
    "xodot;": { p: [10752], c: "\u2A00" },
    "xopf;": { p: [120169], c: "\uD835\uDD69" },
    "xoplus;": { p: [10753], c: "\u2A01" },
    "xotime;": { p: [10754], c: "\u2A02" },
    "xrArr;": { p: [10233], c: "\u27F9" },
    "xrarr;": { p: [10230], c: "\u27F6" },
    "xscr;": { p: [120013], c: "\uD835\uDCCD" },
    "xsqcup;": { p: [10758], c: "\u2A06" },
    "xuplus;": { p: [10756], c: "\u2A04" },
    "xutri;": { p: [9651], c: "\u25B3" },
    "xvee;": { p: [8897], c: "\u22C1" },
    "xwedge;": { p: [8896], c: "\u22C0" },
    yacute: { p: [253], c: "\u00FD" },
    "yacute;": { p: [253], c: "\u00FD" },
    "yacy;": { p: [1103], c: "\u044F" },
    "ycirc;": { p: [375], c: "\u0177" },
    "ycy;": { p: [1099], c: "\u044B" },
    yen: { p: [165], c: "\u00A5" },
    "yen;": { p: [165], c: "\u00A5" },
    "yfr;": { p: [120118], c: "\uD835\uDD36" },
    "yicy;": { p: [1111], c: "\u0457" },
    "yopf;": { p: [120170], c: "\uD835\uDD6A" },
    "yscr;": { p: [120014], c: "\uD835\uDCCE" },
    "yucy;": { p: [1102], c: "\u044E" },
    yuml: { p: [255], c: "\u00FF" },
    "yuml;": { p: [255], c: "\u00FF" },
    "zacute;": { p: [378], c: "\u017A" },
    "zcaron;": { p: [382], c: "\u017E" },
    "zcy;": { p: [1079], c: "\u0437" },
    "zdot;": { p: [380], c: "\u017C" },
    "zeetrf;": { p: [8488], c: "\u2128" },
    "zeta;": { p: [950], c: "\u03B6" },
    "zfr;": { p: [120119], c: "\uD835\uDD37" },
    "zhcy;": { p: [1078], c: "\u0436" },
    "zigrarr;": { p: [8669], c: "\u21DD" },
    "zopf;": { p: [120171], c: "\uD835\uDD6B" },
    "zscr;": { p: [120015], c: "\uD835\uDCCF" },
    "zwj;": { p: [8205], c: "\u200D" },
    "zwnj;": { p: [8204], c: "\u200C" },
};
