var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import * as Path from "path";
import { ConverterComponent } from "../components.js";
import { ApplicationEvents } from "../../application-events.js";
import { ConverterEvents } from "../converter-events.js";
import { i18n, MinimalSourceFile, NormalizedPathUtils } from "#utils";
import { deriveRootDir, discoverPackageJson, nicePath, normalizePath, Option, readFile, } from "#node-utils";
import { existsSync } from "fs";
/**
 * A handler that tries to find the package.json and readme.md files of the
 * current project.
 */
let PackagePlugin = (() => {
    let _classSuper = ConverterComponent;
    let _readme_decorators;
    let _readme_initializers = [];
    let _readme_extraInitializers = [];
    let _entryPointStrategy_decorators;
    let _entryPointStrategy_initializers = [];
    let _entryPointStrategy_extraInitializers = [];
    let _entryPoints_decorators;
    let _entryPoints_initializers = [];
    let _entryPoints_extraInitializers = [];
    let _includeVersion_decorators;
    let _includeVersion_initializers = [];
    let _includeVersion_extraInitializers = [];
    return class PackagePlugin extends _classSuper {
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            _readme_decorators = [Option("readme")];
            _entryPointStrategy_decorators = [Option("entryPointStrategy")];
            _entryPoints_decorators = [Option("entryPoints")];
            _includeVersion_decorators = [Option("includeVersion")];
            __esDecorate(this, null, _readme_decorators, { kind: "accessor", name: "readme", static: false, private: false, access: { has: obj => "readme" in obj, get: obj => obj.readme, set: (obj, value) => { obj.readme = value; } }, metadata: _metadata }, _readme_initializers, _readme_extraInitializers);
            __esDecorate(this, null, _entryPointStrategy_decorators, { kind: "accessor", name: "entryPointStrategy", static: false, private: false, access: { has: obj => "entryPointStrategy" in obj, get: obj => obj.entryPointStrategy, set: (obj, value) => { obj.entryPointStrategy = value; } }, metadata: _metadata }, _entryPointStrategy_initializers, _entryPointStrategy_extraInitializers);
            __esDecorate(this, null, _entryPoints_decorators, { kind: "accessor", name: "entryPoints", static: false, private: false, access: { has: obj => "entryPoints" in obj, get: obj => obj.entryPoints, set: (obj, value) => { obj.entryPoints = value; } }, metadata: _metadata }, _entryPoints_initializers, _entryPoints_extraInitializers);
            __esDecorate(this, null, _includeVersion_decorators, { kind: "accessor", name: "includeVersion", static: false, private: false, access: { has: obj => "includeVersion" in obj, get: obj => obj.includeVersion, set: (obj, value) => { obj.includeVersion = value; } }, metadata: _metadata }, _includeVersion_initializers, _includeVersion_extraInitializers);
            if (_metadata) Object.defineProperty(this, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
        }
        #readme_accessor_storage = __runInitializers(this, _readme_initializers, void 0);
        get readme() { return this.#readme_accessor_storage; }
        set readme(value) { this.#readme_accessor_storage = value; }
        #entryPointStrategy_accessor_storage = (__runInitializers(this, _readme_extraInitializers), __runInitializers(this, _entryPointStrategy_initializers, void 0));
        get entryPointStrategy() { return this.#entryPointStrategy_accessor_storage; }
        set entryPointStrategy(value) { this.#entryPointStrategy_accessor_storage = value; }
        #entryPoints_accessor_storage = (__runInitializers(this, _entryPointStrategy_extraInitializers), __runInitializers(this, _entryPoints_initializers, void 0));
        get entryPoints() { return this.#entryPoints_accessor_storage; }
        set entryPoints(value) { this.#entryPoints_accessor_storage = value; }
        #includeVersion_accessor_storage = (__runInitializers(this, _entryPoints_extraInitializers), __runInitializers(this, _includeVersion_initializers, void 0));
        get includeVersion() { return this.#includeVersion_accessor_storage; }
        set includeVersion(value) { this.#includeVersion_accessor_storage = value; }
        /**
         * The file name of the found readme.md file.
         */
        readmeFile = __runInitializers(this, _includeVersion_extraInitializers);
        /**
         * Contents of the readme.md file discovered, if any
         */
        readmeContents;
        /**
         * Contents of package.json for the active project
         */
        packageJson;
        constructor(owner) {
            super(owner);
            this.owner.on(ConverterEvents.BEGIN, this.onBegin.bind(this));
            this.owner.on(ConverterEvents.RESOLVE_BEGIN, this.onBeginResolve.bind(this));
            this.owner.on(ConverterEvents.END, () => {
                delete this.readmeFile;
                delete this.readmeContents;
                delete this.packageJson;
            });
            this.application.on(ApplicationEvents.REVIVE, this.onRevive.bind(this));
        }
        onRevive(project) {
            this.onBegin();
            this.addEntries(project);
            delete this.readmeFile;
            delete this.packageJson;
            delete this.readmeContents;
        }
        onBegin() {
            this.readmeFile = undefined;
            this.readmeContents = undefined;
            this.packageJson = undefined;
            const dirName = this.application.options.packageDir ??
                Path.resolve(deriveRootDir(this.entryPoints));
            this.application.logger.verbose(`Begin package.json search at ${nicePath(dirName)}`);
            const packageJson = discoverPackageJson(dirName);
            this.packageJson = packageJson?.content;
            // Path will be resolved already. This is kind of ugly, but...
            if (this.readme.endsWith("none")) {
                return; // No readme, we're done
            }
            if (this.readme) {
                // Readme path provided, read only that file.
                this.application.watchFile(this.readme);
                try {
                    this.readmeContents = readFile(this.readme);
                    this.readmeFile = normalizePath(this.readme);
                }
                catch {
                    this.application.logger.error(i18n.provided_readme_at_0_could_not_be_read(nicePath(this.readme)));
                }
            }
            else if (packageJson) {
                // No readme provided, automatically find the readme
                const possibleReadmePaths = [
                    "README.md",
                    "readme.md",
                    "Readme.md",
                ].map(name => Path.join(Path.dirname(packageJson.file), name));
                const readmePath = possibleReadmePaths.find(path => {
                    this.application.watchFile(path);
                    return existsSync(path);
                });
                if (readmePath) {
                    this.readmeFile = normalizePath(readmePath);
                    this.readmeContents = readFile(readmePath);
                    this.application.watchFile(this.readmeFile);
                }
            }
        }
        onBeginResolve(context) {
            this.addEntries(context.project);
        }
        addEntries(project) {
            if (this.readmeFile && this.readmeContents) {
                const { content } = this.application.converter.parseRawComment(new MinimalSourceFile(this.readmeContents, this.readmeFile), project.files);
                project.readme = content;
                project.files.registerReflectionPath(this.readmeFile, project);
                // In packages mode, this probably won't do anything unless someone uses the readme
                // option to select a different file.
                project.files.registerReflectionPath(NormalizedPathUtils.dirname(this.readmeFile), project);
                // This isn't ideal, but seems better than figuring out the readme
                // path over in the include plugin...
                this.owner.includePlugin.checkIncludeTagsParts(project, Path.dirname(this.readmeFile), content);
            }
            if (this.packageJson) {
                project.packageName = this.packageJson.name;
                if (!project.name) {
                    project.name = project.packageName || "Documentation";
                }
                if (this.includeVersion) {
                    project.packageVersion = this.packageJson.version?.replace(/^v/, "");
                }
            }
            else if (!project.name) {
                this.application.logger.warn(i18n.defaulting_project_name());
                project.name = "Documentation";
            }
        }
    };
})();
export { PackagePlugin };
