import { ProviderIconProps } from 'components/icons/providers'

export default function Zookeeper(props: ProviderIconProps) {
  return (
    <svg width="72" height="72" viewBox="0 0 72 72" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
      <g clipPath="url(#clip0_2127_60)">
        <path
          d="M42.6829 7.87207C43.5785 7.87207 43.7073 7.87598 44.0609 7.9248L44.3587 7.96973C45.8402 8.21544 47.1512 8.74594 48.1058 9.50391L48.3851 9.74512C48.6665 10.0065 48.9425 10.3167 49.1175 10.5762L49.2415 10.7852C49.284 10.8635 49.3269 10.9477 49.3655 11.0293C49.4415 11.1898 49.5152 11.3659 49.5452 11.4834L49.5687 11.5947C49.6081 11.8248 49.6007 12.0947 49.5462 12.3125L49.515 12.417C49.3312 12.9328 48.9442 13.3494 48.3792 13.6895L48.1263 13.8311C48.0579 13.8664 47.9995 13.8955 47.9525 13.917C47.9126 13.9352 47.8563 13.9601 47.803 13.9697C47.7904 13.972 47.7565 13.9764 47.7132 13.9707C47.6586 14.0383 47.5894 14.1198 47.5276 14.1865H47.5267L47.6419 14.2803L47.7962 14.415C47.842 14.4586 47.8818 14.5009 47.9134 14.541C47.9434 14.5792 47.9805 14.6329 48.0003 14.6963C48.0183 14.7543 48.0311 14.8604 47.9651 14.9551L47.9319 14.9951C47.9133 15.0137 47.8931 15.0273 47.8753 15.0381L47.8421 15.082C47.7093 15.2528 47.7143 15.2421 47.7239 15.3125C47.7701 15.6508 47.8122 16.0232 47.8275 16.2354L47.846 16.4922L47.7366 16.7383C47.6769 16.8737 47.6212 16.9983 47.6126 17.0146C47.5882 17.0602 47.1991 17.4693 47.0638 17.5918C46.9463 17.6981 46.9213 17.7125 46.8441 17.7129C46.7899 17.7131 46.7601 17.7242 46.7601 17.7451C46.76 17.7557 46.7534 17.7806 46.7454 17.8008C46.7331 17.8318 46.734 17.9882 46.7503 18.7793C46.761 19.2968 46.7704 19.7875 46.7708 19.8691V20.0176L46.5306 20.3994C46.3473 20.6908 46.2661 20.8107 46.1868 20.9023C46.107 20.9947 46.086 21.0245 46.096 21.0342C46.1034 21.041 46.3009 21.1771 46.5355 21.3359C46.6488 21.4127 46.7779 21.4959 46.9134 21.583C47.1744 21.62 47.4201 21.6881 47.6448 21.8008L48.1878 22.1299L48.1927 22.1719L48.1985 22.2139L48.3519 22.2754C48.5164 22.3418 48.6574 22.4138 48.8157 22.5117C49.3382 22.835 49.8034 23.3726 50.0706 23.9619L50.1273 24.0869L50.3011 24.1748C50.3966 24.2229 50.5166 24.2896 50.5677 24.3232C51.1098 24.6805 51.5033 25.2538 51.6614 25.915C51.6944 26.0528 51.7265 26.2494 51.7278 26.3213C51.7292 26.3947 51.7363 26.4008 51.8724 26.4512C52.1875 26.5677 52.4432 26.7238 52.6419 26.9209C52.8303 27.1079 52.9386 27.2891 52.9935 27.5107C53.0173 27.607 53.0207 27.6401 53.0169 27.7568L53.012 27.8916L53.098 27.9639C53.427 28.2417 53.6593 28.6978 53.7484 29.2412C53.7762 29.4111 53.7762 29.8258 53.7484 29.9961C53.6876 30.3671 53.5762 30.6607 53.3909 30.9414C53.3075 31.0678 52.2333 32.9212 52.2278 32.9482C52.2271 32.9561 52.2467 32.9717 52.2718 32.9834C52.2995 32.9963 52.3185 33.0124 52.3187 33.0234C52.3187 33.0336 52.2642 33.1794 52.1976 33.3467C52.0923 33.6111 52.0685 33.6806 52.0208 33.8809C51.9722 34.0846 51.9654 34.1325 51.9564 34.2969C51.9508 34.3977 51.942 34.4845 51.9368 34.4912C51.9341 34.4939 51.8821 34.4927 51.8021 34.4951C51.7965 34.5794 51.7899 34.6472 51.7845 34.6543C51.7772 34.6616 51.6391 34.6667 51.3978 34.668C51.0815 34.6697 50.8535 34.6786 50.7415 34.6943C50.5379 35.0414 50.064 35.8694 50.0638 35.8857C50.0647 35.8934 50.0981 35.9247 50.138 35.9561C50.1786 35.9879 50.2451 36.0452 50.2855 36.083C50.3244 36.1195 50.3578 36.1493 50.3616 36.1514C50.3634 36.1514 50.4119 36.1346 50.4691 36.1143C51.0332 35.9132 51.6877 36.1545 51.848 36.6221C51.8642 36.6696 51.8746 36.7302 51.8782 36.8047L51.8831 36.916L51.9437 36.9404C52.0881 36.999 52.2524 37.1322 52.3333 37.2559C52.4426 37.4232 52.467 37.5542 52.4319 37.7822L52.4261 37.8203L52.511 37.8584C52.887 38.026 53.1585 38.4 53.2161 38.8291C53.233 38.9553 53.2224 39.1725 53.1937 39.29C53.1814 39.3399 53.1722 39.39 53.1722 39.4014C53.1722 39.4613 52.9496 39.8423 52.7982 40.042C52.6887 40.1863 52.5674 40.3177 52.4388 40.4385C52.4211 40.4573 52.4047 40.4788 52.3851 40.499C51.9558 40.9402 51.423 41.2395 50.8362 41.3691C50.6061 41.42 50.4985 41.4307 50.1966 41.4307C49.8944 41.4307 49.7863 41.42 49.556 41.3691C49.1953 41.2894 48.846 41.1418 48.5325 40.9355C48.3822 40.8366 48.179 40.676 48.1009 40.5947C48.0946 40.5882 48.0865 40.5837 48.0804 40.5781C48.0134 40.7015 47.9414 40.8392 47.9417 40.8506C47.9423 40.8637 47.9611 40.916 47.9837 40.9668C48.0136 41.0338 48.0339 41.0638 48.055 41.0742C48.0755 41.0846 48.1003 41.1212 48.138 41.1963C48.3279 41.5746 48.6019 41.946 48.9271 42.2656C49.1445 42.4794 49.3762 42.6666 49.6702 42.8672C49.8082 42.9613 49.8302 42.9908 49.8011 43.043C49.7866 43.0687 49.7814 43.0709 49.6194 43.0889C49.6551 43.1207 49.6617 43.1401 49.6566 43.1719C49.6529 43.1942 49.6437 43.2184 49.636 43.2256C49.6282 43.2328 49.5047 43.2516 49.3587 43.2676C49.2211 43.2826 49.1126 43.2951 49.0306 43.3057C49.0627 43.3818 49.1059 43.4885 49.1566 43.6025L49.3323 43.998L49.4407 44.3887L49.5491 44.7803L49.5501 44.9355V45.0898L49.9105 45.5781C50.1085 45.846 50.2757 46.0747 50.2825 46.0869C50.2903 46.1014 50.2814 46.173 50.2503 46.3408L50.2073 46.5742L50.2601 46.6787C50.2894 46.7363 50.4273 47.0035 50.5667 47.2725L50.8206 47.7617L50.3265 48.7695C50.0549 49.3237 49.8352 49.7841 49.8382 49.792C49.8417 49.7999 49.8626 49.8119 49.8851 49.8193C50.0528 49.874 50.2445 49.9804 50.345 50.0742C50.51 50.2283 50.51 50.3732 50.345 50.5273C50.3251 50.5459 50.302 50.561 50.2796 50.5781C50.2094 50.7041 50.0361 50.8233 49.7679 50.9268C49.9221 50.9685 50.1658 51.038 50.3011 51.083C50.9657 51.3042 51.4191 51.5616 51.5745 51.8066C51.6719 51.9602 51.6258 52.1035 51.4534 52.2139C51.4416 52.2419 51.4227 52.2687 51.3919 52.3027C51.2201 52.4929 50.6965 52.6083 50.0023 52.6084H49.7952C49.7709 52.6335 49.7437 52.6593 49.7161 52.6855L49.6898 52.7168C49.3089 53.1551 48.6484 53.4985 47.762 53.7188C47.6507 53.7464 47.6062 53.7587 47.5862 53.7705C47.561 54.1028 47.5171 54.4004 47.4564 54.665L47.3821 55.2588L47.4847 55.3643C47.6445 55.5285 47.6976 55.6114 47.7874 55.8369C48.0094 56.3946 48.0385 57.1092 47.8636 57.7227C47.8305 57.8386 47.8296 57.8423 47.848 57.8809C47.9096 58.01 48.0507 58.1846 48.1741 58.2852C48.2647 58.3589 48.4534 58.4844 48.473 58.4844C48.4985 58.4822 48.8769 58.3146 49.0364 58.2344C49.3261 58.0886 49.5451 57.9445 49.9651 57.623C50.4054 57.2861 50.5916 57.167 50.8362 57.0693C51.0824 56.9711 51.2859 56.9226 51.5091 56.9082C51.5963 56.9026 51.7139 56.8927 51.7708 56.8857C51.8953 56.8706 52.1796 56.8787 52.3734 56.9033C52.7714 56.9539 53.1513 57.0655 53.4573 57.2217C54.2199 57.6108 54.7425 58.199 54.9173 58.8652C54.9526 59 54.9775 59.1798 54.9778 59.2988C54.978 59.3702 54.9824 59.3901 55.0003 59.4092C55.0219 59.4321 55.0212 59.436 54.9505 60.4375C54.9118 60.9855 54.8808 61.4452 54.8802 61.4658C54.8802 61.4833 54.8974 61.4978 54.9534 61.5254C55.2326 61.6626 55.4437 61.9428 55.4876 62.2344C55.5077 62.3684 55.5077 62.5232 55.4876 62.6572C55.4491 62.9131 55.2868 63.1552 55.0452 63.3154C54.9032 63.4096 54.8863 63.4147 54.3548 63.5254C53.6956 63.6627 52.9717 63.7459 52.1273 63.7822C51.7936 63.7965 50.5481 63.7902 49.8294 63.7705C49.5885 63.7639 49.0417 63.7491 48.6146 63.7373C48.1873 63.7255 47.6432 63.7104 47.4056 63.7041C46.7374 63.6863 45.4303 63.6409 45.2171 63.6279C45.1116 63.6215 44.8117 63.6088 44.5501 63.5996C44.2883 63.5904 44.0442 63.5782 44.0081 63.5732C43.515 63.5051 43.2161 63.4398 42.9681 63.3457C42.7275 63.2543 42.5664 63.0666 42.5042 62.8066C42.424 62.4708 42.56 62.0971 42.8216 61.9355C42.8568 61.9138 42.8864 61.8947 42.887 61.8926C42.887 61.8908 42.8593 61.8384 42.8265 61.7764C42.7177 61.5706 42.6406 61.3421 42.596 61.0947C42.5679 60.9386 42.5628 60.6101 42.5853 60.4326C42.6416 59.9889 42.8176 59.5861 43.0843 59.291C43.2284 59.1314 43.3505 58.8714 43.4339 58.5449C43.5335 58.1549 43.552 57.7907 43.4925 57.4082C43.4831 57.3476 43.4738 57.2735 43.472 57.2432C43.4702 57.2131 43.4612 57.1296 43.4515 57.0586C43.394 56.6377 43.4638 56.1784 43.6419 55.8066C43.7941 55.4889 43.9743 55.2934 44.2679 55.1299C44.3179 55.1021 44.3596 55.0732 44.3763 55.0596C44.3165 54.8885 44.2671 54.7032 44.2278 54.5049C44.1162 54.1251 43.986 53.6854 43.9778 53.6738C43.9707 53.667 43.9105 53.6462 43.845 53.627C43.2102 53.4407 42.6174 53.1121 42.305 52.7744C42.2407 52.7049 42.2275 52.6967 42.1263 52.6582C42.0661 52.6353 41.9483 52.5849 41.8646 52.5469C41.7827 52.5097 41.7113 52.4817 41.7034 52.4834C41.6984 52.4865 41.6937 52.4983 41.6937 52.5088C41.6936 52.5192 41.6876 52.5362 41.68 52.5469C41.6577 52.5773 41.6451 52.5517 41.6224 52.4248L41.6028 52.3125L41.6585 52.0146C41.8951 50.7666 42.0042 49.5887 42.0042 48.2646C42.0042 47.5642 41.9831 47.079 41.9232 46.4043C41.9017 46.1629 41.8432 45.6371 41.8294 45.5625C41.8231 45.5285 41.821 45.5271 41.8079 45.5449C41.7713 45.5949 41.7646 45.5628 41.7278 45.1172C41.7048 44.8376 41.6824 44.6312 41.6653 44.5439C41.643 44.4293 41.6415 44.4048 41.6536 44.3857C41.6657 44.3667 41.6558 44.2222 41.5931 43.4658L41.5345 42.7627C41.5147 43.1849 41.4942 43.7029 41.4632 44.5615L41.3978 46.3779L41.2347 48.1738L41.0706 49.9697L40.9749 50.1924C40.9222 50.3149 40.8768 50.4339 40.8734 50.4561C40.868 50.4894 40.8161 50.5537 40.5814 50.8223C40.4252 51.001 40.2933 51.1539 40.2874 51.1631C40.2812 51.1735 40.3419 51.2413 40.4935 51.3936C40.6116 51.5122 40.7083 51.6144 40.7083 51.6201C40.7077 51.6743 40.6206 52.4368 40.6136 52.4492C40.5953 52.4811 40.4055 52.6839 40.3128 52.7783C40.3097 52.7818 40.3072 52.7864 40.304 52.79C40.2139 52.892 40.1306 52.9816 40.1194 52.9893C40.1017 53.0012 40.0709 52.9888 39.889 52.8984C39.7749 52.8418 39.6719 52.7958 39.6585 52.7949C39.6022 52.7949 39.5238 52.8389 39.4368 52.9209C38.8532 53.4712 37.9585 53.8617 36.9612 54.001L36.8636 54.0146L36.8089 54.1826C36.8057 54.1924 36.8034 54.2023 36.8001 54.2119L36.7181 54.4688C36.639 54.7162 36.5739 54.9275 36.5726 54.9414C36.5724 54.9518 36.5921 54.9857 36.6155 55.0166C36.7551 55.201 36.8693 55.4911 36.9388 55.8369C36.9943 56.1135 37.0042 56.2318 37.0042 56.6133C37.0042 56.9744 36.9949 57.0998 36.9505 57.332C36.9416 57.3786 36.9341 57.4247 36.9339 57.4355C36.9339 57.4467 36.9621 57.4702 37.0071 57.4951C37.1269 57.5614 37.319 57.691 37.4398 57.7871C38.0051 58.2372 38.3377 58.8237 38.3636 59.415C38.3681 59.5185 38.3747 59.556 38.388 59.5713C38.404 59.5896 38.4037 59.593 38.388 59.6045C38.3762 59.6131 38.3659 59.6513 38.3568 59.7236C38.3494 59.782 38.332 59.8817 38.3177 59.9453C38.2996 60.0252 38.2929 60.082 38.2962 60.1289C38.2989 60.1662 38.3062 60.4045 38.3128 60.6572L38.3255 61.1162L38.2933 61.3975C38.2704 61.5975 38.2554 61.6868 38.2425 61.707C38.2284 61.7286 38.2277 61.7363 38.2386 61.7402C38.2467 61.7432 38.2737 61.7529 38.2991 61.7617C38.5115 61.8354 38.6891 62.0999 38.7464 62.4287C38.7706 62.5676 38.7613 62.8203 38.7278 62.9482C38.6754 63.148 38.6078 63.2777 38.4935 63.3926C38.4077 63.4788 38.3227 63.5266 38.2337 63.54C38.2009 63.5451 38.0866 63.5717 37.9788 63.5996C37.4247 63.7428 36.7541 63.849 36.015 63.9111C35.5047 63.954 35.3012 63.9619 34.6028 63.9619C33.9048 63.9619 33.7017 63.954 33.1917 63.9111C32.6267 63.8636 32.1308 63.7949 31.6644 63.6992C31.0839 63.5802 31.0915 63.583 30.8958 63.4414C30.7124 63.3087 30.58 63.1092 30.515 62.8672C30.4857 62.7583 30.4857 62.484 30.515 62.375C30.5968 62.0707 30.7917 61.828 31.056 61.7012C31.1007 61.6797 31.1332 61.6571 31.1341 61.6475C31.1342 61.6384 31.1015 61.1759 31.0618 60.6201C30.99 59.6152 30.9897 59.6094 31.011 59.5859C31.0294 59.5658 31.0334 59.541 31.0384 59.4199C31.0775 58.4808 31.867 57.6108 33.0599 57.1924L33.2073 57.1406V57.1045C33.2069 57.0843 33.1964 56.9983 33.1849 56.9141C33.1591 56.7247 33.1551 56.1545 33.178 55.9678C33.2635 55.2727 33.4816 54.7767 33.7698 54.623C33.8066 54.6034 33.8372 54.5846 33.8372 54.5811C33.8355 54.5704 33.7765 54.3176 33.7054 54.0127C33.6332 53.7032 33.5745 53.4475 33.5745 53.4453C33.5727 53.4421 33.5304 53.4146 33.4788 53.3838C33.0146 53.1059 32.6673 52.7822 32.431 52.4062C32.3071 52.2091 32.2079 51.9663 32.1653 51.7559L32.1448 51.6562L32.0306 51.5605C31.8813 51.4355 31.7094 51.2688 31.5482 51.0938C31.4061 50.9395 31.3943 50.914 31.4612 50.9004C31.4816 50.8962 31.5119 50.8784 31.5286 50.8613C31.5332 50.8566 31.5561 50.8273 31.596 50.7803V50.7783C31.5964 50.7771 31.5985 50.7767 31.5999 50.7754C31.7195 50.6344 31.9728 50.3361 32.2552 49.999C32.8936 49.2372 32.9514 49.1646 32.9456 49.1357C32.9296 49.0554 32.9345 49.0582 32.4964 48.8555C32.0837 48.6645 32.0812 48.6631 32.0823 48.6309C32.0853 48.5503 32.1161 48.4922 32.4163 48.0156L32.6214 47.6914L32.9661 46.8037L33.3109 45.917L33.4974 45.1221C33.5987 44.6905 33.6817 44.3329 33.6839 44.3193C33.6839 44.309 33.2345 44.3429 33.1038 44.3633C33.0717 44.3683 33.0589 44.3638 33.0276 44.3359L32.9905 44.3027L33.0091 44.2676C33.0192 44.248 33.3002 43.7962 33.6341 43.2637L34.2415 42.2949L34.2073 42.2666C34.1735 42.2386 34.1734 42.2369 34.1859 42.1875C34.1945 42.1517 34.1976 41.9639 34.1976 41.5801V41.0234L34.5521 40.2148C34.7467 39.7701 35.1527 38.8616 35.4544 38.1963C35.9993 36.9946 36.0044 36.9845 36.2112 36.6191C36.3258 36.4168 36.4193 36.2402 36.4193 36.2275C36.4176 36.1947 36.25 35.5154 36.2337 35.4756C36.2279 35.462 36.1386 35.3946 36.0316 35.3232L35.8392 35.1953V34.0879L35.7562 33.6211L35.6732 33.1533L35.7347 32.7783C35.7688 32.5724 35.8008 32.393 35.805 32.3789C35.8091 32.3656 35.8433 32.3196 35.8812 32.2773C35.9249 32.2285 35.955 32.1837 35.9642 32.1533C35.9742 32.1198 35.9989 32.0844 36.0482 32.0352C36.2824 31.8008 36.4812 31.4372 36.5882 31.0469C36.726 30.544 36.719 30.0427 36.5667 29.5352L36.5403 29.4463L36.4222 29.3545C36.2515 29.2213 36.2603 29.2339 36.2923 29.1709C36.3111 29.1337 36.3159 29.1147 36.3079 29.1064C36.2997 29.0982 36.2892 29.102 36.2728 29.1201C36.2544 29.1382 35.1286 29.9545 33.7659 30.9375C32.2546 32.0278 31.5753 32.5124 31.3392 32.6729L31.2659 32.7266L31.2542 32.7275C31.2449 32.733 31.2402 32.7378 31.2376 32.7383C31.2127 32.7433 31.0558 32.7602 30.888 32.7754C30.6039 32.801 30.5784 32.805 30.5423 32.8301C30.5172 32.8465 30.0484 33.0527 29.4974 33.29L28.4915 33.7236L28.2669 33.6836C28.144 33.6616 28.0288 33.6378 28.0101 33.6309C27.9601 33.6118 27.8281 33.4728 27.7894 33.3984C27.724 33.2725 27.6868 33.1215 27.6868 32.9795C27.6868 32.9347 27.6767 32.8552 27.6644 32.8027L27.6419 32.707L27.4485 32.6992C26.9719 32.6806 26.4807 32.609 26.0237 32.4902C25.5155 32.3582 25.0058 32.3041 24.5345 32.332C24.4118 32.3393 24.2654 32.3472 24.2093 32.3496C24.1242 32.3532 24.099 32.3583 24.0589 32.3818C24.0214 32.4038 23.9628 32.4178 23.7943 32.4463C23.4187 32.5099 23.1518 32.5795 22.8831 32.6826C22.8024 32.7136 22.719 32.7457 22.6976 32.7539C22.6707 32.7642 22.5976 32.7682 22.4534 32.7686L22.2484 32.7695L22.2542 33.7734C22.2618 35.0229 22.2726 37.4971 22.3099 46.667C22.326 50.6362 22.3421 53.8884 22.346 53.9023C22.3499 53.9068 22.6205 53.9159 22.9466 53.9229C23.55 53.9358 24.3623 53.9265 24.9329 53.8994C25.0638 53.8932 25.1756 53.8902 25.181 53.8936C25.2014 53.9063 25.2058 53.9665 25.1878 53.9863C25.1782 53.997 25.1702 54.0207 25.1702 54.0391C25.1705 54.1377 25.3177 55.1517 25.4114 55.7021C25.7164 57.4924 26.1939 59.3504 26.7288 60.8262C26.9129 61.3339 27.2017 61.8107 27.512 62.1182C27.643 62.2479 27.6531 62.2602 27.6849 62.3428C27.7271 62.4526 27.7418 62.5349 27.7415 62.6533C27.741 62.9023 27.6386 63.1208 27.4202 63.3379C27.095 63.661 26.596 63.8644 25.9857 63.9229C25.9195 63.9292 25.7842 63.9444 25.6849 63.9561C25.3256 63.9981 25.2233 64.0002 23.8997 64C23.1862 63.9999 22.6005 63.9976 22.598 63.9951C22.5949 63.9926 22.5142 63.9859 22.4183 63.9795C22.322 63.9731 22.1271 63.9504 21.9857 63.9297C20.5454 63.7186 19.3728 63.2948 18.6448 62.7227C18.5216 62.6258 18.2778 62.3739 18.2054 62.2686C18.1683 62.2147 18.132 62.1734 18.1214 62.1729C18.1114 62.1726 18.0961 62.165 18.0872 62.1562C18.057 62.126 17.8002 61.5045 17.6331 61.0566C17.4684 60.615 17.2621 59.9967 17.2161 59.8057C17.2152 59.8014 17.2159 59.7833 17.2151 59.7529C17.213 59.7434 17.2097 59.7306 17.2083 59.7148C17.2056 59.6872 17.2042 59.6499 17.2044 59.5996L17.2054 59.4639L17.2132 59.4912C17.2128 59.4535 17.2125 59.4127 17.2122 59.3691C16.9107 55.8864 16.9535 53.866 17.2005 53.415C17.2018 53.4031 17.2015 53.3921 17.2064 53.3828C17.2063 53.3651 17.2064 53.3501 17.2064 53.3379H17.2044V53.2998C17.2044 53.2902 17.2055 53.2833 17.2064 53.2783C17.2068 53.2705 17.2056 53.2653 17.2073 53.2627C17.2093 53.2597 17.2121 53.2613 17.2171 53.2627C17.2175 53.2554 17.2176 53.2511 17.2181 53.251C17.227 53.249 17.2787 53.2593 17.3343 53.2734C17.8169 53.396 18.5459 53.5355 19.2064 53.6318C19.6197 53.6921 20.4278 53.7874 20.4378 53.7773C20.4422 53.7162 20.4431 44.604 20.4427 38.3691C20.4404 37.8877 20.4407 37.4062 20.4359 36.9248V36.8525C20.4339 36.8298 20.4303 36.8066 20.4261 36.7832L20.4066 36.6348C20.3866 35.3583 20.3973 34.0807 20.3909 32.8047V32.7998L20.39 32.7422C20.3883 32.7186 20.3865 32.6901 20.388 32.666C20.3884 32.6595 20.3895 32.6526 20.3909 32.6455C20.3704 32.6421 20.3455 32.6363 20.3187 32.6328C20.1722 32.6136 20.0728 32.568 19.8939 32.4395C19.652 32.2657 19.4838 32.0998 19.4681 32.0205C19.4647 32.0053 19.4376 31.993 19.3597 31.9707C19.1099 31.8992 18.9179 31.7886 18.7464 31.6172C18.5344 31.4052 18.4224 31.1551 18.4105 30.8652C18.4019 30.6563 18.4467 30.4654 18.5443 30.291C18.5654 30.2533 18.583 30.2201 18.5833 30.2168C18.5833 30.214 18.5516 30.2083 18.514 30.2041C18.2444 30.1742 17.9371 30.0609 17.7025 29.9053C17.4992 29.7704 17.2849 29.5264 17.2249 29.3623C17.2182 29.3438 17.2152 29.3268 17.2122 29.3037L17.2103 29.2998L17.2044 29.29L17.2054 29.1445L17.2064 29.0049V28.9326C17.2044 28.9199 17.2013 28.9072 17.1995 28.8945C17.1991 28.863 17.1826 28.82 17.2054 28.7939L17.2044 28.5137V28.5127L17.2142 28.4932C17.2249 28.4226 17.249 28.3769 17.3079 28.2861C17.4644 28.0451 17.7635 27.8194 18.0735 27.708C18.1275 27.6886 18.1728 27.6683 18.1741 27.6631C18.1749 27.6574 18.1435 27.6265 18.1038 27.5938C17.8391 27.3753 17.7136 27.2005 17.6351 26.9424C17.6075 26.8517 17.6048 26.8294 17.6048 26.6582C17.6048 26.4876 17.6072 26.464 17.6341 26.376C17.6933 26.1826 17.7752 26.0406 17.9095 25.8984C18.2612 25.5263 18.8454 25.3847 19.3548 25.5479C19.4119 25.5662 19.4844 25.5928 19.5159 25.6074C19.5471 25.622 19.5824 25.6344 19.595 25.6348C19.6073 25.6349 19.6688 25.6693 19.7318 25.7109C19.9053 25.8257 20.2783 26.0001 20.3997 26.0244L20.4212 26.0283C20.4244 25.69 20.4269 25.3514 20.429 25.0127L20.4261 22.7715C20.4234 20.9789 20.4187 19.4637 20.4163 19.4043L20.4124 19.2959L20.9007 19.3027C21.8636 19.3163 22.1834 19.3243 22.1888 19.333C22.1918 19.3591 22.2017 20.9122 22.2103 22.8027C22.2189 24.6931 22.2256 26.244 22.2259 26.2676C22.2268 26.2761 22.4138 26.26 22.5218 26.2422C22.675 26.2169 22.9804 26.2249 23.1409 26.2578C23.4545 26.3223 23.7626 26.4738 23.973 26.667C24.0154 26.706 24.0988 26.7663 24.1585 26.8008C24.6169 27.0653 25.0134 27.4403 25.2855 27.8672C25.3142 27.9123 25.3463 27.9555 25.3568 27.9629C25.3672 27.9704 25.379 27.9902 25.3831 28.0068C25.3878 28.0244 25.4254 28.1059 25.4661 28.1895C25.5071 28.2735 25.5581 28.3918 25.5804 28.4521C25.6287 28.5832 25.7185 28.7079 25.8587 28.8418C26.4239 28.9999 27.0639 29.2467 27.7786 29.5996C27.7906 29.5968 27.8026 29.5936 27.8148 29.5908C27.8518 29.5998 27.8887 29.6051 27.9193 29.6113C27.9382 29.5803 27.9597 29.5507 27.9788 29.5303C28.024 29.482 28.0619 29.4507 28.1165 29.4258C28.1572 29.3699 28.2098 29.3227 28.2747 29.2881C28.3062 29.2715 28.4007 29.2436 28.5091 29.2197C28.6622 29.1861 28.732 29.1639 28.9329 29.082C29.1443 28.996 29.2104 28.9624 29.4808 28.8037C29.649 28.705 29.794 28.6239 29.804 28.623C29.8126 28.623 29.833 28.6429 29.8489 28.667C29.8644 28.6904 29.8799 28.71 29.8841 28.7109C29.8878 28.7108 30.3866 28.3178 30.9915 27.8379L32.0911 26.9648L33.1673 26.1934L34.2103 25.4453L37.6722 22.4062L37.6976 22.3887L37.8382 22.2666L38.472 21.8545C38.8203 21.6278 39.1207 21.4371 39.14 21.4316C39.1593 21.4262 39.216 21.4005 39.2659 21.374C39.4982 21.2506 39.8609 21.1367 40.1058 21.1104C40.1386 21.1068 40.1733 21.0984 40.1907 21.0928C40.1617 21.0565 40.065 20.945 39.9505 20.8174L39.7005 20.5391L39.5804 20.2881L39.4603 20.0381L39.3734 19.4414C39.3121 19.0225 39.2709 18.6932 39.2357 18.3359C39.2277 18.2556 39.2176 18.1787 39.2103 18.1094C39.0975 17.9666 39.0014 17.8109 38.9232 17.6445C38.7556 17.5241 38.4465 17.2898 38.3919 17.2383C38.3723 17.2198 38.2865 17.0945 38.2015 16.96L38.0472 16.7158L38.0267 16.4561C38.0156 16.3135 38.0035 16.0332 37.9993 15.833L37.9915 15.4688L37.889 15.3711C37.8064 15.2923 37.788 15.2682 37.7884 15.2432C37.7895 15.1946 37.8153 15.0219 37.8226 15.0146C37.8273 15.0109 37.8928 14.9975 37.9691 14.9854L38.1087 14.9639L38.1829 14.999C38.2238 15.0188 38.2597 15.0329 38.262 15.0303C38.2632 15.0172 38.2282 14.6669 38.1839 14.2432C38.1184 13.6167 38.1065 13.4903 38.1136 13.4355C38.1048 13.4315 38.0946 13.4287 38.0853 13.4229L38.0423 13.3877C38.0192 13.3646 38.0058 13.342 38.0013 13.334C37.9956 13.324 37.9909 13.3148 37.9886 13.3096C37.9841 13.2993 37.9806 13.2894 37.9788 13.2842C37.9752 13.2734 37.9725 13.2619 37.97 13.2529C37.9648 13.234 37.9586 13.2095 37.9525 13.1836C37.94 13.1311 37.9245 13.0619 37.9095 12.9883C37.8989 12.9364 37.8823 12.8769 37.8685 12.8164H37.8655C37.8273 12.8076 37.7843 12.7923 37.7405 12.7725L37.6077 12.7041C37.3876 12.5837 37.2381 12.4847 37.0901 12.3545L36.9398 12.2119C36.6788 11.9468 36.5141 11.6684 36.4398 11.3447L36.4134 11.2031C36.4023 11.1258 36.3932 11.0555 36.3978 10.9795C36.4023 10.905 36.4187 10.8348 36.4388 10.7559L36.5081 10.5342C36.5861 10.3274 36.6948 10.1596 36.8597 9.98633L37.1185 9.73535C37.758 9.16184 38.6409 8.67275 39.6351 8.33398L39.8577 8.26367C40.0961 8.19298 40.3757 8.12227 40.64 8.06445C40.9873 7.98847 41.3335 7.92812 41.5325 7.9209L41.5853 7.91602C41.5873 7.91501 41.5892 7.91351 41.5901 7.91309C41.6085 7.90519 41.6251 7.90144 41.6331 7.89941C41.65 7.89521 41.6658 7.89283 41.6751 7.8916C41.6956 7.88891 41.7197 7.88623 41.7435 7.88477C41.7931 7.88174 41.8633 7.87982 41.9485 7.87793C42.1203 7.87412 42.369 7.87207 42.6829 7.87207ZM44.7962 56.3467C44.7971 56.3492 44.8032 56.3525 44.8128 56.3574C44.8043 56.3472 44.7984 56.3352 44.7923 56.3223C44.7942 56.3364 44.7957 56.3448 44.7962 56.3467ZM47.0784 56.2158C47.0904 56.2091 47.1 56.2059 47.1038 56.2031C47.1076 56.2003 47.109 56.192 47.1136 56.1738C47.1028 56.1886 47.0918 56.2029 47.0784 56.2158ZM34.5921 55.3193C34.6023 55.3404 34.6111 55.3528 34.6194 55.3564C34.6213 55.3573 34.6239 55.3566 34.6263 55.3574C34.6132 55.3473 34.6029 55.3338 34.5921 55.3193ZM35.6741 55.25C35.65 55.2713 35.6243 55.2889 35.596 55.3037C35.6051 55.3014 35.614 55.301 35.6214 55.2988C35.6468 55.2913 35.6564 55.2806 35.6741 55.25ZM22.3948 50.4971C22.4082 50.5539 22.4075 50.6409 22.3939 50.6904C22.3803 50.7399 22.3692 50.6933 22.3694 50.5869C22.3697 50.4809 22.3815 50.4404 22.3948 50.4971ZM22.3626 46.4854C22.3639 46.4782 22.3633 46.4749 22.3646 46.4756C22.3831 46.4856 22.3947 46.695 22.4036 46.957C22.4244 47.4126 22.43 48.0234 22.3939 48.0234C22.3918 48.0234 22.391 48.0211 22.389 48.0195C22.3879 48.0211 22.3891 48.0234 22.388 48.0234C22.3817 48.0234 22.3768 48.0089 22.3714 47.9824C22.3468 47.8882 22.3323 47.6334 22.3323 47.2451C22.3323 46.8196 22.3423 46.4727 22.3548 46.4707C22.3579 46.4713 22.3597 46.4766 22.3626 46.4854ZM22.3353 43.7236C22.3387 43.7243 22.3425 43.7542 22.348 43.8066C22.3509 43.7577 22.3548 43.732 22.3577 43.7344C22.3795 43.7555 22.393 44.1393 22.3987 44.5518C22.4005 44.586 22.4029 44.6211 22.4046 44.6562C22.4366 45.3166 22.4296 45.5814 22.3812 45.583C22.3789 45.583 22.3775 45.5803 22.3753 45.5791C22.3743 45.581 22.3754 45.583 22.3743 45.583C22.3721 45.5828 22.3716 45.5795 22.3694 45.5742C22.3304 45.5264 22.3118 45.2492 22.3118 44.6514C22.3118 44.1434 22.3225 43.7286 22.3353 43.7236ZM22.3226 41.1855C22.3257 41.1505 22.3291 41.1313 22.3333 41.1309C22.3427 41.1325 22.3571 41.4815 22.3714 41.9072C22.4055 42.4133 22.4151 42.8708 22.4026 43.127C22.4049 43.3095 22.4051 43.4277 22.3997 43.4277C22.3949 43.4277 22.3769 43.3892 22.3577 43.3379C22.3536 43.3335 22.3496 43.325 22.345 43.3135C22.3255 43.2635 22.3114 42.9592 22.3079 42.5703V42.1133C22.3062 41.7822 22.3089 41.4648 22.3167 41.2842L22.3187 41.124L22.3226 41.1855ZM22.3109 38.584C22.3141 38.5463 22.3182 38.5258 22.3226 38.5264C22.3314 38.5279 22.345 38.8502 22.3587 39.2529L22.3597 39.2695C22.3947 39.7749 22.4034 40.2376 22.3919 40.5049C22.3945 40.6975 22.3935 40.8232 22.388 40.8232C22.3828 40.8213 22.3674 40.786 22.3489 40.7402C22.3446 40.737 22.3391 40.7309 22.3343 40.7197C22.3149 40.6746 22.3008 40.3708 22.2972 39.9795V39.5166C22.2955 39.2024 22.2983 38.9001 22.305 38.7139L22.3069 38.5195L22.3109 38.584ZM50.7376 38.8262C50.7195 38.8498 50.7006 38.8796 50.6878 38.9053C50.6552 38.9707 50.6507 38.99 50.6507 39.0674C50.6507 39.1445 50.655 39.1636 50.6878 39.2295C50.7733 39.401 50.9773 39.4954 51.1722 39.4541C51.2172 39.4445 51.3065 39.4046 51.3411 39.3828C51.2809 39.3933 51.215 39.4005 51.1751 39.3945C51.1079 39.3844 51.0041 39.344 50.9417 39.3037C50.8317 39.2325 50.7559 39.1162 50.7308 38.9805C50.7218 38.932 50.7257 38.879 50.7376 38.8262ZM52.2825 37.9189L52.2737 37.9629L52.3528 37.998C52.7287 38.164 53.0022 38.5393 53.0638 38.9727C53.08 39.0869 53.071 39.3224 53.0462 39.4277C53.044 39.437 53.0416 39.4471 53.0394 39.457C53.0656 39.3966 53.0889 39.3371 53.1028 39.2852C53.1281 39.1909 53.1316 39.1552 53.1321 39.002C53.1327 38.8562 53.129 38.8108 53.1087 38.7305C53.0437 38.4728 52.9011 38.237 52.723 38.0918C52.6343 38.0196 52.4176 37.9093 52.3021 37.8779C52.2961 37.8763 52.2901 37.8754 52.2845 37.874C52.2832 37.8937 52.2843 37.9099 52.2825 37.9189ZM50.2669 39.4219C50.2702 39.4203 50.2733 39.4184 50.2767 39.417C50.2849 39.4262 50.292 39.4366 50.3001 39.4463L50.2806 39.4082L50.2669 39.4219ZM50.2318 39.334L50.2523 39.3066L50.2493 39.2891C50.2444 39.3044 50.238 39.3191 50.2318 39.334ZM50.9642 38.6924C50.9492 38.6871 50.8917 38.7123 50.8392 38.7432C50.837 38.7473 50.8344 38.7516 50.8323 38.7559C50.8069 38.8079 50.803 38.8303 50.803 38.915C50.8031 38.9997 50.8068 39.022 50.8323 39.0742C50.8763 39.1638 50.9293 39.2181 51.014 39.2627C51.1137 39.3151 51.1558 39.3247 51.2698 39.3203C51.291 39.3195 51.3083 39.316 51.3235 39.3145C51.2343 39.1495 50.9755 38.6967 50.9642 38.6924ZM22.3118 36.4033C22.3188 36.4064 22.3278 36.5441 22.3382 36.7422C22.341 36.764 22.3448 36.7874 22.348 36.8125C22.3852 37.1079 22.3934 37.5632 22.3802 37.8545C22.3849 38.0676 22.3854 38.2173 22.3782 38.2188C22.3725 38.2188 22.3521 38.1782 22.3314 38.126C22.3293 38.1231 22.3257 38.1202 22.3235 38.1152C22.2983 38.0566 22.2823 37.6639 22.2864 37.2344C22.2825 36.8127 22.2895 36.3995 22.3118 36.4033ZM52.1702 37.875C52.1613 37.891 52.149 37.9021 52.1331 37.9111C52.1467 37.912 52.1555 37.9149 52.1575 37.9131C52.1624 37.9085 52.1661 37.8942 52.1702 37.875ZM51.7308 37.0566L51.7972 37.0879C52.0266 37.1963 52.1858 37.3574 52.262 37.5596C52.2853 37.6214 52.2906 37.653 52.2913 37.7539C52.2914 37.7594 52.2904 37.7649 52.2903 37.7705C52.3375 37.7731 52.3381 37.7656 52.348 37.7275C52.382 37.5965 52.3466 37.4369 52.2523 37.2959C52.1893 37.2018 52.1221 37.1424 52.0042 37.0752C51.9169 37.0255 51.8229 36.9882 51.7259 36.9639L51.7308 37.0566ZM50.6976 36.1465C50.6288 36.1592 50.5445 36.1839 50.4935 36.2021C50.5578 36.193 50.6303 36.1901 50.7269 36.1904C50.9048 36.191 50.9347 36.1933 51.0335 36.2197C51.2281 36.2718 51.4021 36.3701 51.5247 36.4961C51.6322 36.6066 51.6906 36.7224 51.7132 36.8594C51.7493 36.8652 51.7791 36.8693 51.7845 36.8662C51.8014 36.8557 51.7879 36.723 51.762 36.6504C51.7493 36.6147 51.7221 36.5585 51.7025 36.5254C51.5379 36.2479 51.0819 36.0756 50.6976 36.1465ZM50.303 36.3789C50.3016 36.3826 50.3097 36.3967 50.3226 36.416C50.3186 36.4065 50.3133 36.3974 50.3099 36.3877C50.3142 36.3815 50.3196 36.3764 50.3245 36.3711C50.314 36.375 50.3056 36.3764 50.303 36.3789ZM49.9144 36.041C49.9162 36.0458 49.9434 36.0704 49.9759 36.0947C50.0083 36.119 50.0731 36.1728 50.1194 36.2148L50.2044 36.292L50.2698 36.2646C50.2794 36.2608 50.289 36.2574 50.2982 36.2539C50.2904 36.2454 50.2835 36.2359 50.2757 36.2275C50.2044 36.152 50.0571 36.0297 49.9984 35.9971C49.9905 35.9927 49.9746 35.9809 49.9544 35.9668C49.9305 36.0106 49.9153 36.037 49.9144 36.041ZM49.8255 35.8926C49.8048 35.9147 49.783 35.9314 49.7571 35.9365L49.7903 35.9541L49.8206 35.9023C49.8217 35.9004 49.8232 35.8966 49.8255 35.8926ZM47.639 35.5625C47.6445 35.5628 47.6501 35.5628 47.6556 35.5635L47.6497 35.5586L47.639 35.5625ZM22.3275 34.4688C22.3375 34.5997 22.3375 34.8136 22.3275 34.9443C22.3174 35.0752 22.3089 34.9678 22.3089 34.7061C22.3089 34.4444 22.3174 34.3379 22.3275 34.4688ZM50.4163 34.7383C50.4294 34.7423 50.4396 34.7493 50.4466 34.7617C50.4476 34.7422 50.4392 34.7371 50.4163 34.7383ZM48.4007 28.7891L48.5003 29.46L48.471 29.4834C48.4586 29.4933 48.4031 29.5304 48.3353 29.5762C48.3376 29.5975 48.3416 29.6098 48.3411 29.6123C48.3378 29.6257 48.2556 29.6883 48.1292 29.7734L48.0618 29.8184C48.0515 29.8578 48.0364 29.9132 48.0218 29.9727L47.9739 30.168V30.876C47.9738 31.3072 47.9655 31.8776 47.9525 32.3379C47.9335 33.0056 47.9323 33.1069 47.9456 33.3652C47.9827 33.2261 48.0144 33.1188 48.0218 33.1074C48.0374 33.0831 48.0371 33.0538 48.011 32.7627L47.9827 32.4443L48.1849 32.0518C48.2965 31.8357 48.6475 31.1576 48.9642 30.5449C49.2808 29.9323 49.5394 29.422 49.5394 29.4111C49.5393 29.3669 49.3604 29.1077 49.2191 28.9473C49.0249 28.7269 48.6987 28.5089 48.3978 28.3975C48.377 28.3898 48.3582 28.38 48.3411 28.3721C48.3562 28.4822 48.3761 28.6237 48.4007 28.7891ZM24.3548 32.2168H24.4827C24.4542 32.2116 24.4265 32.2052 24.4007 32.1934C24.404 32.1861 24.4102 32.1806 24.4144 32.1738L24.3548 32.2168ZM22.1556 30.6318C22.1405 30.6123 22.1344 30.6148 22.0276 30.6943C21.9658 30.7405 21.8536 30.817 21.7786 30.8643C21.7036 30.9115 21.6406 30.9548 21.639 30.96C21.6355 30.9727 22.0413 31.2371 22.0648 31.2373C22.0751 31.2369 22.103 31.2141 22.1273 31.1865C22.2188 31.0825 22.2614 30.9466 22.2396 30.8291C22.2276 30.7653 22.1891 30.6754 22.1556 30.6318ZM21.4124 31.0615C21.4163 31.0631 21.4188 31.0657 21.4212 31.0684C21.4247 31.0621 21.428 31.0584 21.428 31.0576C21.4276 31.0571 21.4219 31.0589 21.4124 31.0615ZM20.5071 29.377C20.493 29.3782 20.4286 29.4808 20.4007 29.5469C20.311 29.7591 20.3321 29.9586 20.4671 30.1729C20.566 30.3297 20.7865 30.4635 21.013 30.5039C21.1033 30.5199 21.2891 30.5091 21.3841 30.4824C21.5548 30.4344 21.7167 30.3352 21.8021 30.2266C21.863 30.1488 21.8941 30.0902 21.8812 30.0781C21.8589 30.0607 20.519 29.377 20.5071 29.377ZM27.4632 29.6777C27.4697 29.6809 27.4762 29.6843 27.4827 29.6875C27.5568 29.7076 27.6322 29.727 27.7083 29.7441C27.8392 29.7736 27.8626 29.773 27.8626 29.7412C27.8627 29.7244 27.8753 29.692 27.8939 29.6562C27.8554 29.6368 27.8167 29.6184 27.7786 29.5996C27.6681 29.6252 27.5629 29.651 27.4632 29.6777ZM19.7327 28.8594C19.6964 28.8815 19.613 29.0407 19.5745 29.1611C19.5406 29.2675 19.5023 29.4447 19.5023 29.4951C19.5021 29.5066 19.4945 29.5125 19.5462 29.4902C19.5479 29.4559 19.5512 29.4339 19.556 29.4248C19.5599 29.3509 19.5704 29.3315 19.5843 29.3848C19.5909 29.4102 19.5922 29.4399 19.5931 29.4688C19.6275 29.4532 19.6759 29.4329 19.7405 29.4033L19.9515 29.3076L19.9739 29.2305C19.9865 29.188 20.0134 29.1169 20.0335 29.0732L20.0696 28.9941L20.0403 28.9795C20.0242 28.9713 19.952 28.9379 19.8802 28.9062C19.7859 28.8647 19.7454 28.8521 19.7327 28.8594ZM19.8675 29.4873C19.8708 29.4893 19.8723 29.4929 19.8743 29.4961C19.8744 29.4899 19.8744 29.4863 19.8714 29.4863C19.8704 29.4863 19.8691 29.487 19.8675 29.4873ZM22.722 29.3467C22.7241 29.3454 22.7266 29.3448 22.7288 29.3438C22.7301 29.3419 22.7324 29.3407 22.7337 29.3389C22.7302 29.3357 22.7292 29.332 22.7278 29.333C22.7275 29.3335 22.7251 29.3384 22.722 29.3467ZM20.0706 28.4805C20.0706 28.494 20.13 28.5207 20.2191 28.5469C20.3434 28.5834 20.3316 28.59 20.4974 28.3789C20.5785 28.2755 20.7523 28.0607 20.8831 27.9014C21.014 27.742 21.1214 27.604 21.1214 27.5957C21.1208 27.5693 21.0605 27.49 20.9886 27.4229C20.9197 27.3584 20.7887 27.279 20.7786 27.2949C20.3889 27.9393 20.0737 28.467 20.0706 28.4805ZM21.3343 27.3965L21.3411 27.3906L21.3372 27.3857C21.3367 27.3895 21.3354 27.3928 21.3343 27.3965ZM20.9671 26.8643L20.9632 26.8594L20.9583 26.8555C20.9611 26.8585 20.9643 26.8612 20.9671 26.8643ZM22.2376 26.6719L22.2562 26.6621C22.2485 26.6594 22.2426 26.6555 22.2376 26.6484V26.6719ZM22.2376 26.3916V26.4229C22.24 26.4107 22.2415 26.3996 22.2435 26.3906L22.2376 26.3916ZM20.2249 26.1006C20.239 26.1176 20.2978 26.1742 20.3519 26.2285C20.3978 26.2619 20.4327 26.2873 20.4407 26.29C20.4363 26.285 20.4314 26.2805 20.4271 26.2754L20.4202 26.2588C20.4205 26.2292 20.4199 26.1995 20.4202 26.1699L20.3343 26.1328C20.2638 26.1023 20.2144 26.0879 20.2249 26.1006ZM22.2894 23.7305L22.2991 23.8936C22.3365 24.5115 22.3352 24.8874 22.2962 24.9336C22.2549 24.9817 22.236 24.6723 22.2376 23.9658L22.2405 22.9268L22.2484 23.0693L22.2493 22.9268L22.2894 23.7305ZM43.555 23.1719L43.5706 23.1729L43.5775 23.1699C43.57 23.1707 43.5625 23.1711 43.555 23.1719ZM42.6507 23.1074L42.6653 23.1094C42.6542 23.1053 42.6432 23.101 42.6321 23.0967L42.6507 23.1074ZM42.1575 22.8281L42.1819 22.8418C42.1677 22.831 42.153 22.8208 42.139 22.8096L42.1575 22.8281ZM22.2357 20.3965C22.2391 20.3523 22.2436 20.3283 22.2484 20.3291C22.2578 20.3401 22.2719 20.6927 22.2855 21.1191C22.3174 21.6001 22.3261 22.0439 22.3148 22.3125C22.3171 22.5064 22.3163 22.6341 22.3109 22.6367C22.3066 22.6367 22.2899 22.6106 22.2708 22.5771C22.2668 22.5764 22.2625 22.5726 22.2581 22.5654C22.2387 22.5338 22.2246 22.2322 22.221 21.832V21.3643C22.2195 21.0469 22.2222 20.7385 22.2288 20.542L22.2308 20.3223L22.2357 20.3965ZM46.1234 20.7627C46.1561 20.723 46.1734 20.7013 46.1888 20.6777C46.1904 20.6752 46.192 20.6712 46.1946 20.667C46.1709 20.6989 46.1476 20.7312 46.1234 20.7627ZM39.8294 20.4805L39.8714 20.5273C39.8509 20.498 39.8291 20.4697 39.8099 20.4395L39.8294 20.4805ZM43.1331 20.5098C43.1465 20.5086 43.1592 20.5101 43.1702 20.5088C43.1836 20.5072 43.1969 20.5037 43.2103 20.502C43.1846 20.5049 43.1589 20.5075 43.1331 20.5098ZM44.3382 20.0293C44.2813 20.084 44.2202 20.1325 44.1566 20.1768C44.2264 20.1306 44.2875 20.082 44.3372 20.0303L44.3382 20.0293ZM41.5384 20.0215C41.5179 20.0217 41.5337 20.0533 41.5638 20.0898C41.5784 20.0628 41.6038 20.0511 41.6341 20.0439C41.6325 20.0435 41.6308 20.0434 41.6292 20.043C41.5845 20.0311 41.5433 20.0215 41.5384 20.0215ZM42.1224 20.0195C42.2416 20.0204 42.3608 20.0251 42.4798 20.0322C42.3658 20.0177 42.2416 20.0144 42.1224 20.0195ZM44.4232 19.8643C44.4336 19.8679 44.4391 19.8741 44.4417 19.8838C44.4469 19.8711 44.4493 19.8621 44.4456 19.8584C44.4436 19.8573 44.4358 19.8612 44.4232 19.8643ZM43.5872 18.9033C43.5924 18.9132 43.5984 18.9211 43.6058 18.9268C43.6002 18.9204 43.5941 18.9127 43.5872 18.9033ZM43.7249 18.8838C43.7248 18.8856 43.7253 18.8871 43.7249 18.8887C43.7265 18.8864 43.7313 18.8862 43.7327 18.8838L43.7318 18.8828C43.7298 18.8837 43.7271 18.8829 43.7249 18.8838ZM43.303 18.8066C43.3855 18.8114 43.48 18.8176 43.554 18.8672C43.5412 18.8541 43.528 18.8432 43.513 18.834C43.4621 18.8089 43.394 18.8005 43.303 18.8066ZM47.0726 16.8311C47.0688 16.9215 47.0629 17.0117 47.0599 17.0312C47.056 17.0565 47.059 17.0664 47.0696 17.0664C47.0815 17.0663 47.0832 17.0421 47.0794 16.9434L47.0745 16.8193L47.0901 16.8047C47.0842 16.8039 47.0791 16.8022 47.0735 16.7988L47.0726 16.8311ZM38.4329 17.0576C38.4339 17.0484 38.4362 17.0406 38.4417 17.0342C38.4246 17.0232 38.4089 17.0106 38.3939 16.9971C38.4083 17.0195 38.4214 17.04 38.4329 17.0576ZM38.4984 17.0352L38.5013 17.0381C38.5011 17.0365 38.5003 17.0349 38.5003 17.0332L38.4984 17.0352ZM47.4427 16.8867C47.4488 16.8847 47.4544 16.8821 47.4603 16.8809C47.4551 16.8782 47.4509 16.8743 47.4456 16.8721C47.4459 16.8772 47.4443 16.8817 47.4427 16.8867ZM38.18 16.6602L38.1878 16.6738C38.1827 16.6522 38.1803 16.6301 38.1761 16.6084L38.18 16.6602ZM38.7298 16.1328L38.7376 16.1201L38.7347 16.1162C38.7334 16.1218 38.7313 16.1272 38.7298 16.1328ZM38.4339 15.7773C38.429 15.7757 38.426 15.7973 38.4241 15.8447C38.4297 15.8308 38.4376 15.8178 38.4476 15.8057C38.456 15.8096 38.464 15.8146 38.472 15.8193C38.4499 15.7954 38.437 15.7786 38.4339 15.7773ZM47.303 15.6562C47.3189 15.6485 47.3286 15.657 47.3382 15.6709C47.3331 15.6414 47.3326 15.6216 47.3304 15.6191C47.3288 15.6176 47.3199 15.6328 47.303 15.6562ZM38.4319 15.2852L38.4173 15.2686L38.387 15.2529C38.402 15.2636 38.4175 15.2736 38.4319 15.2852ZM47.2542 15.0986C47.2398 15.114 47.2259 15.1334 47.2073 15.1582C47.2198 15.1523 47.2376 15.1433 47.2601 15.127C47.267 15.1191 47.2725 15.1101 47.2796 15.1025C47.2712 15.1015 47.2628 15.0997 47.2542 15.0986ZM39.3187 14.8994L39.3206 14.9414C39.3224 14.9172 39.324 14.8931 39.3265 14.8691L39.3187 14.8994Z"
          fill="currentColor"
        />
      </g>
      <defs>
        <clipPath id="clip0_2127_60">
          <rect width="72" height="72" fill="currentColor" />
        </clipPath>
      </defs>
    </svg>
  )
}
