Feature: sync a feature branch that is already compressed using the "compress" sync strategy

  Background:
    Given a Git repo with origin
    And Git setting "git-town.sync-feature-strategy" is "compress"
    And the branches
      | NAME  | TYPE    | PARENT | LOCATIONS     |
      | alpha | feature | main   | local, origin |
    And the commits
      | BRANCH | LOCATION      | MESSAGE        |
      | alpha  | local, origin | alpha commit 1 |
    And the branches
      | NAME | TYPE    | PARENT | LOCATIONS     |
      | beta | feature | alpha  | local, origin |
    And the commits
      | BRANCH | LOCATION      | MESSAGE       |
      | beta   | local, origin | beta commit 1 |
    And wait 1 second to ensure new Git timestamps
    And the current branch is "beta"
    When I run "git-town sync --detached"

  Scenario: result
    Then Git Town runs the commands
      | BRANCH | COMMAND                  |
      | beta   | git fetch --prune --tags |
      |        | git checkout alpha       |
      | alpha  | git checkout beta        |
    And these commits exist now
      | BRANCH | LOCATION      | MESSAGE        |
      | alpha  | local, origin | alpha commit 1 |
      | beta   | local, origin | beta commit 1  |

  Scenario: undo
    When I run "git-town undo"
    Then Git Town runs no commands
    And the initial commits exist now
    And the initial branches and lineage exist now
