Feature: display all executed Git commands

  Background:
    Given a Git repo with origin
    And the commits
      | BRANCH | LOCATION | MESSAGE     |
      | main   | origin   | main commit |
    And the current branch is "main"
    When I run "git-town hack new --verbose"

  Scenario: result
    Then Git Town runs the commands
      | BRANCH | TYPE     | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |        | backend  | git version                                                                                                                                                                                                                                                                                                                                      |
      |        | backend  | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |        | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |        | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |        | backend  | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |        | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |        | backend  | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
      |        | backend  | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |        | backend  | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |        | backend  | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |        | backend  | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |        | backend  | git remote                                                                                                                                                                                                                                                                                                                                       |
      | main   | frontend | git fetch --prune --tags                                                                                                                                                                                                                                                                                                                         |
      |        | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |        | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |        | frontend | git -c rebase.updateRefs=false rebase origin/main                                                                                                                                                                                                                                                                                                |
      |        | backend  | git rev-parse --verify -q refs/heads/main                                                                                                                                                                                                                                                                                                        |
      |        | backend  | git rev-parse main origin/main                                                                                                                                                                                                                                                                                                                   |
      |        | backend  | git rev-parse --verify -q refs/heads/main                                                                                                                                                                                                                                                                                                        |
      |        | frontend | git checkout -b new                                                                                                                                                                                                                                                                                                                              |
      |        | backend  | git rev-parse --verify -q refs/heads/main                                                                                                                                                                                                                                                                                                        |
      |        | backend  | git config git-town-branch.new.parent main                                                                                                                                                                                                                                                                                                       |
      |        | backend  | git rev-parse --verify -q refs/heads/main                                                                                                                                                                                                                                                                                                        |
      |        | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |        | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |        | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |        | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
    And Git Town prints:
      """
      Ran 27 shell commands.
      """

  Scenario: undo
    When I run "git-town undo --verbose"
    Then Git Town runs the commands
      | BRANCH | TYPE     | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |        | backend  | git version                                                                                                                                                                                                                                                                                                                                      |
      |        | backend  | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |        | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |        | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |        | backend  | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |        | backend  | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |        | backend  | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |        | backend  | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |        | backend  | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |        | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |        | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |        | backend  | git remote                                                                                                                                                                                                                                                                                                                                       |
      |        | backend  | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
      | new    | frontend | git checkout main                                                                                                                                                                                                                                                                                                                                |
      |        | backend  | git rev-parse HEAD                                                                                                                                                                                                                                                                                                                               |
      | main   | frontend | git reset --hard {{ sha 'initial commit' }}                                                                                                                                                                                                                                                                                                      |
      |        | frontend | git branch -D new                                                                                                                                                                                                                                                                                                                                |
      |        | backend  | git config --unset git-town-branch.new.parent                                                                                                                                                                                                                                                                                                    |
    And Git Town prints:
      """
      Ran 18 shell commands.
      """
