Feature: display all executed Git commands

  Background:
    Given a Git repo with origin
    And the branches
      | NAME     | TYPE    | PARENT | LOCATIONS     |
      | existing | feature | main   | local, origin |
    And the commits
      | BRANCH   | LOCATION      | MESSAGE         |
      | existing | local, origin | existing commit |
    And the current branch is "existing"
    When I run "git-town append new --verbose"

  Scenario: result
    Then Git Town runs the commands
      | BRANCH   | TYPE     | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |          | backend  | git version                                                                                                                                                                                                                                                                                                                                      |
      |          | backend  | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |          | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |          | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |          | backend  | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |          | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |          | backend  | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |          | backend  | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |          | backend  | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |          | backend  | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |          | backend  | git remote                                                                                                                                                                                                                                                                                                                                       |
      | existing | frontend | git fetch --prune --tags                                                                                                                                                                                                                                                                                                                         |
      |          | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |          | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |          | backend  | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
      |          | backend  | git log main..existing --format=%s --reverse                                                                                                                                                                                                                                                                                                     |
      |          | backend  | git log --no-merges --format=%H refs/heads/main ^refs/heads/existing                                                                                                                                                                                                                                                                             |
      |          | backend  | git rev-parse existing origin/existing                                                                                                                                                                                                                                                                                                           |
      |          | backend  | git rev-parse --verify -q refs/heads/existing                                                                                                                                                                                                                                                                                                    |
      |          | backend  | git rev-parse existing origin/existing                                                                                                                                                                                                                                                                                                           |
      |          | backend  | git rev-parse --verify -q refs/heads/existing                                                                                                                                                                                                                                                                                                    |
      |          | frontend | git checkout -b new                                                                                                                                                                                                                                                                                                                              |
      |          | backend  | git rev-parse --verify -q refs/heads/existing                                                                                                                                                                                                                                                                                                    |
      |          | backend  | git config git-town-branch.new.parent existing                                                                                                                                                                                                                                                                                                   |
      |          | backend  | git rev-parse --verify -q refs/heads/existing                                                                                                                                                                                                                                                                                                    |
      |          | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |          | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |          | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |          | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
    And Git Town prints:
      """
      Ran 29 shell commands.
      """

  Scenario: undo
    When I run "git-town undo --verbose"
    Then Git Town runs the commands
      | BRANCH   | TYPE     | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |          | backend  | git version                                                                                                                                                                                                                                                                                                                                      |
      |          | backend  | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |          | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |          | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |          | backend  | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |          | backend  | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |          | backend  | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |          | backend  | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |          | backend  | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |          | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |          | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |          | backend  | git remote                                                                                                                                                                                                                                                                                                                                       |
      |          | backend  | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
      | new      | frontend | git checkout existing                                                                                                                                                                                                                                                                                                                            |
      | existing | frontend | git branch -D new                                                                                                                                                                                                                                                                                                                                |
      |          | backend  | git config --unset git-town-branch.new.parent                                                                                                                                                                                                                                                                                                    |
    And Git Town prints:
      """
      Ran 16 shell commands.
      """
    And the initial commits exist now
    And the initial branches and lineage exist now
