Feature: sync the current feature branch with a tracking branch in detached mode with updates on main

  Background:
    Given a Git repo with origin
    And the branches
      | NAME  | TYPE    | PARENT | LOCATIONS     |
      | alpha | feature | main   | local, origin |
      | beta  | feature | alpha  | local, origin |
    And the commits
      | BRANCH | LOCATION      | MESSAGE      |
      | main   | local, origin | main commit  |
      | alpha  | local, origin | alpha commit |
    And the current branch is "beta"
    And the committed configuration file:
      """
      [sync]
      detached = true
      """
    When I run "git-town sync"

  Scenario: result
    Then Git Town runs the commands
      | BRANCH | COMMAND                        |
      | beta   | git fetch --prune --tags       |
      |        | git checkout alpha             |
      | alpha  | git checkout beta              |
      | beta   | git merge --no-edit --ff alpha |
      |        | git push                       |
    And these commits exist now
      | BRANCH | LOCATION      | MESSAGE                        |
      | main   | local, origin | main commit                    |
      | alpha  | local, origin | alpha commit                   |
      | beta   | local, origin | Merge branch 'alpha' into beta |

  Scenario: undo
    When I run "git-town undo"
    Then Git Town runs the commands
      | BRANCH | COMMAND                                                    |
      | beta   | git reset --hard {{ sha-initial 'persisted config file' }} |
      |        | git push --force-with-lease --force-if-includes            |
    And the initial commits exist now
    And the initial branches and lineage exist now
