'use strict';

var _keys = require('babel-runtime/core-js/object/keys');

var _keys2 = _interopRequireDefault(_keys);

var _stringify = require('babel-runtime/core-js/json/stringify');

var _stringify2 = _interopRequireDefault(_stringify);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

module.exports = {
  data: function data() {
    return {
      chartData: null
    };
  },

  watch: {
    'chartData': {
      handler: function handler(newData, oldData) {
        if (oldData) {
          var chart = this._chart;

          var newDatasetLabels = newData.datasets.map(function (dataset) {
            return dataset.label;
          });

          var oldDatasetLabels = oldData.datasets.map(function (dataset) {
            return dataset.label;
          });

          var oldLabels = (0, _stringify2.default)(oldDatasetLabels);
          var newLabels = (0, _stringify2.default)(newDatasetLabels);

          if (newLabels === oldLabels && oldData.datasets.length === newData.datasets.length) {
            newData.datasets.forEach(function (dataset, i) {
              var oldDatasetKeys = (0, _keys2.default)(oldData.datasets[i]);
              var newDatasetKeys = (0, _keys2.default)(dataset);

              var deletionKeys = oldDatasetKeys.filter(function (key) {
                return key !== '_meta' && newDatasetKeys.indexOf(key) === -1;
              });

              deletionKeys.forEach(function (deletionKey) {
                delete chart.data.datasets[i][deletionKey];
              });

              for (var attribute in dataset) {
                if (dataset.hasOwnProperty(attribute)) {
                  chart.data.datasets[i][attribute] = dataset[attribute];
                }
              }
            });

            if (newData.hasOwnProperty('labels')) {
              chart.data.labels = newData.labels;
            }
            if (newData.hasOwnProperty('xLabels')) {
              chart.data.xLabels = newData.xLabels;
            }
            if (newData.hasOwnProperty('yLabels')) {
              chart.data.yLabels = newData.yLabels;
            }
            chart.update();
          } else {
            chart.destroy();
            this.renderChart(this.chartData, this.options);
          }
        } else {
          this.renderChart(this.chartData, this.options);
        }
      }
    }
  }
};