var asp = require('bluebird').promisify;
var fs = require('graceful-fs');
var path = require('path');
var which = require('which');
var auth = require('./auth');

var isWindows = process.platform.match(/^win/);

function getFilepaths() {
  var home = isWindows ? process.env.USERPROFILE : process.env.HOME;
  var proj = process.env.jspmConfigPath ? path.dirname(process.env.jspmConfigPath) : process.cwd();
  var paths = [path.resolve(proj, '.npmrc'), path.resolve(home, '.npmrc')];

  return paths;
}

function getOptionExact(contents, key) {
  var regex = new RegExp('^' + key + ' ?= ?(.+)', 'm');
  var result;
  for (var i = 0; i <= contents.length; i++) {
    var content = contents[i];
    result = content && content.match(regex);
    if (result)
      return result[1];
  }
}

function getOption(contents, key, registry) {
  if (registry) {
    var prefix = registry.replace(/^.+:/, '') + '/:';
    return getOptionExact(contents, prefix + key) || getOptionExact(contents, key);
  }
  else
    return getOptionExact(contents, key);
}

function safeRead(filepath) {
  if (fs.existsSync(filepath))
    return fs.readFileSync(filepath).toString();
}

function Npmrc() {}

Npmrc.prototype.init = function() {
  this.contents = getFilepaths().map(safeRead);
  this.initialized = true;
};

Npmrc.prototype.getAuth = function(registry) {
  if (!registry)
    registry = this.getRegistry();

  if (!this.initialized)
    this.init();

  var _authToken = getOption(this.contents, '_authToken', registry);
  if (_authToken)
    return { token: _authToken };

  var _auth = getOption(this.contents, '_auth', registry);
  if (_auth)
    return auth.decodeCredentials(_auth);

  var username = getOption(this.contents, 'username', registry);
  var password = getOption(this.contents, '_password', registry);

  if (password)
    password = new Buffer(password, 'base64').toString();

  if (username && password)
    return {
      username: username,
      password: password
    };
};

Npmrc.prototype.getCa = function(registry) {
  if (!registry)
    registry = this.getRegistry();

  if (!this.initialized)
    this.init();

  var cafile = getOption(this.contents, 'cafile', registry);
  if (cafile)
    return fs.readFileSync(cafile);
};

Npmrc.prototype.getRegistry = function(scope) {
  if (!this.initialized)
    this.init();

  var registryKey = 'registry';
  if (scope)
    registryKey = scope + ':' + registryKey;

  var registry = getOption(this.contents, registryKey);
  if (registry && registry.substr(registry.length - 1, 1) == '/')
    registry = registry.substr(0, registry.length - 1);

  return registry;
};

module.exports = Npmrc;
