// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/privacy/dlp/v2beta1/storage.proto

package dlp

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import _ "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Type of information detected by the API.
type InfoType struct {
	// Name of the information type.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *InfoType) Reset()                    { *m = InfoType{} }
func (m *InfoType) String() string            { return proto.CompactTextString(m) }
func (*InfoType) ProtoMessage()               {}
func (*InfoType) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *InfoType) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// General identifier of a data field in a storage service.
type FieldId struct {
	// Name describing the field.
	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName" json:"column_name,omitempty"`
}

func (m *FieldId) Reset()                    { *m = FieldId{} }
func (m *FieldId) String() string            { return proto.CompactTextString(m) }
func (*FieldId) ProtoMessage()               {}
func (*FieldId) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *FieldId) GetColumnName() string {
	if m != nil {
		return m.ColumnName
	}
	return ""
}

// Datastore partition ID.
// A partition ID identifies a grouping of entities. The grouping is always
// by project and namespace, however the namespace ID may be empty.
//
// A partition ID contains several dimensions:
// project ID and namespace ID.
type PartitionId struct {
	// The ID of the project to which the entities belong.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// If not empty, the ID of the namespace to which the entities belong.
	NamespaceId string `protobuf:"bytes,4,opt,name=namespace_id,json=namespaceId" json:"namespace_id,omitempty"`
}

func (m *PartitionId) Reset()                    { *m = PartitionId{} }
func (m *PartitionId) String() string            { return proto.CompactTextString(m) }
func (*PartitionId) ProtoMessage()               {}
func (*PartitionId) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *PartitionId) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *PartitionId) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

// A representation of a Datastore kind.
type KindExpression struct {
	// The name of the kind.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *KindExpression) Reset()                    { *m = KindExpression{} }
func (m *KindExpression) String() string            { return proto.CompactTextString(m) }
func (*KindExpression) ProtoMessage()               {}
func (*KindExpression) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *KindExpression) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A reference to a property relative to the Datastore kind expressions.
type PropertyReference struct {
	// The name of the property.
	// If name includes "."s, it may be interpreted as a property name path.
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
}

func (m *PropertyReference) Reset()                    { *m = PropertyReference{} }
func (m *PropertyReference) String() string            { return proto.CompactTextString(m) }
func (*PropertyReference) ProtoMessage()               {}
func (*PropertyReference) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *PropertyReference) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A representation of a Datastore property in a projection.
type Projection struct {
	// The property to project.
	Property *PropertyReference `protobuf:"bytes,1,opt,name=property" json:"property,omitempty"`
}

func (m *Projection) Reset()                    { *m = Projection{} }
func (m *Projection) String() string            { return proto.CompactTextString(m) }
func (*Projection) ProtoMessage()               {}
func (*Projection) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

func (m *Projection) GetProperty() *PropertyReference {
	if m != nil {
		return m.Property
	}
	return nil
}

// Options defining a data set within Google Cloud Datastore.
type DatastoreOptions struct {
	// A partition ID identifies a grouping of entities. The grouping is always
	// by project and namespace, however the namespace ID may be empty.
	PartitionId *PartitionId `protobuf:"bytes,1,opt,name=partition_id,json=partitionId" json:"partition_id,omitempty"`
	// The kind to process.
	Kind *KindExpression `protobuf:"bytes,2,opt,name=kind" json:"kind,omitempty"`
	// Properties to scan. If none are specified, all properties will be scanned
	// by default.
	Projection []*Projection `protobuf:"bytes,3,rep,name=projection" json:"projection,omitempty"`
}

func (m *DatastoreOptions) Reset()                    { *m = DatastoreOptions{} }
func (m *DatastoreOptions) String() string            { return proto.CompactTextString(m) }
func (*DatastoreOptions) ProtoMessage()               {}
func (*DatastoreOptions) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

func (m *DatastoreOptions) GetPartitionId() *PartitionId {
	if m != nil {
		return m.PartitionId
	}
	return nil
}

func (m *DatastoreOptions) GetKind() *KindExpression {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (m *DatastoreOptions) GetProjection() []*Projection {
	if m != nil {
		return m.Projection
	}
	return nil
}

// Options defining a file or a set of files (path ending with *) within
// a Google Cloud Storage bucket.
type CloudStorageOptions struct {
	FileSet *CloudStorageOptions_FileSet `protobuf:"bytes,1,opt,name=file_set,json=fileSet" json:"file_set,omitempty"`
}

func (m *CloudStorageOptions) Reset()                    { *m = CloudStorageOptions{} }
func (m *CloudStorageOptions) String() string            { return proto.CompactTextString(m) }
func (*CloudStorageOptions) ProtoMessage()               {}
func (*CloudStorageOptions) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

func (m *CloudStorageOptions) GetFileSet() *CloudStorageOptions_FileSet {
	if m != nil {
		return m.FileSet
	}
	return nil
}

// Set of files to scan.
type CloudStorageOptions_FileSet struct {
	// The url, in the format `gs://<bucket>/<path>`. Trailing wildcard in the
	// path is allowed.
	Url string `protobuf:"bytes,1,opt,name=url" json:"url,omitempty"`
}

func (m *CloudStorageOptions_FileSet) Reset()                    { *m = CloudStorageOptions_FileSet{} }
func (m *CloudStorageOptions_FileSet) String() string            { return proto.CompactTextString(m) }
func (*CloudStorageOptions_FileSet) ProtoMessage()               {}
func (*CloudStorageOptions_FileSet) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7, 0} }

func (m *CloudStorageOptions_FileSet) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

// A location in Cloud Storage.
type CloudStoragePath struct {
	// The url, in the format of `gs://bucket/<path>`.
	Path string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
}

func (m *CloudStoragePath) Reset()                    { *m = CloudStoragePath{} }
func (m *CloudStoragePath) String() string            { return proto.CompactTextString(m) }
func (*CloudStoragePath) ProtoMessage()               {}
func (*CloudStoragePath) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

func (m *CloudStoragePath) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

// Options defining BigQuery table and row identifiers.
type BigQueryOptions struct {
	// Complete BigQuery table reference.
	TableReference *BigQueryTable `protobuf:"bytes,1,opt,name=table_reference,json=tableReference" json:"table_reference,omitempty"`
	// References to fields uniquely identifying rows within the table.
	// Nested fields in the format, like `person.birthdate.year`, are allowed.
	IdentifyingFields []*FieldId `protobuf:"bytes,2,rep,name=identifying_fields,json=identifyingFields" json:"identifying_fields,omitempty"`
}

func (m *BigQueryOptions) Reset()                    { *m = BigQueryOptions{} }
func (m *BigQueryOptions) String() string            { return proto.CompactTextString(m) }
func (*BigQueryOptions) ProtoMessage()               {}
func (*BigQueryOptions) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

func (m *BigQueryOptions) GetTableReference() *BigQueryTable {
	if m != nil {
		return m.TableReference
	}
	return nil
}

func (m *BigQueryOptions) GetIdentifyingFields() []*FieldId {
	if m != nil {
		return m.IdentifyingFields
	}
	return nil
}

// Shared message indicating Cloud storage type.
type StorageConfig struct {
	// Types that are valid to be assigned to Type:
	//	*StorageConfig_DatastoreOptions
	//	*StorageConfig_CloudStorageOptions
	//	*StorageConfig_BigQueryOptions
	Type isStorageConfig_Type `protobuf_oneof:"type"`
}

func (m *StorageConfig) Reset()                    { *m = StorageConfig{} }
func (m *StorageConfig) String() string            { return proto.CompactTextString(m) }
func (*StorageConfig) ProtoMessage()               {}
func (*StorageConfig) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10} }

type isStorageConfig_Type interface {
	isStorageConfig_Type()
}

type StorageConfig_DatastoreOptions struct {
	DatastoreOptions *DatastoreOptions `protobuf:"bytes,2,opt,name=datastore_options,json=datastoreOptions,oneof"`
}
type StorageConfig_CloudStorageOptions struct {
	CloudStorageOptions *CloudStorageOptions `protobuf:"bytes,3,opt,name=cloud_storage_options,json=cloudStorageOptions,oneof"`
}
type StorageConfig_BigQueryOptions struct {
	BigQueryOptions *BigQueryOptions `protobuf:"bytes,4,opt,name=big_query_options,json=bigQueryOptions,oneof"`
}

func (*StorageConfig_DatastoreOptions) isStorageConfig_Type()    {}
func (*StorageConfig_CloudStorageOptions) isStorageConfig_Type() {}
func (*StorageConfig_BigQueryOptions) isStorageConfig_Type()     {}

func (m *StorageConfig) GetType() isStorageConfig_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *StorageConfig) GetDatastoreOptions() *DatastoreOptions {
	if x, ok := m.GetType().(*StorageConfig_DatastoreOptions); ok {
		return x.DatastoreOptions
	}
	return nil
}

func (m *StorageConfig) GetCloudStorageOptions() *CloudStorageOptions {
	if x, ok := m.GetType().(*StorageConfig_CloudStorageOptions); ok {
		return x.CloudStorageOptions
	}
	return nil
}

func (m *StorageConfig) GetBigQueryOptions() *BigQueryOptions {
	if x, ok := m.GetType().(*StorageConfig_BigQueryOptions); ok {
		return x.BigQueryOptions
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StorageConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StorageConfig_OneofMarshaler, _StorageConfig_OneofUnmarshaler, _StorageConfig_OneofSizer, []interface{}{
		(*StorageConfig_DatastoreOptions)(nil),
		(*StorageConfig_CloudStorageOptions)(nil),
		(*StorageConfig_BigQueryOptions)(nil),
	}
}

func _StorageConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StorageConfig)
	// type
	switch x := m.Type.(type) {
	case *StorageConfig_DatastoreOptions:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DatastoreOptions); err != nil {
			return err
		}
	case *StorageConfig_CloudStorageOptions:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CloudStorageOptions); err != nil {
			return err
		}
	case *StorageConfig_BigQueryOptions:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BigQueryOptions); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("StorageConfig.Type has unexpected type %T", x)
	}
	return nil
}

func _StorageConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StorageConfig)
	switch tag {
	case 2: // type.datastore_options
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DatastoreOptions)
		err := b.DecodeMessage(msg)
		m.Type = &StorageConfig_DatastoreOptions{msg}
		return true, err
	case 3: // type.cloud_storage_options
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CloudStorageOptions)
		err := b.DecodeMessage(msg)
		m.Type = &StorageConfig_CloudStorageOptions{msg}
		return true, err
	case 4: // type.big_query_options
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BigQueryOptions)
		err := b.DecodeMessage(msg)
		m.Type = &StorageConfig_BigQueryOptions{msg}
		return true, err
	default:
		return false, nil
	}
}

func _StorageConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StorageConfig)
	// type
	switch x := m.Type.(type) {
	case *StorageConfig_DatastoreOptions:
		s := proto.Size(x.DatastoreOptions)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StorageConfig_CloudStorageOptions:
		s := proto.Size(x.CloudStorageOptions)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StorageConfig_BigQueryOptions:
		s := proto.Size(x.BigQueryOptions)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Record key for a finding in a Cloud Storage file.
type CloudStorageKey struct {
	// Path to the file.
	FilePath string `protobuf:"bytes,1,opt,name=file_path,json=filePath" json:"file_path,omitempty"`
	// Byte offset of the referenced data in the file.
	StartOffset int64 `protobuf:"varint,2,opt,name=start_offset,json=startOffset" json:"start_offset,omitempty"`
}

func (m *CloudStorageKey) Reset()                    { *m = CloudStorageKey{} }
func (m *CloudStorageKey) String() string            { return proto.CompactTextString(m) }
func (*CloudStorageKey) ProtoMessage()               {}
func (*CloudStorageKey) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{11} }

func (m *CloudStorageKey) GetFilePath() string {
	if m != nil {
		return m.FilePath
	}
	return ""
}

func (m *CloudStorageKey) GetStartOffset() int64 {
	if m != nil {
		return m.StartOffset
	}
	return 0
}

// Record key for a finding in Cloud Datastore.
type DatastoreKey struct {
	// Datastore entity key.
	EntityKey *Key `protobuf:"bytes,1,opt,name=entity_key,json=entityKey" json:"entity_key,omitempty"`
}

func (m *DatastoreKey) Reset()                    { *m = DatastoreKey{} }
func (m *DatastoreKey) String() string            { return proto.CompactTextString(m) }
func (*DatastoreKey) ProtoMessage()               {}
func (*DatastoreKey) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{12} }

func (m *DatastoreKey) GetEntityKey() *Key {
	if m != nil {
		return m.EntityKey
	}
	return nil
}

// A unique identifier for a Datastore entity.
// If a key's partition ID or any of its path kinds or names are
// reserved/read-only, the key is reserved/read-only.
// A reserved/read-only key is forbidden in certain documented contexts.
type Key struct {
	// Entities are partitioned into subsets, currently identified by a project
	// ID and namespace ID.
	// Queries are scoped to a single partition.
	PartitionId *PartitionId `protobuf:"bytes,1,opt,name=partition_id,json=partitionId" json:"partition_id,omitempty"`
	// The entity path.
	// An entity path consists of one or more elements composed of a kind and a
	// string or numerical identifier, which identify entities. The first
	// element identifies a _root entity_, the second element identifies
	// a _child_ of the root entity, the third element identifies a child of the
	// second entity, and so forth. The entities identified by all prefixes of
	// the path are called the element's _ancestors_.
	//
	// A path can never be empty, and a path can have at most 100 elements.
	Path []*Key_PathElement `protobuf:"bytes,2,rep,name=path" json:"path,omitempty"`
}

func (m *Key) Reset()                    { *m = Key{} }
func (m *Key) String() string            { return proto.CompactTextString(m) }
func (*Key) ProtoMessage()               {}
func (*Key) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{13} }

func (m *Key) GetPartitionId() *PartitionId {
	if m != nil {
		return m.PartitionId
	}
	return nil
}

func (m *Key) GetPath() []*Key_PathElement {
	if m != nil {
		return m.Path
	}
	return nil
}

// A (kind, ID/name) pair used to construct a key path.
//
// If either name or ID is set, the element is complete.
// If neither is set, the element is incomplete.
type Key_PathElement struct {
	// The kind of the entity.
	// A kind matching regex `__.*__` is reserved/read-only.
	// A kind must not contain more than 1500 bytes when UTF-8 encoded.
	// Cannot be `""`.
	Kind string `protobuf:"bytes,1,opt,name=kind" json:"kind,omitempty"`
	// The type of ID.
	//
	// Types that are valid to be assigned to IdType:
	//	*Key_PathElement_Id
	//	*Key_PathElement_Name
	IdType isKey_PathElement_IdType `protobuf_oneof:"id_type"`
}

func (m *Key_PathElement) Reset()                    { *m = Key_PathElement{} }
func (m *Key_PathElement) String() string            { return proto.CompactTextString(m) }
func (*Key_PathElement) ProtoMessage()               {}
func (*Key_PathElement) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{13, 0} }

type isKey_PathElement_IdType interface {
	isKey_PathElement_IdType()
}

type Key_PathElement_Id struct {
	Id int64 `protobuf:"varint,2,opt,name=id,oneof"`
}
type Key_PathElement_Name struct {
	Name string `protobuf:"bytes,3,opt,name=name,oneof"`
}

func (*Key_PathElement_Id) isKey_PathElement_IdType()   {}
func (*Key_PathElement_Name) isKey_PathElement_IdType() {}

func (m *Key_PathElement) GetIdType() isKey_PathElement_IdType {
	if m != nil {
		return m.IdType
	}
	return nil
}

func (m *Key_PathElement) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *Key_PathElement) GetId() int64 {
	if x, ok := m.GetIdType().(*Key_PathElement_Id); ok {
		return x.Id
	}
	return 0
}

func (m *Key_PathElement) GetName() string {
	if x, ok := m.GetIdType().(*Key_PathElement_Name); ok {
		return x.Name
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Key_PathElement) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Key_PathElement_OneofMarshaler, _Key_PathElement_OneofUnmarshaler, _Key_PathElement_OneofSizer, []interface{}{
		(*Key_PathElement_Id)(nil),
		(*Key_PathElement_Name)(nil),
	}
}

func _Key_PathElement_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Key_PathElement)
	// id_type
	switch x := m.IdType.(type) {
	case *Key_PathElement_Id:
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Id))
	case *Key_PathElement_Name:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Name)
	case nil:
	default:
		return fmt.Errorf("Key_PathElement.IdType has unexpected type %T", x)
	}
	return nil
}

func _Key_PathElement_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Key_PathElement)
	switch tag {
	case 2: // id_type.id
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.IdType = &Key_PathElement_Id{int64(x)}
		return true, err
	case 3: // id_type.name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.IdType = &Key_PathElement_Name{x}
		return true, err
	default:
		return false, nil
	}
}

func _Key_PathElement_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Key_PathElement)
	// id_type
	switch x := m.IdType.(type) {
	case *Key_PathElement_Id:
		n += proto.SizeVarint(2<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.Id))
	case *Key_PathElement_Name:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Name)))
		n += len(x.Name)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Message for a unique key indicating a record that contains a finding.
type RecordKey struct {
	// Types that are valid to be assigned to Type:
	//	*RecordKey_CloudStorageKey
	//	*RecordKey_DatastoreKey
	Type isRecordKey_Type `protobuf_oneof:"type"`
}

func (m *RecordKey) Reset()                    { *m = RecordKey{} }
func (m *RecordKey) String() string            { return proto.CompactTextString(m) }
func (*RecordKey) ProtoMessage()               {}
func (*RecordKey) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{14} }

type isRecordKey_Type interface {
	isRecordKey_Type()
}

type RecordKey_CloudStorageKey struct {
	CloudStorageKey *CloudStorageKey `protobuf:"bytes,1,opt,name=cloud_storage_key,json=cloudStorageKey,oneof"`
}
type RecordKey_DatastoreKey struct {
	DatastoreKey *DatastoreKey `protobuf:"bytes,2,opt,name=datastore_key,json=datastoreKey,oneof"`
}

func (*RecordKey_CloudStorageKey) isRecordKey_Type() {}
func (*RecordKey_DatastoreKey) isRecordKey_Type()    {}

func (m *RecordKey) GetType() isRecordKey_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *RecordKey) GetCloudStorageKey() *CloudStorageKey {
	if x, ok := m.GetType().(*RecordKey_CloudStorageKey); ok {
		return x.CloudStorageKey
	}
	return nil
}

func (m *RecordKey) GetDatastoreKey() *DatastoreKey {
	if x, ok := m.GetType().(*RecordKey_DatastoreKey); ok {
		return x.DatastoreKey
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RecordKey) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RecordKey_OneofMarshaler, _RecordKey_OneofUnmarshaler, _RecordKey_OneofSizer, []interface{}{
		(*RecordKey_CloudStorageKey)(nil),
		(*RecordKey_DatastoreKey)(nil),
	}
}

func _RecordKey_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RecordKey)
	// type
	switch x := m.Type.(type) {
	case *RecordKey_CloudStorageKey:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CloudStorageKey); err != nil {
			return err
		}
	case *RecordKey_DatastoreKey:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DatastoreKey); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RecordKey.Type has unexpected type %T", x)
	}
	return nil
}

func _RecordKey_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RecordKey)
	switch tag {
	case 1: // type.cloud_storage_key
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CloudStorageKey)
		err := b.DecodeMessage(msg)
		m.Type = &RecordKey_CloudStorageKey{msg}
		return true, err
	case 2: // type.datastore_key
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DatastoreKey)
		err := b.DecodeMessage(msg)
		m.Type = &RecordKey_DatastoreKey{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RecordKey_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RecordKey)
	// type
	switch x := m.Type.(type) {
	case *RecordKey_CloudStorageKey:
		s := proto.Size(x.CloudStorageKey)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RecordKey_DatastoreKey:
		s := proto.Size(x.DatastoreKey)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Message defining the location of a BigQuery table. A table is uniquely
// identified  by its project_id, dataset_id, and table_name. Within a query
// a table is often referenced with a string in the format of:
// `<project_id>:<dataset_id>.<table_id>` or
// `<project_id>.<dataset_id>.<table_id>`.
type BigQueryTable struct {
	// The Google Cloud Platform project ID of the project containing the table.
	// If omitted, project ID is inferred from the API call.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Dataset ID of the table.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId" json:"dataset_id,omitempty"`
	// Name of the table.
	TableId string `protobuf:"bytes,3,opt,name=table_id,json=tableId" json:"table_id,omitempty"`
}

func (m *BigQueryTable) Reset()                    { *m = BigQueryTable{} }
func (m *BigQueryTable) String() string            { return proto.CompactTextString(m) }
func (*BigQueryTable) ProtoMessage()               {}
func (*BigQueryTable) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{15} }

func (m *BigQueryTable) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *BigQueryTable) GetDatasetId() string {
	if m != nil {
		return m.DatasetId
	}
	return ""
}

func (m *BigQueryTable) GetTableId() string {
	if m != nil {
		return m.TableId
	}
	return ""
}

// An entity in a dataset is a field or set of fields that correspond to a
// single person. For example, in medical records the `EntityId` might be
// a patient identifier, or for financial records it might be an account
// identifier. This message is used when generalizations or analysis must be
// consistent across multiple rows pertaining to the same entity.
type EntityId struct {
	// Composite key indicating which field contains the entity identifier.
	Field *FieldId `protobuf:"bytes,1,opt,name=field" json:"field,omitempty"`
}

func (m *EntityId) Reset()                    { *m = EntityId{} }
func (m *EntityId) String() string            { return proto.CompactTextString(m) }
func (*EntityId) ProtoMessage()               {}
func (*EntityId) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{16} }

func (m *EntityId) GetField() *FieldId {
	if m != nil {
		return m.Field
	}
	return nil
}

func init() {
	proto.RegisterType((*InfoType)(nil), "google.privacy.dlp.v2beta1.InfoType")
	proto.RegisterType((*FieldId)(nil), "google.privacy.dlp.v2beta1.FieldId")
	proto.RegisterType((*PartitionId)(nil), "google.privacy.dlp.v2beta1.PartitionId")
	proto.RegisterType((*KindExpression)(nil), "google.privacy.dlp.v2beta1.KindExpression")
	proto.RegisterType((*PropertyReference)(nil), "google.privacy.dlp.v2beta1.PropertyReference")
	proto.RegisterType((*Projection)(nil), "google.privacy.dlp.v2beta1.Projection")
	proto.RegisterType((*DatastoreOptions)(nil), "google.privacy.dlp.v2beta1.DatastoreOptions")
	proto.RegisterType((*CloudStorageOptions)(nil), "google.privacy.dlp.v2beta1.CloudStorageOptions")
	proto.RegisterType((*CloudStorageOptions_FileSet)(nil), "google.privacy.dlp.v2beta1.CloudStorageOptions.FileSet")
	proto.RegisterType((*CloudStoragePath)(nil), "google.privacy.dlp.v2beta1.CloudStoragePath")
	proto.RegisterType((*BigQueryOptions)(nil), "google.privacy.dlp.v2beta1.BigQueryOptions")
	proto.RegisterType((*StorageConfig)(nil), "google.privacy.dlp.v2beta1.StorageConfig")
	proto.RegisterType((*CloudStorageKey)(nil), "google.privacy.dlp.v2beta1.CloudStorageKey")
	proto.RegisterType((*DatastoreKey)(nil), "google.privacy.dlp.v2beta1.DatastoreKey")
	proto.RegisterType((*Key)(nil), "google.privacy.dlp.v2beta1.Key")
	proto.RegisterType((*Key_PathElement)(nil), "google.privacy.dlp.v2beta1.Key.PathElement")
	proto.RegisterType((*RecordKey)(nil), "google.privacy.dlp.v2beta1.RecordKey")
	proto.RegisterType((*BigQueryTable)(nil), "google.privacy.dlp.v2beta1.BigQueryTable")
	proto.RegisterType((*EntityId)(nil), "google.privacy.dlp.v2beta1.EntityId")
}

func init() { proto.RegisterFile("google/privacy/dlp/v2beta1/storage.proto", fileDescriptor1) }

var fileDescriptor1 = []byte{
	// 929 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0xef, 0x6e, 0xdb, 0x54,
	0x14, 0xaf, 0x93, 0xb2, 0x26, 0x27, 0xe9, 0x9a, 0x78, 0x20, 0x85, 0x8c, 0xad, 0x9b, 0x41, 0x5b,
	0x59, 0xc1, 0x11, 0xe1, 0x03, 0x42, 0x88, 0x21, 0x65, 0x6d, 0xa9, 0xa9, 0xb4, 0x76, 0x77, 0x15,
	0x68, 0xf0, 0xc1, 0xba, 0xf1, 0xbd, 0x76, 0x2f, 0x73, 0x7c, 0x2f, 0xf6, 0xcd, 0x84, 0x5f, 0x00,
	0xf1, 0x2c, 0x3c, 0x00, 0x12, 0x9f, 0x78, 0x1b, 0xc4, 0x63, 0xa0, 0xfb, 0x27, 0x8e, 0x1b, 0x4a,
	0x56, 0xa4, 0x7d, 0xbb, 0x3e, 0x3e, 0xe7, 0x77, 0xee, 0xf9, 0x9d, 0xdf, 0x39, 0x36, 0xec, 0x25,
	0x9c, 0x27, 0x29, 0x1d, 0x89, 0x9c, 0xbd, 0xc2, 0x51, 0x39, 0x22, 0xa9, 0x18, 0xbd, 0x1a, 0x4f,
	0xa9, 0xc4, 0x9f, 0x8c, 0x0a, 0xc9, 0x73, 0x9c, 0x50, 0x5f, 0xe4, 0x5c, 0x72, 0x77, 0x68, 0x3c,
	0x7d, 0xeb, 0xe9, 0x93, 0x54, 0xf8, 0xd6, 0x73, 0xf8, 0x9e, 0x45, 0xc1, 0x82, 0x8d, 0x70, 0x96,
	0x71, 0x89, 0x25, 0xe3, 0x59, 0x61, 0x22, 0x87, 0xbb, 0x55, 0x0e, 0x2e, 0xf9, 0x74, 0x1e, 0x8f,
	0x24, 0x9b, 0xd1, 0x42, 0xe2, 0x99, 0x30, 0x0e, 0xde, 0x5d, 0x68, 0x05, 0x59, 0xcc, 0xcf, 0x4b,
	0x41, 0x5d, 0x17, 0x36, 0x33, 0x3c, 0xa3, 0x03, 0xe7, 0x9e, 0xb3, 0xd7, 0x46, 0xfa, 0xec, 0x3d,
	0x82, 0xad, 0x23, 0x46, 0x53, 0x12, 0x10, 0x77, 0x17, 0x3a, 0x11, 0x4f, 0xe7, 0xb3, 0x2c, 0xac,
	0x79, 0x81, 0x31, 0x3d, 0x55, 0xbe, 0xa7, 0xd0, 0x39, 0xc3, 0xb9, 0x64, 0xea, 0x02, 0x01, 0x71,
	0xef, 0x00, 0x88, 0x9c, 0xff, 0x48, 0x23, 0x19, 0x32, 0x32, 0x68, 0x68, 0xf7, 0xb6, 0xb5, 0x04,
	0xc4, 0xbd, 0x0f, 0x5d, 0x85, 0x53, 0x08, 0x1c, 0x51, 0xe5, 0xb0, 0xa9, 0x1d, 0x3a, 0x95, 0x2d,
	0x20, 0xde, 0x07, 0x70, 0xf3, 0x84, 0x65, 0xe4, 0xf0, 0x67, 0x91, 0xd3, 0xa2, 0x60, 0x3c, 0xbb,
	0xf2, 0x8a, 0x0f, 0xa1, 0x7f, 0x96, 0x73, 0x41, 0x73, 0x59, 0x22, 0x1a, 0xd3, 0x9c, 0x66, 0xd1,
	0xb2, 0x96, 0x46, 0xcd, 0xf1, 0x3b, 0x80, 0x33, 0x93, 0x5e, 0x41, 0x05, 0xd0, 0x12, 0x36, 0x4c,
	0xc3, 0x75, 0xc6, 0x1f, 0xfb, 0xff, 0xcd, 0xb3, 0xff, 0xaf, 0x14, 0xa8, 0x0a, 0xf7, 0xfe, 0x72,
	0xa0, 0x77, 0x80, 0x25, 0x56, 0x5d, 0xa3, 0xa7, 0x42, 0x37, 0xc0, 0xfd, 0x06, 0xba, 0x62, 0xc1,
	0x86, 0xaa, 0xcf, 0xe4, 0x78, 0xb8, 0x36, 0xc7, 0x92, 0x3d, 0xd4, 0x11, 0x35, 0x2a, 0x1f, 0xc3,
	0xe6, 0x4b, 0x96, 0x19, 0x12, 0x3b, 0xe3, 0x47, 0xeb, 0x30, 0x2e, 0x13, 0x86, 0x74, 0x9c, 0x7b,
	0x54, 0xb5, 0x82, 0xf1, 0x6c, 0xd0, 0xbc, 0xd7, 0xdc, 0xeb, 0x8c, 0x1f, 0xbc, 0xa6, 0x5a, 0xeb,
	0x8d, 0x6a, 0x91, 0xde, 0x2f, 0x0e, 0xdc, 0x7a, 0x92, 0xf2, 0x39, 0x79, 0x6e, 0xf4, 0xb9, 0xa8,
	0x15, 0x41, 0x2b, 0x66, 0x29, 0x0d, 0x0b, 0x2a, 0x6d, 0x9d, 0x9f, 0xad, 0x43, 0xbf, 0x02, 0xc2,
	0x3f, 0x62, 0x29, 0x7d, 0x4e, 0x25, 0xda, 0x8a, 0xcd, 0x61, 0x78, 0x5b, 0x29, 0x4f, 0x1f, 0xdd,
	0x1e, 0x34, 0xe7, 0x79, 0x6a, 0x9b, 0xae, 0x8e, 0xde, 0x03, 0xe8, 0xd5, 0x41, 0xce, 0xb0, 0xbc,
	0x50, 0x2d, 0x17, 0x58, 0x5e, 0x2c, 0xb4, 0xa1, 0xce, 0xde, 0x1f, 0x0e, 0xec, 0x4c, 0x58, 0xf2,
	0x6c, 0x4e, 0xf3, 0x72, 0x79, 0xd9, 0x1d, 0x89, 0xa7, 0x29, 0x0d, 0xf3, 0x45, 0x2b, 0xed, 0x9d,
	0x3f, 0x5c, 0x77, 0xe7, 0x05, 0xca, 0xb9, 0x0a, 0x45, 0x37, 0x35, 0xc2, 0x52, 0x6e, 0x08, 0x5c,
	0x46, 0x68, 0x26, 0x59, 0x5c, 0xb2, 0x2c, 0x09, 0x63, 0x35, 0x32, 0xc5, 0xa0, 0xa1, 0x89, 0x7e,
	0x7f, 0x1d, 0xac, 0x1d, 0x2e, 0xd4, 0xaf, 0x85, 0x6b, 0x5b, 0xe1, 0xfd, 0xde, 0x80, 0x6d, 0x5b,
	0xdf, 0x13, 0x9e, 0xc5, 0x2c, 0x71, 0x7f, 0x80, 0x3e, 0x59, 0xc8, 0x2c, 0xe4, 0xa6, 0x1c, 0xab,
	0x89, 0x8f, 0xd6, 0x25, 0x59, 0xd5, 0xe6, 0xf1, 0x06, 0xea, 0x91, 0x55, 0xbd, 0x52, 0x78, 0x27,
	0x52, 0x94, 0x86, 0x76, 0xf7, 0x54, 0x09, 0x9a, 0x3a, 0xc1, 0xe8, 0x7f, 0x36, 0xf4, 0x78, 0x03,
	0xdd, 0x8a, 0xae, 0x90, 0xca, 0x0b, 0xe8, 0x4f, 0x59, 0x12, 0xfe, 0xa4, 0xb8, 0xac, 0x52, 0x6c,
	0xea, 0x14, 0xfb, 0xd7, 0xe1, 0x7f, 0x09, 0xbf, 0x33, 0xbd, 0x6c, 0x9a, 0xdc, 0x80, 0x4d, 0x59,
	0x0a, 0xea, 0x3d, 0x83, 0x9d, 0xfa, 0x85, 0x4e, 0x68, 0xe9, 0xde, 0x86, 0xb6, 0x16, 0x68, 0x4d,
	0x20, 0x5a, 0xb1, 0x5a, 0x38, 0xf7, 0xa1, 0x5b, 0x48, 0x9c, 0xcb, 0x90, 0xc7, 0xb1, 0x52, 0xb0,
	0x62, 0xb4, 0x89, 0x3a, 0xda, 0x76, 0xaa, 0x4d, 0xde, 0x53, 0xe8, 0x56, 0x24, 0x2a, 0xbc, 0xc7,
	0x00, 0xaa, 0x5d, 0xb2, 0x0c, 0x5f, 0xd2, 0xc5, 0xfa, 0xd8, 0x5d, 0x3b, 0x96, 0xb4, 0x44, 0x6d,
	0x13, 0x72, 0x42, 0x4b, 0xef, 0x6f, 0x07, 0x9a, 0x0a, 0xe7, 0x4d, 0x2e, 0x89, 0xaf, 0xac, 0xfe,
	0x8d, 0xea, 0xf6, 0x5f, 0x73, 0x1b, 0x5f, 0x95, 0x7e, 0x98, 0xd2, 0x19, 0xcd, 0xa4, 0x19, 0x96,
	0xe1, 0xb9, 0xda, 0xdf, 0x95, 0x51, 0xcd, 0x93, 0x5e, 0x3a, 0x76, 0x9e, 0xf4, 0x22, 0xe9, 0x41,
	0xc3, 0xee, 0xf2, 0xe6, 0xf1, 0x06, 0x6a, 0x30, 0xe2, 0xbe, 0x6d, 0x17, 0xad, 0x52, 0x49, 0xfb,
	0x78, 0xc3, 0xac, 0xda, 0x49, 0x1b, 0xb6, 0x18, 0x09, 0x75, 0x37, 0xfe, 0x74, 0xa0, 0x8d, 0x68,
	0xc4, 0x73, 0xa2, 0x0a, 0x7e, 0x01, 0xfd, 0xcb, 0x2a, 0x5b, 0xf2, 0xb7, 0x7f, 0x5d, 0x85, 0x9d,
	0xd0, 0x52, 0xb5, 0x3f, 0x5a, 0xe9, 0xf1, 0x29, 0x6c, 0x2f, 0xa7, 0x43, 0xc1, 0x9a, 0xc9, 0xd8,
	0xbb, 0xd6, 0x64, 0x18, 0xcc, 0x2e, 0xa9, 0x3d, 0x57, 0x7a, 0xba, 0x80, 0xed, 0x4b, 0xd3, 0xbf,
	0xf2, 0x65, 0x73, 0x56, 0xbf, 0x6c, 0x77, 0x00, 0x34, 0x0e, 0xad, 0x7f, 0xf8, 0xac, 0x25, 0x20,
	0xee, 0xbb, 0xd0, 0x32, 0xfb, 0x87, 0x11, 0xc3, 0x1a, 0xda, 0xd2, 0xcf, 0x01, 0xf1, 0x0e, 0xa1,
	0x75, 0xa8, 0x35, 0x12, 0x10, 0xf7, 0x73, 0x78, 0x4b, 0xaf, 0x11, 0xcb, 0xce, 0xb5, 0xb6, 0x88,
	0x89, 0x98, 0xfc, 0xea, 0xc0, 0xdd, 0x88, 0xcf, 0xd6, 0x44, 0x4c, 0xe0, 0x20, 0x15, 0x8b, 0xe5,
	0xe9, 0x7c, 0xff, 0xa5, 0xf5, 0x4c, 0x78, 0x8a, 0xb3, 0xc4, 0xe7, 0x79, 0x32, 0x4a, 0x68, 0xa6,
	0xff, 0x10, 0x46, 0xe6, 0x15, 0x16, 0xac, 0xb8, 0xea, 0x4f, 0xe5, 0x0b, 0x92, 0x8a, 0xdf, 0x1a,
	0x83, 0xaf, 0x4d, 0xbc, 0xee, 0x92, 0x7f, 0x90, 0x0a, 0xff, 0xdb, 0xf1, 0x44, 0xbd, 0x9e, 0xde,
	0xd0, 0x20, 0x9f, 0xfe, 0x13, 0x00, 0x00, 0xff, 0xff, 0x7e, 0xae, 0xb2, 0x3b, 0xed, 0x08, 0x00,
	0x00,
}
