// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/firestore/v1beta1/document.proto

package firestore

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf2 "github.com/golang/protobuf/ptypes/struct"
import google_protobuf1 "github.com/golang/protobuf/ptypes/timestamp"
import google_type "google.golang.org/genproto/googleapis/type/latlng"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// A Firestore document.
//
// Must not exceed 1 MiB - 4 bytes.
type Document struct {
	// The resource name of the document, for example
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The document's fields.
	//
	// The map keys represent field names.
	//
	// A simple field name contains only characters `a` to `z`, `A` to `Z`,
	// `0` to `9`, or `_`, and must not start with `0` to `9` or `_`. For example,
	// `foo_bar_17`.
	//
	// Field names matching the regular expression `__.*__` are reserved. Reserved
	// field names are forbidden except in certain documented contexts. The map
	// keys, represented as UTF-8, must not exceed 1,500 bytes and cannot be
	// empty.
	//
	// Field paths may be used in other contexts to refer to structured fields
	// defined here. For `map_value`, the field path is represented by the simple
	// or quoted field names of the containing fields, delimited by `.`. For
	// example, the structured field
	// `"foo" : { map_value: { "x&y" : { string_value: "hello" }}}` would be
	// represented by the field path `foo.x&y`.
	//
	// Within a field path, a quoted field name starts and ends with `` ` `` and
	// may contain any character. Some characters, including `` ` ``, must be
	// escaped using a `\`. For example, `` `x&y` `` represents `x&y` and
	// `` `bak\`tik` `` represents `` bak`tik ``.
	Fields map[string]*Value `protobuf:"bytes,2,rep,name=fields" json:"fields,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Output only. The time at which the document was created.
	//
	// This value increases monotonically when a document is deleted then
	// recreated. It can also be compared to values from other documents and
	// the `read_time` of a query.
	CreateTime *google_protobuf1.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// Output only. The time at which the document was last changed.
	//
	// This value is initally set to the `create_time` then increases
	// monotonically with each change to the document. It can also be
	// compared to values from other documents and the `read_time` of a query.
	UpdateTime *google_protobuf1.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime" json:"update_time,omitempty"`
}

func (m *Document) Reset()                    { *m = Document{} }
func (m *Document) String() string            { return proto.CompactTextString(m) }
func (*Document) ProtoMessage()               {}
func (*Document) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *Document) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Document) GetFields() map[string]*Value {
	if m != nil {
		return m.Fields
	}
	return nil
}

func (m *Document) GetCreateTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Document) GetUpdateTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// A message that can hold any of the supported value types.
type Value struct {
	// Must have a value set.
	//
	// Types that are valid to be assigned to ValueType:
	//	*Value_NullValue
	//	*Value_BooleanValue
	//	*Value_IntegerValue
	//	*Value_DoubleValue
	//	*Value_TimestampValue
	//	*Value_StringValue
	//	*Value_BytesValue
	//	*Value_ReferenceValue
	//	*Value_GeoPointValue
	//	*Value_ArrayValue
	//	*Value_MapValue
	ValueType isValue_ValueType `protobuf_oneof:"value_type"`
}

func (m *Value) Reset()                    { *m = Value{} }
func (m *Value) String() string            { return proto.CompactTextString(m) }
func (*Value) ProtoMessage()               {}
func (*Value) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

type isValue_ValueType interface {
	isValue_ValueType()
}

type Value_NullValue struct {
	NullValue google_protobuf2.NullValue `protobuf:"varint,11,opt,name=null_value,json=nullValue,enum=google.protobuf.NullValue,oneof"`
}
type Value_BooleanValue struct {
	BooleanValue bool `protobuf:"varint,1,opt,name=boolean_value,json=booleanValue,oneof"`
}
type Value_IntegerValue struct {
	IntegerValue int64 `protobuf:"varint,2,opt,name=integer_value,json=integerValue,oneof"`
}
type Value_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,3,opt,name=double_value,json=doubleValue,oneof"`
}
type Value_TimestampValue struct {
	TimestampValue *google_protobuf1.Timestamp `protobuf:"bytes,10,opt,name=timestamp_value,json=timestampValue,oneof"`
}
type Value_StringValue struct {
	StringValue string `protobuf:"bytes,17,opt,name=string_value,json=stringValue,oneof"`
}
type Value_BytesValue struct {
	BytesValue []byte `protobuf:"bytes,18,opt,name=bytes_value,json=bytesValue,proto3,oneof"`
}
type Value_ReferenceValue struct {
	ReferenceValue string `protobuf:"bytes,5,opt,name=reference_value,json=referenceValue,oneof"`
}
type Value_GeoPointValue struct {
	GeoPointValue *google_type.LatLng `protobuf:"bytes,8,opt,name=geo_point_value,json=geoPointValue,oneof"`
}
type Value_ArrayValue struct {
	ArrayValue *ArrayValue `protobuf:"bytes,9,opt,name=array_value,json=arrayValue,oneof"`
}
type Value_MapValue struct {
	MapValue *MapValue `protobuf:"bytes,6,opt,name=map_value,json=mapValue,oneof"`
}

func (*Value_NullValue) isValue_ValueType()      {}
func (*Value_BooleanValue) isValue_ValueType()   {}
func (*Value_IntegerValue) isValue_ValueType()   {}
func (*Value_DoubleValue) isValue_ValueType()    {}
func (*Value_TimestampValue) isValue_ValueType() {}
func (*Value_StringValue) isValue_ValueType()    {}
func (*Value_BytesValue) isValue_ValueType()     {}
func (*Value_ReferenceValue) isValue_ValueType() {}
func (*Value_GeoPointValue) isValue_ValueType()  {}
func (*Value_ArrayValue) isValue_ValueType()     {}
func (*Value_MapValue) isValue_ValueType()       {}

func (m *Value) GetValueType() isValue_ValueType {
	if m != nil {
		return m.ValueType
	}
	return nil
}

func (m *Value) GetNullValue() google_protobuf2.NullValue {
	if x, ok := m.GetValueType().(*Value_NullValue); ok {
		return x.NullValue
	}
	return google_protobuf2.NullValue_NULL_VALUE
}

func (m *Value) GetBooleanValue() bool {
	if x, ok := m.GetValueType().(*Value_BooleanValue); ok {
		return x.BooleanValue
	}
	return false
}

func (m *Value) GetIntegerValue() int64 {
	if x, ok := m.GetValueType().(*Value_IntegerValue); ok {
		return x.IntegerValue
	}
	return 0
}

func (m *Value) GetDoubleValue() float64 {
	if x, ok := m.GetValueType().(*Value_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (m *Value) GetTimestampValue() *google_protobuf1.Timestamp {
	if x, ok := m.GetValueType().(*Value_TimestampValue); ok {
		return x.TimestampValue
	}
	return nil
}

func (m *Value) GetStringValue() string {
	if x, ok := m.GetValueType().(*Value_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (m *Value) GetBytesValue() []byte {
	if x, ok := m.GetValueType().(*Value_BytesValue); ok {
		return x.BytesValue
	}
	return nil
}

func (m *Value) GetReferenceValue() string {
	if x, ok := m.GetValueType().(*Value_ReferenceValue); ok {
		return x.ReferenceValue
	}
	return ""
}

func (m *Value) GetGeoPointValue() *google_type.LatLng {
	if x, ok := m.GetValueType().(*Value_GeoPointValue); ok {
		return x.GeoPointValue
	}
	return nil
}

func (m *Value) GetArrayValue() *ArrayValue {
	if x, ok := m.GetValueType().(*Value_ArrayValue); ok {
		return x.ArrayValue
	}
	return nil
}

func (m *Value) GetMapValue() *MapValue {
	if x, ok := m.GetValueType().(*Value_MapValue); ok {
		return x.MapValue
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Value) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Value_OneofMarshaler, _Value_OneofUnmarshaler, _Value_OneofSizer, []interface{}{
		(*Value_NullValue)(nil),
		(*Value_BooleanValue)(nil),
		(*Value_IntegerValue)(nil),
		(*Value_DoubleValue)(nil),
		(*Value_TimestampValue)(nil),
		(*Value_StringValue)(nil),
		(*Value_BytesValue)(nil),
		(*Value_ReferenceValue)(nil),
		(*Value_GeoPointValue)(nil),
		(*Value_ArrayValue)(nil),
		(*Value_MapValue)(nil),
	}
}

func _Value_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Value)
	// value_type
	switch x := m.ValueType.(type) {
	case *Value_NullValue:
		b.EncodeVarint(11<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.NullValue))
	case *Value_BooleanValue:
		t := uint64(0)
		if x.BooleanValue {
			t = 1
		}
		b.EncodeVarint(1<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *Value_IntegerValue:
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.IntegerValue))
	case *Value_DoubleValue:
		b.EncodeVarint(3<<3 | proto.WireFixed64)
		b.EncodeFixed64(math.Float64bits(x.DoubleValue))
	case *Value_TimestampValue:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TimestampValue); err != nil {
			return err
		}
	case *Value_StringValue:
		b.EncodeVarint(17<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.StringValue)
	case *Value_BytesValue:
		b.EncodeVarint(18<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.BytesValue)
	case *Value_ReferenceValue:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.ReferenceValue)
	case *Value_GeoPointValue:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GeoPointValue); err != nil {
			return err
		}
	case *Value_ArrayValue:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ArrayValue); err != nil {
			return err
		}
	case *Value_MapValue:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MapValue); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Value.ValueType has unexpected type %T", x)
	}
	return nil
}

func _Value_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Value)
	switch tag {
	case 11: // value_type.null_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.ValueType = &Value_NullValue{google_protobuf2.NullValue(x)}
		return true, err
	case 1: // value_type.boolean_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.ValueType = &Value_BooleanValue{x != 0}
		return true, err
	case 2: // value_type.integer_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.ValueType = &Value_IntegerValue{int64(x)}
		return true, err
	case 3: // value_type.double_value
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.ValueType = &Value_DoubleValue{math.Float64frombits(x)}
		return true, err
	case 10: // value_type.timestamp_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf1.Timestamp)
		err := b.DecodeMessage(msg)
		m.ValueType = &Value_TimestampValue{msg}
		return true, err
	case 17: // value_type.string_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.ValueType = &Value_StringValue{x}
		return true, err
	case 18: // value_type.bytes_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.ValueType = &Value_BytesValue{x}
		return true, err
	case 5: // value_type.reference_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.ValueType = &Value_ReferenceValue{x}
		return true, err
	case 8: // value_type.geo_point_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_type.LatLng)
		err := b.DecodeMessage(msg)
		m.ValueType = &Value_GeoPointValue{msg}
		return true, err
	case 9: // value_type.array_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ArrayValue)
		err := b.DecodeMessage(msg)
		m.ValueType = &Value_ArrayValue{msg}
		return true, err
	case 6: // value_type.map_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MapValue)
		err := b.DecodeMessage(msg)
		m.ValueType = &Value_MapValue{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Value_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Value)
	// value_type
	switch x := m.ValueType.(type) {
	case *Value_NullValue:
		n += proto.SizeVarint(11<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.NullValue))
	case *Value_BooleanValue:
		n += proto.SizeVarint(1<<3 | proto.WireVarint)
		n += 1
	case *Value_IntegerValue:
		n += proto.SizeVarint(2<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.IntegerValue))
	case *Value_DoubleValue:
		n += proto.SizeVarint(3<<3 | proto.WireFixed64)
		n += 8
	case *Value_TimestampValue:
		s := proto.Size(x.TimestampValue)
		n += proto.SizeVarint(10<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Value_StringValue:
		n += proto.SizeVarint(17<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.StringValue)))
		n += len(x.StringValue)
	case *Value_BytesValue:
		n += proto.SizeVarint(18<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.BytesValue)))
		n += len(x.BytesValue)
	case *Value_ReferenceValue:
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.ReferenceValue)))
		n += len(x.ReferenceValue)
	case *Value_GeoPointValue:
		s := proto.Size(x.GeoPointValue)
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Value_ArrayValue:
		s := proto.Size(x.ArrayValue)
		n += proto.SizeVarint(9<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Value_MapValue:
		s := proto.Size(x.MapValue)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// An array value.
type ArrayValue struct {
	// Values in the array.
	Values []*Value `protobuf:"bytes,1,rep,name=values" json:"values,omitempty"`
}

func (m *ArrayValue) Reset()                    { *m = ArrayValue{} }
func (m *ArrayValue) String() string            { return proto.CompactTextString(m) }
func (*ArrayValue) ProtoMessage()               {}
func (*ArrayValue) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *ArrayValue) GetValues() []*Value {
	if m != nil {
		return m.Values
	}
	return nil
}

// A map value.
type MapValue struct {
	// The map's fields.
	//
	// The map keys represent field names. Field names matching the regular
	// expression `__.*__` are reserved. Reserved field names are forbidden except
	// in certain documented contexts. The map keys, represented as UTF-8, must
	// not exceed 1,500 bytes and cannot be empty.
	Fields map[string]*Value `protobuf:"bytes,1,rep,name=fields" json:"fields,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *MapValue) Reset()                    { *m = MapValue{} }
func (m *MapValue) String() string            { return proto.CompactTextString(m) }
func (*MapValue) ProtoMessage()               {}
func (*MapValue) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *MapValue) GetFields() map[string]*Value {
	if m != nil {
		return m.Fields
	}
	return nil
}

func init() {
	proto.RegisterType((*Document)(nil), "google.firestore.v1beta1.Document")
	proto.RegisterType((*Value)(nil), "google.firestore.v1beta1.Value")
	proto.RegisterType((*ArrayValue)(nil), "google.firestore.v1beta1.ArrayValue")
	proto.RegisterType((*MapValue)(nil), "google.firestore.v1beta1.MapValue")
}

func init() { proto.RegisterFile("google/firestore/v1beta1/document.proto", fileDescriptor1) }

var fileDescriptor1 = []byte{
	// 643 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x94, 0x4f, 0x6f, 0xd3, 0x30,
	0x18, 0xc6, 0x9b, 0xb6, 0xab, 0xda, 0x37, 0xdd, 0x06, 0xe1, 0x52, 0x55, 0x13, 0x2b, 0x05, 0x44,
	0xb9, 0x24, 0xda, 0x10, 0x02, 0x31, 0x71, 0x58, 0xc7, 0xba, 0x1e, 0x06, 0xaa, 0x02, 0xda, 0x61,
	0x97, 0xca, 0x69, 0x5d, 0x2b, 0xc2, 0xb1, 0x23, 0xc7, 0x99, 0xd4, 0xaf, 0xc2, 0x91, 0x23, 0x07,
	0x3e, 0x01, 0x9f, 0x80, 0x4f, 0x85, 0xfc, 0x2f, 0x9b, 0x60, 0x55, 0x4f, 0xdc, 0x92, 0xf7, 0xfd,
	0x3d, 0xcf, 0xfb, 0xd8, 0xb1, 0x03, 0x2f, 0x08, 0xe7, 0x84, 0xe2, 0x68, 0x95, 0x0a, 0x5c, 0x48,
	0x2e, 0x70, 0x74, 0x73, 0x94, 0x60, 0x89, 0x8e, 0xa2, 0x25, 0x5f, 0x94, 0x19, 0x66, 0x32, 0xcc,
	0x05, 0x97, 0x3c, 0xe8, 0x19, 0x30, 0xac, 0xc0, 0xd0, 0x82, 0xfd, 0x03, 0x6b, 0x81, 0xf2, 0x34,
	0x42, 0x8c, 0x71, 0x89, 0x64, 0xca, 0x59, 0x61, 0x74, 0x55, 0x57, 0xbf, 0x25, 0xe5, 0x2a, 0x2a,
	0xa4, 0x28, 0x17, 0xd6, 0xb5, 0x7f, 0xf8, 0x77, 0x57, 0xa6, 0x19, 0x2e, 0x24, 0xca, 0x72, 0x0b,
	0xd8, 0xb1, 0x91, 0x5c, 0xe7, 0x38, 0xa2, 0x48, 0x52, 0x46, 0x4c, 0x67, 0xf8, 0xab, 0x0e, 0xed,
	0x0f, 0x36, 0x63, 0x10, 0x40, 0x93, 0xa1, 0x0c, 0xf7, 0xbc, 0x81, 0x37, 0xea, 0xc4, 0xfa, 0x39,
	0x98, 0x40, 0x6b, 0x95, 0x62, 0xba, 0x2c, 0x7a, 0xf5, 0x41, 0x63, 0xe4, 0x1f, 0x87, 0xe1, 0xa6,
	0x25, 0x84, 0xce, 0x27, 0x9c, 0x68, 0xc1, 0x39, 0x93, 0x62, 0x1d, 0x5b, 0x75, 0x70, 0x02, 0xfe,
	0x42, 0x60, 0x24, 0xf1, 0x5c, 0x85, 0xeb, 0x35, 0x06, 0xde, 0xc8, 0x3f, 0xee, 0x3b, 0x33, 0x97,
	0x3c, 0xfc, 0xe2, 0x92, 0xc7, 0x60, 0x70, 0x55, 0x50, 0xe2, 0x32, 0x5f, 0x56, 0xe2, 0xe6, 0x76,
	0xb1, 0xc1, 0x55, 0xa1, 0x7f, 0x0d, 0xfe, 0x9d, 0x40, 0xc1, 0x03, 0x68, 0x7c, 0xc5, 0x6b, 0xbb,
	0x46, 0xf5, 0x18, 0xbc, 0x86, 0x9d, 0x1b, 0x44, 0x4b, 0xdc, 0xab, 0x6b, 0xdf, 0xc3, 0xcd, 0x2b,
	0xbc, 0x52, 0x58, 0x6c, 0xe8, 0x77, 0xf5, 0xb7, 0xde, 0xf0, 0x77, 0x13, 0x76, 0x74, 0x31, 0x38,
	0x01, 0x60, 0x25, 0xa5, 0x73, 0xe3, 0xe4, 0x0f, 0xbc, 0xd1, 0xde, 0x3d, 0x09, 0x3f, 0x95, 0x94,
	0x6a, 0x7e, 0x5a, 0x8b, 0x3b, 0xcc, 0xbd, 0x04, 0xcf, 0x61, 0x37, 0xe1, 0x9c, 0x62, 0xc4, 0xac,
	0x5e, 0xa5, 0x6b, 0x4f, 0x6b, 0x71, 0xd7, 0x96, 0x2b, 0x2c, 0x65, 0x12, 0x13, 0x2c, 0xe6, 0xb7,
	0x81, 0x1b, 0x0a, 0xb3, 0x65, 0x83, 0x3d, 0x85, 0xee, 0x92, 0x97, 0x09, 0xc5, 0x96, 0x52, 0x7b,
	0xed, 0x4d, 0x6b, 0xb1, 0x6f, 0xaa, 0x06, 0x3a, 0x87, 0xfd, 0xea, 0x94, 0x58, 0x0e, 0xb6, 0x6d,
	0xeb, 0xb4, 0x16, 0xef, 0x55, 0xa2, 0x6a, 0x56, 0x21, 0x45, 0xca, 0x88, 0xf5, 0x78, 0xa8, 0xb6,
	0x55, 0xcd, 0x32, 0x55, 0x03, 0x3d, 0x01, 0x3f, 0x59, 0x4b, 0x5c, 0x58, 0x26, 0x18, 0x78, 0xa3,
	0xee, 0xb4, 0x16, 0x83, 0x2e, 0x1a, 0xe4, 0x25, 0xec, 0x0b, 0xbc, 0xc2, 0x02, 0xb3, 0x85, 0x8b,
	0xbd, 0x63, 0xad, 0xf6, 0xaa, 0x86, 0x41, 0xdf, 0xc3, 0x3e, 0xc1, 0x7c, 0x9e, 0xf3, 0x94, 0x49,
	0x8b, 0xb6, 0x75, 0xf2, 0x47, 0x2e, 0xb9, 0x3a, 0xe6, 0xe1, 0x25, 0x92, 0x97, 0x8c, 0x4c, 0x6b,
	0xf1, 0x2e, 0xc1, 0x7c, 0xa6, 0x60, 0x23, 0xbf, 0x00, 0x1f, 0x09, 0x81, 0xd6, 0x56, 0xda, 0xd1,
	0xd2, 0x67, 0x9b, 0xbf, 0xf9, 0xa9, 0x82, 0xdd, 0x37, 0x03, 0x54, 0xbd, 0x05, 0xa7, 0xd0, 0xc9,
	0x90, 0xdb, 0xbb, 0x96, 0xb6, 0x19, 0x6e, 0xb6, 0xf9, 0x88, 0x72, 0x67, 0xd2, 0xce, 0xec, 0xf3,
	0xb8, 0x0b, 0xa0, 0xe5, 0x73, 0x95, 0x78, 0x78, 0x0e, 0x70, 0x3b, 0x2c, 0x78, 0x03, 0x2d, 0xdd,
	0x2b, 0x7a, 0x9e, 0xbe, 0x78, 0x5b, 0x8f, 0xa5, 0xc5, 0x87, 0x3f, 0x3d, 0x68, 0xbb, 0x69, 0x77,
	0xae, 0xaf, 0xb7, 0xed, 0xfa, 0x3a, 0xcd, 0x7d, 0xd7, 0xf7, 0x7f, 0x5e, 0xa2, 0xf1, 0x37, 0x0f,
	0x0e, 0x16, 0x3c, 0xdb, 0xa8, 0x18, 0xef, 0xba, 0x3f, 0xcb, 0x4c, 0x1d, 0xc9, 0x99, 0x77, 0x7d,
	0x6a, 0x51, 0xc2, 0x29, 0x62, 0x24, 0xe4, 0x82, 0x44, 0x04, 0x33, 0x7d, 0x60, 0x23, 0xd3, 0x42,
	0x79, 0x5a, 0xfc, 0xfb, 0x3b, 0x3e, 0xa9, 0x2a, 0xdf, 0xeb, 0xcd, 0x8b, 0xb3, 0xc9, 0xe7, 0x1f,
	0xf5, 0xc7, 0x17, 0xc6, 0xea, 0x8c, 0xf2, 0x72, 0x19, 0x4e, 0xaa, 0xd9, 0x57, 0x47, 0x63, 0xa5,
	0x48, 0x5a, 0xda, 0xf5, 0xd5, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x1e, 0x79, 0x7d, 0xad, 0xe3,
	0x05, 0x00, 0x00,
}
