// Code generated by protoc-gen-go. DO NOT EDIT.
// source: model.proto

package model

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "github.com/mwitkow/go-proto-validators"
import _ "google.golang.org/genproto/googleapis/api/annotations"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// HTTPMethod defines a specific HTTP method
type HTTPMethod int32

const (
	HTTPMethod_unknown_method HTTPMethod = 0
	HTTPMethod_get            HTTPMethod = 1
	HTTPMethod_head           HTTPMethod = 2
	HTTPMethod_post           HTTPMethod = 3
	HTTPMethod_put            HTTPMethod = 4
	HTTPMethod_delete         HTTPMethod = 5
	HTTPMethod_options        HTTPMethod = 7
	HTTPMethod_patch          HTTPMethod = 6
)

var HTTPMethod_name = map[int32]string{
	0: "unknown_method",
	1: "get",
	2: "head",
	3: "post",
	4: "put",
	5: "delete",
	7: "options",
	6: "patch",
}
var HTTPMethod_value = map[string]int32{
	"unknown_method": 0,
	"get":            1,
	"head":           2,
	"post":           3,
	"put":            4,
	"delete":         5,
	"options":        7,
	"patch":          6,
}

func (x HTTPMethod) String() string {
	return proto.EnumName(HTTPMethod_name, int32(x))
}
func (HTTPMethod) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{0}
}

// ErrorDatumType defines an internal error code generated within a flow
type ErrorDatumType int32

const (
	ErrorDatumType_unknown_error          ErrorDatumType = 0
	ErrorDatumType_stage_timeout          ErrorDatumType = 1
	ErrorDatumType_stage_failed           ErrorDatumType = 2
	ErrorDatumType_function_timeout       ErrorDatumType = 3
	ErrorDatumType_function_invoke_failed ErrorDatumType = 4
	ErrorDatumType_stage_lost             ErrorDatumType = 5
	ErrorDatumType_invalid_stage_response ErrorDatumType = 6
)

var ErrorDatumType_name = map[int32]string{
	0: "unknown_error",
	1: "stage_timeout",
	2: "stage_failed",
	3: "function_timeout",
	4: "function_invoke_failed",
	5: "stage_lost",
	6: "invalid_stage_response",
}
var ErrorDatumType_value = map[string]int32{
	"unknown_error":          0,
	"stage_timeout":          1,
	"stage_failed":           2,
	"function_timeout":       3,
	"function_invoke_failed": 4,
	"stage_lost":             5,
	"invalid_stage_response": 6,
}

func (x ErrorDatumType) String() string {
	return proto.EnumName(ErrorDatumType_name, int32(x))
}
func (ErrorDatumType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{1}
}

// StateDatumType describes the state of a stage or graph
type StatusDatumType int32

const (
	StatusDatumType_unknown_state StatusDatumType = 0
	StatusDatumType_succeeded     StatusDatumType = 1
	StatusDatumType_failed        StatusDatumType = 2
	StatusDatumType_cancelled     StatusDatumType = 3
	StatusDatumType_killed        StatusDatumType = 4
)

var StatusDatumType_name = map[int32]string{
	0: "unknown_state",
	1: "succeeded",
	2: "failed",
	3: "cancelled",
	4: "killed",
}
var StatusDatumType_value = map[string]int32{
	"unknown_state": 0,
	"succeeded":     1,
	"failed":        2,
	"cancelled":     3,
	"killed":        4,
}

func (x StatusDatumType) String() string {
	return proto.EnumName(StatusDatumType_name, int32(x))
}
func (StatusDatumType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{2}
}

// CompletionOperation describes the type and behaviour of a stage of the graph
type CompletionOperation int32

const (
	CompletionOperation_unknown_operation    CompletionOperation = 0
	CompletionOperation_acceptEither         CompletionOperation = 1
	CompletionOperation_applyToEither        CompletionOperation = 2
	CompletionOperation_thenAcceptBoth       CompletionOperation = 3
	CompletionOperation_thenApply            CompletionOperation = 4
	CompletionOperation_thenRun              CompletionOperation = 5
	CompletionOperation_thenAccept           CompletionOperation = 6
	CompletionOperation_thenCompose          CompletionOperation = 7
	CompletionOperation_thenCombine          CompletionOperation = 8
	CompletionOperation_whenComplete         CompletionOperation = 9
	CompletionOperation_handle               CompletionOperation = 10
	CompletionOperation_supply               CompletionOperation = 11
	CompletionOperation_invokeFunction       CompletionOperation = 12
	CompletionOperation_completedValue       CompletionOperation = 13
	CompletionOperation_delay                CompletionOperation = 14
	CompletionOperation_allOf                CompletionOperation = 15
	CompletionOperation_anyOf                CompletionOperation = 16
	CompletionOperation_externalCompletion   CompletionOperation = 17
	CompletionOperation_exceptionally        CompletionOperation = 18
	CompletionOperation_terminationHook      CompletionOperation = 19
	CompletionOperation_exceptionallyCompose CompletionOperation = 20
)

var CompletionOperation_name = map[int32]string{
	0:  "unknown_operation",
	1:  "acceptEither",
	2:  "applyToEither",
	3:  "thenAcceptBoth",
	4:  "thenApply",
	5:  "thenRun",
	6:  "thenAccept",
	7:  "thenCompose",
	8:  "thenCombine",
	9:  "whenComplete",
	10: "handle",
	11: "supply",
	12: "invokeFunction",
	13: "completedValue",
	14: "delay",
	15: "allOf",
	16: "anyOf",
	17: "externalCompletion",
	18: "exceptionally",
	19: "terminationHook",
	20: "exceptionallyCompose",
}
var CompletionOperation_value = map[string]int32{
	"unknown_operation":    0,
	"acceptEither":         1,
	"applyToEither":        2,
	"thenAcceptBoth":       3,
	"thenApply":            4,
	"thenRun":              5,
	"thenAccept":           6,
	"thenCompose":          7,
	"thenCombine":          8,
	"whenComplete":         9,
	"handle":               10,
	"supply":               11,
	"invokeFunction":       12,
	"completedValue":       13,
	"delay":                14,
	"allOf":                15,
	"anyOf":                16,
	"externalCompletion":   17,
	"exceptionally":        18,
	"terminationHook":      19,
	"exceptionallyCompose": 20,
}

func (x CompletionOperation) String() string {
	return proto.EnumName(CompletionOperation_name, int32(x))
}
func (CompletionOperation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{3}
}

type ListGraphsFilter int32

const (
	ListGraphsFilter_unknown   ListGraphsFilter = 0
	ListGraphsFilter_all       ListGraphsFilter = 1
	ListGraphsFilter_running   ListGraphsFilter = 2
	ListGraphsFilter_completed ListGraphsFilter = 3
)

var ListGraphsFilter_name = map[int32]string{
	0: "unknown",
	1: "all",
	2: "running",
	3: "completed",
}
var ListGraphsFilter_value = map[string]int32{
	"unknown":   0,
	"all":       1,
	"running":   2,
	"completed": 3,
}

func (x ListGraphsFilter) String() string {
	return proto.EnumName(ListGraphsFilter_name, int32(x))
}
func (ListGraphsFilter) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{4}
}

// CompletinonResult holds a value Datum and a result status (successful/failed)
type CompletionResult struct {
	Successful           bool     `protobuf:"varint,1,opt,name=successful,proto3" json:"successful,omitempty"`
	Datum                *Datum   `protobuf:"bytes,2,opt,name=datum,proto3" json:"datum,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CompletionResult) Reset()         { *m = CompletionResult{} }
func (m *CompletionResult) String() string { return proto.CompactTextString(m) }
func (*CompletionResult) ProtoMessage()    {}
func (*CompletionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{0}
}
func (m *CompletionResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CompletionResult.Unmarshal(m, b)
}
func (m *CompletionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CompletionResult.Marshal(b, m, deterministic)
}
func (dst *CompletionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompletionResult.Merge(dst, src)
}
func (m *CompletionResult) XXX_Size() int {
	return xxx_messageInfo_CompletionResult.Size(m)
}
func (m *CompletionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_CompletionResult.DiscardUnknown(m)
}

var xxx_messageInfo_CompletionResult proto.InternalMessageInfo

func (m *CompletionResult) GetSuccessful() bool {
	if m != nil {
		return m.Successful
	}
	return false
}

func (m *CompletionResult) GetDatum() *Datum {
	if m != nil {
		return m.Datum
	}
	return nil
}

// BlobDatum holds a reference to a blob the associated blob store
type BlobDatum struct {
	BlobId               string   `protobuf:"bytes,1,opt,name=blob_id,json=blobId,proto3" json:"blob_id,omitempty"`
	ContentType          string   `protobuf:"bytes,2,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
	Length               int64    `protobuf:"varint,3,opt,name=length,proto3" json:"length,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BlobDatum) Reset()         { *m = BlobDatum{} }
func (m *BlobDatum) String() string { return proto.CompactTextString(m) }
func (*BlobDatum) ProtoMessage()    {}
func (*BlobDatum) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{1}
}
func (m *BlobDatum) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BlobDatum.Unmarshal(m, b)
}
func (m *BlobDatum) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BlobDatum.Marshal(b, m, deterministic)
}
func (dst *BlobDatum) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BlobDatum.Merge(dst, src)
}
func (m *BlobDatum) XXX_Size() int {
	return xxx_messageInfo_BlobDatum.Size(m)
}
func (m *BlobDatum) XXX_DiscardUnknown() {
	xxx_messageInfo_BlobDatum.DiscardUnknown(m)
}

var xxx_messageInfo_BlobDatum proto.InternalMessageInfo

func (m *BlobDatum) GetBlobId() string {
	if m != nil {
		return m.BlobId
	}
	return ""
}

func (m *BlobDatum) GetContentType() string {
	if m != nil {
		return m.ContentType
	}
	return ""
}

func (m *BlobDatum) GetLength() int64 {
	if m != nil {
		return m.Length
	}
	return 0
}

// HTTPHeader wraps a single header key/value
type HTTPHeader struct {
	Key                  string   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HTTPHeader) Reset()         { *m = HTTPHeader{} }
func (m *HTTPHeader) String() string { return proto.CompactTextString(m) }
func (*HTTPHeader) ProtoMessage()    {}
func (*HTTPHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{2}
}
func (m *HTTPHeader) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HTTPHeader.Unmarshal(m, b)
}
func (m *HTTPHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HTTPHeader.Marshal(b, m, deterministic)
}
func (dst *HTTPHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPHeader.Merge(dst, src)
}
func (m *HTTPHeader) XXX_Size() int {
	return xxx_messageInfo_HTTPHeader.Size(m)
}
func (m *HTTPHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPHeader.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPHeader proto.InternalMessageInfo

func (m *HTTPHeader) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *HTTPHeader) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// HTTPReqDatum describes an outgoing or incoming HTTP Request, it wraps the headers, method and optional body
type HTTPReqDatum struct {
	Body                 *BlobDatum    `protobuf:"bytes,1,opt,name=body,proto3" json:"body,omitempty"`
	Headers              []*HTTPHeader `protobuf:"bytes,3,rep,name=headers,proto3" json:"headers,omitempty"`
	Method               HTTPMethod    `protobuf:"varint,4,opt,name=method,proto3,enum=model.HTTPMethod" json:"method,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *HTTPReqDatum) Reset()         { *m = HTTPReqDatum{} }
func (m *HTTPReqDatum) String() string { return proto.CompactTextString(m) }
func (*HTTPReqDatum) ProtoMessage()    {}
func (*HTTPReqDatum) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{3}
}
func (m *HTTPReqDatum) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HTTPReqDatum.Unmarshal(m, b)
}
func (m *HTTPReqDatum) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HTTPReqDatum.Marshal(b, m, deterministic)
}
func (dst *HTTPReqDatum) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPReqDatum.Merge(dst, src)
}
func (m *HTTPReqDatum) XXX_Size() int {
	return xxx_messageInfo_HTTPReqDatum.Size(m)
}
func (m *HTTPReqDatum) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPReqDatum.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPReqDatum proto.InternalMessageInfo

func (m *HTTPReqDatum) GetBody() *BlobDatum {
	if m != nil {
		return m.Body
	}
	return nil
}

func (m *HTTPReqDatum) GetHeaders() []*HTTPHeader {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *HTTPReqDatum) GetMethod() HTTPMethod {
	if m != nil {
		return m.Method
	}
	return HTTPMethod_unknown_method
}

// HTTPRespDatum wraps an outgoing or incoming HTTP REQUEST, it wraps the headers, status code and optinoal body
type HTTPRespDatum struct {
	Body                 *BlobDatum    `protobuf:"bytes,1,opt,name=body,proto3" json:"body,omitempty"`
	Headers              []*HTTPHeader `protobuf:"bytes,3,rep,name=headers,proto3" json:"headers,omitempty"`
	StatusCode           int32         `protobuf:"varint,4,opt,name=status_code,json=statusCode,proto3" json:"status_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *HTTPRespDatum) Reset()         { *m = HTTPRespDatum{} }
func (m *HTTPRespDatum) String() string { return proto.CompactTextString(m) }
func (*HTTPRespDatum) ProtoMessage()    {}
func (*HTTPRespDatum) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{4}
}
func (m *HTTPRespDatum) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HTTPRespDatum.Unmarshal(m, b)
}
func (m *HTTPRespDatum) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HTTPRespDatum.Marshal(b, m, deterministic)
}
func (dst *HTTPRespDatum) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPRespDatum.Merge(dst, src)
}
func (m *HTTPRespDatum) XXX_Size() int {
	return xxx_messageInfo_HTTPRespDatum.Size(m)
}
func (m *HTTPRespDatum) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPRespDatum.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPRespDatum proto.InternalMessageInfo

func (m *HTTPRespDatum) GetBody() *BlobDatum {
	if m != nil {
		return m.Body
	}
	return nil
}

func (m *HTTPRespDatum) GetHeaders() []*HTTPHeader {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *HTTPRespDatum) GetStatusCode() int32 {
	if m != nil {
		return m.StatusCode
	}
	return 0
}

// EmptyDatum represents a null or empty value
type EmptyDatum struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EmptyDatum) Reset()         { *m = EmptyDatum{} }
func (m *EmptyDatum) String() string { return proto.CompactTextString(m) }
func (*EmptyDatum) ProtoMessage()    {}
func (*EmptyDatum) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{5}
}
func (m *EmptyDatum) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EmptyDatum.Unmarshal(m, b)
}
func (m *EmptyDatum) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EmptyDatum.Marshal(b, m, deterministic)
}
func (dst *EmptyDatum) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EmptyDatum.Merge(dst, src)
}
func (m *EmptyDatum) XXX_Size() int {
	return xxx_messageInfo_EmptyDatum.Size(m)
}
func (m *EmptyDatum) XXX_DiscardUnknown() {
	xxx_messageInfo_EmptyDatum.DiscardUnknown(m)
}

var xxx_messageInfo_EmptyDatum proto.InternalMessageInfo

// StageRefDatum represents a reference to another stage in the graph
type StageRefDatum struct {
	StageId              string   `protobuf:"bytes,1,opt,name=stage_id,json=stageId,proto3" json:"stage_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StageRefDatum) Reset()         { *m = StageRefDatum{} }
func (m *StageRefDatum) String() string { return proto.CompactTextString(m) }
func (*StageRefDatum) ProtoMessage()    {}
func (*StageRefDatum) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{6}
}
func (m *StageRefDatum) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StageRefDatum.Unmarshal(m, b)
}
func (m *StageRefDatum) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StageRefDatum.Marshal(b, m, deterministic)
}
func (dst *StageRefDatum) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StageRefDatum.Merge(dst, src)
}
func (m *StageRefDatum) XXX_Size() int {
	return xxx_messageInfo_StageRefDatum.Size(m)
}
func (m *StageRefDatum) XXX_DiscardUnknown() {
	xxx_messageInfo_StageRefDatum.DiscardUnknown(m)
}

var xxx_messageInfo_StageRefDatum proto.InternalMessageInfo

func (m *StageRefDatum) GetStageId() string {
	if m != nil {
		return m.StageId
	}
	return ""
}

// ErrorDatum represents an error that has occured within a flow graph, the type indicates the cause of the error and the message is informational
type ErrorDatum struct {
	Type                 ErrorDatumType `protobuf:"varint,1,opt,name=type,proto3,enum=model.ErrorDatumType" json:"type,omitempty"`
	Message              string         `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ErrorDatum) Reset()         { *m = ErrorDatum{} }
func (m *ErrorDatum) String() string { return proto.CompactTextString(m) }
func (*ErrorDatum) ProtoMessage()    {}
func (*ErrorDatum) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{7}
}
func (m *ErrorDatum) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ErrorDatum.Unmarshal(m, b)
}
func (m *ErrorDatum) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ErrorDatum.Marshal(b, m, deterministic)
}
func (dst *ErrorDatum) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ErrorDatum.Merge(dst, src)
}
func (m *ErrorDatum) XXX_Size() int {
	return xxx_messageInfo_ErrorDatum.Size(m)
}
func (m *ErrorDatum) XXX_DiscardUnknown() {
	xxx_messageInfo_ErrorDatum.DiscardUnknown(m)
}

var xxx_messageInfo_ErrorDatum proto.InternalMessageInfo

func (m *ErrorDatum) GetType() ErrorDatumType {
	if m != nil {
		return m.Type
	}
	return ErrorDatumType_unknown_error
}

func (m *ErrorDatum) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// StateDatum wraps a description of the state of the graph in a datum
type StatusDatum struct {
	Type                 StatusDatumType `protobuf:"varint,1,opt,name=type,proto3,enum=model.StatusDatumType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *StatusDatum) Reset()         { *m = StatusDatum{} }
func (m *StatusDatum) String() string { return proto.CompactTextString(m) }
func (*StatusDatum) ProtoMessage()    {}
func (*StatusDatum) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{8}
}
func (m *StatusDatum) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StatusDatum.Unmarshal(m, b)
}
func (m *StatusDatum) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StatusDatum.Marshal(b, m, deterministic)
}
func (dst *StatusDatum) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatusDatum.Merge(dst, src)
}
func (m *StatusDatum) XXX_Size() int {
	return xxx_messageInfo_StatusDatum.Size(m)
}
func (m *StatusDatum) XXX_DiscardUnknown() {
	xxx_messageInfo_StatusDatum.DiscardUnknown(m)
}

var xxx_messageInfo_StatusDatum proto.InternalMessageInfo

func (m *StatusDatum) GetType() StatusDatumType {
	if m != nil {
		return m.Type
	}
	return StatusDatumType_unknown_state
}

// Datum encapusulates all possible values that may be associated with a stage in the flow graph
type Datum struct {
	// Types that are valid to be assigned to Val:
	//	*Datum_Empty
	//	*Datum_Blob
	//	*Datum_Error
	//	*Datum_StageRef
	//	*Datum_HttpReq
	//	*Datum_HttpResp
	//	*Datum_Status
	Val                  isDatum_Val `protobuf_oneof:"val"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *Datum) Reset()         { *m = Datum{} }
func (m *Datum) String() string { return proto.CompactTextString(m) }
func (*Datum) ProtoMessage()    {}
func (*Datum) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{9}
}
func (m *Datum) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Datum.Unmarshal(m, b)
}
func (m *Datum) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Datum.Marshal(b, m, deterministic)
}
func (dst *Datum) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Datum.Merge(dst, src)
}
func (m *Datum) XXX_Size() int {
	return xxx_messageInfo_Datum.Size(m)
}
func (m *Datum) XXX_DiscardUnknown() {
	xxx_messageInfo_Datum.DiscardUnknown(m)
}

var xxx_messageInfo_Datum proto.InternalMessageInfo

type isDatum_Val interface {
	isDatum_Val()
}

type Datum_Empty struct {
	Empty *EmptyDatum `protobuf:"bytes,1,opt,name=empty,proto3,oneof"`
}

type Datum_Blob struct {
	Blob *BlobDatum `protobuf:"bytes,2,opt,name=blob,proto3,oneof"`
}

type Datum_Error struct {
	Error *ErrorDatum `protobuf:"bytes,3,opt,name=error,proto3,oneof"`
}

type Datum_StageRef struct {
	StageRef *StageRefDatum `protobuf:"bytes,4,opt,name=stage_ref,json=stageRef,proto3,oneof"`
}

type Datum_HttpReq struct {
	HttpReq *HTTPReqDatum `protobuf:"bytes,5,opt,name=http_req,json=httpReq,proto3,oneof"`
}

type Datum_HttpResp struct {
	HttpResp *HTTPRespDatum `protobuf:"bytes,6,opt,name=http_resp,json=httpResp,proto3,oneof"`
}

type Datum_Status struct {
	Status *StatusDatum `protobuf:"bytes,7,opt,name=status,proto3,oneof"`
}

func (*Datum_Empty) isDatum_Val() {}

func (*Datum_Blob) isDatum_Val() {}

func (*Datum_Error) isDatum_Val() {}

func (*Datum_StageRef) isDatum_Val() {}

func (*Datum_HttpReq) isDatum_Val() {}

func (*Datum_HttpResp) isDatum_Val() {}

func (*Datum_Status) isDatum_Val() {}

func (m *Datum) GetVal() isDatum_Val {
	if m != nil {
		return m.Val
	}
	return nil
}

func (m *Datum) GetEmpty() *EmptyDatum {
	if x, ok := m.GetVal().(*Datum_Empty); ok {
		return x.Empty
	}
	return nil
}

func (m *Datum) GetBlob() *BlobDatum {
	if x, ok := m.GetVal().(*Datum_Blob); ok {
		return x.Blob
	}
	return nil
}

func (m *Datum) GetError() *ErrorDatum {
	if x, ok := m.GetVal().(*Datum_Error); ok {
		return x.Error
	}
	return nil
}

func (m *Datum) GetStageRef() *StageRefDatum {
	if x, ok := m.GetVal().(*Datum_StageRef); ok {
		return x.StageRef
	}
	return nil
}

func (m *Datum) GetHttpReq() *HTTPReqDatum {
	if x, ok := m.GetVal().(*Datum_HttpReq); ok {
		return x.HttpReq
	}
	return nil
}

func (m *Datum) GetHttpResp() *HTTPRespDatum {
	if x, ok := m.GetVal().(*Datum_HttpResp); ok {
		return x.HttpResp
	}
	return nil
}

func (m *Datum) GetStatus() *StatusDatum {
	if x, ok := m.GetVal().(*Datum_Status); ok {
		return x.Status
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Datum) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Datum_OneofMarshaler, _Datum_OneofUnmarshaler, _Datum_OneofSizer, []interface{}{
		(*Datum_Empty)(nil),
		(*Datum_Blob)(nil),
		(*Datum_Error)(nil),
		(*Datum_StageRef)(nil),
		(*Datum_HttpReq)(nil),
		(*Datum_HttpResp)(nil),
		(*Datum_Status)(nil),
	}
}

func _Datum_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Datum)
	// val
	switch x := m.Val.(type) {
	case *Datum_Empty:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Empty); err != nil {
			return err
		}
	case *Datum_Blob:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Blob); err != nil {
			return err
		}
	case *Datum_Error:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Error); err != nil {
			return err
		}
	case *Datum_StageRef:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StageRef); err != nil {
			return err
		}
	case *Datum_HttpReq:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HttpReq); err != nil {
			return err
		}
	case *Datum_HttpResp:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HttpResp); err != nil {
			return err
		}
	case *Datum_Status:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Status); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Datum.Val has unexpected type %T", x)
	}
	return nil
}

func _Datum_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Datum)
	switch tag {
	case 1: // val.empty
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(EmptyDatum)
		err := b.DecodeMessage(msg)
		m.Val = &Datum_Empty{msg}
		return true, err
	case 2: // val.blob
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BlobDatum)
		err := b.DecodeMessage(msg)
		m.Val = &Datum_Blob{msg}
		return true, err
	case 3: // val.error
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ErrorDatum)
		err := b.DecodeMessage(msg)
		m.Val = &Datum_Error{msg}
		return true, err
	case 4: // val.stage_ref
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StageRefDatum)
		err := b.DecodeMessage(msg)
		m.Val = &Datum_StageRef{msg}
		return true, err
	case 5: // val.http_req
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HTTPReqDatum)
		err := b.DecodeMessage(msg)
		m.Val = &Datum_HttpReq{msg}
		return true, err
	case 6: // val.http_resp
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HTTPRespDatum)
		err := b.DecodeMessage(msg)
		m.Val = &Datum_HttpResp{msg}
		return true, err
	case 7: // val.status
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StatusDatum)
		err := b.DecodeMessage(msg)
		m.Val = &Datum_Status{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Datum_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Datum)
	// val
	switch x := m.Val.(type) {
	case *Datum_Empty:
		s := proto.Size(x.Empty)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Datum_Blob:
		s := proto.Size(x.Blob)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Datum_Error:
		s := proto.Size(x.Error)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Datum_StageRef:
		s := proto.Size(x.StageRef)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Datum_HttpReq:
		s := proto.Size(x.HttpReq)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Datum_HttpResp:
		s := proto.Size(x.HttpResp)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Datum_Status:
		s := proto.Size(x.Status)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// AddStageRequest adds a new stage with dependenencies to the graph
type AddStageRequest struct {
	FlowId               string              `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	Operation            CompletionOperation `protobuf:"varint,2,opt,name=operation,proto3,enum=model.CompletionOperation" json:"operation,omitempty"`
	Closure              *BlobDatum          `protobuf:"bytes,3,opt,name=closure,proto3" json:"closure,omitempty"`
	Deps                 []string            `protobuf:"bytes,4,rep,name=deps,proto3" json:"deps,omitempty"`
	CodeLocation         string              `protobuf:"bytes,5,opt,name=code_location,json=codeLocation,proto3" json:"code_location,omitempty"`
	CallerId             string              `protobuf:"bytes,6,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *AddStageRequest) Reset()         { *m = AddStageRequest{} }
func (m *AddStageRequest) String() string { return proto.CompactTextString(m) }
func (*AddStageRequest) ProtoMessage()    {}
func (*AddStageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{10}
}
func (m *AddStageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddStageRequest.Unmarshal(m, b)
}
func (m *AddStageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddStageRequest.Marshal(b, m, deterministic)
}
func (dst *AddStageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddStageRequest.Merge(dst, src)
}
func (m *AddStageRequest) XXX_Size() int {
	return xxx_messageInfo_AddStageRequest.Size(m)
}
func (m *AddStageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddStageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddStageRequest proto.InternalMessageInfo

func (m *AddStageRequest) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

func (m *AddStageRequest) GetOperation() CompletionOperation {
	if m != nil {
		return m.Operation
	}
	return CompletionOperation_unknown_operation
}

func (m *AddStageRequest) GetClosure() *BlobDatum {
	if m != nil {
		return m.Closure
	}
	return nil
}

func (m *AddStageRequest) GetDeps() []string {
	if m != nil {
		return m.Deps
	}
	return nil
}

func (m *AddStageRequest) GetCodeLocation() string {
	if m != nil {
		return m.CodeLocation
	}
	return ""
}

func (m *AddStageRequest) GetCallerId() string {
	if m != nil {
		return m.CallerId
	}
	return ""
}

// CompleteStageExternallyRequest marks an existing stage as complete with a specific value
type CompleteStageExternallyRequest struct {
	FlowId               string            `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	StageId              string            `protobuf:"bytes,2,opt,name=stage_id,json=stageId,proto3" json:"stage_id,omitempty"`
	Value                *CompletionResult `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	CodeLocation         string            `protobuf:"bytes,4,opt,name=code_location,json=codeLocation,proto3" json:"code_location,omitempty"`
	CallerId             string            `protobuf:"bytes,5,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CompleteStageExternallyRequest) Reset()         { *m = CompleteStageExternallyRequest{} }
func (m *CompleteStageExternallyRequest) String() string { return proto.CompactTextString(m) }
func (*CompleteStageExternallyRequest) ProtoMessage()    {}
func (*CompleteStageExternallyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{11}
}
func (m *CompleteStageExternallyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CompleteStageExternallyRequest.Unmarshal(m, b)
}
func (m *CompleteStageExternallyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CompleteStageExternallyRequest.Marshal(b, m, deterministic)
}
func (dst *CompleteStageExternallyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompleteStageExternallyRequest.Merge(dst, src)
}
func (m *CompleteStageExternallyRequest) XXX_Size() int {
	return xxx_messageInfo_CompleteStageExternallyRequest.Size(m)
}
func (m *CompleteStageExternallyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CompleteStageExternallyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CompleteStageExternallyRequest proto.InternalMessageInfo

func (m *CompleteStageExternallyRequest) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

func (m *CompleteStageExternallyRequest) GetStageId() string {
	if m != nil {
		return m.StageId
	}
	return ""
}

func (m *CompleteStageExternallyRequest) GetValue() *CompletionResult {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *CompleteStageExternallyRequest) GetCodeLocation() string {
	if m != nil {
		return m.CodeLocation
	}
	return ""
}

func (m *CompleteStageExternallyRequest) GetCallerId() string {
	if m != nil {
		return m.CallerId
	}
	return ""
}

// AddCompletedValueStageRequest creates a new stage with a specific value
type AddCompletedValueStageRequest struct {
	FlowId               string            `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	Value                *CompletionResult `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	CodeLocation         string            `protobuf:"bytes,3,opt,name=code_location,json=codeLocation,proto3" json:"code_location,omitempty"`
	CallerId             string            `protobuf:"bytes,4,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *AddCompletedValueStageRequest) Reset()         { *m = AddCompletedValueStageRequest{} }
func (m *AddCompletedValueStageRequest) String() string { return proto.CompactTextString(m) }
func (*AddCompletedValueStageRequest) ProtoMessage()    {}
func (*AddCompletedValueStageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{12}
}
func (m *AddCompletedValueStageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddCompletedValueStageRequest.Unmarshal(m, b)
}
func (m *AddCompletedValueStageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddCompletedValueStageRequest.Marshal(b, m, deterministic)
}
func (dst *AddCompletedValueStageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddCompletedValueStageRequest.Merge(dst, src)
}
func (m *AddCompletedValueStageRequest) XXX_Size() int {
	return xxx_messageInfo_AddCompletedValueStageRequest.Size(m)
}
func (m *AddCompletedValueStageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddCompletedValueStageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddCompletedValueStageRequest proto.InternalMessageInfo

func (m *AddCompletedValueStageRequest) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

func (m *AddCompletedValueStageRequest) GetValue() *CompletionResult {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *AddCompletedValueStageRequest) GetCodeLocation() string {
	if m != nil {
		return m.CodeLocation
	}
	return ""
}

func (m *AddCompletedValueStageRequest) GetCallerId() string {
	if m != nil {
		return m.CallerId
	}
	return ""
}

// AddDelayStageRequest creates a delay stage
type AddDelayStageRequest struct {
	FlowId               string   `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	DelayMs              int64    `protobuf:"varint,2,opt,name=delay_ms,json=delayMs,proto3" json:"delay_ms,omitempty"`
	CodeLocation         string   `protobuf:"bytes,3,opt,name=code_location,json=codeLocation,proto3" json:"code_location,omitempty"`
	CallerId             string   `protobuf:"bytes,4,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddDelayStageRequest) Reset()         { *m = AddDelayStageRequest{} }
func (m *AddDelayStageRequest) String() string { return proto.CompactTextString(m) }
func (*AddDelayStageRequest) ProtoMessage()    {}
func (*AddDelayStageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{13}
}
func (m *AddDelayStageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddDelayStageRequest.Unmarshal(m, b)
}
func (m *AddDelayStageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddDelayStageRequest.Marshal(b, m, deterministic)
}
func (dst *AddDelayStageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddDelayStageRequest.Merge(dst, src)
}
func (m *AddDelayStageRequest) XXX_Size() int {
	return xxx_messageInfo_AddDelayStageRequest.Size(m)
}
func (m *AddDelayStageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddDelayStageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddDelayStageRequest proto.InternalMessageInfo

func (m *AddDelayStageRequest) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

func (m *AddDelayStageRequest) GetDelayMs() int64 {
	if m != nil {
		return m.DelayMs
	}
	return 0
}

func (m *AddDelayStageRequest) GetCodeLocation() string {
	if m != nil {
		return m.CodeLocation
	}
	return ""
}

func (m *AddDelayStageRequest) GetCallerId() string {
	if m != nil {
		return m.CallerId
	}
	return ""
}

// AddInvokeFunctionStageRequest adds a function invocation
type AddInvokeFunctionStageRequest struct {
	FlowId               string        `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	FunctionId           string        `protobuf:"bytes,2,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
	Arg                  *HTTPReqDatum `protobuf:"bytes,3,opt,name=arg,proto3" json:"arg,omitempty"`
	CodeLocation         string        `protobuf:"bytes,4,opt,name=code_location,json=codeLocation,proto3" json:"code_location,omitempty"`
	CallerId             string        `protobuf:"bytes,5,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *AddInvokeFunctionStageRequest) Reset()         { *m = AddInvokeFunctionStageRequest{} }
func (m *AddInvokeFunctionStageRequest) String() string { return proto.CompactTextString(m) }
func (*AddInvokeFunctionStageRequest) ProtoMessage()    {}
func (*AddInvokeFunctionStageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{14}
}
func (m *AddInvokeFunctionStageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddInvokeFunctionStageRequest.Unmarshal(m, b)
}
func (m *AddInvokeFunctionStageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddInvokeFunctionStageRequest.Marshal(b, m, deterministic)
}
func (dst *AddInvokeFunctionStageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddInvokeFunctionStageRequest.Merge(dst, src)
}
func (m *AddInvokeFunctionStageRequest) XXX_Size() int {
	return xxx_messageInfo_AddInvokeFunctionStageRequest.Size(m)
}
func (m *AddInvokeFunctionStageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddInvokeFunctionStageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddInvokeFunctionStageRequest proto.InternalMessageInfo

func (m *AddInvokeFunctionStageRequest) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

func (m *AddInvokeFunctionStageRequest) GetFunctionId() string {
	if m != nil {
		return m.FunctionId
	}
	return ""
}

func (m *AddInvokeFunctionStageRequest) GetArg() *HTTPReqDatum {
	if m != nil {
		return m.Arg
	}
	return nil
}

func (m *AddInvokeFunctionStageRequest) GetCodeLocation() string {
	if m != nil {
		return m.CodeLocation
	}
	return ""
}

func (m *AddInvokeFunctionStageRequest) GetCallerId() string {
	if m != nil {
		return m.CallerId
	}
	return ""
}

// AddStageResponse returns the stage ID of the created stage
type AddStageResponse struct {
	FlowId               string   `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	StageId              string   `protobuf:"bytes,2,opt,name=stage_id,json=stageId,proto3" json:"stage_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddStageResponse) Reset()         { *m = AddStageResponse{} }
func (m *AddStageResponse) String() string { return proto.CompactTextString(m) }
func (*AddStageResponse) ProtoMessage()    {}
func (*AddStageResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{15}
}
func (m *AddStageResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddStageResponse.Unmarshal(m, b)
}
func (m *AddStageResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddStageResponse.Marshal(b, m, deterministic)
}
func (dst *AddStageResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddStageResponse.Merge(dst, src)
}
func (m *AddStageResponse) XXX_Size() int {
	return xxx_messageInfo_AddStageResponse.Size(m)
}
func (m *AddStageResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AddStageResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AddStageResponse proto.InternalMessageInfo

func (m *AddStageResponse) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

func (m *AddStageResponse) GetStageId() string {
	if m != nil {
		return m.StageId
	}
	return ""
}

type CommitGraphRequest struct {
	FlowId               string   `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommitGraphRequest) Reset()         { *m = CommitGraphRequest{} }
func (m *CommitGraphRequest) String() string { return proto.CompactTextString(m) }
func (*CommitGraphRequest) ProtoMessage()    {}
func (*CommitGraphRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{16}
}
func (m *CommitGraphRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitGraphRequest.Unmarshal(m, b)
}
func (m *CommitGraphRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitGraphRequest.Marshal(b, m, deterministic)
}
func (dst *CommitGraphRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitGraphRequest.Merge(dst, src)
}
func (m *CommitGraphRequest) XXX_Size() int {
	return xxx_messageInfo_CommitGraphRequest.Size(m)
}
func (m *CommitGraphRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitGraphRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CommitGraphRequest proto.InternalMessageInfo

func (m *CommitGraphRequest) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

type GraphRequestProcessedResponse struct {
	FlowId               string   `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GraphRequestProcessedResponse) Reset()         { *m = GraphRequestProcessedResponse{} }
func (m *GraphRequestProcessedResponse) String() string { return proto.CompactTextString(m) }
func (*GraphRequestProcessedResponse) ProtoMessage()    {}
func (*GraphRequestProcessedResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{17}
}
func (m *GraphRequestProcessedResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GraphRequestProcessedResponse.Unmarshal(m, b)
}
func (m *GraphRequestProcessedResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GraphRequestProcessedResponse.Marshal(b, m, deterministic)
}
func (dst *GraphRequestProcessedResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GraphRequestProcessedResponse.Merge(dst, src)
}
func (m *GraphRequestProcessedResponse) XXX_Size() int {
	return xxx_messageInfo_GraphRequestProcessedResponse.Size(m)
}
func (m *GraphRequestProcessedResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GraphRequestProcessedResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GraphRequestProcessedResponse proto.InternalMessageInfo

func (m *GraphRequestProcessedResponse) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

type CompleteDelayStageRequest struct {
	FlowId               string            `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	StageId              string            `protobuf:"bytes,2,opt,name=stage_id,json=stageId,proto3" json:"stage_id,omitempty"`
	Result               *CompletionResult `protobuf:"bytes,3,opt,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CompleteDelayStageRequest) Reset()         { *m = CompleteDelayStageRequest{} }
func (m *CompleteDelayStageRequest) String() string { return proto.CompactTextString(m) }
func (*CompleteDelayStageRequest) ProtoMessage()    {}
func (*CompleteDelayStageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{18}
}
func (m *CompleteDelayStageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CompleteDelayStageRequest.Unmarshal(m, b)
}
func (m *CompleteDelayStageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CompleteDelayStageRequest.Marshal(b, m, deterministic)
}
func (dst *CompleteDelayStageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompleteDelayStageRequest.Merge(dst, src)
}
func (m *CompleteDelayStageRequest) XXX_Size() int {
	return xxx_messageInfo_CompleteDelayStageRequest.Size(m)
}
func (m *CompleteDelayStageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CompleteDelayStageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CompleteDelayStageRequest proto.InternalMessageInfo

func (m *CompleteDelayStageRequest) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

func (m *CompleteDelayStageRequest) GetStageId() string {
	if m != nil {
		return m.StageId
	}
	return ""
}

func (m *CompleteDelayStageRequest) GetResult() *CompletionResult {
	if m != nil {
		return m.Result
	}
	return nil
}

type CompleteStageExternallyResponse struct {
	FlowId               string   `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	StageId              string   `protobuf:"bytes,2,opt,name=stage_id,json=stageId,proto3" json:"stage_id,omitempty"`
	Successful           bool     `protobuf:"varint,3,opt,name=successful,proto3" json:"successful,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CompleteStageExternallyResponse) Reset()         { *m = CompleteStageExternallyResponse{} }
func (m *CompleteStageExternallyResponse) String() string { return proto.CompactTextString(m) }
func (*CompleteStageExternallyResponse) ProtoMessage()    {}
func (*CompleteStageExternallyResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{19}
}
func (m *CompleteStageExternallyResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CompleteStageExternallyResponse.Unmarshal(m, b)
}
func (m *CompleteStageExternallyResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CompleteStageExternallyResponse.Marshal(b, m, deterministic)
}
func (dst *CompleteStageExternallyResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompleteStageExternallyResponse.Merge(dst, src)
}
func (m *CompleteStageExternallyResponse) XXX_Size() int {
	return xxx_messageInfo_CompleteStageExternallyResponse.Size(m)
}
func (m *CompleteStageExternallyResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CompleteStageExternallyResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CompleteStageExternallyResponse proto.InternalMessageInfo

func (m *CompleteStageExternallyResponse) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

func (m *CompleteStageExternallyResponse) GetStageId() string {
	if m != nil {
		return m.StageId
	}
	return ""
}

func (m *CompleteStageExternallyResponse) GetSuccessful() bool {
	if m != nil {
		return m.Successful
	}
	return false
}

type DeactivateGraphRequest struct {
	FlowId               string   `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeactivateGraphRequest) Reset()         { *m = DeactivateGraphRequest{} }
func (m *DeactivateGraphRequest) String() string { return proto.CompactTextString(m) }
func (*DeactivateGraphRequest) ProtoMessage()    {}
func (*DeactivateGraphRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{20}
}
func (m *DeactivateGraphRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeactivateGraphRequest.Unmarshal(m, b)
}
func (m *DeactivateGraphRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeactivateGraphRequest.Marshal(b, m, deterministic)
}
func (dst *DeactivateGraphRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeactivateGraphRequest.Merge(dst, src)
}
func (m *DeactivateGraphRequest) XXX_Size() int {
	return xxx_messageInfo_DeactivateGraphRequest.Size(m)
}
func (m *DeactivateGraphRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeactivateGraphRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeactivateGraphRequest proto.InternalMessageInfo

func (m *DeactivateGraphRequest) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

type CreateGraphRequest struct {
	FunctionId           string   `protobuf:"bytes,1,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
	FlowId               string   `protobuf:"bytes,2,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateGraphRequest) Reset()         { *m = CreateGraphRequest{} }
func (m *CreateGraphRequest) String() string { return proto.CompactTextString(m) }
func (*CreateGraphRequest) ProtoMessage()    {}
func (*CreateGraphRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{21}
}
func (m *CreateGraphRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateGraphRequest.Unmarshal(m, b)
}
func (m *CreateGraphRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateGraphRequest.Marshal(b, m, deterministic)
}
func (dst *CreateGraphRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateGraphRequest.Merge(dst, src)
}
func (m *CreateGraphRequest) XXX_Size() int {
	return xxx_messageInfo_CreateGraphRequest.Size(m)
}
func (m *CreateGraphRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateGraphRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateGraphRequest proto.InternalMessageInfo

func (m *CreateGraphRequest) GetFunctionId() string {
	if m != nil {
		return m.FunctionId
	}
	return ""
}

func (m *CreateGraphRequest) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

type CreateGraphResponse struct {
	FlowId               string   `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateGraphResponse) Reset()         { *m = CreateGraphResponse{} }
func (m *CreateGraphResponse) String() string { return proto.CompactTextString(m) }
func (*CreateGraphResponse) ProtoMessage()    {}
func (*CreateGraphResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{22}
}
func (m *CreateGraphResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateGraphResponse.Unmarshal(m, b)
}
func (m *CreateGraphResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateGraphResponse.Marshal(b, m, deterministic)
}
func (dst *CreateGraphResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateGraphResponse.Merge(dst, src)
}
func (m *CreateGraphResponse) XXX_Size() int {
	return xxx_messageInfo_CreateGraphResponse.Size(m)
}
func (m *CreateGraphResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateGraphResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CreateGraphResponse proto.InternalMessageInfo

func (m *CreateGraphResponse) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

type FaasInvocationResponse struct {
	FlowId               string            `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	StageId              string            `protobuf:"bytes,2,opt,name=stage_id,json=stageId,proto3" json:"stage_id,omitempty"`
	FunctionId           string            `protobuf:"bytes,3,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
	Result               *CompletionResult `protobuf:"bytes,4,opt,name=result,proto3" json:"result,omitempty"`
	CallId               string            `protobuf:"bytes,5,opt,name=call_id,json=callId,proto3" json:"call_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *FaasInvocationResponse) Reset()         { *m = FaasInvocationResponse{} }
func (m *FaasInvocationResponse) String() string { return proto.CompactTextString(m) }
func (*FaasInvocationResponse) ProtoMessage()    {}
func (*FaasInvocationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{23}
}
func (m *FaasInvocationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaasInvocationResponse.Unmarshal(m, b)
}
func (m *FaasInvocationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaasInvocationResponse.Marshal(b, m, deterministic)
}
func (dst *FaasInvocationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaasInvocationResponse.Merge(dst, src)
}
func (m *FaasInvocationResponse) XXX_Size() int {
	return xxx_messageInfo_FaasInvocationResponse.Size(m)
}
func (m *FaasInvocationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_FaasInvocationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_FaasInvocationResponse proto.InternalMessageInfo

func (m *FaasInvocationResponse) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

func (m *FaasInvocationResponse) GetStageId() string {
	if m != nil {
		return m.StageId
	}
	return ""
}

func (m *FaasInvocationResponse) GetFunctionId() string {
	if m != nil {
		return m.FunctionId
	}
	return ""
}

func (m *FaasInvocationResponse) GetResult() *CompletionResult {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *FaasInvocationResponse) GetCallId() string {
	if m != nil {
		return m.CallId
	}
	return ""
}

type GetGraphStateRequest struct {
	FlowId               string   `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetGraphStateRequest) Reset()         { *m = GetGraphStateRequest{} }
func (m *GetGraphStateRequest) String() string { return proto.CompactTextString(m) }
func (*GetGraphStateRequest) ProtoMessage()    {}
func (*GetGraphStateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{24}
}
func (m *GetGraphStateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetGraphStateRequest.Unmarshal(m, b)
}
func (m *GetGraphStateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetGraphStateRequest.Marshal(b, m, deterministic)
}
func (dst *GetGraphStateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetGraphStateRequest.Merge(dst, src)
}
func (m *GetGraphStateRequest) XXX_Size() int {
	return xxx_messageInfo_GetGraphStateRequest.Size(m)
}
func (m *GetGraphStateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetGraphStateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetGraphStateRequest proto.InternalMessageInfo

func (m *GetGraphStateRequest) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

type GetGraphStateResponse struct {
	Stages               map[string]*GetGraphStateResponse_StageRepresentation `protobuf:"bytes,1,rep,name=stages,proto3" json:"stages,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	FunctionId           string                                                `protobuf:"bytes,2,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
	FlowId               string                                                `protobuf:"bytes,3,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                              `json:"-"`
	XXX_unrecognized     []byte                                                `json:"-"`
	XXX_sizecache        int32                                                 `json:"-"`
}

func (m *GetGraphStateResponse) Reset()         { *m = GetGraphStateResponse{} }
func (m *GetGraphStateResponse) String() string { return proto.CompactTextString(m) }
func (*GetGraphStateResponse) ProtoMessage()    {}
func (*GetGraphStateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{25}
}
func (m *GetGraphStateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetGraphStateResponse.Unmarshal(m, b)
}
func (m *GetGraphStateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetGraphStateResponse.Marshal(b, m, deterministic)
}
func (dst *GetGraphStateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetGraphStateResponse.Merge(dst, src)
}
func (m *GetGraphStateResponse) XXX_Size() int {
	return xxx_messageInfo_GetGraphStateResponse.Size(m)
}
func (m *GetGraphStateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetGraphStateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetGraphStateResponse proto.InternalMessageInfo

func (m *GetGraphStateResponse) GetStages() map[string]*GetGraphStateResponse_StageRepresentation {
	if m != nil {
		return m.Stages
	}
	return nil
}

func (m *GetGraphStateResponse) GetFunctionId() string {
	if m != nil {
		return m.FunctionId
	}
	return ""
}

func (m *GetGraphStateResponse) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

type GetGraphStateResponse_StageRepresentation struct {
	Type                 string   `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Status               string   `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	Dependencies         []string `protobuf:"bytes,3,rep,name=dependencies,proto3" json:"dependencies,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetGraphStateResponse_StageRepresentation) Reset() {
	*m = GetGraphStateResponse_StageRepresentation{}
}
func (m *GetGraphStateResponse_StageRepresentation) String() string { return proto.CompactTextString(m) }
func (*GetGraphStateResponse_StageRepresentation) ProtoMessage()    {}
func (*GetGraphStateResponse_StageRepresentation) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{25, 0}
}
func (m *GetGraphStateResponse_StageRepresentation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetGraphStateResponse_StageRepresentation.Unmarshal(m, b)
}
func (m *GetGraphStateResponse_StageRepresentation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetGraphStateResponse_StageRepresentation.Marshal(b, m, deterministic)
}
func (dst *GetGraphStateResponse_StageRepresentation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetGraphStateResponse_StageRepresentation.Merge(dst, src)
}
func (m *GetGraphStateResponse_StageRepresentation) XXX_Size() int {
	return xxx_messageInfo_GetGraphStateResponse_StageRepresentation.Size(m)
}
func (m *GetGraphStateResponse_StageRepresentation) XXX_DiscardUnknown() {
	xxx_messageInfo_GetGraphStateResponse_StageRepresentation.DiscardUnknown(m)
}

var xxx_messageInfo_GetGraphStateResponse_StageRepresentation proto.InternalMessageInfo

func (m *GetGraphStateResponse_StageRepresentation) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *GetGraphStateResponse_StageRepresentation) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *GetGraphStateResponse_StageRepresentation) GetDependencies() []string {
	if m != nil {
		return m.Dependencies
	}
	return nil
}

type ListGraphsRequest struct {
	Filter               ListGraphsFilter `protobuf:"varint,1,opt,name=filter,proto3,enum=model.ListGraphsFilter" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ListGraphsRequest) Reset()         { *m = ListGraphsRequest{} }
func (m *ListGraphsRequest) String() string { return proto.CompactTextString(m) }
func (*ListGraphsRequest) ProtoMessage()    {}
func (*ListGraphsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{26}
}
func (m *ListGraphsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListGraphsRequest.Unmarshal(m, b)
}
func (m *ListGraphsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListGraphsRequest.Marshal(b, m, deterministic)
}
func (dst *ListGraphsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListGraphsRequest.Merge(dst, src)
}
func (m *ListGraphsRequest) XXX_Size() int {
	return xxx_messageInfo_ListGraphsRequest.Size(m)
}
func (m *ListGraphsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListGraphsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListGraphsRequest proto.InternalMessageInfo

func (m *ListGraphsRequest) GetFilter() ListGraphsFilter {
	if m != nil {
		return m.Filter
	}
	return ListGraphsFilter_unknown
}

type StreamLifecycleRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamLifecycleRequest) Reset()         { *m = StreamLifecycleRequest{} }
func (m *StreamLifecycleRequest) String() string { return proto.CompactTextString(m) }
func (*StreamLifecycleRequest) ProtoMessage()    {}
func (*StreamLifecycleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{27}
}
func (m *StreamLifecycleRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamLifecycleRequest.Unmarshal(m, b)
}
func (m *StreamLifecycleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamLifecycleRequest.Marshal(b, m, deterministic)
}
func (dst *StreamLifecycleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamLifecycleRequest.Merge(dst, src)
}
func (m *StreamLifecycleRequest) XXX_Size() int {
	return xxx_messageInfo_StreamLifecycleRequest.Size(m)
}
func (m *StreamLifecycleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamLifecycleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamLifecycleRequest proto.InternalMessageInfo

type StreamGraphRequest struct {
	FlowId               string   `protobuf:"bytes,2,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	FromSeq              uint64   `protobuf:"varint,3,opt,name=from_seq,json=fromSeq,proto3" json:"from_seq,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamGraphRequest) Reset()         { *m = StreamGraphRequest{} }
func (m *StreamGraphRequest) String() string { return proto.CompactTextString(m) }
func (*StreamGraphRequest) ProtoMessage()    {}
func (*StreamGraphRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{28}
}
func (m *StreamGraphRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamGraphRequest.Unmarshal(m, b)
}
func (m *StreamGraphRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamGraphRequest.Marshal(b, m, deterministic)
}
func (dst *StreamGraphRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamGraphRequest.Merge(dst, src)
}
func (m *StreamGraphRequest) XXX_Size() int {
	return xxx_messageInfo_StreamGraphRequest.Size(m)
}
func (m *StreamGraphRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamGraphRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamGraphRequest proto.InternalMessageInfo

func (m *StreamGraphRequest) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

func (m *StreamGraphRequest) GetFromSeq() uint64 {
	if m != nil {
		return m.FromSeq
	}
	return 0
}

type ListGraphResponse struct {
	FlowId               string   `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListGraphResponse) Reset()         { *m = ListGraphResponse{} }
func (m *ListGraphResponse) String() string { return proto.CompactTextString(m) }
func (*ListGraphResponse) ProtoMessage()    {}
func (*ListGraphResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{29}
}
func (m *ListGraphResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListGraphResponse.Unmarshal(m, b)
}
func (m *ListGraphResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListGraphResponse.Marshal(b, m, deterministic)
}
func (dst *ListGraphResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListGraphResponse.Merge(dst, src)
}
func (m *ListGraphResponse) XXX_Size() int {
	return xxx_messageInfo_ListGraphResponse.Size(m)
}
func (m *ListGraphResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListGraphResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListGraphResponse proto.InternalMessageInfo

func (m *ListGraphResponse) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

type ListGraphsResponse struct {
	Graphs               []*ListGraphResponse `protobuf:"bytes,1,rep,name=graphs,proto3" json:"graphs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ListGraphsResponse) Reset()         { *m = ListGraphsResponse{} }
func (m *ListGraphsResponse) String() string { return proto.CompactTextString(m) }
func (*ListGraphsResponse) ProtoMessage()    {}
func (*ListGraphsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{30}
}
func (m *ListGraphsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListGraphsResponse.Unmarshal(m, b)
}
func (m *ListGraphsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListGraphsResponse.Marshal(b, m, deterministic)
}
func (dst *ListGraphsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListGraphsResponse.Merge(dst, src)
}
func (m *ListGraphsResponse) XXX_Size() int {
	return xxx_messageInfo_ListGraphsResponse.Size(m)
}
func (m *ListGraphsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListGraphsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListGraphsResponse proto.InternalMessageInfo

func (m *ListGraphsResponse) GetGraphs() []*ListGraphResponse {
	if m != nil {
		return m.Graphs
	}
	return nil
}

type AwaitStageResultRequest struct {
	FlowId               string   `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	StageId              string   `protobuf:"bytes,2,opt,name=stage_id,json=stageId,proto3" json:"stage_id,omitempty"`
	TimeoutMs            int32    `protobuf:"varint,3,opt,name=timeout_ms,json=timeoutMs,proto3" json:"timeout_ms,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AwaitStageResultRequest) Reset()         { *m = AwaitStageResultRequest{} }
func (m *AwaitStageResultRequest) String() string { return proto.CompactTextString(m) }
func (*AwaitStageResultRequest) ProtoMessage()    {}
func (*AwaitStageResultRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{31}
}
func (m *AwaitStageResultRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AwaitStageResultRequest.Unmarshal(m, b)
}
func (m *AwaitStageResultRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AwaitStageResultRequest.Marshal(b, m, deterministic)
}
func (dst *AwaitStageResultRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AwaitStageResultRequest.Merge(dst, src)
}
func (m *AwaitStageResultRequest) XXX_Size() int {
	return xxx_messageInfo_AwaitStageResultRequest.Size(m)
}
func (m *AwaitStageResultRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AwaitStageResultRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AwaitStageResultRequest proto.InternalMessageInfo

func (m *AwaitStageResultRequest) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

func (m *AwaitStageResultRequest) GetStageId() string {
	if m != nil {
		return m.StageId
	}
	return ""
}

func (m *AwaitStageResultRequest) GetTimeoutMs() int32 {
	if m != nil {
		return m.TimeoutMs
	}
	return 0
}

type AwaitStageResultResponse struct {
	FlowId               string            `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	StageId              string            `protobuf:"bytes,2,opt,name=stage_id,json=stageId,proto3" json:"stage_id,omitempty"`
	Result               *CompletionResult `protobuf:"bytes,3,opt,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *AwaitStageResultResponse) Reset()         { *m = AwaitStageResultResponse{} }
func (m *AwaitStageResultResponse) String() string { return proto.CompactTextString(m) }
func (*AwaitStageResultResponse) ProtoMessage()    {}
func (*AwaitStageResultResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{32}
}
func (m *AwaitStageResultResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AwaitStageResultResponse.Unmarshal(m, b)
}
func (m *AwaitStageResultResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AwaitStageResultResponse.Marshal(b, m, deterministic)
}
func (dst *AwaitStageResultResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AwaitStageResultResponse.Merge(dst, src)
}
func (m *AwaitStageResultResponse) XXX_Size() int {
	return xxx_messageInfo_AwaitStageResultResponse.Size(m)
}
func (m *AwaitStageResultResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AwaitStageResultResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AwaitStageResultResponse proto.InternalMessageInfo

func (m *AwaitStageResultResponse) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

func (m *AwaitStageResultResponse) GetStageId() string {
	if m != nil {
		return m.StageId
	}
	return ""
}

func (m *AwaitStageResultResponse) GetResult() *CompletionResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// Invoke commands
type InvokeFunctionRequest struct {
	FlowId               string        `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	StageId              string        `protobuf:"bytes,2,opt,name=stage_id,json=stageId,proto3" json:"stage_id,omitempty"`
	FunctionId           string        `protobuf:"bytes,3,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
	Arg                  *HTTPReqDatum `protobuf:"bytes,4,opt,name=arg,proto3" json:"arg,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *InvokeFunctionRequest) Reset()         { *m = InvokeFunctionRequest{} }
func (m *InvokeFunctionRequest) String() string { return proto.CompactTextString(m) }
func (*InvokeFunctionRequest) ProtoMessage()    {}
func (*InvokeFunctionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{33}
}
func (m *InvokeFunctionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InvokeFunctionRequest.Unmarshal(m, b)
}
func (m *InvokeFunctionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InvokeFunctionRequest.Marshal(b, m, deterministic)
}
func (dst *InvokeFunctionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InvokeFunctionRequest.Merge(dst, src)
}
func (m *InvokeFunctionRequest) XXX_Size() int {
	return xxx_messageInfo_InvokeFunctionRequest.Size(m)
}
func (m *InvokeFunctionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InvokeFunctionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InvokeFunctionRequest proto.InternalMessageInfo

func (m *InvokeFunctionRequest) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

func (m *InvokeFunctionRequest) GetStageId() string {
	if m != nil {
		return m.StageId
	}
	return ""
}

func (m *InvokeFunctionRequest) GetFunctionId() string {
	if m != nil {
		return m.FunctionId
	}
	return ""
}

func (m *InvokeFunctionRequest) GetArg() *HTTPReqDatum {
	if m != nil {
		return m.Arg
	}
	return nil
}

type InvokeStageRequest struct {
	FlowId               string              `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	StageId              string              `protobuf:"bytes,2,opt,name=stage_id,json=stageId,proto3" json:"stage_id,omitempty"`
	FunctionId           string              `protobuf:"bytes,3,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
	Args                 []*CompletionResult `protobuf:"bytes,5,rep,name=args,proto3" json:"args,omitempty"`
	Closure              *BlobDatum          `protobuf:"bytes,6,opt,name=closure,proto3" json:"closure,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *InvokeStageRequest) Reset()         { *m = InvokeStageRequest{} }
func (m *InvokeStageRequest) String() string { return proto.CompactTextString(m) }
func (*InvokeStageRequest) ProtoMessage()    {}
func (*InvokeStageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{34}
}
func (m *InvokeStageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InvokeStageRequest.Unmarshal(m, b)
}
func (m *InvokeStageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InvokeStageRequest.Marshal(b, m, deterministic)
}
func (dst *InvokeStageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InvokeStageRequest.Merge(dst, src)
}
func (m *InvokeStageRequest) XXX_Size() int {
	return xxx_messageInfo_InvokeStageRequest.Size(m)
}
func (m *InvokeStageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InvokeStageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InvokeStageRequest proto.InternalMessageInfo

func (m *InvokeStageRequest) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

func (m *InvokeStageRequest) GetStageId() string {
	if m != nil {
		return m.StageId
	}
	return ""
}

func (m *InvokeStageRequest) GetFunctionId() string {
	if m != nil {
		return m.FunctionId
	}
	return ""
}

func (m *InvokeStageRequest) GetArgs() []*CompletionResult {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *InvokeStageRequest) GetClosure() *BlobDatum {
	if m != nil {
		return m.Closure
	}
	return nil
}

type GraphLifecycleEvent struct {
	Seq    uint64 `protobuf:"varint,1,opt,name=seq,proto3" json:"seq,omitempty"`
	FlowId string `protobuf:"bytes,2,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	// Types that are valid to be assigned to Val:
	//	*GraphLifecycleEvent_GraphCreated
	//	*GraphLifecycleEvent_GraphCompleted
	Val                  isGraphLifecycleEvent_Val `protobuf_oneof:"val"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *GraphLifecycleEvent) Reset()         { *m = GraphLifecycleEvent{} }
func (m *GraphLifecycleEvent) String() string { return proto.CompactTextString(m) }
func (*GraphLifecycleEvent) ProtoMessage()    {}
func (*GraphLifecycleEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{35}
}
func (m *GraphLifecycleEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GraphLifecycleEvent.Unmarshal(m, b)
}
func (m *GraphLifecycleEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GraphLifecycleEvent.Marshal(b, m, deterministic)
}
func (dst *GraphLifecycleEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GraphLifecycleEvent.Merge(dst, src)
}
func (m *GraphLifecycleEvent) XXX_Size() int {
	return xxx_messageInfo_GraphLifecycleEvent.Size(m)
}
func (m *GraphLifecycleEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_GraphLifecycleEvent.DiscardUnknown(m)
}

var xxx_messageInfo_GraphLifecycleEvent proto.InternalMessageInfo

func (m *GraphLifecycleEvent) GetSeq() uint64 {
	if m != nil {
		return m.Seq
	}
	return 0
}

func (m *GraphLifecycleEvent) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

type isGraphLifecycleEvent_Val interface {
	isGraphLifecycleEvent_Val()
}

type GraphLifecycleEvent_GraphCreated struct {
	GraphCreated *GraphCreatedEvent `protobuf:"bytes,10,opt,name=graph_created,json=graphCreated,proto3,oneof"`
}

type GraphLifecycleEvent_GraphCompleted struct {
	GraphCompleted *GraphCompletedEvent `protobuf:"bytes,12,opt,name=graph_completed,json=graphCompleted,proto3,oneof"`
}

func (*GraphLifecycleEvent_GraphCreated) isGraphLifecycleEvent_Val() {}

func (*GraphLifecycleEvent_GraphCompleted) isGraphLifecycleEvent_Val() {}

func (m *GraphLifecycleEvent) GetVal() isGraphLifecycleEvent_Val {
	if m != nil {
		return m.Val
	}
	return nil
}

func (m *GraphLifecycleEvent) GetGraphCreated() *GraphCreatedEvent {
	if x, ok := m.GetVal().(*GraphLifecycleEvent_GraphCreated); ok {
		return x.GraphCreated
	}
	return nil
}

func (m *GraphLifecycleEvent) GetGraphCompleted() *GraphCompletedEvent {
	if x, ok := m.GetVal().(*GraphLifecycleEvent_GraphCompleted); ok {
		return x.GraphCompleted
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*GraphLifecycleEvent) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _GraphLifecycleEvent_OneofMarshaler, _GraphLifecycleEvent_OneofUnmarshaler, _GraphLifecycleEvent_OneofSizer, []interface{}{
		(*GraphLifecycleEvent_GraphCreated)(nil),
		(*GraphLifecycleEvent_GraphCompleted)(nil),
	}
}

func _GraphLifecycleEvent_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*GraphLifecycleEvent)
	// val
	switch x := m.Val.(type) {
	case *GraphLifecycleEvent_GraphCreated:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GraphCreated); err != nil {
			return err
		}
	case *GraphLifecycleEvent_GraphCompleted:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GraphCompleted); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("GraphLifecycleEvent.Val has unexpected type %T", x)
	}
	return nil
}

func _GraphLifecycleEvent_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*GraphLifecycleEvent)
	switch tag {
	case 10: // val.graph_created
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GraphCreatedEvent)
		err := b.DecodeMessage(msg)
		m.Val = &GraphLifecycleEvent_GraphCreated{msg}
		return true, err
	case 12: // val.graph_completed
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GraphCompletedEvent)
		err := b.DecodeMessage(msg)
		m.Val = &GraphLifecycleEvent_GraphCompleted{msg}
		return true, err
	default:
		return false, nil
	}
}

func _GraphLifecycleEvent_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*GraphLifecycleEvent)
	// val
	switch x := m.Val.(type) {
	case *GraphLifecycleEvent_GraphCreated:
		s := proto.Size(x.GraphCreated)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GraphLifecycleEvent_GraphCompleted:
		s := proto.Size(x.GraphCompleted)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type GraphStreamEvent struct {
	Seq    uint64               `protobuf:"varint,1,opt,name=seq,proto3" json:"seq,omitempty"`
	FlowId string               `protobuf:"bytes,2,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	SentTs *timestamp.Timestamp `protobuf:"bytes,3,opt,name=sent_ts,json=sentTs,proto3" json:"sent_ts,omitempty"`
	// Types that are valid to be assigned to Val:
	//	*GraphStreamEvent_GraphCreated
	//	*GraphStreamEvent_GraphTerminating
	//	*GraphStreamEvent_GraphCompleted
	//	*GraphStreamEvent_DelayScheduled
	//	*GraphStreamEvent_StageAdded
	//	*GraphStreamEvent_StageCompleted
	//	*GraphStreamEvent_StageComposed
	//	*GraphStreamEvent_FaasInvocationStarted
	//	*GraphStreamEvent_FaasInvocationCompleted
	//	*GraphStreamEvent_GraphCommitted
	Val                  isGraphStreamEvent_Val `protobuf_oneof:"val"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *GraphStreamEvent) Reset()         { *m = GraphStreamEvent{} }
func (m *GraphStreamEvent) String() string { return proto.CompactTextString(m) }
func (*GraphStreamEvent) ProtoMessage()    {}
func (*GraphStreamEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{36}
}
func (m *GraphStreamEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GraphStreamEvent.Unmarshal(m, b)
}
func (m *GraphStreamEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GraphStreamEvent.Marshal(b, m, deterministic)
}
func (dst *GraphStreamEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GraphStreamEvent.Merge(dst, src)
}
func (m *GraphStreamEvent) XXX_Size() int {
	return xxx_messageInfo_GraphStreamEvent.Size(m)
}
func (m *GraphStreamEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_GraphStreamEvent.DiscardUnknown(m)
}

var xxx_messageInfo_GraphStreamEvent proto.InternalMessageInfo

func (m *GraphStreamEvent) GetSeq() uint64 {
	if m != nil {
		return m.Seq
	}
	return 0
}

func (m *GraphStreamEvent) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

func (m *GraphStreamEvent) GetSentTs() *timestamp.Timestamp {
	if m != nil {
		return m.SentTs
	}
	return nil
}

type isGraphStreamEvent_Val interface {
	isGraphStreamEvent_Val()
}

type GraphStreamEvent_GraphCreated struct {
	GraphCreated *GraphCreatedEvent `protobuf:"bytes,10,opt,name=graph_created,json=graphCreated,proto3,oneof"`
}

type GraphStreamEvent_GraphTerminating struct {
	GraphTerminating *GraphTerminatingEvent `protobuf:"bytes,11,opt,name=graph_terminating,json=graphTerminating,proto3,oneof"`
}

type GraphStreamEvent_GraphCompleted struct {
	GraphCompleted *GraphCompletedEvent `protobuf:"bytes,12,opt,name=graph_completed,json=graphCompleted,proto3,oneof"`
}

type GraphStreamEvent_DelayScheduled struct {
	DelayScheduled *DelayScheduledEvent `protobuf:"bytes,13,opt,name=delay_scheduled,json=delayScheduled,proto3,oneof"`
}

type GraphStreamEvent_StageAdded struct {
	StageAdded *StageAddedEvent `protobuf:"bytes,14,opt,name=stage_added,json=stageAdded,proto3,oneof"`
}

type GraphStreamEvent_StageCompleted struct {
	StageCompleted *StageCompletedEvent `protobuf:"bytes,15,opt,name=stage_completed,json=stageCompleted,proto3,oneof"`
}

type GraphStreamEvent_StageComposed struct {
	StageComposed *StageComposedEvent `protobuf:"bytes,16,opt,name=stage_composed,json=stageComposed,proto3,oneof"`
}

type GraphStreamEvent_FaasInvocationStarted struct {
	FaasInvocationStarted *FaasInvocationStartedEvent `protobuf:"bytes,17,opt,name=faas_invocation_started,json=faasInvocationStarted,proto3,oneof"`
}

type GraphStreamEvent_FaasInvocationCompleted struct {
	FaasInvocationCompleted *FaasInvocationCompletedEvent `protobuf:"bytes,18,opt,name=faas_invocation_completed,json=faasInvocationCompleted,proto3,oneof"`
}

type GraphStreamEvent_GraphCommitted struct {
	GraphCommitted *GraphCommittedEvent `protobuf:"bytes,19,opt,name=graph_committed,json=graphCommitted,proto3,oneof"`
}

func (*GraphStreamEvent_GraphCreated) isGraphStreamEvent_Val() {}

func (*GraphStreamEvent_GraphTerminating) isGraphStreamEvent_Val() {}

func (*GraphStreamEvent_GraphCompleted) isGraphStreamEvent_Val() {}

func (*GraphStreamEvent_DelayScheduled) isGraphStreamEvent_Val() {}

func (*GraphStreamEvent_StageAdded) isGraphStreamEvent_Val() {}

func (*GraphStreamEvent_StageCompleted) isGraphStreamEvent_Val() {}

func (*GraphStreamEvent_StageComposed) isGraphStreamEvent_Val() {}

func (*GraphStreamEvent_FaasInvocationStarted) isGraphStreamEvent_Val() {}

func (*GraphStreamEvent_FaasInvocationCompleted) isGraphStreamEvent_Val() {}

func (*GraphStreamEvent_GraphCommitted) isGraphStreamEvent_Val() {}

func (m *GraphStreamEvent) GetVal() isGraphStreamEvent_Val {
	if m != nil {
		return m.Val
	}
	return nil
}

func (m *GraphStreamEvent) GetGraphCreated() *GraphCreatedEvent {
	if x, ok := m.GetVal().(*GraphStreamEvent_GraphCreated); ok {
		return x.GraphCreated
	}
	return nil
}

func (m *GraphStreamEvent) GetGraphTerminating() *GraphTerminatingEvent {
	if x, ok := m.GetVal().(*GraphStreamEvent_GraphTerminating); ok {
		return x.GraphTerminating
	}
	return nil
}

func (m *GraphStreamEvent) GetGraphCompleted() *GraphCompletedEvent {
	if x, ok := m.GetVal().(*GraphStreamEvent_GraphCompleted); ok {
		return x.GraphCompleted
	}
	return nil
}

func (m *GraphStreamEvent) GetDelayScheduled() *DelayScheduledEvent {
	if x, ok := m.GetVal().(*GraphStreamEvent_DelayScheduled); ok {
		return x.DelayScheduled
	}
	return nil
}

func (m *GraphStreamEvent) GetStageAdded() *StageAddedEvent {
	if x, ok := m.GetVal().(*GraphStreamEvent_StageAdded); ok {
		return x.StageAdded
	}
	return nil
}

func (m *GraphStreamEvent) GetStageCompleted() *StageCompletedEvent {
	if x, ok := m.GetVal().(*GraphStreamEvent_StageCompleted); ok {
		return x.StageCompleted
	}
	return nil
}

func (m *GraphStreamEvent) GetStageComposed() *StageComposedEvent {
	if x, ok := m.GetVal().(*GraphStreamEvent_StageComposed); ok {
		return x.StageComposed
	}
	return nil
}

func (m *GraphStreamEvent) GetFaasInvocationStarted() *FaasInvocationStartedEvent {
	if x, ok := m.GetVal().(*GraphStreamEvent_FaasInvocationStarted); ok {
		return x.FaasInvocationStarted
	}
	return nil
}

func (m *GraphStreamEvent) GetFaasInvocationCompleted() *FaasInvocationCompletedEvent {
	if x, ok := m.GetVal().(*GraphStreamEvent_FaasInvocationCompleted); ok {
		return x.FaasInvocationCompleted
	}
	return nil
}

func (m *GraphStreamEvent) GetGraphCommitted() *GraphCommittedEvent {
	if x, ok := m.GetVal().(*GraphStreamEvent_GraphCommitted); ok {
		return x.GraphCommitted
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*GraphStreamEvent) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _GraphStreamEvent_OneofMarshaler, _GraphStreamEvent_OneofUnmarshaler, _GraphStreamEvent_OneofSizer, []interface{}{
		(*GraphStreamEvent_GraphCreated)(nil),
		(*GraphStreamEvent_GraphTerminating)(nil),
		(*GraphStreamEvent_GraphCompleted)(nil),
		(*GraphStreamEvent_DelayScheduled)(nil),
		(*GraphStreamEvent_StageAdded)(nil),
		(*GraphStreamEvent_StageCompleted)(nil),
		(*GraphStreamEvent_StageComposed)(nil),
		(*GraphStreamEvent_FaasInvocationStarted)(nil),
		(*GraphStreamEvent_FaasInvocationCompleted)(nil),
		(*GraphStreamEvent_GraphCommitted)(nil),
	}
}

func _GraphStreamEvent_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*GraphStreamEvent)
	// val
	switch x := m.Val.(type) {
	case *GraphStreamEvent_GraphCreated:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GraphCreated); err != nil {
			return err
		}
	case *GraphStreamEvent_GraphTerminating:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GraphTerminating); err != nil {
			return err
		}
	case *GraphStreamEvent_GraphCompleted:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GraphCompleted); err != nil {
			return err
		}
	case *GraphStreamEvent_DelayScheduled:
		b.EncodeVarint(13<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DelayScheduled); err != nil {
			return err
		}
	case *GraphStreamEvent_StageAdded:
		b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StageAdded); err != nil {
			return err
		}
	case *GraphStreamEvent_StageCompleted:
		b.EncodeVarint(15<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StageCompleted); err != nil {
			return err
		}
	case *GraphStreamEvent_StageComposed:
		b.EncodeVarint(16<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StageComposed); err != nil {
			return err
		}
	case *GraphStreamEvent_FaasInvocationStarted:
		b.EncodeVarint(17<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.FaasInvocationStarted); err != nil {
			return err
		}
	case *GraphStreamEvent_FaasInvocationCompleted:
		b.EncodeVarint(18<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.FaasInvocationCompleted); err != nil {
			return err
		}
	case *GraphStreamEvent_GraphCommitted:
		b.EncodeVarint(19<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GraphCommitted); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("GraphStreamEvent.Val has unexpected type %T", x)
	}
	return nil
}

func _GraphStreamEvent_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*GraphStreamEvent)
	switch tag {
	case 10: // val.graph_created
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GraphCreatedEvent)
		err := b.DecodeMessage(msg)
		m.Val = &GraphStreamEvent_GraphCreated{msg}
		return true, err
	case 11: // val.graph_terminating
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GraphTerminatingEvent)
		err := b.DecodeMessage(msg)
		m.Val = &GraphStreamEvent_GraphTerminating{msg}
		return true, err
	case 12: // val.graph_completed
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GraphCompletedEvent)
		err := b.DecodeMessage(msg)
		m.Val = &GraphStreamEvent_GraphCompleted{msg}
		return true, err
	case 13: // val.delay_scheduled
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DelayScheduledEvent)
		err := b.DecodeMessage(msg)
		m.Val = &GraphStreamEvent_DelayScheduled{msg}
		return true, err
	case 14: // val.stage_added
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StageAddedEvent)
		err := b.DecodeMessage(msg)
		m.Val = &GraphStreamEvent_StageAdded{msg}
		return true, err
	case 15: // val.stage_completed
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StageCompletedEvent)
		err := b.DecodeMessage(msg)
		m.Val = &GraphStreamEvent_StageCompleted{msg}
		return true, err
	case 16: // val.stage_composed
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StageComposedEvent)
		err := b.DecodeMessage(msg)
		m.Val = &GraphStreamEvent_StageComposed{msg}
		return true, err
	case 17: // val.faas_invocation_started
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(FaasInvocationStartedEvent)
		err := b.DecodeMessage(msg)
		m.Val = &GraphStreamEvent_FaasInvocationStarted{msg}
		return true, err
	case 18: // val.faas_invocation_completed
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(FaasInvocationCompletedEvent)
		err := b.DecodeMessage(msg)
		m.Val = &GraphStreamEvent_FaasInvocationCompleted{msg}
		return true, err
	case 19: // val.graph_committed
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GraphCommittedEvent)
		err := b.DecodeMessage(msg)
		m.Val = &GraphStreamEvent_GraphCommitted{msg}
		return true, err
	default:
		return false, nil
	}
}

func _GraphStreamEvent_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*GraphStreamEvent)
	// val
	switch x := m.Val.(type) {
	case *GraphStreamEvent_GraphCreated:
		s := proto.Size(x.GraphCreated)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GraphStreamEvent_GraphTerminating:
		s := proto.Size(x.GraphTerminating)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GraphStreamEvent_GraphCompleted:
		s := proto.Size(x.GraphCompleted)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GraphStreamEvent_DelayScheduled:
		s := proto.Size(x.DelayScheduled)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GraphStreamEvent_StageAdded:
		s := proto.Size(x.StageAdded)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GraphStreamEvent_StageCompleted:
		s := proto.Size(x.StageCompleted)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GraphStreamEvent_StageComposed:
		s := proto.Size(x.StageComposed)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GraphStreamEvent_FaasInvocationStarted:
		s := proto.Size(x.FaasInvocationStarted)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GraphStreamEvent_FaasInvocationCompleted:
		s := proto.Size(x.FaasInvocationCompleted)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GraphStreamEvent_GraphCommitted:
		s := proto.Size(x.GraphCommitted)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Graph created
type GraphCreatedEvent struct {
	FlowId               string               `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	FunctionId           string               `protobuf:"bytes,2,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
	Ts                   *timestamp.Timestamp `protobuf:"bytes,3,opt,name=ts,proto3" json:"ts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GraphCreatedEvent) Reset()         { *m = GraphCreatedEvent{} }
func (m *GraphCreatedEvent) String() string { return proto.CompactTextString(m) }
func (*GraphCreatedEvent) ProtoMessage()    {}
func (*GraphCreatedEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{37}
}
func (m *GraphCreatedEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GraphCreatedEvent.Unmarshal(m, b)
}
func (m *GraphCreatedEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GraphCreatedEvent.Marshal(b, m, deterministic)
}
func (dst *GraphCreatedEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GraphCreatedEvent.Merge(dst, src)
}
func (m *GraphCreatedEvent) XXX_Size() int {
	return xxx_messageInfo_GraphCreatedEvent.Size(m)
}
func (m *GraphCreatedEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_GraphCreatedEvent.DiscardUnknown(m)
}

var xxx_messageInfo_GraphCreatedEvent proto.InternalMessageInfo

func (m *GraphCreatedEvent) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

func (m *GraphCreatedEvent) GetFunctionId() string {
	if m != nil {
		return m.FunctionId
	}
	return ""
}

func (m *GraphCreatedEvent) GetTs() *timestamp.Timestamp {
	if m != nil {
		return m.Ts
	}
	return nil
}

// A delay has started - this marks the relative start of an event when a delay node is recovered
type DelayScheduledEvent struct {
	StageId              string               `protobuf:"bytes,1,opt,name=stage_id,json=stageId,proto3" json:"stage_id,omitempty"`
	TimeMs               int64                `protobuf:"varint,2,opt,name=time_ms,json=timeMs,proto3" json:"time_ms,omitempty"`
	Ts                   *timestamp.Timestamp `protobuf:"bytes,3,opt,name=ts,proto3" json:"ts,omitempty"`
	FlowId               string               `protobuf:"bytes,4,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *DelayScheduledEvent) Reset()         { *m = DelayScheduledEvent{} }
func (m *DelayScheduledEvent) String() string { return proto.CompactTextString(m) }
func (*DelayScheduledEvent) ProtoMessage()    {}
func (*DelayScheduledEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{38}
}
func (m *DelayScheduledEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DelayScheduledEvent.Unmarshal(m, b)
}
func (m *DelayScheduledEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DelayScheduledEvent.Marshal(b, m, deterministic)
}
func (dst *DelayScheduledEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DelayScheduledEvent.Merge(dst, src)
}
func (m *DelayScheduledEvent) XXX_Size() int {
	return xxx_messageInfo_DelayScheduledEvent.Size(m)
}
func (m *DelayScheduledEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_DelayScheduledEvent.DiscardUnknown(m)
}

var xxx_messageInfo_DelayScheduledEvent proto.InternalMessageInfo

func (m *DelayScheduledEvent) GetStageId() string {
	if m != nil {
		return m.StageId
	}
	return ""
}

func (m *DelayScheduledEvent) GetTimeMs() int64 {
	if m != nil {
		return m.TimeMs
	}
	return 0
}

func (m *DelayScheduledEvent) GetTs() *timestamp.Timestamp {
	if m != nil {
		return m.Ts
	}
	return nil
}

func (m *DelayScheduledEvent) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

// Graph termination has started - no more changes can be made to this graph
// this will be fillowed by a completion event when any termination hooks have run
type GraphTerminatingEvent struct {
	FlowId               string               `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	FunctionId           string               `protobuf:"bytes,2,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
	Status               StatusDatumType      `protobuf:"varint,3,opt,name=status,proto3,enum=model.StatusDatumType" json:"status,omitempty"`
	Ts                   *timestamp.Timestamp `protobuf:"bytes,4,opt,name=ts,proto3" json:"ts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GraphTerminatingEvent) Reset()         { *m = GraphTerminatingEvent{} }
func (m *GraphTerminatingEvent) String() string { return proto.CompactTextString(m) }
func (*GraphTerminatingEvent) ProtoMessage()    {}
func (*GraphTerminatingEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{39}
}
func (m *GraphTerminatingEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GraphTerminatingEvent.Unmarshal(m, b)
}
func (m *GraphTerminatingEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GraphTerminatingEvent.Marshal(b, m, deterministic)
}
func (dst *GraphTerminatingEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GraphTerminatingEvent.Merge(dst, src)
}
func (m *GraphTerminatingEvent) XXX_Size() int {
	return xxx_messageInfo_GraphTerminatingEvent.Size(m)
}
func (m *GraphTerminatingEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_GraphTerminatingEvent.DiscardUnknown(m)
}

var xxx_messageInfo_GraphTerminatingEvent proto.InternalMessageInfo

func (m *GraphTerminatingEvent) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

func (m *GraphTerminatingEvent) GetFunctionId() string {
	if m != nil {
		return m.FunctionId
	}
	return ""
}

func (m *GraphTerminatingEvent) GetStatus() StatusDatumType {
	if m != nil {
		return m.Status
	}
	return StatusDatumType_unknown_state
}

func (m *GraphTerminatingEvent) GetTs() *timestamp.Timestamp {
	if m != nil {
		return m.Ts
	}
	return nil
}

// Graph is complete  and will no longer change
type GraphCompletedEvent struct {
	FlowId               string               `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	FunctionId           string               `protobuf:"bytes,2,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
	Ts                   *timestamp.Timestamp `protobuf:"bytes,3,opt,name=ts,proto3" json:"ts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GraphCompletedEvent) Reset()         { *m = GraphCompletedEvent{} }
func (m *GraphCompletedEvent) String() string { return proto.CompactTextString(m) }
func (*GraphCompletedEvent) ProtoMessage()    {}
func (*GraphCompletedEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{40}
}
func (m *GraphCompletedEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GraphCompletedEvent.Unmarshal(m, b)
}
func (m *GraphCompletedEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GraphCompletedEvent.Marshal(b, m, deterministic)
}
func (dst *GraphCompletedEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GraphCompletedEvent.Merge(dst, src)
}
func (m *GraphCompletedEvent) XXX_Size() int {
	return xxx_messageInfo_GraphCompletedEvent.Size(m)
}
func (m *GraphCompletedEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_GraphCompletedEvent.DiscardUnknown(m)
}

var xxx_messageInfo_GraphCompletedEvent proto.InternalMessageInfo

func (m *GraphCompletedEvent) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

func (m *GraphCompletedEvent) GetFunctionId() string {
	if m != nil {
		return m.FunctionId
	}
	return ""
}

func (m *GraphCompletedEvent) GetTs() *timestamp.Timestamp {
	if m != nil {
		return m.Ts
	}
	return nil
}

// The graph is committed - this typically indicates that the function that created the flow has completed
// once this event has been posted the graph will finish when all active or pending nodes have completed.
type GraphCommittedEvent struct {
	FlowId               string               `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	Ts                   *timestamp.Timestamp `protobuf:"bytes,2,opt,name=ts,proto3" json:"ts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GraphCommittedEvent) Reset()         { *m = GraphCommittedEvent{} }
func (m *GraphCommittedEvent) String() string { return proto.CompactTextString(m) }
func (*GraphCommittedEvent) ProtoMessage()    {}
func (*GraphCommittedEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{41}
}
func (m *GraphCommittedEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GraphCommittedEvent.Unmarshal(m, b)
}
func (m *GraphCommittedEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GraphCommittedEvent.Marshal(b, m, deterministic)
}
func (dst *GraphCommittedEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GraphCommittedEvent.Merge(dst, src)
}
func (m *GraphCommittedEvent) XXX_Size() int {
	return xxx_messageInfo_GraphCommittedEvent.Size(m)
}
func (m *GraphCommittedEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_GraphCommittedEvent.DiscardUnknown(m)
}

var xxx_messageInfo_GraphCommittedEvent proto.InternalMessageInfo

func (m *GraphCommittedEvent) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

func (m *GraphCommittedEvent) GetTs() *timestamp.Timestamp {
	if m != nil {
		return m.Ts
	}
	return nil
}

// A stage was added to the graph
type StageAddedEvent struct {
	StageId              string               `protobuf:"bytes,1,opt,name=stage_id,json=stageId,proto3" json:"stage_id,omitempty"`
	Op                   CompletionOperation  `protobuf:"varint,2,opt,name=op,proto3,enum=model.CompletionOperation" json:"op,omitempty"`
	Closure              *BlobDatum           `protobuf:"bytes,3,opt,name=closure,proto3" json:"closure,omitempty"`
	Dependencies         []string             `protobuf:"bytes,4,rep,name=dependencies,proto3" json:"dependencies,omitempty"`
	Ts                   *timestamp.Timestamp `protobuf:"bytes,5,opt,name=ts,proto3" json:"ts,omitempty"`
	CodeLocation         string               `protobuf:"bytes,6,opt,name=code_location,json=codeLocation,proto3" json:"code_location,omitempty"`
	CallerId             string               `protobuf:"bytes,7,opt,name=caller_id,json=callerId,proto3" json:"caller_id,omitempty"`
	FlowId               string               `protobuf:"bytes,8,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *StageAddedEvent) Reset()         { *m = StageAddedEvent{} }
func (m *StageAddedEvent) String() string { return proto.CompactTextString(m) }
func (*StageAddedEvent) ProtoMessage()    {}
func (*StageAddedEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{42}
}
func (m *StageAddedEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StageAddedEvent.Unmarshal(m, b)
}
func (m *StageAddedEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StageAddedEvent.Marshal(b, m, deterministic)
}
func (dst *StageAddedEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StageAddedEvent.Merge(dst, src)
}
func (m *StageAddedEvent) XXX_Size() int {
	return xxx_messageInfo_StageAddedEvent.Size(m)
}
func (m *StageAddedEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_StageAddedEvent.DiscardUnknown(m)
}

var xxx_messageInfo_StageAddedEvent proto.InternalMessageInfo

func (m *StageAddedEvent) GetStageId() string {
	if m != nil {
		return m.StageId
	}
	return ""
}

func (m *StageAddedEvent) GetOp() CompletionOperation {
	if m != nil {
		return m.Op
	}
	return CompletionOperation_unknown_operation
}

func (m *StageAddedEvent) GetClosure() *BlobDatum {
	if m != nil {
		return m.Closure
	}
	return nil
}

func (m *StageAddedEvent) GetDependencies() []string {
	if m != nil {
		return m.Dependencies
	}
	return nil
}

func (m *StageAddedEvent) GetTs() *timestamp.Timestamp {
	if m != nil {
		return m.Ts
	}
	return nil
}

func (m *StageAddedEvent) GetCodeLocation() string {
	if m != nil {
		return m.CodeLocation
	}
	return ""
}

func (m *StageAddedEvent) GetCallerId() string {
	if m != nil {
		return m.CallerId
	}
	return ""
}

func (m *StageAddedEvent) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

// A stage completed  - downstream stages may be triggered
type StageCompletedEvent struct {
	StageId              string               `protobuf:"bytes,1,opt,name=stage_id,json=stageId,proto3" json:"stage_id,omitempty"`
	Result               *CompletionResult    `protobuf:"bytes,2,opt,name=result,proto3" json:"result,omitempty"`
	Ts                   *timestamp.Timestamp `protobuf:"bytes,3,opt,name=ts,proto3" json:"ts,omitempty"`
	FlowId               string               `protobuf:"bytes,4,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *StageCompletedEvent) Reset()         { *m = StageCompletedEvent{} }
func (m *StageCompletedEvent) String() string { return proto.CompactTextString(m) }
func (*StageCompletedEvent) ProtoMessage()    {}
func (*StageCompletedEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{43}
}
func (m *StageCompletedEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StageCompletedEvent.Unmarshal(m, b)
}
func (m *StageCompletedEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StageCompletedEvent.Marshal(b, m, deterministic)
}
func (dst *StageCompletedEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StageCompletedEvent.Merge(dst, src)
}
func (m *StageCompletedEvent) XXX_Size() int {
	return xxx_messageInfo_StageCompletedEvent.Size(m)
}
func (m *StageCompletedEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_StageCompletedEvent.DiscardUnknown(m)
}

var xxx_messageInfo_StageCompletedEvent proto.InternalMessageInfo

func (m *StageCompletedEvent) GetStageId() string {
	if m != nil {
		return m.StageId
	}
	return ""
}

func (m *StageCompletedEvent) GetResult() *CompletionResult {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *StageCompletedEvent) GetTs() *timestamp.Timestamp {
	if m != nil {
		return m.Ts
	}
	return nil
}

func (m *StageCompletedEvent) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

// A stage was composed into  stage_id  - stage_id will compelete with the saem result as composed_stage_id
type StageComposedEvent struct {
	StageId              string               `protobuf:"bytes,1,opt,name=stage_id,json=stageId,proto3" json:"stage_id,omitempty"`
	ComposedStageId      string               `protobuf:"bytes,2,opt,name=composed_stage_id,json=composedStageId,proto3" json:"composed_stage_id,omitempty"`
	Ts                   *timestamp.Timestamp `protobuf:"bytes,3,opt,name=ts,proto3" json:"ts,omitempty"`
	FlowId               string               `protobuf:"bytes,4,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *StageComposedEvent) Reset()         { *m = StageComposedEvent{} }
func (m *StageComposedEvent) String() string { return proto.CompactTextString(m) }
func (*StageComposedEvent) ProtoMessage()    {}
func (*StageComposedEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{44}
}
func (m *StageComposedEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StageComposedEvent.Unmarshal(m, b)
}
func (m *StageComposedEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StageComposedEvent.Marshal(b, m, deterministic)
}
func (dst *StageComposedEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StageComposedEvent.Merge(dst, src)
}
func (m *StageComposedEvent) XXX_Size() int {
	return xxx_messageInfo_StageComposedEvent.Size(m)
}
func (m *StageComposedEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_StageComposedEvent.DiscardUnknown(m)
}

var xxx_messageInfo_StageComposedEvent proto.InternalMessageInfo

func (m *StageComposedEvent) GetStageId() string {
	if m != nil {
		return m.StageId
	}
	return ""
}

func (m *StageComposedEvent) GetComposedStageId() string {
	if m != nil {
		return m.ComposedStageId
	}
	return ""
}

func (m *StageComposedEvent) GetTs() *timestamp.Timestamp {
	if m != nil {
		return m.Ts
	}
	return nil
}

func (m *StageComposedEvent) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

// A call to the FaaS has started
type FaasInvocationStartedEvent struct {
	StageId              string               `protobuf:"bytes,1,opt,name=stage_id,json=stageId,proto3" json:"stage_id,omitempty"`
	Ts                   *timestamp.Timestamp `protobuf:"bytes,2,opt,name=ts,proto3" json:"ts,omitempty"`
	FunctionId           string               `protobuf:"bytes,3,opt,name=function_id,json=functionId,proto3" json:"function_id,omitempty"`
	FlowId               string               `protobuf:"bytes,4,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *FaasInvocationStartedEvent) Reset()         { *m = FaasInvocationStartedEvent{} }
func (m *FaasInvocationStartedEvent) String() string { return proto.CompactTextString(m) }
func (*FaasInvocationStartedEvent) ProtoMessage()    {}
func (*FaasInvocationStartedEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{45}
}
func (m *FaasInvocationStartedEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaasInvocationStartedEvent.Unmarshal(m, b)
}
func (m *FaasInvocationStartedEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaasInvocationStartedEvent.Marshal(b, m, deterministic)
}
func (dst *FaasInvocationStartedEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaasInvocationStartedEvent.Merge(dst, src)
}
func (m *FaasInvocationStartedEvent) XXX_Size() int {
	return xxx_messageInfo_FaasInvocationStartedEvent.Size(m)
}
func (m *FaasInvocationStartedEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_FaasInvocationStartedEvent.DiscardUnknown(m)
}

var xxx_messageInfo_FaasInvocationStartedEvent proto.InternalMessageInfo

func (m *FaasInvocationStartedEvent) GetStageId() string {
	if m != nil {
		return m.StageId
	}
	return ""
}

func (m *FaasInvocationStartedEvent) GetTs() *timestamp.Timestamp {
	if m != nil {
		return m.Ts
	}
	return nil
}

func (m *FaasInvocationStartedEvent) GetFunctionId() string {
	if m != nil {
		return m.FunctionId
	}
	return ""
}

func (m *FaasInvocationStartedEvent) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

// A call to the FaaS completed
type FaasInvocationCompletedEvent struct {
	StageId              string               `protobuf:"bytes,1,opt,name=stage_id,json=stageId,proto3" json:"stage_id,omitempty"`
	Result               *CompletionResult    `protobuf:"bytes,2,opt,name=result,proto3" json:"result,omitempty"`
	Ts                   *timestamp.Timestamp `protobuf:"bytes,3,opt,name=ts,proto3" json:"ts,omitempty"`
	CallId               string               `protobuf:"bytes,4,opt,name=call_id,json=callId,proto3" json:"call_id,omitempty"`
	FlowId               string               `protobuf:"bytes,5,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *FaasInvocationCompletedEvent) Reset()         { *m = FaasInvocationCompletedEvent{} }
func (m *FaasInvocationCompletedEvent) String() string { return proto.CompactTextString(m) }
func (*FaasInvocationCompletedEvent) ProtoMessage()    {}
func (*FaasInvocationCompletedEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{46}
}
func (m *FaasInvocationCompletedEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaasInvocationCompletedEvent.Unmarshal(m, b)
}
func (m *FaasInvocationCompletedEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaasInvocationCompletedEvent.Marshal(b, m, deterministic)
}
func (dst *FaasInvocationCompletedEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaasInvocationCompletedEvent.Merge(dst, src)
}
func (m *FaasInvocationCompletedEvent) XXX_Size() int {
	return xxx_messageInfo_FaasInvocationCompletedEvent.Size(m)
}
func (m *FaasInvocationCompletedEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_FaasInvocationCompletedEvent.DiscardUnknown(m)
}

var xxx_messageInfo_FaasInvocationCompletedEvent proto.InternalMessageInfo

func (m *FaasInvocationCompletedEvent) GetStageId() string {
	if m != nil {
		return m.StageId
	}
	return ""
}

func (m *FaasInvocationCompletedEvent) GetResult() *CompletionResult {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *FaasInvocationCompletedEvent) GetTs() *timestamp.Timestamp {
	if m != nil {
		return m.Ts
	}
	return nil
}

func (m *FaasInvocationCompletedEvent) GetCallId() string {
	if m != nil {
		return m.CallId
	}
	return ""
}

func (m *FaasInvocationCompletedEvent) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

// Request Wrapper,
type RuntimeInvokeStageRequest struct {
	FlowId               string              `protobuf:"bytes,1,opt,name=flow_id,json=flowId,proto3" json:"flow_id,omitempty"`
	StageId              string              `protobuf:"bytes,2,opt,name=stage_id,json=stageId,proto3" json:"stage_id,omitempty"`
	Args                 []*CompletionResult `protobuf:"bytes,3,rep,name=args,proto3" json:"args,omitempty"`
	Closure              *BlobDatum          `protobuf:"bytes,4,opt,name=closure,proto3" json:"closure,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *RuntimeInvokeStageRequest) Reset()         { *m = RuntimeInvokeStageRequest{} }
func (m *RuntimeInvokeStageRequest) String() string { return proto.CompactTextString(m) }
func (*RuntimeInvokeStageRequest) ProtoMessage()    {}
func (*RuntimeInvokeStageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{47}
}
func (m *RuntimeInvokeStageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RuntimeInvokeStageRequest.Unmarshal(m, b)
}
func (m *RuntimeInvokeStageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RuntimeInvokeStageRequest.Marshal(b, m, deterministic)
}
func (dst *RuntimeInvokeStageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuntimeInvokeStageRequest.Merge(dst, src)
}
func (m *RuntimeInvokeStageRequest) XXX_Size() int {
	return xxx_messageInfo_RuntimeInvokeStageRequest.Size(m)
}
func (m *RuntimeInvokeStageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RuntimeInvokeStageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RuntimeInvokeStageRequest proto.InternalMessageInfo

func (m *RuntimeInvokeStageRequest) GetFlowId() string {
	if m != nil {
		return m.FlowId
	}
	return ""
}

func (m *RuntimeInvokeStageRequest) GetStageId() string {
	if m != nil {
		return m.StageId
	}
	return ""
}

func (m *RuntimeInvokeStageRequest) GetArgs() []*CompletionResult {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *RuntimeInvokeStageRequest) GetClosure() *BlobDatum {
	if m != nil {
		return m.Closure
	}
	return nil
}

// Result wrapper - intentionally deep to allow extra fields at top level
type RuntimeInvokeStageResponse struct {
	Result               *CompletionResult `protobuf:"bytes,5,opt,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *RuntimeInvokeStageResponse) Reset()         { *m = RuntimeInvokeStageResponse{} }
func (m *RuntimeInvokeStageResponse) String() string { return proto.CompactTextString(m) }
func (*RuntimeInvokeStageResponse) ProtoMessage()    {}
func (*RuntimeInvokeStageResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_52321f9a89a392dd, []int{48}
}
func (m *RuntimeInvokeStageResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RuntimeInvokeStageResponse.Unmarshal(m, b)
}
func (m *RuntimeInvokeStageResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RuntimeInvokeStageResponse.Marshal(b, m, deterministic)
}
func (dst *RuntimeInvokeStageResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuntimeInvokeStageResponse.Merge(dst, src)
}
func (m *RuntimeInvokeStageResponse) XXX_Size() int {
	return xxx_messageInfo_RuntimeInvokeStageResponse.Size(m)
}
func (m *RuntimeInvokeStageResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RuntimeInvokeStageResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RuntimeInvokeStageResponse proto.InternalMessageInfo

func (m *RuntimeInvokeStageResponse) GetResult() *CompletionResult {
	if m != nil {
		return m.Result
	}
	return nil
}

func init() {
	proto.RegisterType((*CompletionResult)(nil), "model.CompletionResult")
	proto.RegisterType((*BlobDatum)(nil), "model.BlobDatum")
	proto.RegisterType((*HTTPHeader)(nil), "model.HTTPHeader")
	proto.RegisterType((*HTTPReqDatum)(nil), "model.HTTPReqDatum")
	proto.RegisterType((*HTTPRespDatum)(nil), "model.HTTPRespDatum")
	proto.RegisterType((*EmptyDatum)(nil), "model.EmptyDatum")
	proto.RegisterType((*StageRefDatum)(nil), "model.StageRefDatum")
	proto.RegisterType((*ErrorDatum)(nil), "model.ErrorDatum")
	proto.RegisterType((*StatusDatum)(nil), "model.StatusDatum")
	proto.RegisterType((*Datum)(nil), "model.Datum")
	proto.RegisterType((*AddStageRequest)(nil), "model.AddStageRequest")
	proto.RegisterType((*CompleteStageExternallyRequest)(nil), "model.CompleteStageExternallyRequest")
	proto.RegisterType((*AddCompletedValueStageRequest)(nil), "model.AddCompletedValueStageRequest")
	proto.RegisterType((*AddDelayStageRequest)(nil), "model.AddDelayStageRequest")
	proto.RegisterType((*AddInvokeFunctionStageRequest)(nil), "model.AddInvokeFunctionStageRequest")
	proto.RegisterType((*AddStageResponse)(nil), "model.AddStageResponse")
	proto.RegisterType((*CommitGraphRequest)(nil), "model.CommitGraphRequest")
	proto.RegisterType((*GraphRequestProcessedResponse)(nil), "model.GraphRequestProcessedResponse")
	proto.RegisterType((*CompleteDelayStageRequest)(nil), "model.CompleteDelayStageRequest")
	proto.RegisterType((*CompleteStageExternallyResponse)(nil), "model.CompleteStageExternallyResponse")
	proto.RegisterType((*DeactivateGraphRequest)(nil), "model.DeactivateGraphRequest")
	proto.RegisterType((*CreateGraphRequest)(nil), "model.CreateGraphRequest")
	proto.RegisterType((*CreateGraphResponse)(nil), "model.CreateGraphResponse")
	proto.RegisterType((*FaasInvocationResponse)(nil), "model.FaasInvocationResponse")
	proto.RegisterType((*GetGraphStateRequest)(nil), "model.GetGraphStateRequest")
	proto.RegisterType((*GetGraphStateResponse)(nil), "model.GetGraphStateResponse")
	proto.RegisterMapType((map[string]*GetGraphStateResponse_StageRepresentation)(nil), "model.GetGraphStateResponse.StagesEntry")
	proto.RegisterType((*GetGraphStateResponse_StageRepresentation)(nil), "model.GetGraphStateResponse.StageRepresentation")
	proto.RegisterType((*ListGraphsRequest)(nil), "model.ListGraphsRequest")
	proto.RegisterType((*StreamLifecycleRequest)(nil), "model.StreamLifecycleRequest")
	proto.RegisterType((*StreamGraphRequest)(nil), "model.StreamGraphRequest")
	proto.RegisterType((*ListGraphResponse)(nil), "model.ListGraphResponse")
	proto.RegisterType((*ListGraphsResponse)(nil), "model.ListGraphsResponse")
	proto.RegisterType((*AwaitStageResultRequest)(nil), "model.AwaitStageResultRequest")
	proto.RegisterType((*AwaitStageResultResponse)(nil), "model.AwaitStageResultResponse")
	proto.RegisterType((*InvokeFunctionRequest)(nil), "model.InvokeFunctionRequest")
	proto.RegisterType((*InvokeStageRequest)(nil), "model.InvokeStageRequest")
	proto.RegisterType((*GraphLifecycleEvent)(nil), "model.GraphLifecycleEvent")
	proto.RegisterType((*GraphStreamEvent)(nil), "model.GraphStreamEvent")
	proto.RegisterType((*GraphCreatedEvent)(nil), "model.GraphCreatedEvent")
	proto.RegisterType((*DelayScheduledEvent)(nil), "model.DelayScheduledEvent")
	proto.RegisterType((*GraphTerminatingEvent)(nil), "model.GraphTerminatingEvent")
	proto.RegisterType((*GraphCompletedEvent)(nil), "model.GraphCompletedEvent")
	proto.RegisterType((*GraphCommittedEvent)(nil), "model.GraphCommittedEvent")
	proto.RegisterType((*StageAddedEvent)(nil), "model.StageAddedEvent")
	proto.RegisterType((*StageCompletedEvent)(nil), "model.StageCompletedEvent")
	proto.RegisterType((*StageComposedEvent)(nil), "model.StageComposedEvent")
	proto.RegisterType((*FaasInvocationStartedEvent)(nil), "model.FaasInvocationStartedEvent")
	proto.RegisterType((*FaasInvocationCompletedEvent)(nil), "model.FaasInvocationCompletedEvent")
	proto.RegisterType((*RuntimeInvokeStageRequest)(nil), "model.RuntimeInvokeStageRequest")
	proto.RegisterType((*RuntimeInvokeStageResponse)(nil), "model.RuntimeInvokeStageResponse")
	proto.RegisterEnum("model.HTTPMethod", HTTPMethod_name, HTTPMethod_value)
	proto.RegisterEnum("model.ErrorDatumType", ErrorDatumType_name, ErrorDatumType_value)
	proto.RegisterEnum("model.StatusDatumType", StatusDatumType_name, StatusDatumType_value)
	proto.RegisterEnum("model.CompletionOperation", CompletionOperation_name, CompletionOperation_value)
	proto.RegisterEnum("model.ListGraphsFilter", ListGraphsFilter_name, ListGraphsFilter_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// FlowServiceClient is the client API for FlowService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FlowServiceClient interface {
	CreateGraph(ctx context.Context, in *CreateGraphRequest, opts ...grpc.CallOption) (*CreateGraphResponse, error)
	AddStage(ctx context.Context, in *AddStageRequest, opts ...grpc.CallOption) (*AddStageResponse, error)
	AddValueStage(ctx context.Context, in *AddCompletedValueStageRequest, opts ...grpc.CallOption) (*AddStageResponse, error)
	AddInvokeFunction(ctx context.Context, in *AddInvokeFunctionStageRequest, opts ...grpc.CallOption) (*AddStageResponse, error)
	AddDelay(ctx context.Context, in *AddDelayStageRequest, opts ...grpc.CallOption) (*AddStageResponse, error)
	AwaitStageResult(ctx context.Context, in *AwaitStageResultRequest, opts ...grpc.CallOption) (*AwaitStageResultResponse, error)
	CompleteStageExternally(ctx context.Context, in *CompleteStageExternallyRequest, opts ...grpc.CallOption) (*CompleteStageExternallyResponse, error)
	Commit(ctx context.Context, in *CommitGraphRequest, opts ...grpc.CallOption) (*GraphRequestProcessedResponse, error)
	GetGraphState(ctx context.Context, in *GetGraphStateRequest, opts ...grpc.CallOption) (*GetGraphStateResponse, error)
	StreamLifecycle(ctx context.Context, in *StreamLifecycleRequest, opts ...grpc.CallOption) (FlowService_StreamLifecycleClient, error)
	StreamEvents(ctx context.Context, in *StreamGraphRequest, opts ...grpc.CallOption) (FlowService_StreamEventsClient, error)
}

type flowServiceClient struct {
	cc *grpc.ClientConn
}

func NewFlowServiceClient(cc *grpc.ClientConn) FlowServiceClient {
	return &flowServiceClient{cc}
}

func (c *flowServiceClient) CreateGraph(ctx context.Context, in *CreateGraphRequest, opts ...grpc.CallOption) (*CreateGraphResponse, error) {
	out := new(CreateGraphResponse)
	err := c.cc.Invoke(ctx, "/model.FlowService/CreateGraph", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowServiceClient) AddStage(ctx context.Context, in *AddStageRequest, opts ...grpc.CallOption) (*AddStageResponse, error) {
	out := new(AddStageResponse)
	err := c.cc.Invoke(ctx, "/model.FlowService/AddStage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowServiceClient) AddValueStage(ctx context.Context, in *AddCompletedValueStageRequest, opts ...grpc.CallOption) (*AddStageResponse, error) {
	out := new(AddStageResponse)
	err := c.cc.Invoke(ctx, "/model.FlowService/AddValueStage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowServiceClient) AddInvokeFunction(ctx context.Context, in *AddInvokeFunctionStageRequest, opts ...grpc.CallOption) (*AddStageResponse, error) {
	out := new(AddStageResponse)
	err := c.cc.Invoke(ctx, "/model.FlowService/AddInvokeFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowServiceClient) AddDelay(ctx context.Context, in *AddDelayStageRequest, opts ...grpc.CallOption) (*AddStageResponse, error) {
	out := new(AddStageResponse)
	err := c.cc.Invoke(ctx, "/model.FlowService/AddDelay", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowServiceClient) AwaitStageResult(ctx context.Context, in *AwaitStageResultRequest, opts ...grpc.CallOption) (*AwaitStageResultResponse, error) {
	out := new(AwaitStageResultResponse)
	err := c.cc.Invoke(ctx, "/model.FlowService/AwaitStageResult", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowServiceClient) CompleteStageExternally(ctx context.Context, in *CompleteStageExternallyRequest, opts ...grpc.CallOption) (*CompleteStageExternallyResponse, error) {
	out := new(CompleteStageExternallyResponse)
	err := c.cc.Invoke(ctx, "/model.FlowService/CompleteStageExternally", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowServiceClient) Commit(ctx context.Context, in *CommitGraphRequest, opts ...grpc.CallOption) (*GraphRequestProcessedResponse, error) {
	out := new(GraphRequestProcessedResponse)
	err := c.cc.Invoke(ctx, "/model.FlowService/Commit", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowServiceClient) GetGraphState(ctx context.Context, in *GetGraphStateRequest, opts ...grpc.CallOption) (*GetGraphStateResponse, error) {
	out := new(GetGraphStateResponse)
	err := c.cc.Invoke(ctx, "/model.FlowService/GetGraphState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowServiceClient) StreamLifecycle(ctx context.Context, in *StreamLifecycleRequest, opts ...grpc.CallOption) (FlowService_StreamLifecycleClient, error) {
	stream, err := c.cc.NewStream(ctx, &_FlowService_serviceDesc.Streams[0], "/model.FlowService/StreamLifecycle", opts...)
	if err != nil {
		return nil, err
	}
	x := &flowServiceStreamLifecycleClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type FlowService_StreamLifecycleClient interface {
	Recv() (*GraphLifecycleEvent, error)
	grpc.ClientStream
}

type flowServiceStreamLifecycleClient struct {
	grpc.ClientStream
}

func (x *flowServiceStreamLifecycleClient) Recv() (*GraphLifecycleEvent, error) {
	m := new(GraphLifecycleEvent)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *flowServiceClient) StreamEvents(ctx context.Context, in *StreamGraphRequest, opts ...grpc.CallOption) (FlowService_StreamEventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_FlowService_serviceDesc.Streams[1], "/model.FlowService/StreamEvents", opts...)
	if err != nil {
		return nil, err
	}
	x := &flowServiceStreamEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type FlowService_StreamEventsClient interface {
	Recv() (*GraphStreamEvent, error)
	grpc.ClientStream
}

type flowServiceStreamEventsClient struct {
	grpc.ClientStream
}

func (x *flowServiceStreamEventsClient) Recv() (*GraphStreamEvent, error) {
	m := new(GraphStreamEvent)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// FlowServiceServer is the server API for FlowService service.
type FlowServiceServer interface {
	CreateGraph(context.Context, *CreateGraphRequest) (*CreateGraphResponse, error)
	AddStage(context.Context, *AddStageRequest) (*AddStageResponse, error)
	AddValueStage(context.Context, *AddCompletedValueStageRequest) (*AddStageResponse, error)
	AddInvokeFunction(context.Context, *AddInvokeFunctionStageRequest) (*AddStageResponse, error)
	AddDelay(context.Context, *AddDelayStageRequest) (*AddStageResponse, error)
	AwaitStageResult(context.Context, *AwaitStageResultRequest) (*AwaitStageResultResponse, error)
	CompleteStageExternally(context.Context, *CompleteStageExternallyRequest) (*CompleteStageExternallyResponse, error)
	Commit(context.Context, *CommitGraphRequest) (*GraphRequestProcessedResponse, error)
	GetGraphState(context.Context, *GetGraphStateRequest) (*GetGraphStateResponse, error)
	StreamLifecycle(*StreamLifecycleRequest, FlowService_StreamLifecycleServer) error
	StreamEvents(*StreamGraphRequest, FlowService_StreamEventsServer) error
}

func RegisterFlowServiceServer(s *grpc.Server, srv FlowServiceServer) {
	s.RegisterService(&_FlowService_serviceDesc, srv)
}

func _FlowService_CreateGraph_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGraphRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowServiceServer).CreateGraph(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/model.FlowService/CreateGraph",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowServiceServer).CreateGraph(ctx, req.(*CreateGraphRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FlowService_AddStage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddStageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowServiceServer).AddStage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/model.FlowService/AddStage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowServiceServer).AddStage(ctx, req.(*AddStageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FlowService_AddValueStage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddCompletedValueStageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowServiceServer).AddValueStage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/model.FlowService/AddValueStage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowServiceServer).AddValueStage(ctx, req.(*AddCompletedValueStageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FlowService_AddInvokeFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddInvokeFunctionStageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowServiceServer).AddInvokeFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/model.FlowService/AddInvokeFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowServiceServer).AddInvokeFunction(ctx, req.(*AddInvokeFunctionStageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FlowService_AddDelay_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddDelayStageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowServiceServer).AddDelay(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/model.FlowService/AddDelay",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowServiceServer).AddDelay(ctx, req.(*AddDelayStageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FlowService_AwaitStageResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AwaitStageResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowServiceServer).AwaitStageResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/model.FlowService/AwaitStageResult",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowServiceServer).AwaitStageResult(ctx, req.(*AwaitStageResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FlowService_CompleteStageExternally_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CompleteStageExternallyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowServiceServer).CompleteStageExternally(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/model.FlowService/CompleteStageExternally",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowServiceServer).CompleteStageExternally(ctx, req.(*CompleteStageExternallyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FlowService_Commit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitGraphRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowServiceServer).Commit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/model.FlowService/Commit",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowServiceServer).Commit(ctx, req.(*CommitGraphRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FlowService_GetGraphState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGraphStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowServiceServer).GetGraphState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/model.FlowService/GetGraphState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowServiceServer).GetGraphState(ctx, req.(*GetGraphStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FlowService_StreamLifecycle_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StreamLifecycleRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(FlowServiceServer).StreamLifecycle(m, &flowServiceStreamLifecycleServer{stream})
}

type FlowService_StreamLifecycleServer interface {
	Send(*GraphLifecycleEvent) error
	grpc.ServerStream
}

type flowServiceStreamLifecycleServer struct {
	grpc.ServerStream
}

func (x *flowServiceStreamLifecycleServer) Send(m *GraphLifecycleEvent) error {
	return x.ServerStream.SendMsg(m)
}

func _FlowService_StreamEvents_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StreamGraphRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(FlowServiceServer).StreamEvents(m, &flowServiceStreamEventsServer{stream})
}

type FlowService_StreamEventsServer interface {
	Send(*GraphStreamEvent) error
	grpc.ServerStream
}

type flowServiceStreamEventsServer struct {
	grpc.ServerStream
}

func (x *flowServiceStreamEventsServer) Send(m *GraphStreamEvent) error {
	return x.ServerStream.SendMsg(m)
}

var _FlowService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "model.FlowService",
	HandlerType: (*FlowServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateGraph",
			Handler:    _FlowService_CreateGraph_Handler,
		},
		{
			MethodName: "AddStage",
			Handler:    _FlowService_AddStage_Handler,
		},
		{
			MethodName: "AddValueStage",
			Handler:    _FlowService_AddValueStage_Handler,
		},
		{
			MethodName: "AddInvokeFunction",
			Handler:    _FlowService_AddInvokeFunction_Handler,
		},
		{
			MethodName: "AddDelay",
			Handler:    _FlowService_AddDelay_Handler,
		},
		{
			MethodName: "AwaitStageResult",
			Handler:    _FlowService_AwaitStageResult_Handler,
		},
		{
			MethodName: "CompleteStageExternally",
			Handler:    _FlowService_CompleteStageExternally_Handler,
		},
		{
			MethodName: "Commit",
			Handler:    _FlowService_Commit_Handler,
		},
		{
			MethodName: "GetGraphState",
			Handler:    _FlowService_GetGraphState_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamLifecycle",
			Handler:       _FlowService_StreamLifecycle_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "StreamEvents",
			Handler:       _FlowService_StreamEvents_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "model.proto",
}

func init() { proto.RegisterFile("model.proto", fileDescriptor_model_52321f9a89a392dd) }

var fileDescriptor_model_52321f9a89a392dd = []byte{
	// 2891 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x39, 0x49, 0x6f, 0x23, 0xd7,
	0xd1, 0x6a, 0xae, 0x62, 0x51, 0x4b, 0xeb, 0x69, 0xa3, 0x38, 0x8b, 0xe4, 0xf6, 0xd8, 0x9f, 0x4c,
	0x5b, 0xe4, 0x8c, 0x06, 0xf3, 0xd9, 0x63, 0x18, 0x9f, 0x2d, 0xcd, 0x48, 0x96, 0xf0, 0xcd, 0xc0,
	0x46, 0x4b, 0xc8, 0x32, 0x76, 0x4c, 0xb4, 0xd8, 0x8f, 0x64, 0x47, 0xcd, 0xee, 0x9e, 0x7e, 0x4d,
	0xc9, 0xca, 0xc4, 0x48, 0x10, 0xe4, 0x10, 0x20, 0x48, 0x60, 0x20, 0xbe, 0x26, 0x08, 0x10, 0xc4,
	0xb7, 0x20, 0xc7, 0x20, 0xb7, 0x1c, 0x73, 0xcb, 0x21, 0x40, 0x6e, 0xc1, 0x00, 0x83, 0x00, 0xf9,
	0x07, 0x39, 0x05, 0x48, 0xf0, 0xb6, 0x5e, 0xb8, 0x0c, 0xa9, 0x91, 0x9c, 0xf0, 0xc4, 0xae, 0x57,
	0xaf, 0xb6, 0x57, 0x55, 0xaf, 0xaa, 0x1e, 0x14, 0x3b, 0xae, 0x89, 0xed, 0xaa, 0xe7, 0xbb, 0x81,
	0x8b, 0xb2, 0xec, 0xa3, 0xbc, 0xda, 0x72, 0xdd, 0x96, 0x8d, 0x6b, 0x0c, 0x78, 0xd4, 0x6d, 0xd6,
	0x02, 0xab, 0x83, 0x49, 0x60, 0x74, 0x3c, 0x8e, 0x57, 0xfe, 0xdf, 0x96, 0x15, 0xb4, 0xbb, 0x47,
	0xd5, 0x86, 0xdb, 0xa9, 0x75, 0x4e, 0xad, 0xe0, 0xd8, 0x3d, 0xad, 0xb5, 0xdc, 0x0d, 0xb6, 0xb8,
	0x71, 0x62, 0xd8, 0x96, 0x69, 0x04, 0xae, 0x4f, 0x6a, 0xe1, 0x5f, 0xb1, 0xef, 0xaa, 0x20, 0x6c,
	0x78, 0x56, 0xcd, 0x70, 0x1c, 0x37, 0x30, 0x02, 0xcb, 0x75, 0x08, 0x5f, 0xd5, 0x3e, 0x01, 0xf5,
	0x9e, 0xdb, 0xf1, 0x6c, 0x4c, 0x81, 0x3a, 0x26, 0x5d, 0x3b, 0x40, 0xd7, 0x01, 0x48, 0xb7, 0xd1,
	0xc0, 0x84, 0x34, 0xbb, 0x76, 0x49, 0x59, 0x53, 0xd6, 0x27, 0xf5, 0x18, 0x04, 0x55, 0x20, 0x6b,
	0x1a, 0x41, 0xb7, 0x53, 0x4a, 0xad, 0x29, 0xeb, 0xc5, 0xcd, 0xa9, 0x2a, 0x57, 0xe7, 0x3e, 0x85,
	0x6d, 0xe7, 0x9e, 0x3d, 0x5d, 0x4d, 0xad, 0x29, 0x3a, 0x47, 0xd1, 0x4e, 0xa1, 0xb0, 0x6d, 0xbb,
	0x47, 0x6c, 0x0d, 0xad, 0x42, 0xfe, 0xc8, 0x76, 0x8f, 0xea, 0x96, 0xc9, 0xa8, 0x16, 0x38, 0xf2,
	0x37, 0x14, 0x3d, 0x47, 0xc1, 0xfb, 0x26, 0x7a, 0x0d, 0xa6, 0x1a, 0xae, 0x13, 0x60, 0x27, 0xa8,
	0x07, 0x67, 0x1e, 0x66, 0x0c, 0x22, 0xac, 0xa2, 0x58, 0x3b, 0x3c, 0xf3, 0x30, 0xba, 0x0e, 0x39,
	0x1b, 0x3b, 0xad, 0xa0, 0x5d, 0x4a, 0xaf, 0x29, 0xeb, 0x69, 0x8e, 0xa4, 0x4e, 0xe8, 0x02, 0xaa,
	0xdd, 0x07, 0xd8, 0x3b, 0x3c, 0xfc, 0x70, 0x0f, 0x1b, 0x26, 0xf6, 0x51, 0x09, 0xd2, 0xc7, 0xf8,
	0xac, 0x87, 0x2b, 0x05, 0xa1, 0xab, 0x90, 0x3d, 0x31, 0xec, 0x6e, 0x2f, 0x2f, 0x0e, 0xd4, 0xbe,
	0x50, 0x60, 0x8a, 0x92, 0xd1, 0xf1, 0x63, 0xae, 0xc2, 0x0d, 0xc8, 0x1c, 0xb9, 0x26, 0xa7, 0x54,
	0xdc, 0x54, 0x85, 0xea, 0xa1, 0x8a, 0x3a, 0x5b, 0x45, 0xaf, 0x43, 0xbe, 0xcd, 0x18, 0x93, 0x52,
	0x7a, 0x2d, 0xbd, 0x5e, 0xdc, 0x9c, 0x13, 0x88, 0x91, 0x48, 0xba, 0xc4, 0x40, 0xb7, 0x20, 0xd7,
	0xc1, 0x41, 0xdb, 0x35, 0x4b, 0x99, 0x35, 0x65, 0x7d, 0x26, 0x81, 0xfb, 0x90, 0x2d, 0x84, 0x46,
	0x15, 0x88, 0xda, 0x8f, 0x15, 0x98, 0xe6, 0x62, 0x11, 0xef, 0x2b, 0x93, 0xeb, 0x7f, 0xa0, 0x48,
	0x02, 0x23, 0xe8, 0x92, 0x7a, 0xc3, 0x35, 0x31, 0x13, 0x2e, 0x1b, 0x9a, 0x19, 0xf8, 0xd2, 0x3d,
	0xd7, 0xc4, 0xda, 0x14, 0xc0, 0x4e, 0xc7, 0x0b, 0xce, 0x18, 0x27, 0x6d, 0x13, 0xa6, 0x0f, 0x02,
	0xa3, 0x85, 0x75, 0xdc, 0xe4, 0xa2, 0xbd, 0x04, 0x93, 0x84, 0x02, 0xfa, 0x8f, 0x3d, 0xcf, 0xe0,
	0xfb, 0xa6, 0xf6, 0x4d, 0x80, 0x1d, 0xdf, 0x77, 0x7d, 0xbe, 0xe1, 0x16, 0x64, 0xd8, 0xe9, 0x2b,
	0xcc, 0x1c, 0x8b, 0x42, 0xc4, 0x08, 0x81, 0x9e, 0x7f, 0x68, 0x12, 0x86, 0x8a, 0x4a, 0x90, 0xef,
	0x60, 0x42, 0x8c, 0x96, 0x38, 0x47, 0x5d, 0x7e, 0x6a, 0x5b, 0x50, 0x3c, 0x60, 0xa2, 0x72, 0xda,
	0x9b, 0x09, 0xda, 0x4b, 0x82, 0x76, 0x0c, 0xa3, 0x9f, 0xb8, 0xf6, 0x97, 0x14, 0x64, 0xf9, 0xee,
	0xd7, 0x20, 0x8b, 0xa9, 0xa6, 0xc2, 0xcc, 0xd2, 0x7a, 0x91, 0xf6, 0x7b, 0x13, 0x3a, 0xc7, 0x40,
	0xaf, 0x42, 0x86, 0x3a, 0xb5, 0x88, 0x91, 0xbe, 0x03, 0xd9, 0x9b, 0xd0, 0xd9, 0x3a, 0x23, 0x49,
	0x35, 0x63, 0x6e, 0x1c, 0x23, 0x19, 0x6a, 0xcb, 0x48, 0xd2, 0x2f, 0x74, 0x1b, 0x0a, 0xdc, 0x90,
	0x3e, 0x6e, 0xb2, 0xe3, 0x28, 0x6e, 0x2e, 0x44, 0x0a, 0x44, 0x16, 0xdf, 0x9b, 0xd0, 0xb9, 0xc5,
	0x75, 0xdc, 0x44, 0x37, 0x61, 0xb2, 0x1d, 0x04, 0x5e, 0xdd, 0xc7, 0x8f, 0x4b, 0x59, 0xb6, 0x67,
	0x3e, 0x76, 0xe6, 0xd2, 0xaf, 0xf7, 0x26, 0xf4, 0x3c, 0x45, 0xd3, 0xf1, 0x63, 0xca, 0x46, 0xec,
	0x20, 0x5e, 0x29, 0x97, 0x60, 0x93, 0xf0, 0x39, 0xca, 0x86, 0xef, 0x21, 0x1e, 0x7a, 0x03, 0x72,
	0xdc, 0x23, 0x4a, 0x79, 0xb6, 0x03, 0xf5, 0x5b, 0x76, 0x6f, 0x42, 0x17, 0x38, 0xdb, 0x59, 0x48,
	0x9f, 0x18, 0xb6, 0xf6, 0x0f, 0x05, 0x66, 0xb7, 0x4c, 0x53, 0x08, 0xff, 0xb8, 0x8b, 0x49, 0x40,
	0x73, 0x44, 0xd3, 0x76, 0x4f, 0x07, 0xe4, 0x08, 0x0a, 0xde, 0x37, 0xd1, 0x7b, 0x50, 0x70, 0x3d,
	0xec, 0xb3, 0x2c, 0xc6, 0xac, 0x3b, 0xb3, 0x59, 0x16, 0xcc, 0xa2, 0x4c, 0xf6, 0x81, 0xc4, 0x08,
	0x8f, 0x32, 0xda, 0x84, 0x2a, 0x90, 0x6f, 0xd8, 0x2e, 0xe9, 0xfa, 0x58, 0x18, 0xbd, 0x3f, 0x5c,
	0x24, 0x02, 0x42, 0x90, 0x31, 0xb1, 0x47, 0x4a, 0x99, 0xb5, 0xf4, 0x7a, 0x41, 0x67, 0xff, 0xd1,
	0xcb, 0x30, 0x4d, 0x23, 0xa2, 0x6e, 0xbb, 0x0d, 0x2e, 0x45, 0x96, 0xb9, 0xdc, 0x14, 0x05, 0x3e,
	0x10, 0x30, 0x74, 0x05, 0x0a, 0x0d, 0xc3, 0xb6, 0xb1, 0x4f, 0x35, 0xc9, 0x31, 0x84, 0x49, 0x0e,
	0xd8, 0x37, 0xb5, 0xbf, 0x2a, 0x70, 0x5d, 0x08, 0x8b, 0x99, 0xf6, 0x3b, 0x9f, 0x06, 0xd8, 0x77,
	0x0c, 0xdb, 0x3e, 0x1b, 0xdb, 0x0e, 0xf1, 0xb0, 0x4a, 0x0d, 0x0c, 0x2b, 0x74, 0x47, 0xe6, 0x36,
	0xae, 0xe6, 0x72, 0x9f, 0x99, 0x78, 0xc2, 0x8f, 0x72, 0x36, 0xc3, 0xee, 0xd7, 0x2f, 0x33, 0x4a,
	0xbf, 0x6c, 0x8f, 0x7e, 0xbf, 0x57, 0xe0, 0xda, 0x96, 0x69, 0x4a, 0x15, 0xcd, 0xaf, 0x51, 0xba,
	0xe7, 0x3b, 0xe6, 0x3b, 0xf1, 0xbc, 0x7c, 0x01, 0xd9, 0xd3, 0xa3, 0x64, 0xcf, 0xf4, 0xc8, 0xfe,
	0x6b, 0x05, 0x16, 0xb6, 0x4c, 0xf3, 0x3e, 0xb6, 0x8d, 0xb3, 0xf3, 0x89, 0x5c, 0x81, 0x49, 0x93,
	0xee, 0xaa, 0x77, 0x08, 0x93, 0x3a, 0xbd, 0x3d, 0xfb, 0xec, 0xe9, 0x6a, 0x51, 0xfd, 0x97, 0xfc,
	0x29, 0x7a, 0x9e, 0x21, 0x3c, 0x24, 0x97, 0x20, 0xe7, 0x17, 0x29, 0x66, 0xe3, 0x7d, 0xe7, 0xc4,
	0x3d, 0xc6, 0xbb, 0x5d, 0xa7, 0x41, 0xb7, 0x9c, 0x4f, 0x60, 0x03, 0x8a, 0x4d, 0xb1, 0x31, 0xf2,
	0xa2, 0xf7, 0x9e, 0x3d, 0x5d, 0x7d, 0x07, 0xae, 0x7c, 0xb2, 0xfe, 0x91, 0xb1, 0xf1, 0x9d, 0xad,
	0x8d, 0x47, 0x37, 0x37, 0xee, 0xd6, 0xab, 0x1f, 0x6f, 0x7c, 0xeb, 0xc9, 0xad, 0x37, 0x36, 0xef,
	0xdc, 0xf9, 0xec, 0xb5, 0x77, 0x6f, 0x54, 0xae, 0xc9, 0x5d, 0x6b, 0x96, 0xb9, 0xd6, 0xe9, 0x92,
	0x60, 0xed, 0x08, 0xaf, 0x11, 0x0f, 0x37, 0xac, 0xa6, 0x85, 0x4d, 0x1d, 0xe4, 0xf2, 0xbe, 0x89,
	0x36, 0x20, 0x6d, 0xf8, 0x2d, 0xe1, 0x80, 0x83, 0x32, 0x4f, 0x78, 0x80, 0x14, 0xef, 0x12, 0x5c,
	0x6f, 0x17, 0xd4, 0x28, 0xa5, 0x10, 0xcf, 0x75, 0x08, 0x46, 0xcb, 0x3d, 0x86, 0x08, 0x0d, 0xb0,
	0xd2, 0x1b, 0x43, 0xd1, 0x95, 0x74, 0x07, 0xd0, 0x3d, 0xb7, 0xd3, 0xb1, 0x82, 0xf7, 0x7d, 0xc3,
	0x6b, 0x8f, 0x6b, 0x52, 0xed, 0x2d, 0xb8, 0x16, 0xdf, 0xf0, 0xa1, 0xef, 0xd2, 0xaa, 0x09, 0x9b,
	0x23, 0x65, 0xd1, 0x3e, 0x57, 0x60, 0x45, 0x06, 0xcc, 0x0b, 0x38, 0xdf, 0x18, 0xe9, 0xa0, 0x06,
	0x39, 0x9f, 0x05, 0xcd, 0x88, 0x7c, 0xa0, 0x0b, 0x34, 0xad, 0x0b, 0xab, 0x43, 0xb3, 0xd4, 0x8b,
	0x9b, 0xb6, 0xa7, 0xbe, 0x4c, 0xf7, 0xd6, 0x97, 0xda, 0x5d, 0x58, 0xba, 0x8f, 0x8d, 0x46, 0x60,
	0x9d, 0x18, 0x01, 0x3e, 0x9f, 0xf9, 0x3f, 0x57, 0x00, 0xdd, 0xf3, 0x71, 0xef, 0xbe, 0x1e, 0x47,
	0x57, 0xbe, 0x02, 0x47, 0x8f, 0x19, 0x22, 0x95, 0x38, 0xd7, 0x2a, 0xcc, 0x27, 0x24, 0x1a, 0xe5,
	0x07, 0xbf, 0x53, 0x60, 0x69, 0xd7, 0x30, 0x08, 0x0d, 0x6c, 0xee, 0xf0, 0x17, 0x32, 0xf6, 0x6a,
	0x52, 0x75, 0x9e, 0x66, 0xe2, 0x82, 0x47, 0x5e, 0x91, 0x19, 0xcb, 0x2b, 0xa8, 0x14, 0x34, 0xda,
	0xa2, 0xe0, 0xcb, 0xd1, 0xcf, 0x7d, 0x53, 0x7b, 0x13, 0x16, 0xde, 0xc7, 0x3c, 0x5e, 0xe8, 0xb5,
	0x3f, 0xb6, 0xef, 0x6a, 0x7f, 0x4f, 0xc1, 0x62, 0xcf, 0x4e, 0xa1, 0xf1, 0x7b, 0xac, 0xac, 0x68,
	0x61, 0x52, 0x52, 0x58, 0xbd, 0xba, 0x2e, 0x84, 0x1b, 0x88, 0xcd, 0xab, 0x20, 0xb2, 0xe3, 0x04,
	0xfe, 0x99, 0x2e, 0xf6, 0xf5, 0xea, 0x9f, 0xea, 0xd3, 0x3f, 0x66, 0xd4, 0x74, 0xdc, 0xa8, 0x65,
	0x0c, 0xf3, 0x22, 0x04, 0x3d, 0x1f, 0x13, 0xec, 0xf0, 0xc6, 0x89, 0x56, 0x04, 0x61, 0x05, 0x59,
	0x10, 0xe5, 0xe7, 0x52, 0x58, 0xfd, 0x88, 0xb3, 0xe7, 0x5f, 0x48, 0x83, 0x29, 0x13, 0x7b, 0xd8,
	0x31, 0xb1, 0xd3, 0xb0, 0x30, 0x2f, 0xba, 0x0b, 0x7a, 0x02, 0x56, 0x3e, 0x66, 0x05, 0xaa, 0x94,
	0x1b, 0xa9, 0xb1, 0x4e, 0x85, 0x77, 0x28, 0xbb, 0xc9, 0x9b, 0xf0, 0xe6, 0x68, 0x13, 0x24, 0x25,
	0x16, 0x57, 0xe3, 0xdb, 0xa9, 0xb7, 0x14, 0xed, 0x01, 0xcc, 0x3d, 0xb0, 0x08, 0xdf, 0x48, 0xe4,
	0xf9, 0xbc, 0x09, 0xb9, 0xa6, 0x65, 0x07, 0xd8, 0x17, 0x55, 0xb1, 0xf4, 0x80, 0x08, 0x73, 0x97,
	0x2d, 0x47, 0x6d, 0x08, 0x47, 0xd7, 0x4a, 0xb0, 0x74, 0x10, 0xf8, 0xd8, 0xe8, 0x3c, 0xb0, 0x9a,
	0xb8, 0x71, 0xd6, 0xb0, 0xe5, 0x91, 0x6b, 0x7b, 0x80, 0xf8, 0x4a, 0x22, 0x0c, 0x87, 0xc5, 0x08,
	0xf5, 0xdf, 0xa6, 0xef, 0x76, 0xea, 0x04, 0x3f, 0x66, 0x87, 0x90, 0xd1, 0xf3, 0xf4, 0xfb, 0x00,
	0x3f, 0xd6, 0xde, 0x88, 0x49, 0x3c, 0x3a, 0x78, 0x76, 0x01, 0xc5, 0xf5, 0x13, 0xe8, 0x37, 0x21,
	0xd7, 0x62, 0x10, 0xe1, 0x45, 0xa5, 0x5e, 0x05, 0x25, 0xa6, 0x2e, 0xf0, 0xb4, 0x9f, 0x28, 0xb0,
	0xbc, 0x75, 0x6a, 0x58, 0x81, 0xbc, 0x48, 0x68, 0x00, 0x5c, 0x62, 0x2a, 0xae, 0x02, 0xd0, 0xfe,
	0xde, 0xed, 0x06, 0xb4, 0x58, 0x48, 0xb3, 0xd6, 0xaa, 0xaf, 0x58, 0x28, 0x08, 0x94, 0x87, 0x44,
	0xfb, 0x1e, 0x94, 0xfa, 0xc5, 0xb9, 0x40, 0x56, 0x38, 0xf7, 0x55, 0xf0, 0xc3, 0x14, 0x2c, 0x26,
	0x4b, 0x8d, 0xcb, 0x34, 0xc7, 0xa7, 0x03, 0x92, 0xd4, 0xf6, 0xd7, 0x9f, 0x3d, 0x5d, 0x3d, 0x80,
	0x77, 0x3e, 0x59, 0xff, 0xb8, 0xfa, 0xdd, 0x58, 0x8a, 0x8e, 0x65, 0xe8, 0xf5, 0x5a, 0x0c, 0x5e,
	0xa3, 0x0b, 0x37, 0xc5, 0xc2, 0xc7, 0xef, 0x56, 0x2b, 0x34, 0x81, 0xcf, 0x5b, 0x0e, 0x9b, 0x87,
	0xac, 0xc5, 0x12, 0xf9, 0xa0, 0xfa, 0x24, 0x33, 0x5e, 0x7d, 0xa2, 0xfd, 0x22, 0x05, 0x88, 0x9b,
	0xe1, 0xd2, 0x6f, 0xe7, 0xc6, 0x20, 0x1b, 0x6c, 0x3f, 0x7b, 0xba, 0xfa, 0x7f, 0x17, 0xb3, 0x41,
	0x42, 0xdd, 0xd7, 0x21, 0x63, 0xf8, 0x2d, 0x52, 0xca, 0xb2, 0x38, 0x18, 0x7a, 0xea, 0x0c, 0x09,
	0x6d, 0x46, 0x7d, 0x52, 0x6e, 0x70, 0x9f, 0x14, 0x1a, 0x47, 0x22, 0x6a, 0x7f, 0x52, 0x60, 0x9e,
	0x85, 0x54, 0x98, 0x12, 0x76, 0x4e, 0xb0, 0x13, 0xd0, 0xb4, 0x46, 0x83, 0x5b, 0x61, 0xc1, 0x4d,
	0xff, 0x0e, 0x4f, 0x06, 0xef, 0xc2, 0x34, 0x8b, 0xc2, 0x7a, 0x83, 0x5d, 0x9b, 0x66, 0x09, 0x18,
	0x73, 0x19, 0xb4, 0x8c, 0x3a, 0xbf, 0x51, 0x4d, 0x46, 0x7b, 0x6f, 0x42, 0x9f, 0x6a, 0xc5, 0x80,
	0x68, 0x07, 0x66, 0x05, 0x01, 0xd9, 0x7f, 0x94, 0xa6, 0x18, 0x89, 0x72, 0x82, 0x84, 0x5c, 0x94,
	0x44, 0x66, 0x5a, 0x09, 0xb0, 0x6c, 0x52, 0x9f, 0xe5, 0x40, 0x15, 0x89, 0x96, 0x26, 0xb4, 0x73,
	0xab, 0x73, 0x1b, 0xf2, 0x84, 0x0d, 0xb4, 0x88, 0x88, 0xb5, 0x72, 0x95, 0x4f, 0xe4, 0xaa, 0x72,
	0xd4, 0x57, 0x3d, 0x94, 0xa3, 0x3e, 0x3d, 0x47, 0x51, 0x0f, 0xc9, 0xc5, 0x6d, 0xf0, 0xff, 0x30,
	0xc7, 0x09, 0x04, 0xd8, 0xef, 0x58, 0x8e, 0x11, 0x58, 0x4e, 0xab, 0x54, 0x64, 0x44, 0xae, 0xc6,
	0x89, 0x1c, 0x46, 0xcb, 0x92, 0x90, 0xda, 0xea, 0x59, 0xb8, 0x24, 0x83, 0x52, 0x32, 0xbc, 0x3f,
	0x22, 0x8d, 0x36, 0x36, 0xbb, 0x36, 0x36, 0x4b, 0xd3, 0x09, 0x32, 0xbc, 0xec, 0x95, 0x8b, 0x21,
	0x19, 0x33, 0x01, 0x46, 0x77, 0xd9, 0x5c, 0xaa, 0x85, 0xeb, 0x86, 0x69, 0x62, 0xb3, 0x34, 0xc3,
	0x48, 0x2c, 0xc5, 0x07, 0x21, 0x5b, 0x74, 0x41, 0x6e, 0x07, 0x12, 0x82, 0xa8, 0x04, 0x7c, 0x6b,
	0xa4, 0xc8, 0x6c, 0x42, 0x02, 0xb6, 0xbd, 0x5f, 0x11, 0x92, 0x00, 0xa3, 0x6d, 0x98, 0x89, 0xc8,
	0xb8, 0x04, 0x9b, 0x25, 0x95, 0x51, 0x59, 0xe9, 0xa5, 0x42, 0xd7, 0x24, 0x91, 0x69, 0x12, 0x87,
	0xa2, 0x8f, 0x60, 0xb9, 0x69, 0x18, 0xa4, 0x6e, 0x85, 0x65, 0x5e, 0x9d, 0x04, 0x86, 0x4f, 0x45,
	0x9a, 0x63, 0xc4, 0x5e, 0x12, 0xc4, 0x92, 0xb5, 0xe0, 0x01, 0xc7, 0x91, 0x44, 0x17, 0x9b, 0x83,
	0x56, 0x91, 0x01, 0x2b, 0xbd, 0xc4, 0x23, 0x8d, 0x11, 0x23, 0xff, 0xf2, 0x40, 0xf2, 0x7d, 0xaa,
	0x2f, 0x37, 0x07, 0xaf, 0x27, 0x7c, 0xa2, 0x63, 0x05, 0x94, 0xf0, 0xfc, 0x40, 0x9f, 0xe0, 0x8b,
	0x7d, 0x3e, 0xc1, 0xc1, 0x32, 0xc8, 0xce, 0x60, 0xae, 0xcf, 0xa7, 0x87, 0x5f, 0x6c, 0x23, 0x6b,
	0xba, 0x0a, 0xa4, 0xc6, 0x0a, 0xb7, 0x54, 0x40, 0xb4, 0x9f, 0x2a, 0x30, 0x3f, 0xc0, 0xf1, 0x12,
	0xb7, 0xa7, 0x92, 0xbc, 0x3d, 0x97, 0x21, 0x4f, 0xaf, 0xe6, 0xb0, 0xcf, 0xd7, 0x73, 0xf4, 0xf3,
	0x21, 0x39, 0x0f, 0xdf, 0xb8, 0x76, 0x99, 0x44, 0x0d, 0xf3, 0x1b, 0x05, 0x16, 0x07, 0xc6, 0xe6,
	0x05, 0x0c, 0x52, 0x0d, 0x0b, 0xd4, 0xf4, 0xf3, 0x06, 0x9f, 0x61, 0xe1, 0xca, 0x15, 0xc9, 0x8c,
	0x65, 0xc0, 0x27, 0x22, 0xe3, 0x27, 0x7d, 0xe7, 0x3f, 0x74, 0x7a, 0x8f, 0x22, 0xe6, 0x31, 0x47,
	0x1b, 0xce, 0x9c, 0xd3, 0x4e, 0x8d, 0x45, 0xfb, 0xb7, 0x29, 0x98, 0xed, 0xc9, 0x27, 0xcf, 0xf3,
	0x8a, 0x0a, 0xa4, 0x5c, 0x6f, 0xf4, 0x44, 0x52, 0x4f, 0xb9, 0xde, 0xb9, 0x46, 0x90, 0xbd, 0x4d,
	0x44, 0xa6, 0xbf, 0x89, 0x10, 0x6a, 0x65, 0xc7, 0x72, 0xbc, 0xbe, 0x19, 0x4b, 0x6e, 0xd4, 0x8c,
	0x25, 0x9f, 0x9c, 0xb1, 0xc4, 0xad, 0x3b, 0x99, 0x70, 0xdd, 0x2f, 0x15, 0xd1, 0x33, 0xf5, 0xf8,
	0xc2, 0x73, 0xac, 0x16, 0x55, 0xa2, 0xa9, 0xf1, 0xda, 0xcf, 0x4b, 0x89, 0xb1, 0x5f, 0x2a, 0xb4,
	0x41, 0xe9, 0xcd, 0xd2, 0xcf, 0x3f, 0xdd, 0x39, 0x99, 0xed, 0xeb, 0x3d, 0x55, 0xf5, 0xac, 0x5c,
	0x38, 0x88, 0x3c, 0xe1, 0xe2, 0x22, 0xfe, 0x5c, 0x81, 0xf2, 0xf0, 0xdc, 0x3f, 0xc2, 0x11, 0xc7,
	0xf5, 0xf1, 0xd1, 0xe3, 0x81, 0xa1, 0xf2, 0xfd, 0x51, 0x81, 0xab, 0xcf, 0xbb, 0x3c, 0xfe, 0x9b,
	0x87, 0x2e, 0xe7, 0x13, 0x99, 0xf8, 0x7c, 0x22, 0xae, 0x4a, 0x36, 0xa1, 0xca, 0x1f, 0x14, 0x58,
	0xd1, 0xbb, 0x0e, 0x4d, 0xe2, 0x5f, 0x51, 0x71, 0x2f, 0xeb, 0xee, 0xf4, 0x39, 0xeb, 0xee, 0xcc,
	0xb8, 0x75, 0xf7, 0x43, 0x28, 0x0f, 0xd2, 0x40, 0xb4, 0x88, 0x91, 0xbd, 0xb3, 0x63, 0xd9, 0xbb,
	0xf2, 0x6d, 0xfe, 0x7a, 0xca, 0x9f, 0x1f, 0x11, 0x82, 0x99, 0xae, 0x73, 0xec, 0xb8, 0xa7, 0x4e,
	0x9d, 0x3f, 0x40, 0xaa, 0x13, 0x28, 0x0f, 0xe9, 0x16, 0x0e, 0x54, 0x05, 0x4d, 0x42, 0xa6, 0x8d,
	0x0d, 0x53, 0x4d, 0xd1, 0x7f, 0x9e, 0x4b, 0x02, 0x35, 0x4d, 0x17, 0xbd, 0x6e, 0xa0, 0x66, 0x10,
	0x40, 0xce, 0xc4, 0xd4, 0x27, 0xd4, 0x2c, 0x2a, 0x42, 0xde, 0xf5, 0xd8, 0xdb, 0xb3, 0x9a, 0x47,
	0x05, 0xc8, 0x7a, 0x46, 0xd0, 0x68, 0xab, 0xb9, 0xca, 0x97, 0x0a, 0xcc, 0x24, 0x1f, 0xf7, 0xd0,
	0x1c, 0x4c, 0x4b, 0x86, 0xec, 0xe9, 0x4b, 0x9d, 0xa0, 0x20, 0x6e, 0x64, 0xd1, 0x14, 0xab, 0x0a,
	0x52, 0x61, 0x8a, 0x83, 0x9a, 0x86, 0x65, 0x63, 0x2a, 0xc1, 0x02, 0xa8, 0xa1, 0x37, 0x4b, 0xbc,
	0x34, 0x2a, 0xc3, 0x52, 0xe4, 0xe3, 0xcc, 0x3a, 0x72, 0x47, 0x06, 0xcd, 0x00, 0xaf, 0x0f, 0xeb,
	0x36, 0x95, 0x3c, 0x4b, 0x71, 0x45, 0xcb, 0x58, 0x97, 0x6f, 0x6d, 0xdc, 0x86, 0x6a, 0xae, 0xf2,
	0x88, 0x5d, 0x07, 0xf1, 0xfb, 0x32, 0x2e, 0x28, 0xbd, 0x39, 0xb1, 0x3a, 0x81, 0xa6, 0xa1, 0xc0,
	0x66, 0x99, 0xd8, 0xc4, 0xa6, 0xaa, 0x50, 0x0b, 0x84, 0xe2, 0x4d, 0xd3, 0xa4, 0xea, 0x34, 0xb0,
	0x4d, 0x3f, 0xd3, 0x74, 0xe9, 0xd8, 0x62, 0xff, 0x33, 0x95, 0xef, 0xa7, 0x61, 0x7e, 0xc0, 0x65,
	0x81, 0x16, 0x61, 0x4e, 0x32, 0x08, 0x1f, 0xb0, 0xd4, 0x09, 0xaa, 0xba, 0xd1, 0x68, 0x60, 0x2f,
	0xd8, 0xb1, 0x82, 0x36, 0xf6, 0x55, 0x85, 0x4a, 0x62, 0x78, 0x9e, 0x7d, 0x76, 0xe8, 0x0a, 0x50,
	0x8a, 0x1e, 0x5b, 0xd0, 0xc6, 0xce, 0x16, 0x43, 0xdc, 0x76, 0x83, 0xb6, 0x9a, 0xa6, 0x22, 0x30,
	0x18, 0x45, 0x55, 0x33, 0xf4, 0x4c, 0xe8, 0xa7, 0xde, 0x75, 0xd4, 0x2c, 0xb5, 0x45, 0x84, 0xaf,
	0xe6, 0xd0, 0x2c, 0x14, 0xe9, 0xb7, 0x48, 0x91, 0x6a, 0x3e, 0x06, 0x38, 0xb2, 0x1c, 0xac, 0x4e,
	0x52, 0x31, 0x4e, 0x05, 0x06, 0x3b, 0xe4, 0x02, 0xd5, 0xa9, 0x6d, 0x38, 0xa6, 0x8d, 0x55, 0xa0,
	0xff, 0x49, 0x97, 0x31, 0x2a, 0x52, 0x59, 0xac, 0xc4, 0xf8, 0x40, 0x9d, 0xa2, 0xb0, 0x46, 0xe2,
	0x85, 0x48, 0x9d, 0xa6, 0x7e, 0xc1, 0xca, 0x7d, 0x75, 0x86, 0xfe, 0x35, 0x6c, 0xfb, 0x83, 0xa6,
	0x3a, 0xcb, 0xfe, 0x3a, 0x67, 0x1f, 0x34, 0x55, 0x15, 0x2d, 0x01, 0xc2, 0x62, 0x0c, 0x1d, 0xd9,
	0x4b, 0x9d, 0xa3, 0xfa, 0xe3, 0x4f, 0xa9, 0xe0, 0x96, 0xcb, 0x26, 0xd4, 0x2a, 0x42, 0xf3, 0x30,
	0x1b, 0x76, 0x3f, 0xae, 0xb3, 0xe7, 0xba, 0xc7, 0xea, 0x3c, 0x2a, 0xc1, 0x42, 0x02, 0x4f, 0x6a,
	0xb7, 0x50, 0xb9, 0x0f, 0x6a, 0xef, 0xc4, 0x8b, 0xda, 0x47, 0x98, 0x9f, 0xbb, 0xbc, 0x61, 0xdb,
	0xaa, 0x42, 0xa1, 0x7e, 0xd7, 0x71, 0x2c, 0xa7, 0x25, 0x0e, 0x55, 0x6a, 0xa1, 0xa6, 0x37, 0xff,
	0x59, 0x80, 0xe2, 0xae, 0xed, 0x9e, 0x1e, 0x60, 0xff, 0xc4, 0x6a, 0x60, 0xf4, 0x08, 0x8a, 0xb1,
	0xf1, 0x2f, 0x92, 0x2d, 0x42, 0xff, 0x90, 0xba, 0x5c, 0x1e, 0xb4, 0xc4, 0x9d, 0x4f, 0x5b, 0xf8,
	0xc1, 0x9f, 0xff, 0xf6, 0xb3, 0xd4, 0x8c, 0x56, 0xa8, 0x9d, 0xdc, 0xaa, 0xd1, 0xb4, 0x43, 0xde,
	0x56, 0x2a, 0xc8, 0x80, 0x49, 0xf9, 0xd6, 0x81, 0x64, 0x45, 0xd7, 0xf3, 0x9e, 0x5a, 0x5e, 0xee,
	0x83, 0x0b, 0x92, 0x37, 0x18, 0xc9, 0xeb, 0xda, 0x4a, 0x48, 0xb2, 0xf6, 0x44, 0xe4, 0xb9, 0xcf,
	0x6a, 0xcc, 0xf7, 0x29, 0x8b, 0x00, 0xa6, 0xb7, 0xcc, 0xd8, 0xfb, 0x1d, 0xba, 0x11, 0xd1, 0x1b,
	0xfe, 0xbc, 0xf7, 0x82, 0x5c, 0xf9, 0x9c, 0x52, 0xa9, 0xa0, 0x33, 0x98, 0xeb, 0x7b, 0xda, 0x8a,
	0x73, 0x1e, 0xfe, 0xe8, 0x35, 0x9c, 0xf3, 0x2b, 0x8c, 0xf3, 0xaa, 0x56, 0x1e, 0xc4, 0x99, 0xfb,
	0x26, 0x65, 0xdd, 0x64, 0x36, 0x65, 0x0d, 0x01, 0xba, 0x12, 0xd1, 0xea, 0x7b, 0x91, 0x79, 0x41,
	0x15, 0x99, 0x73, 0x53, 0x3e, 0x3f, 0x52, 0x40, 0xed, 0x1d, 0xe9, 0xa1, 0xeb, 0x92, 0xe6, 0xe0,
	0xd1, 0x63, 0x79, 0x75, 0xe8, 0xba, 0xe0, 0x7d, 0x9b, 0xf1, 0xde, 0x40, 0xaf, 0x0f, 0x3d, 0x54,
	0x52, 0x7b, 0x22, 0x2f, 0xab, 0xcf, 0x6a, 0x06, 0xa5, 0x83, 0x7e, 0xa5, 0xc0, 0xf2, 0x90, 0x77,
	0x1e, 0xf4, 0x4a, 0xf2, 0xa6, 0x18, 0xf2, 0x5a, 0x5d, 0x7e, 0x75, 0x14, 0x9a, 0x90, 0xef, 0x2e,
	0x93, 0xef, 0xb6, 0x56, 0x1d, 0x4f, 0x3e, 0x19, 0x58, 0xd4, 0x60, 0x1d, 0xc8, 0xf1, 0x22, 0x3f,
	0x8a, 0xa1, 0xbe, 0xf7, 0xb9, 0xf2, 0x8d, 0x78, 0xf3, 0x39, 0xec, 0x0d, 0x4e, 0xd3, 0x98, 0x14,
	0x57, 0x07, 0xbb, 0x02, 0xef, 0x67, 0x51, 0x0b, 0xa6, 0x13, 0x13, 0xf6, 0xd0, 0x19, 0x06, 0x3d,
	0x71, 0x94, 0xaf, 0x3e, 0x6f, 0x28, 0xaf, 0x5d, 0x61, 0xfc, 0x16, 0xd1, 0xfc, 0x00, 0x7e, 0xe8,
	0x88, 0xde, 0x2a, 0x89, 0x21, 0x3a, 0xba, 0x16, 0x76, 0x67, 0x83, 0x86, 0xeb, 0xe5, 0x44, 0x87,
	0x9d, 0x9c, 0xb3, 0x69, 0x88, 0xb1, 0x9a, 0x42, 0x40, 0x59, 0x11, 0xb6, 0xff, 0xa6, 0x82, 0xda,
	0x30, 0x15, 0x9b, 0x5e, 0x11, 0xb4, 0x92, 0x60, 0x90, 0xb0, 0xe0, 0x72, 0x9c, 0x78, 0x6c, 0x93,
	0x34, 0x1a, 0x2a, 0x0f, 0x3e, 0x3a, 0xce, 0xe9, 0x28, 0xc7, 0x8a, 0xb2, 0xdb, 0xff, 0x0e, 0x00,
	0x00, 0xff, 0xff, 0x59, 0x33, 0xe8, 0xc4, 0xe3, 0x26, 0x00, 0x00,
}
