// Code generated by go-swagger; DO NOT EDIT.

package triggers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/fnproject/fn_go/modelsv2"
)

// UpdateTriggerReader is a Reader for the UpdateTrigger structure.
type UpdateTriggerReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateTriggerReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateTriggerOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateTriggerBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewUpdateTriggerNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		result := NewUpdateTriggerDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUpdateTriggerOK creates a UpdateTriggerOK with default headers values
func NewUpdateTriggerOK() *UpdateTriggerOK {
	return &UpdateTriggerOK{}
}

/*UpdateTriggerOK handles this case with default header values.

Updated Triggers metadata.
*/
type UpdateTriggerOK struct {
	Payload *modelsv2.Trigger
}

func (o *UpdateTriggerOK) Error() string {
	return fmt.Sprintf("[PUT /triggers/{triggerID}][%d] updateTriggerOK  %+v", 200, o.Payload)
}

func (o *UpdateTriggerOK) GetPayload() *modelsv2.Trigger {
	return o.Payload
}

func (o *UpdateTriggerOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(modelsv2.Trigger)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateTriggerBadRequest creates a UpdateTriggerBadRequest with default headers values
func NewUpdateTriggerBadRequest() *UpdateTriggerBadRequest {
	return &UpdateTriggerBadRequest{}
}

/*UpdateTriggerBadRequest handles this case with default header values.

Parameters are missing or invalid.
*/
type UpdateTriggerBadRequest struct {
	Payload *modelsv2.Error
}

func (o *UpdateTriggerBadRequest) Error() string {
	return fmt.Sprintf("[PUT /triggers/{triggerID}][%d] updateTriggerBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateTriggerBadRequest) GetPayload() *modelsv2.Error {
	return o.Payload
}

func (o *UpdateTriggerBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(modelsv2.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateTriggerNotFound creates a UpdateTriggerNotFound with default headers values
func NewUpdateTriggerNotFound() *UpdateTriggerNotFound {
	return &UpdateTriggerNotFound{}
}

/*UpdateTriggerNotFound handles this case with default header values.

The Trigger does not exist.
*/
type UpdateTriggerNotFound struct {
	Payload *modelsv2.Error
}

func (o *UpdateTriggerNotFound) Error() string {
	return fmt.Sprintf("[PUT /triggers/{triggerID}][%d] updateTriggerNotFound  %+v", 404, o.Payload)
}

func (o *UpdateTriggerNotFound) GetPayload() *modelsv2.Error {
	return o.Payload
}

func (o *UpdateTriggerNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(modelsv2.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateTriggerDefault creates a UpdateTriggerDefault with default headers values
func NewUpdateTriggerDefault(code int) *UpdateTriggerDefault {
	return &UpdateTriggerDefault{
		_statusCode: code,
	}
}

/*UpdateTriggerDefault handles this case with default header values.

An unexpected error occurred.
*/
type UpdateTriggerDefault struct {
	_statusCode int

	Payload *modelsv2.Error
}

// Code gets the status code for the update trigger default response
func (o *UpdateTriggerDefault) Code() int {
	return o._statusCode
}

func (o *UpdateTriggerDefault) Error() string {
	return fmt.Sprintf("[PUT /triggers/{triggerID}][%d] UpdateTrigger default  %+v", o._statusCode, o.Payload)
}

func (o *UpdateTriggerDefault) GetPayload() *modelsv2.Error {
	return o.Payload
}

func (o *UpdateTriggerDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(modelsv2.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
