// Code generated by go-swagger; DO NOT EDIT.

package fns

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/fnproject/fn_go/modelsv2"
)

// DeleteFnReader is a Reader for the DeleteFn structure.
type DeleteFnReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteFnReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewDeleteFnNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewDeleteFnNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		result := NewDeleteFnDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDeleteFnNoContent creates a DeleteFnNoContent with default headers values
func NewDeleteFnNoContent() *DeleteFnNoContent {
	return &DeleteFnNoContent{}
}

/*DeleteFnNoContent handles this case with default header values.

Function successfully deleted.
*/
type DeleteFnNoContent struct {
}

func (o *DeleteFnNoContent) Error() string {
	return fmt.Sprintf("[DELETE /fns/{fnID}][%d] deleteFnNoContent ", 204)
}

func (o *DeleteFnNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDeleteFnNotFound creates a DeleteFnNotFound with default headers values
func NewDeleteFnNotFound() *DeleteFnNotFound {
	return &DeleteFnNotFound{}
}

/*DeleteFnNotFound handles this case with default header values.

Function does not exist.
*/
type DeleteFnNotFound struct {
	Payload *modelsv2.Error
}

func (o *DeleteFnNotFound) Error() string {
	return fmt.Sprintf("[DELETE /fns/{fnID}][%d] deleteFnNotFound  %+v", 404, o.Payload)
}

func (o *DeleteFnNotFound) GetPayload() *modelsv2.Error {
	return o.Payload
}

func (o *DeleteFnNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(modelsv2.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteFnDefault creates a DeleteFnDefault with default headers values
func NewDeleteFnDefault(code int) *DeleteFnDefault {
	return &DeleteFnDefault{
		_statusCode: code,
	}
}

/*DeleteFnDefault handles this case with default header values.

Error
*/
type DeleteFnDefault struct {
	_statusCode int

	Payload *modelsv2.Error
}

// Code gets the status code for the delete fn default response
func (o *DeleteFnDefault) Code() int {
	return o._statusCode
}

func (o *DeleteFnDefault) Error() string {
	return fmt.Sprintf("[DELETE /fns/{fnID}][%d] DeleteFn default  %+v", o._statusCode, o.Payload)
}

func (o *DeleteFnDefault) GetPayload() *modelsv2.Error {
	return o.Payload
}

func (o *DeleteFnDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(modelsv2.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
