// Code generated by go-swagger; DO NOT EDIT.

package fns

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/fnproject/fn_go/modelsv2"
)

// CreateFnReader is a Reader for the CreateFn structure.
type CreateFnReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateFnReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateFnOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreateFnBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewCreateFnNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewCreateFnConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		result := NewCreateFnDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCreateFnOK creates a CreateFnOK with default headers values
func NewCreateFnOK() *CreateFnOK {
	return &CreateFnOK{}
}

/*CreateFnOK handles this case with default header values.

Function details.
*/
type CreateFnOK struct {
	Payload *modelsv2.Fn
}

func (o *CreateFnOK) Error() string {
	return fmt.Sprintf("[POST /fns][%d] createFnOK  %+v", 200, o.Payload)
}

func (o *CreateFnOK) GetPayload() *modelsv2.Fn {
	return o.Payload
}

func (o *CreateFnOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(modelsv2.Fn)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateFnBadRequest creates a CreateFnBadRequest with default headers values
func NewCreateFnBadRequest() *CreateFnBadRequest {
	return &CreateFnBadRequest{}
}

/*CreateFnBadRequest handles this case with default header values.

Invalid Function.
*/
type CreateFnBadRequest struct {
	Payload *modelsv2.Error
}

func (o *CreateFnBadRequest) Error() string {
	return fmt.Sprintf("[POST /fns][%d] createFnBadRequest  %+v", 400, o.Payload)
}

func (o *CreateFnBadRequest) GetPayload() *modelsv2.Error {
	return o.Payload
}

func (o *CreateFnBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(modelsv2.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateFnNotFound creates a CreateFnNotFound with default headers values
func NewCreateFnNotFound() *CreateFnNotFound {
	return &CreateFnNotFound{}
}

/*CreateFnNotFound handles this case with default header values.

Related app does not exist.
*/
type CreateFnNotFound struct {
	Payload *modelsv2.Error
}

func (o *CreateFnNotFound) Error() string {
	return fmt.Sprintf("[POST /fns][%d] createFnNotFound  %+v", 404, o.Payload)
}

func (o *CreateFnNotFound) GetPayload() *modelsv2.Error {
	return o.Payload
}

func (o *CreateFnNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(modelsv2.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateFnConflict creates a CreateFnConflict with default headers values
func NewCreateFnConflict() *CreateFnConflict {
	return &CreateFnConflict{}
}

/*CreateFnConflict handles this case with default header values.

Function with name already exists.
*/
type CreateFnConflict struct {
	Payload *modelsv2.Error
}

func (o *CreateFnConflict) Error() string {
	return fmt.Sprintf("[POST /fns][%d] createFnConflict  %+v", 409, o.Payload)
}

func (o *CreateFnConflict) GetPayload() *modelsv2.Error {
	return o.Payload
}

func (o *CreateFnConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(modelsv2.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateFnDefault creates a CreateFnDefault with default headers values
func NewCreateFnDefault(code int) *CreateFnDefault {
	return &CreateFnDefault{
		_statusCode: code,
	}
}

/*CreateFnDefault handles this case with default header values.

An unexpected error occurred.
*/
type CreateFnDefault struct {
	_statusCode int

	Payload *modelsv2.Error
}

// Code gets the status code for the create fn default response
func (o *CreateFnDefault) Code() int {
	return o._statusCode
}

func (o *CreateFnDefault) Error() string {
	return fmt.Sprintf("[POST /fns][%d] CreateFn default  %+v", o._statusCode, o.Payload)
}

func (o *CreateFnDefault) GetPayload() *modelsv2.Error {
	return o.Payload
}

func (o *CreateFnDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(modelsv2.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
