// Code generated by go-swagger; DO NOT EDIT.

package apps

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/fnproject/fn_go/modelsv2"
)

// GetAppReader is a Reader for the GetApp structure.
type GetAppReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetAppReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetAppOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewGetAppNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		result := NewGetAppDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetAppOK creates a GetAppOK with default headers values
func NewGetAppOK() *GetAppOK {
	return &GetAppOK{}
}

/*GetAppOK handles this case with default header values.

Application details and stats.
*/
type GetAppOK struct {
	Payload *modelsv2.App
}

func (o *GetAppOK) Error() string {
	return fmt.Sprintf("[GET /apps/{appID}][%d] getAppOK  %+v", 200, o.Payload)
}

func (o *GetAppOK) GetPayload() *modelsv2.App {
	return o.Payload
}

func (o *GetAppOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(modelsv2.App)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAppNotFound creates a GetAppNotFound with default headers values
func NewGetAppNotFound() *GetAppNotFound {
	return &GetAppNotFound{}
}

/*GetAppNotFound handles this case with default header values.

The Application does not exist.
*/
type GetAppNotFound struct {
	Payload *modelsv2.Error
}

func (o *GetAppNotFound) Error() string {
	return fmt.Sprintf("[GET /apps/{appID}][%d] getAppNotFound  %+v", 404, o.Payload)
}

func (o *GetAppNotFound) GetPayload() *modelsv2.Error {
	return o.Payload
}

func (o *GetAppNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(modelsv2.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAppDefault creates a GetAppDefault with default headers values
func NewGetAppDefault(code int) *GetAppDefault {
	return &GetAppDefault{
		_statusCode: code,
	}
}

/*GetAppDefault handles this case with default header values.

An unexpected error occurred.
*/
type GetAppDefault struct {
	_statusCode int

	Payload *modelsv2.Error
}

// Code gets the status code for the get app default response
func (o *GetAppDefault) Code() int {
	return o._statusCode
}

func (o *GetAppDefault) Error() string {
	return fmt.Sprintf("[GET /apps/{appID}][%d] GetApp default  %+v", o._statusCode, o.Payload)
}

func (o *GetAppDefault) GetPayload() *modelsv2.Error {
	return o.Payload
}

func (o *GetAppDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(modelsv2.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
