// Code generated by go-swagger; DO NOT EDIT.

package apps

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/fnproject/fn_go/modelsv2"
)

// CreateAppReader is a Reader for the CreateApp structure.
type CreateAppReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateAppReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateAppOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreateAppBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewCreateAppConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		result := NewCreateAppDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCreateAppOK creates a CreateAppOK with default headers values
func NewCreateAppOK() *CreateAppOK {
	return &CreateAppOK{}
}

/*CreateAppOK handles this case with default header values.

Application details and stats.
*/
type CreateAppOK struct {
	Payload *modelsv2.App
}

func (o *CreateAppOK) Error() string {
	return fmt.Sprintf("[POST /apps][%d] createAppOK  %+v", 200, o.Payload)
}

func (o *CreateAppOK) GetPayload() *modelsv2.App {
	return o.Payload
}

func (o *CreateAppOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(modelsv2.App)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateAppBadRequest creates a CreateAppBadRequest with default headers values
func NewCreateAppBadRequest() *CreateAppBadRequest {
	return &CreateAppBadRequest{}
}

/*CreateAppBadRequest handles this case with default header values.

Parameters are missing or invalid.
*/
type CreateAppBadRequest struct {
	Payload *modelsv2.Error
}

func (o *CreateAppBadRequest) Error() string {
	return fmt.Sprintf("[POST /apps][%d] createAppBadRequest  %+v", 400, o.Payload)
}

func (o *CreateAppBadRequest) GetPayload() *modelsv2.Error {
	return o.Payload
}

func (o *CreateAppBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(modelsv2.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateAppConflict creates a CreateAppConflict with default headers values
func NewCreateAppConflict() *CreateAppConflict {
	return &CreateAppConflict{}
}

/*CreateAppConflict handles this case with default header values.

Application with name already exists.
*/
type CreateAppConflict struct {
	Payload *modelsv2.Error
}

func (o *CreateAppConflict) Error() string {
	return fmt.Sprintf("[POST /apps][%d] createAppConflict  %+v", 409, o.Payload)
}

func (o *CreateAppConflict) GetPayload() *modelsv2.Error {
	return o.Payload
}

func (o *CreateAppConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(modelsv2.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateAppDefault creates a CreateAppDefault with default headers values
func NewCreateAppDefault(code int) *CreateAppDefault {
	return &CreateAppDefault{
		_statusCode: code,
	}
}

/*CreateAppDefault handles this case with default header values.

An unexpected error occurred.
*/
type CreateAppDefault struct {
	_statusCode int

	Payload *modelsv2.Error
}

// Code gets the status code for the create app default response
func (o *CreateAppDefault) Code() int {
	return o._statusCode
}

func (o *CreateAppDefault) Error() string {
	return fmt.Sprintf("[POST /apps][%d] CreateApp default  %+v", o._statusCode, o.Payload)
}

func (o *CreateAppDefault) GetPayload() *modelsv2.Error {
	return o.Payload
}

func (o *CreateAppDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(modelsv2.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
