/*
 * Copyright (c) 2019, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package commands

import (
	"github.com/fnproject/cli/common"
	"github.com/urfave/cli"
)

// ConfigureCommand returns configure cli.command
func ConfigureCommand() cli.Command {
	return cli.Command{
		Name:         "config",
		Aliases:      []string{"cf"},
		Usage:        "\tSet configuration for an object",
		Category:     "MANAGEMENT COMMANDS",
		ArgsUsage:    "<subcommand>",
		Description:  "This command sets a configuration key for an 'app' or 'function'.",
		Subcommands:  GetCommands(ConfigCmds),
		BashComplete: common.DefaultBashComplete,
	}
}
