package uuid

// Fast UUID formatting adapted from
// https://github.com/m4rw3r/uuid/blob/master/uuid.go

// halfbyte2hexchar contains an array of character values corresponding to
// hexadecimal values for the position in the array, 0 to 15 (0x0-0xf, half-byte).
var halfbyte2hexchar = []byte{
	48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102,
}

// ToString formats raw UUID bytes as a standard UUID string
func ToString(u [24]byte) string {
	/* It is a lot (~10x) faster to allocate a byte slice of specific size and
	   then use a lookup table to write the characters to the byte-array and
	   finally cast to string instead of using fmt.Sprintf() */
	/* Slightly faster to not use make([]byte, 36), guessing either call
	   overhead or slice-header overhead is the cause */
	b := [36]byte{}

	for i, n := range []int{
		0, 2, 4, 6,
		9, 11,
		14, 16,
		19, 21,
		24, 26, 28, 30, 32, 34,
	} {
		b[n] = halfbyte2hexchar[(u[i]>>4)&0x0f]
		b[n+1] = halfbyte2hexchar[u[i]&0x0f]
	}

	b[8] = '-'
	b[13] = '-'
	b[18] = '-'
	b[23] = '-'

	/* Oddly does not seem to cause a memory allocation,
	   internal data-array is most likely just moved over
	   to the string-header: */
	return string(b[:])
}
