// Code generated by go-swagger; DO NOT EDIT.

package volume

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

// Volume volume
//
// swagger:model Volume
type Volume struct {

	// cluster volume
	ClusterVolume *ClusterVolume `json:"ClusterVolume,omitempty"`

	// Date/Time the volume was created.
	// Example: 2016-06-07T20:31:11.853781916Z
	CreatedAt string `json:"CreatedAt,omitempty"`

	// Name of the volume driver used by the volume.
	// Example: custom
	// Required: true
	Driver string `json:"Driver"`

	// User-defined key/value metadata.
	// Example: {"com.example.some-label":"some-value","com.example.some-other-label":"some-other-value"}
	// Required: true
	Labels map[string]string `json:"Labels"`

	// Mount path of the volume on the host.
	// Example: /var/lib/docker/volumes/tardis
	// Required: true
	Mountpoint string `json:"Mountpoint"`

	// Name of the volume.
	// Example: tardis
	// Required: true
	Name string `json:"Name"`

	// The driver specific options used when creating the volume.
	//
	// Example: {"device":"tmpfs","o":"size=100m,uid=1000","type":"tmpfs"}
	// Required: true
	Options map[string]string `json:"Options"`

	// The level at which the volume exists. Either `global` for cluster-wide,
	// or `local` for machine level.
	//
	// Example: local
	// Required: true
	// Enum: ["local","global"]
	Scope string `json:"Scope"`

	// Low-level details about the volume, provided by the volume driver.
	// Details are returned as a map with key/value pairs:
	// `{"key":"value","key2":"value2"}`.
	//
	// The `Status` field is optional, and is omitted if the volume driver
	// does not support this feature.
	//
	// Example: {"hello":"world"}
	Status map[string]interface{} `json:"Status,omitempty"`

	// usage data
	UsageData *UsageData `json:"UsageData,omitempty"`
}

// UsageData Usage details about the volume. This information is used by the
// `GET /system/df` endpoint, and omitted in other endpoints.
//
// swagger:model UsageData
type UsageData struct {

	// The number of containers referencing this volume. This field
	// is set to `-1` if the reference-count is not available.
	//
	// Required: true
	RefCount int64 `json:"RefCount"`

	// Amount of disk space used by the volume (in bytes). This information
	// is only available for volumes created with the `"local"` volume
	// driver. For volumes created with other volume drivers, this field
	// is set to `-1` ("not available")
	//
	// Required: true
	Size int64 `json:"Size"`
}
