// Code generated by go-swagger; DO NOT EDIT.

package plugin

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

// Plugin A plugin for the Engine API
//
// swagger:model Plugin
type Plugin struct {

	// config
	// Required: true
	Config Config `json:"Config"`

	// True if the plugin is running. False if the plugin is not running, only installed.
	// Example: true
	// Required: true
	Enabled bool `json:"Enabled"`

	// Id
	// Example: 5724e2c8652da337ab2eedd19fc6fc0ec908e4bd907c7421bf6a8dfc70c4c078
	ID string `json:"Id,omitempty"`

	// name
	// Example: tiborvass/sample-volume-plugin
	// Required: true
	Name string `json:"Name"`

	// plugin remote reference used to push/pull the plugin
	// Example: localhost:5000/tiborvass/sample-volume-plugin:latest
	PluginReference string `json:"PluginReference,omitempty"`

	// settings
	// Required: true
	Settings Settings `json:"Settings"`
}

// Config The config of a plugin.
//
// swagger:model Config
type Config struct {

	// args
	// Required: true
	Args Args `json:"Args"`

	// description
	// Example: A sample volume plugin for Docker
	// Required: true
	Description string `json:"Description"`

	// Docker Version used to create the plugin
	// Example: 17.06.0-ce
	DockerVersion string `json:"DockerVersion,omitempty"`

	// documentation
	// Example: https://docs.docker.com/engine/extend/plugins/
	// Required: true
	Documentation string `json:"Documentation"`

	// entrypoint
	// Example: ["/usr/bin/sample-volume-plugin","/data"]
	// Required: true
	Entrypoint []string `json:"Entrypoint"`

	// env
	// Example: [{"Description":"If set, prints debug messages","Name":"DEBUG","Settable":null,"Value":"0"}]
	// Required: true
	Env []Env `json:"Env"`

	// interface
	// Required: true
	Interface Interface `json:"Interface"`

	// ipc host
	// Example: false
	// Required: true
	IpcHost bool `json:"IpcHost"`

	// linux
	// Required: true
	Linux LinuxConfig `json:"Linux"`

	// mounts
	// Required: true
	Mounts []Mount `json:"Mounts"`

	// network
	// Required: true
	Network NetworkConfig `json:"Network"`

	// pid host
	// Example: false
	// Required: true
	PidHost bool `json:"PidHost"`

	// propagated mount
	// Example: /mnt/volumes
	// Required: true
	PropagatedMount string `json:"PropagatedMount"`

	// user
	User User `json:"User,omitempty"`

	// work dir
	// Example: /bin/
	// Required: true
	WorkDir string `json:"WorkDir"`

	// rootfs
	Rootfs *RootFS `json:"rootfs,omitempty"`
}

// Args args
//
// swagger:model Args
type Args struct {

	// description
	// Example: command line arguments
	// Required: true
	Description string `json:"Description"`

	// name
	// Example: args
	// Required: true
	Name string `json:"Name"`

	// settable
	// Required: true
	Settable []string `json:"Settable"`

	// value
	// Required: true
	Value []string `json:"Value"`
}

// Interface The interface between Docker and the plugin
//
// swagger:model Interface
type Interface struct {

	// Protocol to use for clients connecting to the plugin.
	// Example: some.protocol/v1.0
	// Enum: ["","moby.plugins.http/v1"]
	ProtocolScheme string `json:"ProtocolScheme,omitempty"`

	// socket
	// Example: plugins.sock
	// Required: true
	Socket string `json:"Socket"`

	// types
	// Example: ["docker.volumedriver/1.0"]
	// Required: true
	Types []CapabilityID `json:"Types"`
}

// LinuxConfig linux config
//
// swagger:model LinuxConfig
type LinuxConfig struct {

	// allow all devices
	// Example: false
	// Required: true
	AllowAllDevices bool `json:"AllowAllDevices"`

	// capabilities
	// Example: ["CAP_SYS_ADMIN","CAP_SYSLOG"]
	// Required: true
	Capabilities []string `json:"Capabilities"`

	// devices
	// Required: true
	Devices []Device `json:"Devices"`
}

// NetworkConfig network config
//
// swagger:model NetworkConfig
type NetworkConfig struct {

	// type
	// Example: host
	// Required: true
	Type string `json:"Type"`
}

// RootFS root f s
//
// swagger:model RootFS
type RootFS struct {

	// diff ids
	// Example: ["sha256:675532206fbf3030b8458f88d6e26d4eb1577688a25efec97154c94e8b6b4887","sha256:e216a057b1cb1efc11f8a268f37ef62083e70b1b38323ba252e25ac88904a7e8"]
	DiffIds []string `json:"diff_ids"`

	// type
	// Example: layers
	Type string `json:"type,omitempty"`
}

// User user
//
// swagger:model User
type User struct {

	// g ID
	// Example: 1000
	GID uint32 `json:"GID,omitempty"`

	// UID
	// Example: 1000
	UID uint32 `json:"UID,omitempty"`
}

// Settings user-configurable settings for the plugin.
//
// swagger:model Settings
type Settings struct {

	// args
	// Required: true
	Args []string `json:"Args"`

	// devices
	// Required: true
	Devices []Device `json:"Devices"`

	// env
	// Example: ["DEBUG=0"]
	// Required: true
	Env []string `json:"Env"`

	// mounts
	// Required: true
	Mounts []Mount `json:"Mounts"`
}
