# docker run

<!---MARKER_GEN_START-->
Create and run a new container from an image

### Aliases

`docker container run`, `docker run`

### Options

| Name                      | Type          | Default   | Description                                                                                                                                                                                                                                                                                                      |
|:--------------------------|:--------------|:----------|:-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `--add-host`              | `list`        |           | Add a custom host-to-IP mapping (host:ip)                                                                                                                                                                                                                                                                        |
| `--annotation`            | `map`         | `map[]`   | Add an annotation to the container (passed through to the OCI runtime)                                                                                                                                                                                                                                           |
| `-a`, `--attach`          | `list`        |           | Attach to STDIN, STDOUT or STDERR                                                                                                                                                                                                                                                                                |
| `--blkio-weight`          | `uint16`      | `0`       | Block IO (relative weight), between 10 and 1000, or 0 to disable (default 0)                                                                                                                                                                                                                                     |
| `--blkio-weight-device`   | `list`        |           | Block IO weight (relative device weight)                                                                                                                                                                                                                                                                         |
| `--cap-add`               | `list`        |           | Add Linux capabilities                                                                                                                                                                                                                                                                                           |
| `--cap-drop`              | `list`        |           | Drop Linux capabilities                                                                                                                                                                                                                                                                                          |
| `--cgroup-parent`         | `string`      |           | Optional parent cgroup for the container                                                                                                                                                                                                                                                                         |
| `--cgroupns`              | `string`      |           | Cgroup namespace to use (host\|private)<br>'host':    Run the container in the Docker host's cgroup namespace<br>'private': Run the container in its own private cgroup namespace<br>'':        Use the cgroup namespace as configured by the<br>           default-cgroupns-mode option on the daemon (default) |
| `--cidfile`               | `string`      |           | Write the container ID to the file                                                                                                                                                                                                                                                                               |
| `--cpu-count`             | `int64`       | `0`       | CPU count (Windows only)                                                                                                                                                                                                                                                                                         |
| `--cpu-percent`           | `int64`       | `0`       | CPU percent (Windows only)                                                                                                                                                                                                                                                                                       |
| `--cpu-period`            | `int64`       | `0`       | Limit CPU CFS (Completely Fair Scheduler) period                                                                                                                                                                                                                                                                 |
| `--cpu-quota`             | `int64`       | `0`       | Limit CPU CFS (Completely Fair Scheduler) quota                                                                                                                                                                                                                                                                  |
| `--cpu-rt-period`         | `int64`       | `0`       | Limit CPU real-time period in microseconds                                                                                                                                                                                                                                                                       |
| `--cpu-rt-runtime`        | `int64`       | `0`       | Limit CPU real-time runtime in microseconds                                                                                                                                                                                                                                                                      |
| `-c`, `--cpu-shares`      | `int64`       | `0`       | CPU shares (relative weight)                                                                                                                                                                                                                                                                                     |
| `--cpus`                  | `decimal`     |           | Number of CPUs                                                                                                                                                                                                                                                                                                   |
| `--cpuset-cpus`           | `string`      |           | CPUs in which to allow execution (0-3, 0,1)                                                                                                                                                                                                                                                                      |
| `--cpuset-mems`           | `string`      |           | MEMs in which to allow execution (0-3, 0,1)                                                                                                                                                                                                                                                                      |
| `-d`, `--detach`          | `bool`        |           | Run container in background and print container ID                                                                                                                                                                                                                                                               |
| `--detach-keys`           | `string`      |           | Override the key sequence for detaching a container                                                                                                                                                                                                                                                              |
| `--device`                | `list`        |           | Add a host device to the container                                                                                                                                                                                                                                                                               |
| `--device-cgroup-rule`    | `list`        |           | Add a rule to the cgroup allowed devices list                                                                                                                                                                                                                                                                    |
| `--device-read-bps`       | `list`        |           | Limit read rate (bytes per second) from a device                                                                                                                                                                                                                                                                 |
| `--device-read-iops`      | `list`        |           | Limit read rate (IO per second) from a device                                                                                                                                                                                                                                                                    |
| `--device-write-bps`      | `list`        |           | Limit write rate (bytes per second) to a device                                                                                                                                                                                                                                                                  |
| `--device-write-iops`     | `list`        |           | Limit write rate (IO per second) to a device                                                                                                                                                                                                                                                                     |
| `--disable-content-trust` | `bool`        | `true`    | Skip image verification                                                                                                                                                                                                                                                                                          |
| `--dns`                   | `list`        |           | Set custom DNS servers                                                                                                                                                                                                                                                                                           |
| `--dns-option`            | `list`        |           | Set DNS options                                                                                                                                                                                                                                                                                                  |
| `--dns-search`            | `list`        |           | Set custom DNS search domains                                                                                                                                                                                                                                                                                    |
| `--domainname`            | `string`      |           | Container NIS domain name                                                                                                                                                                                                                                                                                        |
| `--entrypoint`            | `string`      |           | Overwrite the default ENTRYPOINT of the image                                                                                                                                                                                                                                                                    |
| `-e`, `--env`             | `list`        |           | Set environment variables                                                                                                                                                                                                                                                                                        |
| `--env-file`              | `list`        |           | Read in a file of environment variables                                                                                                                                                                                                                                                                          |
| `--expose`                | `list`        |           | Expose a port or a range of ports                                                                                                                                                                                                                                                                                |
| `--gpus`                  | `gpu-request` |           | GPU devices to add to the container ('all' to pass all GPUs)                                                                                                                                                                                                                                                     |
| `--group-add`             | `list`        |           | Add additional groups to join                                                                                                                                                                                                                                                                                    |
| `--health-cmd`            | `string`      |           | Command to run to check health                                                                                                                                                                                                                                                                                   |
| `--health-interval`       | `duration`    | `0s`      | Time between running the check (ms\|s\|m\|h) (default 0s)                                                                                                                                                                                                                                                        |
| `--health-retries`        | `int`         | `0`       | Consecutive failures needed to report unhealthy                                                                                                                                                                                                                                                                  |
| `--health-start-interval` | `duration`    | `0s`      | Time between running the check during the start period (ms\|s\|m\|h) (default 0s)                                                                                                                                                                                                                                |
| `--health-start-period`   | `duration`    | `0s`      | Start period for the container to initialize before starting health-retries countdown (ms\|s\|m\|h) (default 0s)                                                                                                                                                                                                 |
| `--health-timeout`        | `duration`    | `0s`      | Maximum time to allow one check to run (ms\|s\|m\|h) (default 0s)                                                                                                                                                                                                                                                |
| `--help`                  | `bool`        |           | Print usage                                                                                                                                                                                                                                                                                                      |
| `-h`, `--hostname`        | `string`      |           | Container host name                                                                                                                                                                                                                                                                                              |
| `--init`                  | `bool`        |           | Run an init inside the container that forwards signals and reaps processes                                                                                                                                                                                                                                       |
| `-i`, `--interactive`     | `bool`        |           | Keep STDIN open even if not attached                                                                                                                                                                                                                                                                             |
| `--io-maxbandwidth`       | `bytes`       | `0`       | Maximum IO bandwidth limit for the system drive (Windows only)                                                                                                                                                                                                                                                   |
| `--io-maxiops`            | `uint64`      | `0`       | Maximum IOps limit for the system drive (Windows only)                                                                                                                                                                                                                                                           |
| `--ip`                    | `string`      |           | IPv4 address (e.g., 172.30.100.104)                                                                                                                                                                                                                                                                              |
| `--ip6`                   | `string`      |           | IPv6 address (e.g., 2001:db8::33)                                                                                                                                                                                                                                                                                |
| `--ipc`                   | `string`      |           | IPC mode to use                                                                                                                                                                                                                                                                                                  |
| `--isolation`             | `string`      |           | Container isolation technology                                                                                                                                                                                                                                                                                   |
| `-l`, `--label`           | `list`        |           | Set meta data on a container                                                                                                                                                                                                                                                                                     |
| `--label-file`            | `list`        |           | Read in a line delimited file of labels                                                                                                                                                                                                                                                                          |
| `--link`                  | `list`        |           | Add link to another container                                                                                                                                                                                                                                                                                    |
| `--link-local-ip`         | `list`        |           | Container IPv4/IPv6 link-local addresses                                                                                                                                                                                                                                                                         |
| `--log-driver`            | `string`      |           | Logging driver for the container                                                                                                                                                                                                                                                                                 |
| `--log-opt`               | `list`        |           | Log driver options                                                                                                                                                                                                                                                                                               |
| `--mac-address`           | `string`      |           | Container MAC address (e.g., 92:d0:c6:0a:29:33)                                                                                                                                                                                                                                                                  |
| `-m`, `--memory`          | `bytes`       | `0`       | Memory limit                                                                                                                                                                                                                                                                                                     |
| `--memory-reservation`    | `bytes`       | `0`       | Memory soft limit                                                                                                                                                                                                                                                                                                |
| `--memory-swap`           | `bytes`       | `0`       | Swap limit equal to memory plus swap: '-1' to enable unlimited swap                                                                                                                                                                                                                                              |
| `--memory-swappiness`     | `int64`       | `-1`      | Tune container memory swappiness (0 to 100)                                                                                                                                                                                                                                                                      |
| `--mount`                 | `mount`       |           | Attach a filesystem mount to the container                                                                                                                                                                                                                                                                       |
| `--name`                  | `string`      |           | Assign a name to the container                                                                                                                                                                                                                                                                                   |
| `--network`               | `network`     |           | Connect a container to a network                                                                                                                                                                                                                                                                                 |
| `--network-alias`         | `list`        |           | Add network-scoped alias for the container                                                                                                                                                                                                                                                                       |
| `--no-healthcheck`        | `bool`        |           | Disable any container-specified HEALTHCHECK                                                                                                                                                                                                                                                                      |
| `--oom-kill-disable`      | `bool`        |           | Disable OOM Killer                                                                                                                                                                                                                                                                                               |
| `--oom-score-adj`         | `int`         | `0`       | Tune host's OOM preferences (-1000 to 1000)                                                                                                                                                                                                                                                                      |
| `--pid`                   | `string`      |           | PID namespace to use                                                                                                                                                                                                                                                                                             |
| `--pids-limit`            | `int64`       | `0`       | Tune container pids limit (set -1 for unlimited)                                                                                                                                                                                                                                                                 |
| `--platform`              | `string`      |           | Set platform if server is multi-platform capable                                                                                                                                                                                                                                                                 |
| `--privileged`            | `bool`        |           | Give extended privileges to this container                                                                                                                                                                                                                                                                       |
| `-p`, `--publish`         | `list`        |           | Publish a container's port(s) to the host                                                                                                                                                                                                                                                                        |
| `-P`, `--publish-all`     | `bool`        |           | Publish all exposed ports to random ports                                                                                                                                                                                                                                                                        |
| `--pull`                  | `string`      | `missing` | Pull image before running (`always`, `missing`, `never`)                                                                                                                                                                                                                                                         |
| `-q`, `--quiet`           | `bool`        |           | Suppress the pull output                                                                                                                                                                                                                                                                                         |
| `--read-only`             | `bool`        |           | Mount the container's root filesystem as read only                                                                                                                                                                                                                                                               |
| `--restart`               | `string`      | `no`      | Restart policy to apply when a container exits                                                                                                                                                                                                                                                                   |
| `--rm`                    | `bool`        |           | Automatically remove the container and its associated anonymous volumes when it exits                                                                                                                                                                                                                            |
| `--runtime`               | `string`      |           | Runtime to use for this container                                                                                                                                                                                                                                                                                |
| `--security-opt`          | `list`        |           | Security Options                                                                                                                                                                                                                                                                                                 |
| `--shm-size`              | `bytes`       | `0`       | Size of /dev/shm                                                                                                                                                                                                                                                                                                 |
| `--sig-proxy`             | `bool`        | `true`    | Proxy received signals to the process                                                                                                                                                                                                                                                                            |
| `--stop-signal`           | `string`      |           | Signal to stop the container                                                                                                                                                                                                                                                                                     |
| `--stop-timeout`          | `int`         | `0`       | Timeout (in seconds) to stop a container                                                                                                                                                                                                                                                                         |
| `--storage-opt`           | `list`        |           | Storage driver options for the container                                                                                                                                                                                                                                                                         |
| `--sysctl`                | `map`         | `map[]`   | Sysctl options                                                                                                                                                                                                                                                                                                   |
| `--tmpfs`                 | `list`        |           | Mount a tmpfs directory                                                                                                                                                                                                                                                                                          |
| `-t`, `--tty`             | `bool`        |           | Allocate a pseudo-TTY                                                                                                                                                                                                                                                                                            |
| `--ulimit`                | `ulimit`      |           | Ulimit options                                                                                                                                                                                                                                                                                                   |
| `--use-api-socket`        | `bool`        |           | Bind mount Docker API socket and required auth                                                                                                                                                                                                                                                                   |
| `-u`, `--user`            | `string`      |           | Username or UID (format: <name\|uid>[:<group\|gid>])                                                                                                                                                                                                                                                             |
| `--userns`                | `string`      |           | User namespace to use                                                                                                                                                                                                                                                                                            |
| `--uts`                   | `string`      |           | UTS namespace to use                                                                                                                                                                                                                                                                                             |
| `-v`, `--volume`          | `list`        |           | Bind mount a volume                                                                                                                                                                                                                                                                                              |
| `--volume-driver`         | `string`      |           | Optional volume driver for the container                                                                                                                                                                                                                                                                         |
| `--volumes-from`          | `list`        |           | Mount volumes from the specified container(s)                                                                                                                                                                                                                                                                    |
| `-w`, `--workdir`         | `string`      |           | Working directory inside the container                                                                                                                                                                                                                                                                           |


<!---MARKER_GEN_END-->

