Contributing to consul-alerts
=============================

:+1::tada: First off, thanks for taking the time to contribute! :tada::+1:

The following is a set of guidelines for contributing to `consul-alerts`. These are just guidelines, not rules, use your best judgment and feel free to propose changes to this document in a pull request.

#### Table Of Contents

[What should I know before I get started?](#what-should-i-know-before-i-get-started)

-	[Code of Conduct](#code-of-conduct)

[How Can I Contribute?](#how-can-i-contribute)

-	[Reporting Bugs](#reporting-bugs)
-	[Suggesting Enhancements](#suggesting-enhancements)
-	[Your First Code Contribution](#your-first-code-contribution)

What should I know before I get started?
----------------------------------------

### Code of Conduct

This project adheres to the Contributor Covenant [code of conduct](CODE_OF_CONDUCT.md). By participating, you are expected to uphold this code.

How Can I Contribute?
---------------------

### Reporting Bugs

This section guides you through submitting a bug report for `consul-alerts`. Following these guidelines helps maintainers and the community understand your report :pencil:, reproduce the behavior :computer: :computer:, and find related reports :mag_right:.

Before creating bug reports, please check the project's GitHub issues as you might find out that you don't need to create one. When you are creating a bug report, please [include as many details as possible](#how-do-i-submit-a-good-bug-report).

#### Before Submitting A Bug Report

-	**Perform a cursory search** to see if the problem has already been reported. If it has, add a comment to the existing issue instead of opening a new one.

#### How Do I Submit A (Good) Bug Report?

Bugs are tracked as [GitHub issues](https://guides.github.com/features/issues/). Create an issue and provide the following information.

Explain the problem and include additional details to help maintainers reproduce the problem:

-	**Use a clear and descriptive title** for the issue to identify the problem.
-	**Describe the exact steps which reproduce the problem** in as many details as possible. For example, start by explaining how you started consul-alerts, e.g. which command exactly you used in the terminal, or how you started consul-alerts otherwise. When listing steps, **don't just say what you did, but explain how you did it**.
-	**Provide specific examples to demonstrate the steps**. Include links to files or GitHub projects, or copy/pasteable snippets, which you use in those examples. If you're providing snippets in the issue, use [Markdown code blocks](https://help.github.com/articles/markdown-basics/#multiple-lines).
-	**Describe the behavior you observed after following the steps** and point out what exactly is the problem with that behavior.
-	**Explain which behavior you expected to see instead and why.**

Include details about your configuration and environment:

-	**Which version of consul-alerts are you using?**
-	**Which version of Consul are you using?**
-	**What's the name and version of the OS you're using**?
-	**Are you running consul-alerts in the Cloud or a Virtual Machine?** If so, which Provider or VM software are you using?

### Suggesting Enhancements

This section guides you through submitting an enhancement suggestion for `consul-alerts`, including completely new features and minor improvements to existing functionality. Following these guidelines helps maintainers and the community understand your suggestion :pencil: and find related suggestions :mag_right:.

Before creating enhancement suggestions, please check GitHub issues as you might find out that you don't need to create one. When you are creating an enhancement suggestion, please [include as many details as possible](#how-do-i-submit-a-good-enhancement-suggestion).

#### Before Submitting An Enhancement Suggestion

-	**Perform a issue search** to see if the enhancement has already been suggested. If it has, add a comment to the existing issue instead of opening a new one.

#### How Do I Submit A (Good) Enhancement Suggestion?

Enhancement suggestions are tracked as [GitHub issues](https://guides.github.com/features/issues/). Create an issue and provide the following information:

-	**Use a clear and descriptive title** for the issue to identify the suggestion.
-	**Provide a step-by-step description of the suggested enhancement** in as many details as possible.
-	**Provide specific examples to demonstrate the steps**. Include copy/pasteable snippets which you use in those examples, as [Markdown code blocks](https://help.github.com/articles/markdown-basics/#multiple-lines).
-	**Describe the current behavior** and **explain which behavior you expected to see instead** and why.
-	**Explain why this enhancement would be useful** to most consul-alerts users.

### Your First Code Contribution

Unsure where to begin contributing to consul-alerts? Please check our GitHub issues list for Open issues or enhancements.
