// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

//
//Package event provides a service for subscribing to state change events.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: private/pbsubscribe/subscribe.proto

// TODO: ideally we would have prefixed this package as
// "hashicorp.consul.internal.subscribe" before releasing but now correcting this will
// require a grpc passthrough service shim since the package name is part of
// the rpc method dispatch and editing it naively would break backwards
// compatibility.

package pbsubscribe

import (
	_ "github.com/hashicorp/consul/proto-public/annotations/ratelimit"
	pbcommon "github.com/hashicorp/consul/proto/private/pbcommon"
	pbconfigentry "github.com/hashicorp/consul/proto/private/pbconfigentry"
	pbservice "github.com/hashicorp/consul/proto/private/pbservice"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Topic enumerates the supported event topics.
type Topic int32

const (
	Topic_Unknown Topic = 0
	// ServiceHealth topic contains events for any changes to service health.
	Topic_ServiceHealth Topic = 1
	// ServiceHealthConnect topic contains events for any changes to service
	// health for connect-enabled services.
	Topic_ServiceHealthConnect Topic = 2
	// MeshConfig topic contains events for changes to the global mesh config.
	Topic_MeshConfig Topic = 3
	// ServiceResolver topic contains events for changes to a service resolver.
	Topic_ServiceResolver Topic = 4
	// IngressGateway topic contains events for changes to an ingress gateway.
	Topic_IngressGateway Topic = 5
	// ServiceIntentions topic contains events for changes to service intentions.
	Topic_ServiceIntentions Topic = 6
	// ServiceList topic contains events about services (not service instances)
	// getting registered/deregistered. It can be used to materialize a list of
	// the services in the given datacenter.
	//
	// Note: WildcardSubject is the only supported Subject on this topic.
	Topic_ServiceList Topic = 7
	// ServiceDefaults topic contains events for changes to service-defaults.
	Topic_ServiceDefaults Topic = 8
	// APIGateway topic contains events for changes to api-gateways.
	Topic_APIGateway Topic = 9
	// TCPRoute topic contains events for changes to tcp-routes.
	Topic_TCPRoute Topic = 10
	// HTTPRoute topic contains events for changes to http-routes.
	Topic_HTTPRoute Topic = 11
	// InlineCertificate topic contains events for changes to inline-certificates.
	Topic_InlineCertificate Topic = 12
	// BoundAPIGateway topic contains events for changes to bound-api-gateways.
	Topic_BoundAPIGateway Topic = 13
	// IPRateLimit topic contains events for changes to control-plane-request-limit
	Topic_IPRateLimit Topic = 14
	// SamenessGroup topic contains events for changes to Sameness Groups
	Topic_SamenessGroup Topic = 15
	// JWTProvider topic contains events for changes to jwt-provider
	Topic_JWTProvider Topic = 16
	// ExportedServices topic contains events for changes to exported-services.
	Topic_ExportedServices Topic = 17
	// FileSystemCertificate topic contains events for changes to file-system-certificates.
	Topic_FileSystemCertificate Topic = 18
)

// Enum value maps for Topic.
var (
	Topic_name = map[int32]string{
		0:  "Unknown",
		1:  "ServiceHealth",
		2:  "ServiceHealthConnect",
		3:  "MeshConfig",
		4:  "ServiceResolver",
		5:  "IngressGateway",
		6:  "ServiceIntentions",
		7:  "ServiceList",
		8:  "ServiceDefaults",
		9:  "APIGateway",
		10: "TCPRoute",
		11: "HTTPRoute",
		12: "InlineCertificate",
		13: "BoundAPIGateway",
		14: "IPRateLimit",
		15: "SamenessGroup",
		16: "JWTProvider",
		17: "ExportedServices",
		18: "FileSystemCertificate",
	}
	Topic_value = map[string]int32{
		"Unknown":               0,
		"ServiceHealth":         1,
		"ServiceHealthConnect":  2,
		"MeshConfig":            3,
		"ServiceResolver":       4,
		"IngressGateway":        5,
		"ServiceIntentions":     6,
		"ServiceList":           7,
		"ServiceDefaults":       8,
		"APIGateway":            9,
		"TCPRoute":              10,
		"HTTPRoute":             11,
		"InlineCertificate":     12,
		"BoundAPIGateway":       13,
		"IPRateLimit":           14,
		"SamenessGroup":         15,
		"JWTProvider":           16,
		"ExportedServices":      17,
		"FileSystemCertificate": 18,
	}
)

func (x Topic) Enum() *Topic {
	p := new(Topic)
	*p = x
	return p
}

func (x Topic) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Topic) Descriptor() protoreflect.EnumDescriptor {
	return file_private_pbsubscribe_subscribe_proto_enumTypes[0].Descriptor()
}

func (Topic) Type() protoreflect.EnumType {
	return &file_private_pbsubscribe_subscribe_proto_enumTypes[0]
}

func (x Topic) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Topic.Descriptor instead.
func (Topic) EnumDescriptor() ([]byte, []int) {
	return file_private_pbsubscribe_subscribe_proto_rawDescGZIP(), []int{0}
}

type CatalogOp int32

const (
	CatalogOp_Register   CatalogOp = 0
	CatalogOp_Deregister CatalogOp = 1
)

// Enum value maps for CatalogOp.
var (
	CatalogOp_name = map[int32]string{
		0: "Register",
		1: "Deregister",
	}
	CatalogOp_value = map[string]int32{
		"Register":   0,
		"Deregister": 1,
	}
)

func (x CatalogOp) Enum() *CatalogOp {
	p := new(CatalogOp)
	*p = x
	return p
}

func (x CatalogOp) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CatalogOp) Descriptor() protoreflect.EnumDescriptor {
	return file_private_pbsubscribe_subscribe_proto_enumTypes[1].Descriptor()
}

func (CatalogOp) Type() protoreflect.EnumType {
	return &file_private_pbsubscribe_subscribe_proto_enumTypes[1]
}

func (x CatalogOp) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CatalogOp.Descriptor instead.
func (CatalogOp) EnumDescriptor() ([]byte, []int) {
	return file_private_pbsubscribe_subscribe_proto_rawDescGZIP(), []int{1}
}

type ConfigEntryUpdate_UpdateOp int32

const (
	ConfigEntryUpdate_Upsert ConfigEntryUpdate_UpdateOp = 0
	ConfigEntryUpdate_Delete ConfigEntryUpdate_UpdateOp = 1
)

// Enum value maps for ConfigEntryUpdate_UpdateOp.
var (
	ConfigEntryUpdate_UpdateOp_name = map[int32]string{
		0: "Upsert",
		1: "Delete",
	}
	ConfigEntryUpdate_UpdateOp_value = map[string]int32{
		"Upsert": 0,
		"Delete": 1,
	}
)

func (x ConfigEntryUpdate_UpdateOp) Enum() *ConfigEntryUpdate_UpdateOp {
	p := new(ConfigEntryUpdate_UpdateOp)
	*p = x
	return p
}

func (x ConfigEntryUpdate_UpdateOp) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConfigEntryUpdate_UpdateOp) Descriptor() protoreflect.EnumDescriptor {
	return file_private_pbsubscribe_subscribe_proto_enumTypes[2].Descriptor()
}

func (ConfigEntryUpdate_UpdateOp) Type() protoreflect.EnumType {
	return &file_private_pbsubscribe_subscribe_proto_enumTypes[2]
}

func (x ConfigEntryUpdate_UpdateOp) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConfigEntryUpdate_UpdateOp.Descriptor instead.
func (ConfigEntryUpdate_UpdateOp) EnumDescriptor() ([]byte, []int) {
	return file_private_pbsubscribe_subscribe_proto_rawDescGZIP(), []int{5, 0}
}

type NamedSubject struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Key is a topic-specific identifier that restricts the scope of the
	// subscription to only events pertaining to that identifier. For example,
	// to receive events for a single service, the service's name is specified
	// as the key.
	Key string `protobuf:"bytes,1,opt,name=Key,proto3" json:"Key,omitempty"`
	// Namespace which contains the resources. If Namespace is not specified the
	// default namespace will be used.
	//
	// Namespace is an enterprise-only feature.
	Namespace string `protobuf:"bytes,2,opt,name=Namespace,proto3" json:"Namespace,omitempty"`
	// Partition which contains the resources. If Partition is not specified the
	// default partition will be used.
	//
	// Partition is an enterprise-only feature.
	Partition string `protobuf:"bytes,3,opt,name=Partition,proto3" json:"Partition,omitempty"`
	// PeerName is the name of the peer that the requested service was imported from.
	PeerName      string `protobuf:"bytes,4,opt,name=PeerName,proto3" json:"PeerName,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NamedSubject) Reset() {
	*x = NamedSubject{}
	mi := &file_private_pbsubscribe_subscribe_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NamedSubject) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamedSubject) ProtoMessage() {}

func (x *NamedSubject) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbsubscribe_subscribe_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamedSubject.ProtoReflect.Descriptor instead.
func (*NamedSubject) Descriptor() ([]byte, []int) {
	return file_private_pbsubscribe_subscribe_proto_rawDescGZIP(), []int{0}
}

func (x *NamedSubject) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *NamedSubject) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *NamedSubject) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

func (x *NamedSubject) GetPeerName() string {
	if x != nil {
		return x.PeerName
	}
	return ""
}

// SubscribeRequest used to subscribe to a topic.
type SubscribeRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Topic identifies the set of events the subscriber is interested in.
	Topic Topic `protobuf:"varint,1,opt,name=Topic,proto3,enum=subscribe.Topic" json:"Topic,omitempty"`
	// Deprecated: use NamedSubject.Key instead.
	Key string `protobuf:"bytes,2,opt,name=Key,proto3" json:"Key,omitempty"`
	// Token is the ACL token to authenticate the request. The token must have
	// sufficient privileges to read the requested information otherwise events
	// will be filtered, possibly resulting in an empty snapshot and no further
	// updates sent.
	Token string `protobuf:"bytes,3,opt,name=Token,proto3" json:"Token,omitempty"`
	// Index is the raft index the subscriber has already observed up to. This
	// is zero on an initial streaming call, but then can be provided by a
	// client on subsequent re-connections such that the full snapshot doesn't
	// need to be resent if the client is up to date.
	Index uint64 `protobuf:"varint,4,opt,name=Index,proto3" json:"Index,omitempty"`
	// Datacenter specifies the Consul datacenter the request is targeted at.
	// If it's not the local DC the server will forward the request to
	// the remote DC and proxy the results back  to the subscriber. An empty
	// string defaults to the local datacenter.
	Datacenter string `protobuf:"bytes,5,opt,name=Datacenter,proto3" json:"Datacenter,omitempty"`
	// Deprecated: use NamedSubject.Namespace instead.
	Namespace string `protobuf:"bytes,6,opt,name=Namespace,proto3" json:"Namespace,omitempty"`
	// Deprecated: use NamedSubject.Partition instead.
	Partition string `protobuf:"bytes,7,opt,name=Partition,proto3" json:"Partition,omitempty"`
	// Deprecated: use NamedSubject.PeerName instead.
	PeerName string `protobuf:"bytes,8,opt,name=PeerName,proto3" json:"PeerName,omitempty"`
	// Subject identifies a portion of a topic for which the subscriber wishes to
	// receive events (e.g. health events for a particular service).
	//
	// Types that are valid to be assigned to Subject:
	//
	//	*SubscribeRequest_WildcardSubject
	//	*SubscribeRequest_NamedSubject
	Subject       isSubscribeRequest_Subject `protobuf_oneof:"Subject"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SubscribeRequest) Reset() {
	*x = SubscribeRequest{}
	mi := &file_private_pbsubscribe_subscribe_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SubscribeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubscribeRequest) ProtoMessage() {}

func (x *SubscribeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbsubscribe_subscribe_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubscribeRequest.ProtoReflect.Descriptor instead.
func (*SubscribeRequest) Descriptor() ([]byte, []int) {
	return file_private_pbsubscribe_subscribe_proto_rawDescGZIP(), []int{1}
}

func (x *SubscribeRequest) GetTopic() Topic {
	if x != nil {
		return x.Topic
	}
	return Topic_Unknown
}

func (x *SubscribeRequest) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *SubscribeRequest) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *SubscribeRequest) GetIndex() uint64 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *SubscribeRequest) GetDatacenter() string {
	if x != nil {
		return x.Datacenter
	}
	return ""
}

func (x *SubscribeRequest) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *SubscribeRequest) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

func (x *SubscribeRequest) GetPeerName() string {
	if x != nil {
		return x.PeerName
	}
	return ""
}

func (x *SubscribeRequest) GetSubject() isSubscribeRequest_Subject {
	if x != nil {
		return x.Subject
	}
	return nil
}

func (x *SubscribeRequest) GetWildcardSubject() bool {
	if x != nil {
		if x, ok := x.Subject.(*SubscribeRequest_WildcardSubject); ok {
			return x.WildcardSubject
		}
	}
	return false
}

func (x *SubscribeRequest) GetNamedSubject() *NamedSubject {
	if x != nil {
		if x, ok := x.Subject.(*SubscribeRequest_NamedSubject); ok {
			return x.NamedSubject
		}
	}
	return nil
}

type isSubscribeRequest_Subject interface {
	isSubscribeRequest_Subject()
}

type SubscribeRequest_WildcardSubject struct {
	// WildcardSubject is used to subscribe to all events published on the topic
	// if it is supported.
	WildcardSubject bool `protobuf:"varint,9,opt,name=WildcardSubject,proto3,oneof"`
}

type SubscribeRequest_NamedSubject struct {
	// NamedSubject is used to subscribe to events pertaining to a specific
	// resource (e.g. a particular service or config entry).
	NamedSubject *NamedSubject `protobuf:"bytes,10,opt,name=NamedSubject,proto3,oneof"`
}

func (*SubscribeRequest_WildcardSubject) isSubscribeRequest_Subject() {}

func (*SubscribeRequest_NamedSubject) isSubscribeRequest_Subject() {}

// Event describes a streaming update on a subscription. Events are used both to
// describe the current "snapshot" of the result as well as ongoing mutations to
// that snapshot.
type Event struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Index is the raft index at which the mutation took place. At the top
	// level of a subscription there will always be at most one Event per index.
	// If multiple events are published to the same topic in a single raft
	// transaction then the batch of events will be encoded inside a single
	// top-level event to ensure they are delivered atomically to clients.
	Index uint64 `protobuf:"varint,1,opt,name=Index,proto3" json:"Index,omitempty"`
	// Payload is the actual event content.
	//
	// Types that are valid to be assigned to Payload:
	//
	//	*Event_EndOfSnapshot
	//	*Event_NewSnapshotToFollow
	//	*Event_EventBatch
	//	*Event_ServiceHealth
	//	*Event_ConfigEntry
	//	*Event_Service
	Payload       isEvent_Payload `protobuf_oneof:"Payload"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Event) Reset() {
	*x = Event{}
	mi := &file_private_pbsubscribe_subscribe_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event) ProtoMessage() {}

func (x *Event) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbsubscribe_subscribe_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event.ProtoReflect.Descriptor instead.
func (*Event) Descriptor() ([]byte, []int) {
	return file_private_pbsubscribe_subscribe_proto_rawDescGZIP(), []int{2}
}

func (x *Event) GetIndex() uint64 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *Event) GetPayload() isEvent_Payload {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *Event) GetEndOfSnapshot() bool {
	if x != nil {
		if x, ok := x.Payload.(*Event_EndOfSnapshot); ok {
			return x.EndOfSnapshot
		}
	}
	return false
}

func (x *Event) GetNewSnapshotToFollow() bool {
	if x != nil {
		if x, ok := x.Payload.(*Event_NewSnapshotToFollow); ok {
			return x.NewSnapshotToFollow
		}
	}
	return false
}

func (x *Event) GetEventBatch() *EventBatch {
	if x != nil {
		if x, ok := x.Payload.(*Event_EventBatch); ok {
			return x.EventBatch
		}
	}
	return nil
}

func (x *Event) GetServiceHealth() *ServiceHealthUpdate {
	if x != nil {
		if x, ok := x.Payload.(*Event_ServiceHealth); ok {
			return x.ServiceHealth
		}
	}
	return nil
}

func (x *Event) GetConfigEntry() *ConfigEntryUpdate {
	if x != nil {
		if x, ok := x.Payload.(*Event_ConfigEntry); ok {
			return x.ConfigEntry
		}
	}
	return nil
}

func (x *Event) GetService() *ServiceListUpdate {
	if x != nil {
		if x, ok := x.Payload.(*Event_Service); ok {
			return x.Service
		}
	}
	return nil
}

type isEvent_Payload interface {
	isEvent_Payload()
}

type Event_EndOfSnapshot struct {
	// EndOfSnapshot indicates the event stream for the initial snapshot has
	// ended. Subsequent Events delivered will be mutations to that result.
	EndOfSnapshot bool `protobuf:"varint,2,opt,name=EndOfSnapshot,proto3,oneof"`
}

type Event_NewSnapshotToFollow struct {
	// NewSnapshotToFollow indicates that the client view is stale. The client
	// must reset its view before handing any more events. Subsequent events
	// in the stream will be for a new snapshot until an EndOfSnapshot event
	// is received.
	NewSnapshotToFollow bool `protobuf:"varint,3,opt,name=NewSnapshotToFollow,proto3,oneof"`
}

type Event_EventBatch struct {
	// EventBatch is a set of events. This is typically used as the payload
	// type where multiple events are emitted in a single topic and raft
	// index (e.g. transactional updates). In this case the Topic and Index
	// values of all events will match and the whole set should be delivered
	// and consumed atomically.
	EventBatch *EventBatch `protobuf:"bytes,4,opt,name=EventBatch,proto3,oneof"`
}

type Event_ServiceHealth struct {
	// ServiceHealth is used for ServiceHealth and ServiceHealthConnect
	// topics.
	ServiceHealth *ServiceHealthUpdate `protobuf:"bytes,10,opt,name=ServiceHealth,proto3,oneof"`
}

type Event_ConfigEntry struct {
	// ConfigEntry is used for config entry topics (e.g. MeshConfig).
	ConfigEntry *ConfigEntryUpdate `protobuf:"bytes,11,opt,name=ConfigEntry,proto3,oneof"`
}

type Event_Service struct {
	// Service is used for ServiceList topic.
	Service *ServiceListUpdate `protobuf:"bytes,12,opt,name=Service,proto3,oneof"`
}

func (*Event_EndOfSnapshot) isEvent_Payload() {}

func (*Event_NewSnapshotToFollow) isEvent_Payload() {}

func (*Event_EventBatch) isEvent_Payload() {}

func (*Event_ServiceHealth) isEvent_Payload() {}

func (*Event_ConfigEntry) isEvent_Payload() {}

func (*Event_Service) isEvent_Payload() {}

type EventBatch struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Events        []*Event               `protobuf:"bytes,1,rep,name=Events,proto3" json:"Events,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EventBatch) Reset() {
	*x = EventBatch{}
	mi := &file_private_pbsubscribe_subscribe_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EventBatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventBatch) ProtoMessage() {}

func (x *EventBatch) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbsubscribe_subscribe_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventBatch.ProtoReflect.Descriptor instead.
func (*EventBatch) Descriptor() ([]byte, []int) {
	return file_private_pbsubscribe_subscribe_proto_rawDescGZIP(), []int{3}
}

func (x *EventBatch) GetEvents() []*Event {
	if x != nil {
		return x.Events
	}
	return nil
}

type ServiceHealthUpdate struct {
	state            protoimpl.MessageState      `protogen:"open.v1"`
	Op               CatalogOp                   `protobuf:"varint,1,opt,name=Op,proto3,enum=subscribe.CatalogOp" json:"Op,omitempty"`
	CheckServiceNode *pbservice.CheckServiceNode `protobuf:"bytes,2,opt,name=CheckServiceNode,proto3" json:"CheckServiceNode,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *ServiceHealthUpdate) Reset() {
	*x = ServiceHealthUpdate{}
	mi := &file_private_pbsubscribe_subscribe_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceHealthUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceHealthUpdate) ProtoMessage() {}

func (x *ServiceHealthUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbsubscribe_subscribe_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceHealthUpdate.ProtoReflect.Descriptor instead.
func (*ServiceHealthUpdate) Descriptor() ([]byte, []int) {
	return file_private_pbsubscribe_subscribe_proto_rawDescGZIP(), []int{4}
}

func (x *ServiceHealthUpdate) GetOp() CatalogOp {
	if x != nil {
		return x.Op
	}
	return CatalogOp_Register
}

func (x *ServiceHealthUpdate) GetCheckServiceNode() *pbservice.CheckServiceNode {
	if x != nil {
		return x.CheckServiceNode
	}
	return nil
}

type ConfigEntryUpdate struct {
	state         protoimpl.MessageState     `protogen:"open.v1"`
	Op            ConfigEntryUpdate_UpdateOp `protobuf:"varint,1,opt,name=Op,proto3,enum=subscribe.ConfigEntryUpdate_UpdateOp" json:"Op,omitempty"`
	ConfigEntry   *pbconfigentry.ConfigEntry `protobuf:"bytes,2,opt,name=ConfigEntry,proto3" json:"ConfigEntry,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConfigEntryUpdate) Reset() {
	*x = ConfigEntryUpdate{}
	mi := &file_private_pbsubscribe_subscribe_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigEntryUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigEntryUpdate) ProtoMessage() {}

func (x *ConfigEntryUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbsubscribe_subscribe_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigEntryUpdate.ProtoReflect.Descriptor instead.
func (*ConfigEntryUpdate) Descriptor() ([]byte, []int) {
	return file_private_pbsubscribe_subscribe_proto_rawDescGZIP(), []int{5}
}

func (x *ConfigEntryUpdate) GetOp() ConfigEntryUpdate_UpdateOp {
	if x != nil {
		return x.Op
	}
	return ConfigEntryUpdate_Upsert
}

func (x *ConfigEntryUpdate) GetConfigEntry() *pbconfigentry.ConfigEntry {
	if x != nil {
		return x.ConfigEntry
	}
	return nil
}

type ServiceListUpdate struct {
	state          protoimpl.MessageState   `protogen:"open.v1"`
	Op             CatalogOp                `protobuf:"varint,1,opt,name=Op,proto3,enum=subscribe.CatalogOp" json:"Op,omitempty"`
	Name           string                   `protobuf:"bytes,2,opt,name=Name,proto3" json:"Name,omitempty"`
	EnterpriseMeta *pbcommon.EnterpriseMeta `protobuf:"bytes,3,opt,name=EnterpriseMeta,proto3" json:"EnterpriseMeta,omitempty"`
	PeerName       string                   `protobuf:"bytes,4,opt,name=PeerName,proto3" json:"PeerName,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *ServiceListUpdate) Reset() {
	*x = ServiceListUpdate{}
	mi := &file_private_pbsubscribe_subscribe_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceListUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceListUpdate) ProtoMessage() {}

func (x *ServiceListUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbsubscribe_subscribe_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceListUpdate.ProtoReflect.Descriptor instead.
func (*ServiceListUpdate) Descriptor() ([]byte, []int) {
	return file_private_pbsubscribe_subscribe_proto_rawDescGZIP(), []int{6}
}

func (x *ServiceListUpdate) GetOp() CatalogOp {
	if x != nil {
		return x.Op
	}
	return CatalogOp_Register
}

func (x *ServiceListUpdate) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ServiceListUpdate) GetEnterpriseMeta() *pbcommon.EnterpriseMeta {
	if x != nil {
		return x.EnterpriseMeta
	}
	return nil
}

func (x *ServiceListUpdate) GetPeerName() string {
	if x != nil {
		return x.PeerName
	}
	return ""
}

var File_private_pbsubscribe_subscribe_proto protoreflect.FileDescriptor

const file_private_pbsubscribe_subscribe_proto_rawDesc = "" +
	"\n" +
	"#private/pbsubscribe/subscribe.proto\x12\tsubscribe\x1a%annotations/ratelimit/ratelimit.proto\x1a\x1dprivate/pbcommon/common.proto\x1a(private/pbconfigentry/config_entry.proto\x1a\x1cprivate/pbservice/node.proto\"x\n" +
	"\fNamedSubject\x12\x10\n" +
	"\x03Key\x18\x01 \x01(\tR\x03Key\x12\x1c\n" +
	"\tNamespace\x18\x02 \x01(\tR\tNamespace\x12\x1c\n" +
	"\tPartition\x18\x03 \x01(\tR\tPartition\x12\x1a\n" +
	"\bPeerName\x18\x04 \x01(\tR\bPeerName\"\xe6\x02\n" +
	"\x10SubscribeRequest\x12&\n" +
	"\x05Topic\x18\x01 \x01(\x0e2\x10.subscribe.TopicR\x05Topic\x12\x10\n" +
	"\x03Key\x18\x02 \x01(\tR\x03Key\x12\x14\n" +
	"\x05Token\x18\x03 \x01(\tR\x05Token\x12\x14\n" +
	"\x05Index\x18\x04 \x01(\x04R\x05Index\x12\x1e\n" +
	"\n" +
	"Datacenter\x18\x05 \x01(\tR\n" +
	"Datacenter\x12\x1c\n" +
	"\tNamespace\x18\x06 \x01(\tR\tNamespace\x12\x1c\n" +
	"\tPartition\x18\a \x01(\tR\tPartition\x12\x1a\n" +
	"\bPeerName\x18\b \x01(\tR\bPeerName\x12*\n" +
	"\x0fWildcardSubject\x18\t \x01(\bH\x00R\x0fWildcardSubject\x12=\n" +
	"\fNamedSubject\x18\n" +
	" \x01(\v2\x17.subscribe.NamedSubjectH\x00R\fNamedSubjectB\t\n" +
	"\aSubject\"\x81\x03\n" +
	"\x05Event\x12\x14\n" +
	"\x05Index\x18\x01 \x01(\x04R\x05Index\x12&\n" +
	"\rEndOfSnapshot\x18\x02 \x01(\bH\x00R\rEndOfSnapshot\x122\n" +
	"\x13NewSnapshotToFollow\x18\x03 \x01(\bH\x00R\x13NewSnapshotToFollow\x127\n" +
	"\n" +
	"EventBatch\x18\x04 \x01(\v2\x15.subscribe.EventBatchH\x00R\n" +
	"EventBatch\x12F\n" +
	"\rServiceHealth\x18\n" +
	" \x01(\v2\x1e.subscribe.ServiceHealthUpdateH\x00R\rServiceHealth\x12@\n" +
	"\vConfigEntry\x18\v \x01(\v2\x1c.subscribe.ConfigEntryUpdateH\x00R\vConfigEntry\x128\n" +
	"\aService\x18\f \x01(\v2\x1c.subscribe.ServiceListUpdateH\x00R\aServiceB\t\n" +
	"\aPayload\"6\n" +
	"\n" +
	"EventBatch\x12(\n" +
	"\x06Events\x18\x01 \x03(\v2\x10.subscribe.EventR\x06Events\"\x9c\x01\n" +
	"\x13ServiceHealthUpdate\x12$\n" +
	"\x02Op\x18\x01 \x01(\x0e2\x14.subscribe.CatalogOpR\x02Op\x12_\n" +
	"\x10CheckServiceNode\x18\x02 \x01(\v23.hashicorp.consul.internal.service.CheckServiceNodeR\x10CheckServiceNode\"\xc4\x01\n" +
	"\x11ConfigEntryUpdate\x125\n" +
	"\x02Op\x18\x01 \x01(\x0e2%.subscribe.ConfigEntryUpdate.UpdateOpR\x02Op\x12T\n" +
	"\vConfigEntry\x18\x02 \x01(\v22.hashicorp.consul.internal.configentry.ConfigEntryR\vConfigEntry\"\"\n" +
	"\bUpdateOp\x12\n" +
	"\n" +
	"\x06Upsert\x10\x00\x12\n" +
	"\n" +
	"\x06Delete\x10\x01\"\xc3\x01\n" +
	"\x11ServiceListUpdate\x12$\n" +
	"\x02Op\x18\x01 \x01(\x0e2\x14.subscribe.CatalogOpR\x02Op\x12\x12\n" +
	"\x04Name\x18\x02 \x01(\tR\x04Name\x12X\n" +
	"\x0eEnterpriseMeta\x18\x03 \x01(\v20.hashicorp.consul.internal.common.EnterpriseMetaR\x0eEnterpriseMeta\x12\x1a\n" +
	"\bPeerName\x18\x04 \x01(\tR\bPeerName*\xf6\x02\n" +
	"\x05Topic\x12\v\n" +
	"\aUnknown\x10\x00\x12\x11\n" +
	"\rServiceHealth\x10\x01\x12\x18\n" +
	"\x14ServiceHealthConnect\x10\x02\x12\x0e\n" +
	"\n" +
	"MeshConfig\x10\x03\x12\x13\n" +
	"\x0fServiceResolver\x10\x04\x12\x12\n" +
	"\x0eIngressGateway\x10\x05\x12\x15\n" +
	"\x11ServiceIntentions\x10\x06\x12\x0f\n" +
	"\vServiceList\x10\a\x12\x13\n" +
	"\x0fServiceDefaults\x10\b\x12\x0e\n" +
	"\n" +
	"APIGateway\x10\t\x12\f\n" +
	"\bTCPRoute\x10\n" +
	"\x12\r\n" +
	"\tHTTPRoute\x10\v\x12\x15\n" +
	"\x11InlineCertificate\x10\f\x12\x13\n" +
	"\x0fBoundAPIGateway\x10\r\x12\x0f\n" +
	"\vIPRateLimit\x10\x0e\x12\x11\n" +
	"\rSamenessGroup\x10\x0f\x12\x0f\n" +
	"\vJWTProvider\x10\x10\x12\x14\n" +
	"\x10ExportedServices\x10\x11\x12\x19\n" +
	"\x15FileSystemCertificate\x10\x12*)\n" +
	"\tCatalogOp\x12\f\n" +
	"\bRegister\x10\x00\x12\x0e\n" +
	"\n" +
	"Deregister\x10\x012a\n" +
	"\x17StateChangeSubscription\x12F\n" +
	"\tSubscribe\x12\x1b.subscribe.SubscribeRequest\x1a\x10.subscribe.Event\"\b\xe2\x86\x04\x04\b\x02\x10\t0\x01B\x9a\x01\n" +
	"\rcom.subscribeB\x0eSubscribeProtoP\x01Z5github.com/hashicorp/consul/proto/private/pbsubscribe\xa2\x02\x03SXX\xaa\x02\tSubscribe\xca\x02\tSubscribe\xe2\x02\x15Subscribe\\GPBMetadata\xea\x02\tSubscribeb\x06proto3"

var (
	file_private_pbsubscribe_subscribe_proto_rawDescOnce sync.Once
	file_private_pbsubscribe_subscribe_proto_rawDescData []byte
)

func file_private_pbsubscribe_subscribe_proto_rawDescGZIP() []byte {
	file_private_pbsubscribe_subscribe_proto_rawDescOnce.Do(func() {
		file_private_pbsubscribe_subscribe_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_private_pbsubscribe_subscribe_proto_rawDesc), len(file_private_pbsubscribe_subscribe_proto_rawDesc)))
	})
	return file_private_pbsubscribe_subscribe_proto_rawDescData
}

var file_private_pbsubscribe_subscribe_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_private_pbsubscribe_subscribe_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_private_pbsubscribe_subscribe_proto_goTypes = []any{
	(Topic)(0),                         // 0: subscribe.Topic
	(CatalogOp)(0),                     // 1: subscribe.CatalogOp
	(ConfigEntryUpdate_UpdateOp)(0),    // 2: subscribe.ConfigEntryUpdate.UpdateOp
	(*NamedSubject)(nil),               // 3: subscribe.NamedSubject
	(*SubscribeRequest)(nil),           // 4: subscribe.SubscribeRequest
	(*Event)(nil),                      // 5: subscribe.Event
	(*EventBatch)(nil),                 // 6: subscribe.EventBatch
	(*ServiceHealthUpdate)(nil),        // 7: subscribe.ServiceHealthUpdate
	(*ConfigEntryUpdate)(nil),          // 8: subscribe.ConfigEntryUpdate
	(*ServiceListUpdate)(nil),          // 9: subscribe.ServiceListUpdate
	(*pbservice.CheckServiceNode)(nil), // 10: hashicorp.consul.internal.service.CheckServiceNode
	(*pbconfigentry.ConfigEntry)(nil),  // 11: hashicorp.consul.internal.configentry.ConfigEntry
	(*pbcommon.EnterpriseMeta)(nil),    // 12: hashicorp.consul.internal.common.EnterpriseMeta
}
var file_private_pbsubscribe_subscribe_proto_depIdxs = []int32{
	0,  // 0: subscribe.SubscribeRequest.Topic:type_name -> subscribe.Topic
	3,  // 1: subscribe.SubscribeRequest.NamedSubject:type_name -> subscribe.NamedSubject
	6,  // 2: subscribe.Event.EventBatch:type_name -> subscribe.EventBatch
	7,  // 3: subscribe.Event.ServiceHealth:type_name -> subscribe.ServiceHealthUpdate
	8,  // 4: subscribe.Event.ConfigEntry:type_name -> subscribe.ConfigEntryUpdate
	9,  // 5: subscribe.Event.Service:type_name -> subscribe.ServiceListUpdate
	5,  // 6: subscribe.EventBatch.Events:type_name -> subscribe.Event
	1,  // 7: subscribe.ServiceHealthUpdate.Op:type_name -> subscribe.CatalogOp
	10, // 8: subscribe.ServiceHealthUpdate.CheckServiceNode:type_name -> hashicorp.consul.internal.service.CheckServiceNode
	2,  // 9: subscribe.ConfigEntryUpdate.Op:type_name -> subscribe.ConfigEntryUpdate.UpdateOp
	11, // 10: subscribe.ConfigEntryUpdate.ConfigEntry:type_name -> hashicorp.consul.internal.configentry.ConfigEntry
	1,  // 11: subscribe.ServiceListUpdate.Op:type_name -> subscribe.CatalogOp
	12, // 12: subscribe.ServiceListUpdate.EnterpriseMeta:type_name -> hashicorp.consul.internal.common.EnterpriseMeta
	4,  // 13: subscribe.StateChangeSubscription.Subscribe:input_type -> subscribe.SubscribeRequest
	5,  // 14: subscribe.StateChangeSubscription.Subscribe:output_type -> subscribe.Event
	14, // [14:15] is the sub-list for method output_type
	13, // [13:14] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_private_pbsubscribe_subscribe_proto_init() }
func file_private_pbsubscribe_subscribe_proto_init() {
	if File_private_pbsubscribe_subscribe_proto != nil {
		return
	}
	file_private_pbsubscribe_subscribe_proto_msgTypes[1].OneofWrappers = []any{
		(*SubscribeRequest_WildcardSubject)(nil),
		(*SubscribeRequest_NamedSubject)(nil),
	}
	file_private_pbsubscribe_subscribe_proto_msgTypes[2].OneofWrappers = []any{
		(*Event_EndOfSnapshot)(nil),
		(*Event_NewSnapshotToFollow)(nil),
		(*Event_EventBatch)(nil),
		(*Event_ServiceHealth)(nil),
		(*Event_ConfigEntry)(nil),
		(*Event_Service)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_private_pbsubscribe_subscribe_proto_rawDesc), len(file_private_pbsubscribe_subscribe_proto_rawDesc)),
			NumEnums:      3,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_private_pbsubscribe_subscribe_proto_goTypes,
		DependencyIndexes: file_private_pbsubscribe_subscribe_proto_depIdxs,
		EnumInfos:         file_private_pbsubscribe_subscribe_proto_enumTypes,
		MessageInfos:      file_private_pbsubscribe_subscribe_proto_msgTypes,
	}.Build()
	File_private_pbsubscribe_subscribe_proto = out.File
	file_private_pbsubscribe_subscribe_proto_goTypes = nil
	file_private_pbsubscribe_subscribe_proto_depIdxs = nil
}
