// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             (unknown)
// source: private/pbpeering/peering.proto

package pbpeering

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	PeeringService_GenerateToken_FullMethodName            = "/hashicorp.consul.internal.peering.PeeringService/GenerateToken"
	PeeringService_Establish_FullMethodName                = "/hashicorp.consul.internal.peering.PeeringService/Establish"
	PeeringService_PeeringRead_FullMethodName              = "/hashicorp.consul.internal.peering.PeeringService/PeeringRead"
	PeeringService_PeeringList_FullMethodName              = "/hashicorp.consul.internal.peering.PeeringService/PeeringList"
	PeeringService_PeeringDelete_FullMethodName            = "/hashicorp.consul.internal.peering.PeeringService/PeeringDelete"
	PeeringService_PeeringWrite_FullMethodName             = "/hashicorp.consul.internal.peering.PeeringService/PeeringWrite"
	PeeringService_TrustBundleListByService_FullMethodName = "/hashicorp.consul.internal.peering.PeeringService/TrustBundleListByService"
	PeeringService_TrustBundleRead_FullMethodName          = "/hashicorp.consul.internal.peering.PeeringService/TrustBundleRead"
)

// PeeringServiceClient is the client API for PeeringService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// PeeringService handles operations for establishing peering relationships
// between disparate Consul clusters.
type PeeringServiceClient interface {
	GenerateToken(ctx context.Context, in *GenerateTokenRequest, opts ...grpc.CallOption) (*GenerateTokenResponse, error)
	Establish(ctx context.Context, in *EstablishRequest, opts ...grpc.CallOption) (*EstablishResponse, error)
	PeeringRead(ctx context.Context, in *PeeringReadRequest, opts ...grpc.CallOption) (*PeeringReadResponse, error)
	PeeringList(ctx context.Context, in *PeeringListRequest, opts ...grpc.CallOption) (*PeeringListResponse, error)
	PeeringDelete(ctx context.Context, in *PeeringDeleteRequest, opts ...grpc.CallOption) (*PeeringDeleteResponse, error)
	// TODO(peering): As of writing, this method is only used in tests to set up Peerings in the state store.
	// Consider removing if we can find another way to populate state store in peering_endpoint_test.go
	PeeringWrite(ctx context.Context, in *PeeringWriteRequest, opts ...grpc.CallOption) (*PeeringWriteResponse, error)
	// TODO(peering): Rename this to PeeredServiceRoots? or something like that?
	TrustBundleListByService(ctx context.Context, in *TrustBundleListByServiceRequest, opts ...grpc.CallOption) (*TrustBundleListByServiceResponse, error)
	TrustBundleRead(ctx context.Context, in *TrustBundleReadRequest, opts ...grpc.CallOption) (*TrustBundleReadResponse, error)
}

type peeringServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewPeeringServiceClient(cc grpc.ClientConnInterface) PeeringServiceClient {
	return &peeringServiceClient{cc}
}

func (c *peeringServiceClient) GenerateToken(ctx context.Context, in *GenerateTokenRequest, opts ...grpc.CallOption) (*GenerateTokenResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GenerateTokenResponse)
	err := c.cc.Invoke(ctx, PeeringService_GenerateToken_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *peeringServiceClient) Establish(ctx context.Context, in *EstablishRequest, opts ...grpc.CallOption) (*EstablishResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(EstablishResponse)
	err := c.cc.Invoke(ctx, PeeringService_Establish_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *peeringServiceClient) PeeringRead(ctx context.Context, in *PeeringReadRequest, opts ...grpc.CallOption) (*PeeringReadResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(PeeringReadResponse)
	err := c.cc.Invoke(ctx, PeeringService_PeeringRead_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *peeringServiceClient) PeeringList(ctx context.Context, in *PeeringListRequest, opts ...grpc.CallOption) (*PeeringListResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(PeeringListResponse)
	err := c.cc.Invoke(ctx, PeeringService_PeeringList_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *peeringServiceClient) PeeringDelete(ctx context.Context, in *PeeringDeleteRequest, opts ...grpc.CallOption) (*PeeringDeleteResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(PeeringDeleteResponse)
	err := c.cc.Invoke(ctx, PeeringService_PeeringDelete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *peeringServiceClient) PeeringWrite(ctx context.Context, in *PeeringWriteRequest, opts ...grpc.CallOption) (*PeeringWriteResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(PeeringWriteResponse)
	err := c.cc.Invoke(ctx, PeeringService_PeeringWrite_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *peeringServiceClient) TrustBundleListByService(ctx context.Context, in *TrustBundleListByServiceRequest, opts ...grpc.CallOption) (*TrustBundleListByServiceResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(TrustBundleListByServiceResponse)
	err := c.cc.Invoke(ctx, PeeringService_TrustBundleListByService_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *peeringServiceClient) TrustBundleRead(ctx context.Context, in *TrustBundleReadRequest, opts ...grpc.CallOption) (*TrustBundleReadResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(TrustBundleReadResponse)
	err := c.cc.Invoke(ctx, PeeringService_TrustBundleRead_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PeeringServiceServer is the server API for PeeringService service.
// All implementations should embed UnimplementedPeeringServiceServer
// for forward compatibility.
//
// PeeringService handles operations for establishing peering relationships
// between disparate Consul clusters.
type PeeringServiceServer interface {
	GenerateToken(context.Context, *GenerateTokenRequest) (*GenerateTokenResponse, error)
	Establish(context.Context, *EstablishRequest) (*EstablishResponse, error)
	PeeringRead(context.Context, *PeeringReadRequest) (*PeeringReadResponse, error)
	PeeringList(context.Context, *PeeringListRequest) (*PeeringListResponse, error)
	PeeringDelete(context.Context, *PeeringDeleteRequest) (*PeeringDeleteResponse, error)
	// TODO(peering): As of writing, this method is only used in tests to set up Peerings in the state store.
	// Consider removing if we can find another way to populate state store in peering_endpoint_test.go
	PeeringWrite(context.Context, *PeeringWriteRequest) (*PeeringWriteResponse, error)
	// TODO(peering): Rename this to PeeredServiceRoots? or something like that?
	TrustBundleListByService(context.Context, *TrustBundleListByServiceRequest) (*TrustBundleListByServiceResponse, error)
	TrustBundleRead(context.Context, *TrustBundleReadRequest) (*TrustBundleReadResponse, error)
}

// UnimplementedPeeringServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedPeeringServiceServer struct{}

func (UnimplementedPeeringServiceServer) GenerateToken(context.Context, *GenerateTokenRequest) (*GenerateTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateToken not implemented")
}
func (UnimplementedPeeringServiceServer) Establish(context.Context, *EstablishRequest) (*EstablishResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Establish not implemented")
}
func (UnimplementedPeeringServiceServer) PeeringRead(context.Context, *PeeringReadRequest) (*PeeringReadResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PeeringRead not implemented")
}
func (UnimplementedPeeringServiceServer) PeeringList(context.Context, *PeeringListRequest) (*PeeringListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PeeringList not implemented")
}
func (UnimplementedPeeringServiceServer) PeeringDelete(context.Context, *PeeringDeleteRequest) (*PeeringDeleteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PeeringDelete not implemented")
}
func (UnimplementedPeeringServiceServer) PeeringWrite(context.Context, *PeeringWriteRequest) (*PeeringWriteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PeeringWrite not implemented")
}
func (UnimplementedPeeringServiceServer) TrustBundleListByService(context.Context, *TrustBundleListByServiceRequest) (*TrustBundleListByServiceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TrustBundleListByService not implemented")
}
func (UnimplementedPeeringServiceServer) TrustBundleRead(context.Context, *TrustBundleReadRequest) (*TrustBundleReadResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TrustBundleRead not implemented")
}
func (UnimplementedPeeringServiceServer) testEmbeddedByValue() {}

// UnsafePeeringServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PeeringServiceServer will
// result in compilation errors.
type UnsafePeeringServiceServer interface {
	mustEmbedUnimplementedPeeringServiceServer()
}

func RegisterPeeringServiceServer(s grpc.ServiceRegistrar, srv PeeringServiceServer) {
	// If the following call pancis, it indicates UnimplementedPeeringServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&PeeringService_ServiceDesc, srv)
}

func _PeeringService_GenerateToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PeeringServiceServer).GenerateToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PeeringService_GenerateToken_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PeeringServiceServer).GenerateToken(ctx, req.(*GenerateTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PeeringService_Establish_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EstablishRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PeeringServiceServer).Establish(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PeeringService_Establish_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PeeringServiceServer).Establish(ctx, req.(*EstablishRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PeeringService_PeeringRead_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PeeringReadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PeeringServiceServer).PeeringRead(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PeeringService_PeeringRead_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PeeringServiceServer).PeeringRead(ctx, req.(*PeeringReadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PeeringService_PeeringList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PeeringListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PeeringServiceServer).PeeringList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PeeringService_PeeringList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PeeringServiceServer).PeeringList(ctx, req.(*PeeringListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PeeringService_PeeringDelete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PeeringDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PeeringServiceServer).PeeringDelete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PeeringService_PeeringDelete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PeeringServiceServer).PeeringDelete(ctx, req.(*PeeringDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PeeringService_PeeringWrite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PeeringWriteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PeeringServiceServer).PeeringWrite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PeeringService_PeeringWrite_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PeeringServiceServer).PeeringWrite(ctx, req.(*PeeringWriteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PeeringService_TrustBundleListByService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TrustBundleListByServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PeeringServiceServer).TrustBundleListByService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PeeringService_TrustBundleListByService_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PeeringServiceServer).TrustBundleListByService(ctx, req.(*TrustBundleListByServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PeeringService_TrustBundleRead_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TrustBundleReadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PeeringServiceServer).TrustBundleRead(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PeeringService_TrustBundleRead_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PeeringServiceServer).TrustBundleRead(ctx, req.(*TrustBundleReadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// PeeringService_ServiceDesc is the grpc.ServiceDesc for PeeringService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var PeeringService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "hashicorp.consul.internal.peering.PeeringService",
	HandlerType: (*PeeringServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GenerateToken",
			Handler:    _PeeringService_GenerateToken_Handler,
		},
		{
			MethodName: "Establish",
			Handler:    _PeeringService_Establish_Handler,
		},
		{
			MethodName: "PeeringRead",
			Handler:    _PeeringService_PeeringRead_Handler,
		},
		{
			MethodName: "PeeringList",
			Handler:    _PeeringService_PeeringList_Handler,
		},
		{
			MethodName: "PeeringDelete",
			Handler:    _PeeringService_PeeringDelete_Handler,
		},
		{
			MethodName: "PeeringWrite",
			Handler:    _PeeringService_PeeringWrite_Handler,
		},
		{
			MethodName: "TrustBundleListByService",
			Handler:    _PeeringService_TrustBundleListByService_Handler,
		},
		{
			MethodName: "TrustBundleRead",
			Handler:    _PeeringService_TrustBundleRead_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "private/pbpeering/peering.proto",
}
