<?php
/*
 * License: GPLv3
 * License URI: https://www.gnu.org/licenses/gpl.txt
 * Copyright 2024-2025 Jean-Sebastien Morisset (https://surniaulula.com/)
 */

if ( ! defined( 'ABSPATH' ) ) {

	die( 'These aren\'t the droids you\'re looking for.' );
}

if ( ! class_exists( 'SucomEducationLevels' ) ) {

	class SucomEducationLevels {

		/*
		 * See https://developers.google.com/search/docs/appearance/structured-data/learning-video#learning-video-[videoobject,-learningresource].
		 */
		private static $levels = array(
			'[generic]' => array(
				'Beginner',
				'Intermediate',
				'Advanced',
			),
			'Algeria' => array(
				'Lower Secondary School (DZ)',
				'Grade 8 (DZ)',
				'Grade 9 (DZ)',
				'Upper Secondary School (DZ)',
				'Grade 10 (DZ)',
				'Grade 11 (DZ)',
				'Grade 12 (DZ)',
				'Higher Education (DZ)',
			),
			'Argentina' => array(
				'Secondary (AR)',
				'8th Grade (AR)',
				'9th Grade (AR)',
				'10th Grade (AR)',
				'11th Grade (AR)',
				'12th Grade (AR)',
				'Higher Education (AR)',
			),
			'Australia' => array(
				'Secondary School (AU)',
				'Year 8 (AU)',
				'Year 9 (AU)',
				'Year 10 (AU)',
				'Senior Secondary School (AU)',
				'Year 11 (AU)',
				'Year 12 (AU)',
				'University (AU)',
			),
			'Austria' => array(
				'Upper Secondary Level (AT)',
				'9th Grade (AT)',
				'10th Grade (AT)',
				'11th Grade (AT)',
				'12th Grade (AT)',
				'Tertiary Level (AT)',
			),
			'Azerbaijan' => array(
				'General Secondary Education (AZ)',
				'8th Grade (AZ)',
				'9th Grade (AZ)',
				'Full Secondary Education (AZ)',
				'10th Grade (AZ)',
				'11th Grade (AZ)',
				'Higher Education (AZ)',
			),
			'Bahrain' => array(
				'Intermediate Stage (BH)',
				'Grade 8 (BH)',
				'Grade 9 (BH)',
				'Secondary Stage (BH)',
				'Grade 10 (BH)',
				'Grade 11 (BH)',
				'Grade 12 (BH)',
				'Higher Education (BH)',
			),
			'Bangladesh' => array(
				'Junior Secondary Education (BD)',
				'Grade VIII (BD)',
				'Secondary Education (BD)',
				'Grade IX (BD)',
				'Grade X (BD)',
				'Higher Secondary Education (BD)',
				'Grade XI (BD)',
				'Grade XII (BD)',
				'Tertiary Education (BD)',
			),
			'Belarus' => array(
				'Compulsory Basic Education (BY)',
				'Grade 8 (BY)',
				'Grade 9 (BY)',
				'General Upper Secondary Education (BY)',
				'Grade 10 (BY)',
				'Grade 11 (BY)',
				'Grade 12 (BY)',
				'Higher Education (BY)',
			),
			'Belgium' => array(
				'Secondary Education (BE)',
				'2nd Secondary (BE)',
				'3rd Secondary (BE)',
				'4th Secondary (BE)',
				'5th Secondary (BE)',
				'6th Secondary (BE)',
				'Higher Education (BE)',
			),
			'Bolivia' => array(
				'Lower Secondary Education (BO)',
				'8th Grade (BO)',
				'Upper Secondary Education (BO)',
				'9th Grade (BO)',
				'10th Grade (BO)',
				'11th Grade (BO)',
				'12th Grade (BO)',
				'Higher Education (BO)',
			),
			'Bosnia and Herzegovina' => array(
				'Primary Education (BA)',
				'Grade 8 (BA)',
				'Grade 9 (BA)',
				'Secondary Education (BA)',
				'Grade 10 (BA)',
				'Grade 11 (BA)',
				'Grade 12 (BA)',
				'Grade 13 (BA)',
				'Tertiary Education (BA)',
			),
			'Brazil' => array(
				'Elementary School (BR)',
				'8th Grade (BR)',
				'High School (BR)',
				'1st Grade (High School) (BR)',
				'2nd Grade (High School) (BR)',
				'3rd Grade (High School) (BR)',
				'Higher Education (BR)',
			),
			'Bulgaria' => array(
				'Secondary Education (BG)',
				'10th Grade (BG)',
				'11th Grade (BG)',
				'12th Grade (BG)',
				'Higher Education (BG)',
			),
			'Canada' => array(
				'Intermediate Education (CA)',
				'Grade 8 (CA)',
				'Grade 9 (CA)',
				'Secondary Education (CA)',
				'Grade 10 (CA)',
				'Grade 11 (CA)',
				'Grade 12 (CA)',
				'Tertiary Education (CA)',
			),
			'Chile' => array(
				'Secondary Education (CL)',
				'9th Grade (CL)',
				'10th Grade (CL)',
				'11th Grade (CL)',
				'12th Grade (CL)',
				'Higher Education (CL)',
			),
			'Colombia' => array(
				'Basic Secondary (CO)',
				'9th Grade (CO)',
				'High School Education (CO)',
				'10th Grade (CO)',
				'11th Grade (CO)',
				'Tertiary (CO)',
			),
			'Costa Rica' => array(
				'Secondary Education (CR)',
				'Eighth Grade (CR)',
				'Ninth Grade (CR)',
				'Tenth Grade (CR)',
				'Eleventh Grade (CR)',
				'Twelfth Grade (CR)',
				'Higher Education (CR)',
			),
			'Croatia' => array(
				'Secondary Education (HR)',
				'10th Grade (HR)',
				'11th Grade (HR)',
				'12th Grade (HR)',
				'Higher Education (HR)',
			),
			'Cyprus' => array(
				'Secondary Education (CY)',
				'Grade 9 (CY)',
				'Grade 10 (CY)',
				'Grade 11 (CY)',
				'Grade 12 (CY)',
				'Higher Education (CY)',
			),
			'Czechia' => array(
				'Upper Secondary Education (CZ)',
				'Grade 10 (CZ)',
				'Grade 11 (CZ)',
				'Grade 12 (CZ)',
				'Higher Education (CZ)',
			),
			'Denmark' => array(
				'Secondary Education (DK)',
				'8th Grade (DK)',
				'9th Grade (DK)',
				'10th Grade (DK)',
				'Upper Secondary Education (DK)',
				'11th Grade (DK)',
				'12th Grade (DK)',
				'Higher Education (DK)',
			),
			'Dominican Republic' => array(
				'Primary School (DO)',
				'Grade 8 (DO)',
				'Secondary School (DO)',
				'Grade 1 (Secondary School) (DO)',
				'Grade 2 (Secondary School) (DO)',
				'Grade 3 (Secondary School) (DO)',
				'Grade 4 (Secondary School) (DO)',
				'Higher Education (DO)',
				'Doctorate (DO)',
			),
			'Ecuador' => array(
				'Secondary (EC)',
				'Eighth Grade (EC)',
				'Ninth Grade (EC)',
				'Tenth Grade (EC)',
				'Eleventh Grade (EC)',
				'Twelfth Grade (EC)',
				'Tertiary Education (EC)',
			),
			'Egypt' => array(
				'Preparatory Stage (EG)',
				'Grade 8 (EG)',
				'Grade 9 (EG)',
				'Secondary Education (EG)',
				'Grade 10 (EG)',
				'Grade 11 (EG)',
				'Grade 12 (EG)',
				'Higher Education (EG)',
			),
			'El Salvador' => array(
				'3rd Cycle (SV)',
				'7th Grade (SV)',
				'8th Grade (SV)',
				'9th Grade (SV)',
				'Middle Education (SV)',
				'10th Grade (SV)',
				'11th Grade (SV)',
				'Higher Education (SV)',
			),
			'England' => array(
				'Key Stage 3 (GB-ENG)',
				'Year 9 (GB-ENG)',
				'Key Stage 4 (GB-ENG)',
				'Year 10 (GB-ENG)',
				'Year 11 (GB-ENG)',
				'Key Stage 5 (GB-ENG)',
				'Year 12 (GB-ENG)',
				'Year 13 (GB-ENG)',
				'Higher Education (GB-ENG)',
			),
			'Estonia' => array(
				'Basic Education (EE)',
				'7th Grade (EE)',
				'8th Grade (EE)',
				'9th Grade (EE)',
				'Secondary Education (EE)',
				'10th Grade (EE)',
				'11th Grade (EE)',
				'12th Grade (EE)',
				'Higher Education (EE)',
			),
			'Finland' => array(
				'Basic Education (FI)',
				'7th Grade (FI)',
				'8th Grade (FI)',
				'9th Grade (FI)',
				'Upper Secondary Education (FI)',
				'10th Grade (FI)',
				'11th Grade (FI)',
				'12th Grade (FI)',
				'Higher Education (FI)',
			),
			'France' => array(
				'Lycée (FR)',
				'Seconde (FR)',
				'Première (FR)',
				'Terminale (FR)',
			),
			'Georgia' => array(
				'Basic Education (GE)',
				'Grade 8 (GE)',
				'Grade 9 (GE)',
				'Secondary Education (GE)',
				'Grade 10 (GE)',
				'Grade 11 (GE)',
				'Grade 12 (GE)',
				'Tertiary Education (GE)',
			),
			'Germany' => array(
				'Gymnasium (DE)',
				'11th Grade (Gymnasium) (DE)',
				'12th Grade (Gymnasium) (DE)',
				'13th Grade (Gymnasium) (DE)',
				'University (DE)',
			),
			'Ghana' => array(
				'Junior Secondary School (GH)',
				'Grade 8 (GH)',
				'Grade 9 (GH)',
				'Senior Secondary School (GH)',
				'Grade 10 (GH)',
				'Grade 11 (GH)',
				'Grade 12 (GH)',
				'Higher Education (GH)',
			),
			'Greece' => array(
				'Upper Secondary School (GR)',
				'1st Grade (Lyceum) (GR)',
				'2nd Grade (Lyceum) (GR)',
				'3rd Grade (Lyceum) (GR)',
				'Tertiary Education (GR)',
			),
			'Guatemala' => array(
				'Lower Secondary (GT)',
				'Grade 7 (GT)',
				'Grade 8 (GT)',
				'Grade 9 (GT)',
				'Upper Secondary (GT)',
				'Grade 10 (GT)',
				'Grade 11 (GT)',
				'Grade 12 (GT)',
				'Higher Education (GT)',
			),
			'Honduras' => array(
				'Lower Secondary Education (HN)',
				'8th Grade (HN)',
				'9th Grade (HN)',
				'Upper Secondary Education (HN)',
				'10th Grade (HN)',
				'11th Grade (HN)',
				'12th Grade (HN)',
				'Tertiary Education (HN)',
			),
			'Hong Kong' => array(
				'Junior Secondary (HK)',
				'Secondary 2 (HK)',
				'Secondary 3 (HK)',
				'Senior Secondary (HK)',
				'Secondary 4 (HK)',
				'Secondary 5 (HK)',
				'Secondary 6 (HK)',
				'University (HK)',
			),
			'Hungary' => array(
				'Upper Secondary Education (HU)',
				'11th Grade (HU)',
				'12th Grade (HU)',
				'13th Grade (HU)',
				'Higher Education (HU)',
			),
			'Iceland' => array(
				'Primary Education (IS)',
				'Grade 8 (IS)',
				'Grade 9 (IS)',
				'Grade 10 (IS)',
				'Upper Secondary Education (IS)',
				'11th Grade (IS)',
				'12th Grade (IS)',
				'13th Grade (IS)',
				'Higher Education (IS)',
			),
			'India' => array(
				'Middle Stage (IN)',
				'Class 8 (IN)',
				'Secondary School (IN)',
				'Class 9 (IN)',
				'Class 10 (IN)',
				'Senior Secondary School (IN)',
				'Class 11 (IN)',
				'Class 12 (IN)',
				'Undergraduate College (IN)',
				'Post-Graduate College (IN)',
			),
			'Indonesia' => array(
				'Middle School (ID)',
				'8th Grade (ID)',
				'9th Grade (ID)',
				'High School (ID)',
				'10th Grade (ID)',
				'11th Grade (ID)',
				'12th Grade (ID)',
				'Tertiary Education (ID)',
			),
			'Iraq' => array(
				'Intermediate Education (IQ)',
				'Eighth Grade (IQ)',
				'Ninth Grade (IQ)',
				'Preparatory Education (IQ)',
				'Tenth Grade (IQ)',
				'Eleventh Grade (IQ)',
				'Twelfth Grade (IQ)',
				'Higher Education (IQ)',
			),
			'Ireland' => array(
				'Senior Cycle (IE)',
				'Transition Year (IE)',
				'Fifth Year (IE)',
				'Sixth Year (IE)',
				'University (IE)',
			),
			'Israel' => array(
				'Intermediate School (IL)',
				'Grade 8 (IL)',
				'Grade 9 (IL)',
				'Secondary School (IL)',
				'Grade 10 (IL)',
				'Grade 11 (IL)',
				'Grade 12 (IL)',
				'University (IL)',
				'Doctorate (IL)',
			),
			'Italy' => array(
				'Upper Secondary Education (IT)',
				'2nd Upper (IT)',
				'3rd Upper (IT)',
				'4th Upper (IT)',
				'5th Upper (IT)',
				'Higher Education (IT)',
			),
			'Jamaica' => array(
				'Secondary Education (JM)',
				'Grade 8 (JM)',
				'Grade 9 (JM)',
				'Grade 10 (JM)',
				'Grade 11 (JM)',
				'Grade 12 (JM)',
				'Tertiary Education (JM)',
			),
			'Japan' => array(
				'Lower Secondary School (JP)',
				'Grade 2 (Lower Secondary) (JP)',
				'Grade 3 (Lower Secondary) (JP)',
				'Upper Secondary School (JP)',
				'Grade 1 (Upper Secondary) (JP)',
				'Grade 2 (Upper Secondary) (JP)',
				'Grade 3 (Upper Secondary) (JP)',
				'Higher Education (JP)',
			),
			'Jordan' => array(
				'Basic Education (JO)',
				'Grade 8 (JO)',
				'Grade 9 (JO)',
				'Grade 10 (JO)',
				'Secondary Education (JO)',
				'Grade 11 (JO)',
				'Grade 12 (JO)',
				'Higher Education (JO)',
				'Doctorate (JO)',
			),
			'Kazakhstan' => array(
				'Lower Secondary School (KZ)',
				'Grade 7 (KZ)',
				'Grade 8 (KZ)',
				'Grade 9 (KZ)',
				'Upper Secondary School (KZ)',
				'Grade 10 (KZ)',
				'Grade 11 (KZ)',
				'Tertiary Institutions (KZ)',
			),
			'Kenya' => array(
				'Upper Primary (KE)',
				'Standard 8 (KE)',
				'High School (KE)',
				'Standard 9 (KE)',
				'Standard 10 (KE)',
				'Standard 11 (KE)',
				'Standard 12 (KE)',
				'Higher Education (KE)',
			),
			'Kuwait' => array(
				'Intermediate Education (KW)',
				'Grade 8 (KW)',
				'Grade 9 (KW)',
				'Secondary Education (KW)',
				'Grade 10 (KW)',
				'Grade 11 (KW)',
				'Grade 12 (KW)',
				'Higher Education (KW)',
			),
			'Latvia' => array(
				'Primary Education (LV)',
				'Grade 7 (LV)',
				'Grade 8 (LV)',
				'Senior Secondary Education (LV)',
				'Grade 10 (LV)',
				'Grade 11 (LV)',
				'Grade 12 (LV)',
				'Higher Education (LV)',
			),
			'Lebanon' => array(
				'Intermediate Level (LB)',
				'Grade 8 (LB)',
				'Grade 9 (LB)',
				'Secondary Education (LB)',
				'Grade 10 (LB)',
				'Grade 11 (LB)',
				'Grade 12 (LB)',
				'Tertiary Education (LB)',
			),
			'Libya' => array(
				'Primary Education (LY)',
				'Grade 8 (LY)',
				'Grade 9 (LY)',
				'Secondary Education (LY)',
				'Grade 10 (LY)',
				'Grade 11 (LY)',
				'Grade 12 (LY)',
				'Tertiary Education (LY)',
			),
			'Liechtenstein' => array(
				'Middle School (LI)',
				'7th Grade (LI)',
				'8th Grade (LI)',
				'9th Grade (LI)',
				'High School (LI)',
				'10th Grade (LI)',
				'11th Grade (LI)',
				'12th Grade (LI)',
				'Tertiary Education (LI)',
			),
			'Lithuania' => array(
				'Lower Secondary Education (LT)',
				'Grade 8 (LT)',
				'Grade 9 (LT)',
				'Grade 10 (LT)',
				'Upper Secondary Education (LT)',
				'Grade 11 (LT)',
				'Grade 12 (LT)',
				'Higher Education (LT)',
			),
			'Luxembourg' => array(
				'Upper Secondary Education (LU)',
				'3 G (LU)',
				'2 G (LU)',
				'1 G (LU)',
				'Higher Education (LU)',
			),
			'Malaysia' => array(
				'Secondary (MY)',
				'Form 2 (MY)',
				'Form 3 (MY)',
				'Form 4 (MY)',
				'Form 5 (MY)',
				'Pre-University (MY)',
				'Lower Form 6 (MY)',
				'Upper Form 6 (MY)',
				'Post-Secondary Education (MY)',
			),
			'Malta' => array(
				'Secondary Education (MT)',
				'Grade 9 (MT)',
				'Grade 10 (MT)',
				'Grade 11 (MT)',
				'Post-Secondary Education (MT)',
				'Tertiary Education (MT)',
				'Postgraduate Education (MT)',
			),
			'Mexico' => array(
				'Lower Secondary Education (MX)',
				'Grade 8 (MX)',
				'Grade 9 (MX)',
				'Upper Secondary Education (MX)',
				'Grade 10 (MX)',
				'Grade 11 (MX)',
				'Grade 12 (MX)',
				'Tertiary Education (MX)',
			),
			'Montenegro' => array(
				'Primary Education (ME)',
				'Grade 8 (ME)',
				'Grade 9 (ME)',
				'Secondary Education (ME)',
				'Grade 10 (ME)',
				'Grade 11 (ME)',
				'Grade 12 (ME)',
				'Grade 13 (ME)',
				'Higher Education (ME)',
			),
			'Morocco' => array(
				'Lower Secondary (MA)',
				'Grade 8 (MA)',
				'Grade 9 (MA)',
				'Upper Secondary (MA)',
				'Grade 10 (MA)',
				'Grade 11 (MA)',
				'Grade 12 (MA)',
				'Tertiary (MA)',
			),
			'Nepal' => array(
				'Secondary (NP)',
				'Year 9 (NP)',
				'Year 10 (NP)',
				'Senior Higher Secondary (NP)',
				'Year 11 (NP)',
				'Year 12 (NP)',
			),
			'Netherlands' => array(
				'Secondary Education (NL)',
				'5th Year (HAVO) (NL)',
				'Higher Education (NL)',
			),
			'New Zealand' => array(
				'Year 9-13 Secondary School (NZ)',
				'Year 9 (NZ)',
				'Year 10 (NZ)',
				'Year 11 (NZ)',
				'Year 12 (NZ)',
				'Year 13 (NZ)',
				'University (NZ)',
				'Doctorate (NZ)',
			),
			'Nicaragua' => array(
				'Lower Secondary Education (NI)',
				'Grade 8 (NI)',
				'Grade 9 (NI)',
				'Higher Secondary Education (NI)',
				'Grade 10 (NI)',
				'Grade 11 (NI)',
				'Tertiary Education (NI)',
			),
			'Nigeria' => array(
				'Junior Secondary Education (NG)',
				'Grade 8 (NG)',
				'Grade 9 (NG)',
				'Senior Secondary Education (NG)',
				'Grade 10 (NG)',
				'Grade 11 (NG)',
				'Grade 12 (NG)',
				'University (NG)',
				'Doctorate (NG)',
			),
			'North Macedonia' => array(
				'Primary Education (MK)',
				'Grade 7 (MK)',
				'Grade 8 (MK)',
				'Secondary Education (MK)',
				'Grade 9 (MK)',
				'Grade 10 (MK)',
				'Grade 11 (MK)',
				'Grade 12 (MK)',
				'Higher Education (MK)',
			),
			'Northern Ireland' => array(
				'Key Stage 3 (GB-NIR)',
				'Year 10 (GB-NIR)',
				'Key Stage 4 (GB-NIR)',
				'Year 11 (GB-NIR)',
				'Year 12 (GB-NIR)',
				'Key Stage 5 (GB-NIR)',
				'Higher Education (GB-NIR)',
			),
			'Norway' => array(
				'Lower Secondary School (NO)',
				'8th Grade (NO)',
				'9th Grade (NO)',
				'10th Grade (NO)',
				'Upper Secondary School (NO)',
				'VG1 (NO)',
				'VG2 (NO)',
				'VG3 (NO)',
				'Higher Education (NO)',
			),
			'Oman' => array(
				'Basic Education (OM)',
				'Grade 8 (OM)',
				'Grade 9 (OM)',
				'Grade 10 (OM)',
				'Secondary Education (OM)',
				'Grade 11 (OM)',
				'Grade 12 (OM)',
				'Higher Education (OM)',
				'Doctorate (OM)',
			),
			'Pakistan' => array(
				'Middle School (PK)',
				'Class 8 (PK)',
				'High School (PK)',
				'Class 9 (PK)',
				'Class 10 (PK)',
				'Higher Secondary School (PK)',
				'Class 11 (PK)',
				'Class 12 (PK)',
				'University (PK)',
			),
			'Panama' => array(
				'First Step of Secondary Level (PA)',
				'Grade Eight (PA)',
				'Grade Nine (PA)',
				'Second Step of Secondary Level (PA)',
				'Grade Ten (PA)',
				'Grade Eleven (PA)',
				'Grade Twelve (PA)',
				'Higher Education (PA)',
			),
			'Papua New Guinea' => array(
				'Middle (PG)',
				'Grade 7 (PG)',
				'Grade 8 (PG)',
				'Grade 9 (PG)',
				'Grade 10 (PG)',
				'Secondary (PG)',
				'Grade 11 (PG)',
				'Grade 12 (PG)',
				'Tertiary (PG)',
			),
			'Paraguay' => array(
				'Primary Education (PY)',
				'8th Grade (PY)',
				'9th Grade (PY)',
				'Upper Secondary Education (PY)',
				'10th Grade (PY)',
				'11th Grade (PY)',
				'12th Grade (PY)',
				'Tertiary Education (PY)',
			),
			'Peru' => array(
				'Secondary School (PE)',
				'9th Grade (PE)',
				'10th Grade (PE)',
				'11th Grade (PE)',
				'Higher Education (PE)',
			),
			'Philippines' => array(
				'Junior High School (PH)',
				'Grade 8 (PH)',
				'Grade 9 (PH)',
				'Grade 10 (PH)',
				'Senior High School (PH)',
				'Grade 11 (PH)',
				'Grade 12 (PH)',
				'Tertiary Education (PH)',
			),
			'Poland' => array(
				'Upper Secondary Education (PL)',
				'Grade 2 (High School) (PL)',
				'Grade 3 (High School) (PL)',
				'Grade 4 (High School) (PL)',
				'Higher Education (PL)',
			),
			'Portugal' => array(
				'Basic Education (PT)',
				'8th Year (PT)',
				'9th Year (PT)',
				'Secondary Education (PT)',
				'10th Year (PT)',
				'11th Year (PT)',
				'12th Year (PT)',
				'Tertiary Education (PT)',
			),
			'Puerto Rico' => array(
				'Junior High School (PR)',
				'Eighth Grade (PR)',
				'Ninth Grade (PR)',
				'High School (PR)',
				'Tenth Grade (PR)',
				'Eleventh Grade (PR)',
				'Twelfth Grade (PR)',
				'Higher Education (PR)',
			),
			'Qatar' => array(
				'Preparatory Education (QA)',
				'Grade 8 (QA)',
				'Grade 9 (QA)',
				'Secondary Education (QA)',
				'Grade 10 (QA)',
				'Grade 11 (QA)',
				'Grade 12 (QA)',
				'University (QA)',
				'Doctorate (QA)',
			),
			'Romania' => array(
				'Secondary School (RO)',
				'Class X (RO)',
				'Class XI (RO)',
				'Class XII (RO)',
				'Higher Education (RO)',
			),
			'Russia' => array(
				'Basic General Education (RU)',
				'Eighth Grade (RU)',
				'Ninth Grade (RU)',
				'Secondary General Education (RU)',
				'Tenth Grade (RU)',
				'Eleventh Grade (RU)',
				'Postsecondary and Tertiary Education (RU)',
			),
			'Saudi Arabia' => array(
				'Intermediate Education (SA)',
				'Grade 8 (SA)',
				'Grade 9 (SA)',
				'Secondary Education (SA)',
				'Grade 10 (SA)',
				'Grade 11 (SA)',
				'Grade 12 (SA)',
				'Tertiary Education (SA)',
			),
			'Scotland' => array(
				'Secondary School (GB-SCT)',
				'Second Year (S2) (GB-SCT)',
				'Third Year (S3) (GB-SCT)',
				'Fourth Year (S4) (GB-SCT)',
				'Fifth Year (S5) (GB-SCT)',
				'Higher Education (GB-SCT)',
				'Doctorate (GB-SCT)',
			),
			'Senegal' => array(
				'Lower Secondary Education (SN)',
				'Grade 8 (SN)',
				'Grade 9 (SN)',
				'Grade 10 (SN)',
				'Upper Secondary Education (SN)',
				'Grade 11 (SN)',
				'Grade 12 (SN)',
				'Grade 13 (SN)',
				'Tertiary Education (SN)',
			),
			'Serbia' => array(
				'Secondary-High School (RS)',
				'Year 2 (RS)',
				'Year 3 (RS)',
				'Year 4 (RS)',
				'Higher Education (RS)',
			),
			'Singapore' => array(
				'Secondary Education (SG)',
				'Secondary 1 (SG)',
				'Secondary 2 (SG)',
				'Secondary 3 (SG)',
				'Secondary 4 (SG)',
				'Secondary 5 (SG)',
				'Post-Secondary Education (SG)',
			),
			'Slovakia' => array(
				'High School (SK)',
				'2nd Grade (High School) (SK)',
				'3rd Grade (High School) (SK)',
				'4th Grade (High School) (SK)',
				'Post-Secondary Education (SK)',
			),
			'Slovenia' => array(
				'Upper Secondary Education (SI)',
				'Grade 11 (SI)',
				'Grade 12 (SI)',
				'Grade 13 (SI)',
				'Tertiary Education (SI)',
			),
			'South Africa' => array(
				'Senior Phase (ZA)',
				'Grade 8 (ZA)',
				'Grade 9 (ZA)',
				'Further Education and Training (ZA)',
				'Grade 10 (ZA)',
				'Grade 11 (ZA)',
				'Grade 12 (ZA)',
				'Higher Education and Training (ZA)',
			),
			'South Korea' => array(
				'Middle School (KR)',
				'3rd Grade (KR)',
				'High School (KR)',
				'1st Grade (KR)',
				'2nd Grade (KR)',
				'3rd Grade (KR)',
				'Higher Education (KR)',
			),
			'Spain' => array(
				'Lower Secondary Education (ES)',
				'Grade 9 (ES)',
				'Grade 10 (ES)',
				'Upper Secondary Education (ES)',
				'Grade 11 (ES)',
				'Grade 12 (ES)',
				'Tertiary education (ES)',
			),
			'Sri Lanka' => array(
				'Junior Secondary (LK)',
				'Grade 9 (LK)',
				'Senior Secondary (LK)',
				'Grade 10 (LK)',
				'Grade 11 (LK)',
				'Collegiate (LK)',
				'Grade 12 (LK)',
				'Grade 13 (LK)',
				'Tertiary Education (LK)',
			),
			'Sweden' => array(
				'Comprehensive School (SE)',
				'7th Grade (SE)',
				'8th Grade (SE)',
				'9th Grade (SE)',
				'Upper Secondary Education (SE)',
				'1st Grade (SE)',
				'2nd Grade (SE)',
				'3rd Grade (SE)',
				'University (SE)',
			),
			'Switzerland' => array(
				'Lower Secondary Level (CH)',
				'Grade 8 (CH)',
				'Grade 9 (CH)',
				'Upper Secondary Level (CH)',
				'Grade-1 (CH)',
				'Grade-2 (CH)',
				'Grade-3 (CH)',
				'Tertiary Level (CH)',
			),
			'Taiwan' => array(
				'Junior High School (TW)',
				'8th Grade (TW)',
				'9th Grade (TW)',
				'Senior High School (TW)',
				'10th Grade (TW)',
				'11th Grade (TW)',
				'12th Grade (TW)',
				'Tertiary Education (TW)',
			),
			'Tanzania' => array(
				'Primary Education (TZ)',
				'Grade 7 (TZ)',
				'Lower Secondary (TZ)',
				'Grade 8 (TZ)',
				'Grade 9 (TZ)',
				'Grade 10 (TZ)',
				'Grade 11 (TZ)',
				'Grade 12 (TZ)',
				'Upper Secondary (TZ)',
				'University (TZ)',
				'Doctorate (TZ)',
			),
			'Thailand' => array(
				'Lower Secondary (TH)',
				'Eighth Grade (TH)',
				'Ninth Grade (TH)',
				'Upper Secondary (TH)',
				'Tenth Grade (TH)',
				'Eleventh Grade (TH)',
				'Twelfth Grade (TH)',
				'Higher Education (TH)',
			),
			'Tunisia' => array(
				'Basic Education (TN)',
				'Eighth Grade (TN)',
				'Ninth Grade (TN)',
				'Secondary Education (TN)',
				'Tenth Grade (TN)',
				'Eleventh Grade (TN)',
				'Twelfth Grade (TN)',
				'Tertiary Education (TN)',
			),
			'Türkiye' => array(
				'Primary Education (TR)',
				'8th Grade (TR)',
				'High School (TR)',
				'9th Grade (TR)',
				'10th Grade (TR)',
				'11th Grade (TR)',
				'12th Grade (TR)',
				'Higher Education (TR)',
			),
			'Uganda' => array(
				'Lower Secondary Education (UG)',
				'Eighth Grade (UG)',
				'Ninth Grade (UG)',
				'Tenth Grade (UG)',
				'Eleventh Grade (UG)',
				'Upper Secondary Education (UG)',
				'Twelfth Grade (UG)',
				'Thirteenth Grade (UG)',
				'Post-Secondary Education (UG)',
			),
			'Ukraine' => array(
				'Secondary Base School (UA)',
				'8th Grade (UA)',
				'9th Grade (UA)',
				'Secondary Last School (UA)',
				'10th Grade (UA)',
				'11th Grade (UA)',
				'12th Grade (UA)',
				'Higher Education (UA)',
			),
			'United Arab Emirates' => array(
				'Intermediate Level (AE)',
				'Grade 8 (AE)',
				'Secondary Level (AE)',
				'Grade 9 (AE)',
				'Grade 10 (AE)',
				'Grade 11 (AE)',
				'Grade 12 (AE)',
				'Higher Education (AE)',
			),
			'United States' => array(
				'Middle School (US)',
				'Eighth Grade (US)',
				'High School (US)',
				'Ninth Grade (US)',
				'Tenth Grade (US)',
				'Eleventh Grade (US)',
				'Twelfth Grade (US)',
				'College (US)',
				'Graduate School (US)',
			),
			'Venezuela' => array(
				'Middle Education (VE)',
				'Grade 9 (VE)',
				'Diversified Education (VE)',
				'Grade 10 (VE)',
				'Grade 11 (VE)',
				'Grade 12 (VE)',
				'Higher Education School (VE)',
			),
			'Vietnam' => array(
				'Upper Secondary Education (VN)',
				'Tenth Grade (VN)',
				'Eleventh Grade (VN)',
				'Twelfth Grade (VN)',
				'Higher Education (VN)',
			),
			'Wales' => array(
				'Key Stage 4 (GB-WLS)',
				'Year 10 (GB-WLS)',
				'Year 11 (GB-WLS)',
				'Key Stage 5 (GB-WLS)',
				'Year 12 (GB-WLS)',
				'Year 13 (GB-WLS)',
				'Higher Education (GB-WLS)',
			),
			'Yemen' => array(
				'Basic Education (YE)',
				'Grade 8 (YE)',
				'Grade 9 (YE)',
				'Secondary Education (YE)',
				'Grade 10 (YE)',
				'Grade 11 (YE)',
				'Grade 12 (YE)',
				'University Education (YE)',
			),
			'Zimbabwe' => array(
				'Secondary Education (ZW)',
				'Grade 8 (ZW)',
				'Grade 9 (ZW)',
				'Grade 10 (ZW)',
				'Grade 11 (ZW)',
				'Grade 12 (ZW)',
				'Grade 13 (ZW)',
				'Tertiary Education (ZW)',
			),
		);

		public static function get( $key = false ) {

			$levels = array();

			foreach ( self::$levels as $country => $arr ) {

				$grades = array();

				foreach ( $arr as $num => $value ) {

					$grades[ $value ] = preg_replace( '/ \([A-Z\-]+\)$/', '', $value );
				}

				$levels[ $country ] = $grades;
			}

			if ( false !== $key ) {

				if ( ! isset( $levels[ $key ] ) ) {

					return $levels[ 'Generic' ];
				}

				return $levels[ $key ];
			}

			return $levels;
		}
	}
}
