;; Tests for i64x2 arithmetic operations on major boundary values and all special values.


(module
  (func (export "i64x2.extmul_low_i32x4_s") (param v128 v128) (result v128) (i64x2.extmul_low_i32x4_s (local.get 0) (local.get 1)))
  (func (export "i64x2.extmul_high_i32x4_s") (param v128 v128) (result v128) (i64x2.extmul_high_i32x4_s (local.get 0) (local.get 1)))
  (func (export "i64x2.extmul_low_i32x4_u") (param v128 v128) (result v128) (i64x2.extmul_low_i32x4_u (local.get 0) (local.get 1)))
  (func (export "i64x2.extmul_high_i32x4_u") (param v128 v128) (result v128) (i64x2.extmul_high_i32x4_u (local.get 0) (local.get 1)))
)


;; i64x2.extmul_low_i32x4_s
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 0 0 0 0)
                                                  (v128.const i32x4 0 0 0 0))
                                                  (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 0 0 0 0)
                                                  (v128.const i32x4 1 1 1 1))
                                                  (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 1 1 1 1)
                                                  (v128.const i32x4 1 1 1 1))
                                                  (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 0 0 0 0)
                                                  (v128.const i32x4 -1 -1 -1 -1))
                                                  (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 1 1 1 1)
                                                  (v128.const i32x4 -1 -1 -1 -1))
                                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 -1 -1 -1 -1)
                                                  (v128.const i32x4 -1 -1 -1 -1))
                                                  (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 1073741823 1073741823 1073741823 1073741823)
                                                  (v128.const i32x4 1073741824 1073741824 1073741824 1073741824))
                                                  (v128.const i64x2 1152921503533105152 1152921503533105152))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 1073741824 1073741824 1073741824 1073741824)
                                                  (v128.const i32x4 1073741824 1073741824 1073741824 1073741824))
                                                  (v128.const i64x2 1152921504606846976 1152921504606846976))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 -1073741823 -1073741823 -1073741823 -1073741823)
                                                  (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
                                                  (v128.const i64x2 1152921503533105152 1152921503533105152))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824)
                                                  (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
                                                  (v128.const i64x2 1152921504606846976 1152921504606846976))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 -1073741825 -1073741825 -1073741825 -1073741825)
                                                  (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
                                                  (v128.const i64x2 1152921505680588800 1152921505680588800))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 2147483645 2147483645 2147483645 2147483645)
                                                  (v128.const i32x4 1 1 1 1))
                                                  (v128.const i64x2 2147483645 2147483645))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 2147483646 2147483646 2147483646 2147483646)
                                                  (v128.const i32x4 1 1 1 1))
                                                  (v128.const i64x2 2147483646 2147483646))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 2147483648 2147483648 2147483648 2147483648)
                                                  (v128.const i32x4 1 1 1 1))
                                                  (v128.const i64x2 -2147483648 -2147483648))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 -2147483646 -2147483646 -2147483646 -2147483646)
                                                  (v128.const i32x4 -1 -1 -1 -1))
                                                  (v128.const i64x2 2147483646 2147483646))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647)
                                                  (v128.const i32x4 -1 -1 -1 -1))
                                                  (v128.const i64x2 2147483647 2147483647))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648)
                                                  (v128.const i32x4 -1 -1 -1 -1))
                                                  (v128.const i64x2 2147483648 2147483648))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 2147483647 2147483647 2147483647 2147483647)
                                                  (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
                                                  (v128.const i64x2 4611686014132420609 4611686014132420609))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648)
                                                  (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
                                                  (v128.const i64x2 4611686018427387904 4611686018427387904))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648)
                                                  (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647))
                                                  (v128.const i64x2 4611686016279904256 4611686016279904256))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                  (v128.const i32x4 0 0 0 0))
                                                  (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                  (v128.const i32x4 1 1 1 1))
                                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                  (v128.const i32x4 -1 -1 -1 -1))
                                                  (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                  (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
                                                  (v128.const i64x2 -2147483647 -2147483647))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                  (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
                                                  (v128.const i64x2 2147483648 2147483648))
(assert_return (invoke "i64x2.extmul_low_i32x4_s" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                  (v128.const i32x4 4294967295 4294967295 4294967295 4294967295))
                                                  (v128.const i64x2 1 1))

;; i64x2.extmul_high_i32x4_s
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 0 0 0 0)
                                                   (v128.const i32x4 0 0 0 0))
                                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 0 0 0 0)
                                                   (v128.const i32x4 1 1 1 1))
                                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 1 1 1 1)
                                                   (v128.const i32x4 1 1 1 1))
                                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 0 0 0 0)
                                                   (v128.const i32x4 -1 -1 -1 -1))
                                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 1 1 1 1)
                                                   (v128.const i32x4 -1 -1 -1 -1))
                                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 -1 -1 -1 -1)
                                                   (v128.const i32x4 -1 -1 -1 -1))
                                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 1073741823 1073741823 1073741823 1073741823)
                                                   (v128.const i32x4 1073741824 1073741824 1073741824 1073741824))
                                                   (v128.const i64x2 1152921503533105152 1152921503533105152))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 1073741824 1073741824 1073741824 1073741824)
                                                   (v128.const i32x4 1073741824 1073741824 1073741824 1073741824))
                                                   (v128.const i64x2 1152921504606846976 1152921504606846976))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 -1073741823 -1073741823 -1073741823 -1073741823)
                                                   (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
                                                   (v128.const i64x2 1152921503533105152 1152921503533105152))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824)
                                                   (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
                                                   (v128.const i64x2 1152921504606846976 1152921504606846976))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 -1073741825 -1073741825 -1073741825 -1073741825)
                                                   (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
                                                   (v128.const i64x2 1152921505680588800 1152921505680588800))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 2147483645 2147483645 2147483645 2147483645)
                                                   (v128.const i32x4 1 1 1 1))
                                                   (v128.const i64x2 2147483645 2147483645))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 2147483646 2147483646 2147483646 2147483646)
                                                   (v128.const i32x4 1 1 1 1))
                                                   (v128.const i64x2 2147483646 2147483646))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 2147483648 2147483648 2147483648 2147483648)
                                                   (v128.const i32x4 1 1 1 1))
                                                   (v128.const i64x2 -2147483648 -2147483648))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 -2147483646 -2147483646 -2147483646 -2147483646)
                                                   (v128.const i32x4 -1 -1 -1 -1))
                                                   (v128.const i64x2 2147483646 2147483646))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647)
                                                   (v128.const i32x4 -1 -1 -1 -1))
                                                   (v128.const i64x2 2147483647 2147483647))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648)
                                                   (v128.const i32x4 -1 -1 -1 -1))
                                                   (v128.const i64x2 2147483648 2147483648))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 2147483647 2147483647 2147483647 2147483647)
                                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
                                                   (v128.const i64x2 4611686014132420609 4611686014132420609))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648)
                                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
                                                   (v128.const i64x2 4611686018427387904 4611686018427387904))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648)
                                                   (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647))
                                                   (v128.const i64x2 4611686016279904256 4611686016279904256))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                   (v128.const i32x4 0 0 0 0))
                                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                   (v128.const i32x4 1 1 1 1))
                                                   (v128.const i64x2 -1 -1))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                   (v128.const i32x4 -1 -1 -1 -1))
                                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
                                                   (v128.const i64x2 -2147483647 -2147483647))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
                                                   (v128.const i64x2 2147483648 2147483648))
(assert_return (invoke "i64x2.extmul_high_i32x4_s" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                   (v128.const i32x4 4294967295 4294967295 4294967295 4294967295))
                                                   (v128.const i64x2 1 1))

;; i64x2.extmul_low_i32x4_u
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 0 0 0 0)
                                                  (v128.const i32x4 0 0 0 0))
                                                  (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 0 0 0 0)
                                                  (v128.const i32x4 1 1 1 1))
                                                  (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 1 1 1 1)
                                                  (v128.const i32x4 1 1 1 1))
                                                  (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 0 0 0 0)
                                                  (v128.const i32x4 -1 -1 -1 -1))
                                                  (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 1 1 1 1)
                                                  (v128.const i32x4 -1 -1 -1 -1))
                                                  (v128.const i64x2 4294967295 4294967295))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 -1 -1 -1 -1)
                                                  (v128.const i32x4 -1 -1 -1 -1))
                                                  (v128.const i64x2 -8589934591 -8589934591))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 1073741823 1073741823 1073741823 1073741823)
                                                  (v128.const i32x4 1073741824 1073741824 1073741824 1073741824))
                                                  (v128.const i64x2 1152921503533105152 1152921503533105152))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 1073741824 1073741824 1073741824 1073741824)
                                                  (v128.const i32x4 1073741824 1073741824 1073741824 1073741824))
                                                  (v128.const i64x2 1152921504606846976 1152921504606846976))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 -1073741823 -1073741823 -1073741823 -1073741823)
                                                  (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
                                                  (v128.const i64x2 -8070450529026703360 -8070450529026703360))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824)
                                                  (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
                                                  (v128.const i64x2 -8070450532247928832 -8070450532247928832))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 -1073741825 -1073741825 -1073741825 -1073741825)
                                                  (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
                                                  (v128.const i64x2 -8070450535469154304 -8070450535469154304))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 2147483645 2147483645 2147483645 2147483645)
                                                  (v128.const i32x4 1 1 1 1))
                                                  (v128.const i64x2 2147483645 2147483645))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 2147483646 2147483646 2147483646 2147483646)
                                                  (v128.const i32x4 1 1 1 1))
                                                  (v128.const i64x2 2147483646 2147483646))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 2147483648 2147483648 2147483648 2147483648)
                                                  (v128.const i32x4 1 1 1 1))
                                                  (v128.const i64x2 2147483648 2147483648))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 -2147483646 -2147483646 -2147483646 -2147483646)
                                                  (v128.const i32x4 -1 -1 -1 -1))
                                                  (v128.const i64x2 -9223372030412324866 -9223372030412324866))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647)
                                                  (v128.const i32x4 -1 -1 -1 -1))
                                                  (v128.const i64x2 -9223372034707292161 -9223372034707292161))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648)
                                                  (v128.const i32x4 -1 -1 -1 -1))
                                                  (v128.const i64x2 9223372034707292160 9223372034707292160))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 2147483647 2147483647 2147483647 2147483647)
                                                  (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
                                                  (v128.const i64x2 4611686014132420609 4611686014132420609))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648)
                                                  (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
                                                  (v128.const i64x2 4611686018427387904 4611686018427387904))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648)
                                                  (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647))
                                                  (v128.const i64x2 4611686020574871552 4611686020574871552))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                  (v128.const i32x4 0 0 0 0))
                                                  (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                  (v128.const i32x4 1 1 1 1))
                                                  (v128.const i64x2 4294967295 4294967295))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                  (v128.const i32x4 -1 -1 -1 -1))
                                                  (v128.const i64x2 -8589934591 -8589934591))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                  (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
                                                  (v128.const i64x2 9223372030412324865 9223372030412324865))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                  (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
                                                  (v128.const i64x2 9223372034707292160 9223372034707292160))
(assert_return (invoke "i64x2.extmul_low_i32x4_u" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                  (v128.const i32x4 4294967295 4294967295 4294967295 4294967295))
                                                  (v128.const i64x2 -8589934591 -8589934591))

;; i64x2.extmul_high_i32x4_u
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 0 0 0 0)
                                                   (v128.const i32x4 0 0 0 0))
                                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 0 0 0 0)
                                                   (v128.const i32x4 1 1 1 1))
                                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 1 1 1 1)
                                                   (v128.const i32x4 1 1 1 1))
                                                   (v128.const i64x2 1 1))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 0 0 0 0)
                                                   (v128.const i32x4 -1 -1 -1 -1))
                                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 1 1 1 1)
                                                   (v128.const i32x4 -1 -1 -1 -1))
                                                   (v128.const i64x2 4294967295 4294967295))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 -1 -1 -1 -1)
                                                   (v128.const i32x4 -1 -1 -1 -1))
                                                   (v128.const i64x2 -8589934591 -8589934591))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 1073741823 1073741823 1073741823 1073741823)
                                                   (v128.const i32x4 1073741824 1073741824 1073741824 1073741824))
                                                   (v128.const i64x2 1152921503533105152 1152921503533105152))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 1073741824 1073741824 1073741824 1073741824)
                                                   (v128.const i32x4 1073741824 1073741824 1073741824 1073741824))
                                                   (v128.const i64x2 1152921504606846976 1152921504606846976))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 -1073741823 -1073741823 -1073741823 -1073741823)
                                                   (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
                                                   (v128.const i64x2 -8070450529026703360 -8070450529026703360))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824)
                                                   (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
                                                   (v128.const i64x2 -8070450532247928832 -8070450532247928832))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 -1073741825 -1073741825 -1073741825 -1073741825)
                                                   (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
                                                   (v128.const i64x2 -8070450535469154304 -8070450535469154304))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 2147483645 2147483645 2147483645 2147483645)
                                                   (v128.const i32x4 1 1 1 1))
                                                   (v128.const i64x2 2147483645 2147483645))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 2147483646 2147483646 2147483646 2147483646)
                                                   (v128.const i32x4 1 1 1 1))
                                                   (v128.const i64x2 2147483646 2147483646))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 2147483648 2147483648 2147483648 2147483648)
                                                   (v128.const i32x4 1 1 1 1))
                                                   (v128.const i64x2 2147483648 2147483648))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 -2147483646 -2147483646 -2147483646 -2147483646)
                                                   (v128.const i32x4 -1 -1 -1 -1))
                                                   (v128.const i64x2 -9223372030412324866 -9223372030412324866))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647)
                                                   (v128.const i32x4 -1 -1 -1 -1))
                                                   (v128.const i64x2 -9223372034707292161 -9223372034707292161))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648)
                                                   (v128.const i32x4 -1 -1 -1 -1))
                                                   (v128.const i64x2 9223372034707292160 9223372034707292160))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 2147483647 2147483647 2147483647 2147483647)
                                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
                                                   (v128.const i64x2 4611686014132420609 4611686014132420609))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648)
                                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
                                                   (v128.const i64x2 4611686018427387904 4611686018427387904))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648)
                                                   (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647))
                                                   (v128.const i64x2 4611686020574871552 4611686020574871552))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                   (v128.const i32x4 0 0 0 0))
                                                   (v128.const i64x2 0 0))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                   (v128.const i32x4 1 1 1 1))
                                                   (v128.const i64x2 4294967295 4294967295))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                   (v128.const i32x4 -1 -1 -1 -1))
                                                   (v128.const i64x2 -8589934591 -8589934591))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
                                                   (v128.const i64x2 9223372030412324865 9223372030412324865))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
                                                   (v128.const i64x2 9223372034707292160 9223372034707292160))
(assert_return (invoke "i64x2.extmul_high_i32x4_u" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                                   (v128.const i32x4 4294967295 4294967295 4294967295 4294967295))
                                                   (v128.const i64x2 -8589934591 -8589934591))

;; type check
(assert_invalid (module (func (result v128) (i64x2.extmul_low_i32x4_s (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i64x2.extmul_high_i32x4_s (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i64x2.extmul_low_i32x4_u (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i64x2.extmul_high_i32x4_u (i32.const 0) (f32.const 0.0)))) "type mismatch")

;; Test operation with empty argument

(assert_invalid
  (module
    (func $i64x2.extmul_low_i32x4_s-1st-arg-empty (result v128)
      (i64x2.extmul_low_i32x4_s (v128.const i64x2 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i64x2.extmul_low_i32x4_s-arg-empty (result v128)
      (i64x2.extmul_low_i32x4_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i64x2.extmul_high_i32x4_s-1st-arg-empty (result v128)
      (i64x2.extmul_high_i32x4_s (v128.const i64x2 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i64x2.extmul_high_i32x4_s-arg-empty (result v128)
      (i64x2.extmul_high_i32x4_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i64x2.extmul_low_i32x4_u-1st-arg-empty (result v128)
      (i64x2.extmul_low_i32x4_u (v128.const i64x2 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i64x2.extmul_low_i32x4_u-arg-empty (result v128)
      (i64x2.extmul_low_i32x4_u)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i64x2.extmul_high_i32x4_u-1st-arg-empty (result v128)
      (i64x2.extmul_high_i32x4_u (v128.const i64x2 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i64x2.extmul_high_i32x4_u-arg-empty (result v128)
      (i64x2.extmul_high_i32x4_u)
    )
  )
  "type mismatch"
)

