;; Test exact casts of types that do not involve custom descriptors.

;; Structs
(module
  (type $super (sub (struct)))
  (type $sub (sub $super (struct)))

  (global $super anyref (struct.new $super))
  (global $sub anyref (struct.new $sub))

  (func $super (result anyref) (struct.new $super))
  (func $sub (result anyref) (struct.new $sub))

  (func (export "self-nullable") (result anyref)
    (ref.cast (ref null (exact $super)) (struct.new $super))
  )
  (func (export "self-nullable-global") (result anyref)
    (ref.cast (ref null (exact $super)) (global.get $super))
  )
  (func (export "self-nullable-call") (result anyref)
    (ref.cast (ref null (exact $super)) (call $super))
  )
  (func (export "self-nullable-null") (result anyref)
    (ref.cast (ref null (exact $super)) (ref.null $super))
  )

  (func (export "self-nonnullable") (result anyref)
    (ref.cast (ref (exact $super)) (struct.new $super))
  )
  (func (export "self-nonnullable-global") (result anyref)
    (ref.cast (ref (exact $super)) (global.get $super))
  )
  (func (export "self-nonnullable-call") (result anyref)
    (ref.cast (ref (exact $super)) (call $super))
  )
  (func (export "self-nonnullable-null") (result anyref)
    (ref.cast (ref (exact $super)) (ref.null $super))
  )

  (func (export "sub-nullable") (result anyref)
    (ref.cast (ref null (exact $super)) (struct.new $sub))
  )
  (func (export "sub-nullable-global") (result anyref)
    (ref.cast (ref null (exact $super)) (global.get $sub))
  )
  (func (export "sub-nullable-call") (result anyref)
    (ref.cast (ref null (exact $super)) (call $sub))
  )
  (func (export "sub-nullable-null") (result anyref)
    (ref.cast (ref null (exact $super)) (ref.null $sub))
  )

  (func (export "sub-nonnullable") (result anyref)
    (ref.cast (ref (exact $super)) (struct.new $sub))
  )
  (func (export "sub-nonnullable-global") (result anyref)
    (ref.cast (ref (exact $super)) (global.get $sub))
  )
  (func (export "sub-nonnullable-call") (result anyref)
    (ref.cast (ref (exact $super)) (call $sub))
  )
  (func (export "sub-nonnullable-null") (result anyref)
    (ref.cast (ref (exact $super)) (ref.null $sub))
  )

  (func (export "super-nullable") (result anyref)
    (ref.cast (ref null (exact $sub)) (struct.new $super))
  )
  (func (export "super-nullable-global") (result anyref)
    (ref.cast (ref null (exact $sub)) (global.get $super))
  )
  (func (export "super-nullable-call") (result anyref)
    (ref.cast (ref null (exact $sub)) (call $super))
  )
  (func (export "super-nullable-null") (result anyref)
    (ref.cast (ref null (exact $sub)) (ref.null $super))
  )

  (func (export "super-nonnullable") (result anyref)
    (ref.cast (ref (exact $sub)) (struct.new $super))
  )
  (func (export "super-nonnullable-global") (result anyref)
    (ref.cast (ref (exact $sub)) (global.get $super))
  )
  (func (export "super-nonnullable-call") (result anyref)
    (ref.cast (ref (exact $sub)) (call $super))
  )
  (func (export "super-nonnullable-null") (result anyref)
    (ref.cast (ref (exact $sub)) (ref.null $super))
  )

  (func (export "yes-br-on-cast-val")
    (block (result anyref)
      (br_on_cast 0 anyref (ref (exact $super)) (global.get $super))
      (unreachable)
    )
    (return)
  )

  (func (export "no-br-on-cast-val")
    (block (result anyref)
      (br_on_cast 0 anyref (ref (exact $super)) (global.get $sub))
      (return)
    )
    (unreachable)
  )

  (func (export "yes-br-on-cast-null")
    (block (result anyref)
      (br_on_cast 0 anyref (ref null (exact $super)) (ref.null none))
      (unreachable)
    )
    (return)
  )

  (func (export "no-br-on-cast-null")
    (block (result anyref)
      (br_on_cast 0 anyref (ref (exact $super)) (ref.null none))
      (return)
    )
    (unreachable)
  )

  (func (export "no-br-on-cast-fail-val")
    (block (result anyref)
      (br_on_cast_fail 0 anyref (ref (exact $super)) (global.get $super))
      (return)
    )
    (unreachable)
  )

  (func (export "yes-br-on-cast-fail-val")
    (block (result anyref)
      (br_on_cast_fail 0 anyref (ref (exact $super)) (global.get $sub))
      (unreachable)
    )
    (return)
  )

  (func (export "no-br-on-cast-fail-null")
    (block (result anyref)
      (br_on_cast_fail 0 anyref (ref null (exact $super)) (ref.null none))
      (return)
    )
    (unreachable)
  )

  (func (export "yes-br-on-cast-fail-null")
    (block (result anyref)
      (br_on_cast_fail 0 anyref (ref (exact $super)) (ref.null none))
      (unreachable)
    )
    (return)
  )

  (func (export "yes-ref-test-val") (result i32)
    (ref.test (ref (exact $super)) (global.get $super))
  )
  (func (export "no-ref-test-val") (result i32)
    (ref.test (ref (exact $super)) (global.get $sub))
  )
  (func (export "yes-ref-test-null") (result i32)
    (ref.test (ref null (exact $super)) (ref.null none))
  )
  (func (export "no-ref-test-null") (result i32)
    (ref.test (ref (exact $super)) (ref.null none))
  )
)

(assert_return (invoke "self-nullable") (ref.struct))
(assert_return (invoke "self-nullable-global") (ref.struct))
(assert_return (invoke "self-nullable-call") (ref.struct))
(assert_return (invoke "self-nullable-null") (ref.null none))

(assert_return (invoke "self-nonnullable") (ref.struct))
(assert_return (invoke "self-nonnullable-global") (ref.struct))
(assert_return (invoke "self-nonnullable-call") (ref.struct))
(assert_trap (invoke "self-nonnullable-null") "cast failure")

(assert_trap (invoke "sub-nullable") "cast failure")
(assert_trap (invoke "sub-nullable-global") "cast failure")
(assert_trap (invoke "sub-nullable-call") "cast failure")
(assert_return (invoke "sub-nullable-null") (ref.null none))

(assert_trap (invoke "sub-nonnullable") "cast failure")
(assert_trap (invoke "sub-nonnullable-global") "cast failure")
(assert_trap (invoke "sub-nonnullable-call") "cast failure")
(assert_trap (invoke "sub-nonnullable-null") "cast failure")

(assert_trap (invoke "super-nullable") "cast failure")
(assert_trap (invoke "super-nullable-global") "cast failure")
(assert_trap (invoke "super-nullable-call") "cast failure")
(assert_return (invoke "super-nullable-null") (ref.null none))

(assert_trap (invoke "super-nonnullable") "cast failure")
(assert_trap (invoke "super-nonnullable-global") "cast failure")
(assert_trap (invoke "super-nonnullable-call") "cast failure")
(assert_trap (invoke "super-nonnullable-null") "cast failure")

(assert_return (invoke "yes-br-on-cast-val"))
(assert_return (invoke "no-br-on-cast-val"))
(assert_return (invoke "yes-br-on-cast-null"))
(assert_return (invoke "no-br-on-cast-null"))

(assert_return (invoke "no-br-on-cast-fail-val"))
(assert_return (invoke "yes-br-on-cast-fail-val"))
(assert_return (invoke "no-br-on-cast-fail-null"))
(assert_return (invoke "yes-br-on-cast-fail-null"))

(assert_return (invoke "yes-ref-test-val") (i32.const 1))
(assert_return (invoke "no-ref-test-val") (i32.const 0))
(assert_return (invoke "yes-ref-test-null") (i32.const 1))
(assert_return (invoke "no-ref-test-null") (i32.const 0))

;; Arrays
(module
  (type $super (sub (array i8)))
  (type $sub (sub $super (array i8)))

  (global $super anyref (array.new_fixed $super 0))
  (global $sub anyref (array.new_fixed $sub 0))

  (func $super (result anyref) (array.new_fixed $super 0))
  (func $sub (result anyref) (array.new_fixed $sub 0))

  (func (export "self-nullable") (result anyref)
    (ref.cast (ref null (exact $super)) (array.new_fixed $super 0))
  )
  (func (export "self-nullable-global") (result anyref)
    (ref.cast (ref null (exact $super)) (global.get $super))
  )
  (func (export "self-nullable-call") (result anyref)
    (ref.cast (ref null (exact $super)) (call $super))
  )
  (func (export "self-nullable-null") (result anyref)
    (ref.cast (ref null (exact $super)) (ref.null $super))
  )

  (func (export "self-nonnullable") (result anyref)
    (ref.cast (ref (exact $super)) (array.new_fixed $super 0))
  )
  (func (export "self-nonnullable-global") (result anyref)
    (ref.cast (ref (exact $super)) (global.get $super))
  )
  (func (export "self-nonnullable-call") (result anyref)
    (ref.cast (ref (exact $super)) (call $super))
  )
  (func (export "self-nonnullable-null") (result anyref)
    (ref.cast (ref (exact $super)) (ref.null $super))
  )

  (func (export "sub-nullable") (result anyref)
    (ref.cast (ref null (exact $super)) (array.new_fixed $sub 0))
  )
  (func (export "sub-nullable-global") (result anyref)
    (ref.cast (ref null (exact $super)) (global.get $sub))
  )
  (func (export "sub-nullable-call") (result anyref)
    (ref.cast (ref null (exact $super)) (call $sub))
  )
  (func (export "sub-nullable-null") (result anyref)
    (ref.cast (ref null (exact $super)) (ref.null $sub))
  )

  (func (export "sub-nonnullable") (result anyref)
    (ref.cast (ref (exact $super)) (array.new_fixed $sub 0))
  )
  (func (export "sub-nonnullable-global") (result anyref)
    (ref.cast (ref (exact $super)) (global.get $sub))
  )
  (func (export "sub-nonnullable-call") (result anyref)
    (ref.cast (ref (exact $super)) (call $sub))
  )
  (func (export "sub-nonnullable-null") (result anyref)
    (ref.cast (ref (exact $super)) (ref.null $sub))
  )

  (func (export "super-nullable") (result anyref)
    (ref.cast (ref null (exact $sub)) (array.new_fixed $super 0))
  )
  (func (export "super-nullable-global") (result anyref)
    (ref.cast (ref null (exact $sub)) (global.get $super))
  )
  (func (export "super-nullable-call") (result anyref)
    (ref.cast (ref null (exact $sub)) (call $super))
  )
  (func (export "super-nullable-null") (result anyref)
    (ref.cast (ref null (exact $sub)) (ref.null $super))
  )

  (func (export "super-nonnullable") (result anyref)
    (ref.cast (ref (exact $sub)) (array.new_fixed $super 0))
  )
  (func (export "super-nonnullable-global") (result anyref)
    (ref.cast (ref (exact $sub)) (global.get $super))
  )
  (func (export "super-nonnullable-call") (result anyref)
    (ref.cast (ref (exact $sub)) (call $super))
  )
  (func (export "super-nonnullable-null") (result anyref)
    (ref.cast (ref (exact $sub)) (ref.null $super))
  )

  (func (export "yes-br-on-cast-val")
    (block (result anyref)
      (br_on_cast 0 anyref (ref (exact $super)) (global.get $super))
      (unreachable)
    )
    (return)
  )

  (func (export "no-br-on-cast-val")
    (block (result anyref)
      (br_on_cast 0 anyref (ref (exact $super)) (global.get $sub))
      (return)
    )
    (unreachable)
  )

  (func (export "yes-br-on-cast-null")
    (block (result anyref)
      (br_on_cast 0 anyref (ref null (exact $super)) (ref.null none))
      (unreachable)
    )
    (return)
  )

  (func (export "no-br-on-cast-null")
    (block (result anyref)
      (br_on_cast 0 anyref (ref (exact $super)) (ref.null none))
      (return)
    )
    (unreachable)
  )

  (func (export "no-br-on-cast-fail-val")
    (block (result anyref)
      (br_on_cast_fail 0 anyref (ref (exact $super)) (global.get $super))
      (return)
    )
    (unreachable)
  )

  (func (export "yes-br-on-cast-fail-val")
    (block (result anyref)
      (br_on_cast_fail 0 anyref (ref (exact $super)) (global.get $sub))
      (unreachable)
    )
    (return)
  )

  (func (export "no-br-on-cast-fail-null")
    (block (result anyref)
      (br_on_cast_fail 0 anyref (ref null (exact $super)) (ref.null none))
      (return)
    )
    (unreachable)
  )

  (func (export "yes-br-on-cast-fail-null")
    (block (result anyref)
      (br_on_cast_fail 0 anyref (ref (exact $super)) (ref.null none))
      (unreachable)
    )
    (return)
  )

  (func (export "yes-ref-test-val") (result i32)
    (ref.test (ref (exact $super)) (global.get $super))
  )
  (func (export "no-ref-test-val") (result i32)
    (ref.test (ref (exact $super)) (global.get $sub))
  )
  (func (export "yes-ref-test-null") (result i32)
    (ref.test (ref null (exact $super)) (ref.null none))
  )
  (func (export "no-ref-test-null") (result i32)
    (ref.test (ref (exact $super)) (ref.null none))
  )
)

(assert_return (invoke "self-nullable") (ref.array))
(assert_return (invoke "self-nullable-global") (ref.array))
(assert_return (invoke "self-nullable-call") (ref.array))
(assert_return (invoke "self-nullable-null") (ref.null none))

(assert_return (invoke "self-nonnullable") (ref.array))
(assert_return (invoke "self-nonnullable-global") (ref.array))
(assert_return (invoke "self-nonnullable-call") (ref.array))
(assert_trap (invoke "self-nonnullable-null") "cast failure")

(assert_trap (invoke "sub-nullable") "cast failure")
(assert_trap (invoke "sub-nullable-global") "cast failure")
(assert_trap (invoke "sub-nullable-call") "cast failure")
(assert_return (invoke "sub-nullable-null") (ref.null none))

(assert_trap (invoke "sub-nonnullable") "cast failure")
(assert_trap (invoke "sub-nonnullable-global") "cast failure")
(assert_trap (invoke "sub-nonnullable-call") "cast failure")
(assert_trap (invoke "sub-nonnullable-null") "cast failure")

(assert_trap (invoke "super-nullable") "cast failure")
(assert_trap (invoke "super-nullable-global") "cast failure")
(assert_trap (invoke "super-nullable-call") "cast failure")
(assert_return (invoke "super-nullable-null") (ref.null none))

(assert_trap (invoke "super-nonnullable") "cast failure")
(assert_trap (invoke "super-nonnullable-global") "cast failure")
(assert_trap (invoke "super-nonnullable-call") "cast failure")
(assert_trap (invoke "super-nonnullable-null") "cast failure")

(assert_return (invoke "yes-br-on-cast-val"))
(assert_return (invoke "no-br-on-cast-val"))
(assert_return (invoke "yes-br-on-cast-null"))
(assert_return (invoke "no-br-on-cast-null"))

(assert_return (invoke "no-br-on-cast-fail-val"))
(assert_return (invoke "yes-br-on-cast-fail-val"))
(assert_return (invoke "no-br-on-cast-fail-null"))
(assert_return (invoke "yes-br-on-cast-fail-null"))

(assert_return (invoke "yes-ref-test-val") (i32.const 1))
(assert_return (invoke "no-ref-test-val") (i32.const 0))
(assert_return (invoke "yes-ref-test-null") (i32.const 1))
(assert_return (invoke "no-ref-test-null") (i32.const 0))

;; Functions
(module
  (type $super (sub (func (result funcref))))
  (type $sub (sub $super (func (result funcref))))

  (global $super funcref (ref.func $super))
  (global $sub funcref (ref.func $sub))

  (func $super (type $super) (ref.func $super))
  (func $sub (type $sub) (ref.func $sub))

  (func (export "self-nullable") (result funcref)
    (ref.cast (ref null (exact $super)) (ref.func $super))
  )
  (func (export "self-nullable-global") (result funcref)
    (ref.cast (ref null (exact $super)) (global.get $super))
  )
  (func (export "self-nullable-call") (result funcref)
    (ref.cast (ref null (exact $super)) (call $super))
  )
  (func (export "self-nullable-null") (result funcref)
    (ref.cast (ref null (exact $super)) (ref.null $super))
  )

  (func (export "self-nonnullable") (result funcref)
    (ref.cast (ref (exact $super)) (ref.func $super))
  )
  (func (export "self-nonnullable-global") (result funcref)
    (ref.cast (ref (exact $super)) (global.get $super))
  )
  (func (export "self-nonnullable-call") (result funcref)
    (ref.cast (ref (exact $super)) (call $super))
  )
  (func (export "self-nonnullable-null") (result funcref)
    (ref.cast (ref (exact $super)) (ref.null $super))
  )

  (func (export "sub-nullable") (result funcref)
    (ref.cast (ref null (exact $super)) (ref.func $sub))
  )
  (func (export "sub-nullable-global") (result funcref)
    (ref.cast (ref null (exact $super)) (global.get $sub))
  )
  (func (export "sub-nullable-call") (result funcref)
    (ref.cast (ref null (exact $super)) (call $sub))
  )
  (func (export "sub-nullable-null") (result funcref)
    (ref.cast (ref null (exact $super)) (ref.null $sub))
  )

  (func (export "sub-nonnullable") (result funcref)
    (ref.cast (ref (exact $super)) (ref.func $sub))
  )
  (func (export "sub-nonnullable-global") (result funcref)
    (ref.cast (ref (exact $super)) (global.get $sub))
  )
  (func (export "sub-nonnullable-call") (result funcref)
    (ref.cast (ref (exact $super)) (call $sub))
  )
  (func (export "sub-nonnullable-null") (result funcref)
    (ref.cast (ref (exact $super)) (ref.null $sub))
  )

  (func (export "super-nullable") (result funcref)
    (ref.cast (ref null (exact $sub)) (ref.func $super))
  )
  (func (export "super-nullable-global") (result funcref)
    (ref.cast (ref null (exact $sub)) (global.get $super))
  )
  (func (export "super-nullable-call") (result funcref)
    (ref.cast (ref null (exact $sub)) (call $super))
  )
  (func (export "super-nullable-null") (result funcref)
    (ref.cast (ref null (exact $sub)) (ref.null $super))
  )

  (func (export "super-nonnullable") (result funcref)
    (ref.cast (ref (exact $sub)) (ref.func $super))
  )
  (func (export "super-nonnullable-global") (result funcref)
    (ref.cast (ref (exact $sub)) (global.get $super))
  )
  (func (export "super-nonnullable-call") (result funcref)
    (ref.cast (ref (exact $sub)) (call $super))
  )
  (func (export "super-nonnullable-null") (result funcref)
    (ref.cast (ref (exact $sub)) (ref.null $super))
  )

  (func (export "yes-br-on-cast-val")
    (block (result funcref)
      (br_on_cast 0 funcref (ref (exact $super)) (global.get $super))
      (unreachable)
    )
    (return)
  )

  (func (export "no-br-on-cast-val")
    (block (result funcref)
      (br_on_cast 0 funcref (ref (exact $super)) (global.get $sub))
      (return)
    )
    (unreachable)
  )

  (func (export "yes-br-on-cast-null")
    (block (result funcref)
      (br_on_cast 0 funcref (ref null (exact $super)) (ref.null nofunc))
      (unreachable)
    )
    (return)
  )

  (func (export "no-br-on-cast-null")
    (block (result funcref)
      (br_on_cast 0 funcref (ref (exact $super)) (ref.null nofunc))
      (return)
    )
    (unreachable)
  )

  (func (export "no-br-on-cast-fail-val")
    (block (result funcref)
      (br_on_cast_fail 0 funcref (ref (exact $super)) (global.get $super))
      (return)
    )
    (unreachable)
  )

  (func (export "yes-br-on-cast-fail-val")
    (block (result funcref)
      (br_on_cast_fail 0 funcref (ref (exact $super)) (global.get $sub))
      (unreachable)
    )
    (return)
  )

  (func (export "no-br-on-cast-fail-null")
    (block (result funcref)
      (br_on_cast_fail 0 funcref (ref null (exact $super)) (ref.null nofunc))
      (return)
    )
    (unreachable)
  )

  (func (export "yes-br-on-cast-fail-null")
    (block (result funcref)
      (br_on_cast_fail 0 funcref (ref (exact $super)) (ref.null nofunc))
      (unreachable)
    )
    (return)
  )

  (func (export "yes-ref-test-val") (result i32)
    (ref.test (ref (exact $super)) (global.get $super))
  )
  (func (export "no-ref-test-val") (result i32)
    (ref.test (ref (exact $super)) (global.get $sub))
  )
  (func (export "yes-ref-test-null") (result i32)
    (ref.test (ref null (exact $super)) (ref.null nofunc))
  )
  (func (export "no-ref-test-null") (result i32)
    (ref.test (ref (exact $super)) (ref.null nofunc))
  )
)

(assert_return (invoke "self-nullable") (ref.func))
(assert_return (invoke "self-nullable-global") (ref.func))
(assert_return (invoke "self-nullable-call") (ref.func))
(assert_return (invoke "self-nullable-null") (ref.null nofunc))

(assert_return (invoke "self-nonnullable") (ref.func))
(assert_return (invoke "self-nonnullable-global") (ref.func))
(assert_return (invoke "self-nonnullable-call") (ref.func))
(assert_trap (invoke "self-nonnullable-null") "cast failure")

(assert_trap (invoke "sub-nullable") "cast failure")
(assert_trap (invoke "sub-nullable-global") "cast failure")
(assert_trap (invoke "sub-nullable-call") "cast failure")
(assert_return (invoke "sub-nullable-null") (ref.null nofunc))

(assert_trap (invoke "sub-nonnullable") "cast failure")
(assert_trap (invoke "sub-nonnullable-global") "cast failure")
(assert_trap (invoke "sub-nonnullable-call") "cast failure")
(assert_trap (invoke "sub-nonnullable-null") "cast failure")

(assert_trap (invoke "super-nullable") "cast failure")
(assert_trap (invoke "super-nullable-global") "cast failure")
(assert_trap (invoke "super-nullable-call") "cast failure")
(assert_return (invoke "super-nullable-null") (ref.null nofunc))

(assert_trap (invoke "super-nonnullable") "cast failure")
(assert_trap (invoke "super-nonnullable-global") "cast failure")
(assert_trap (invoke "super-nonnullable-call") "cast failure")
(assert_trap (invoke "super-nonnullable-null") "cast failure")

(assert_return (invoke "yes-br-on-cast-val"))
(assert_return (invoke "no-br-on-cast-val"))
(assert_return (invoke "yes-br-on-cast-null"))
(assert_return (invoke "no-br-on-cast-null"))

(assert_return (invoke "no-br-on-cast-fail-val"))
(assert_return (invoke "yes-br-on-cast-fail-val"))
(assert_return (invoke "no-br-on-cast-fail-null"))
(assert_return (invoke "yes-br-on-cast-fail-null"))

(assert_return (invoke "yes-ref-test-val") (i32.const 1))
(assert_return (invoke "no-ref-test-val") (i32.const 0))
(assert_return (invoke "yes-ref-test-null") (i32.const 1))
(assert_return (invoke "no-ref-test-null") (i32.const 0))
