#!/bin/bash
set -ueo pipefail

CC=${CC:=clang}

for input in testsuite/*.c; do
  output="testsuite/$(basename $input .c).wasm"

  if [ "$input" -nt "$output" ]; then
    echo "Compiling $input"
    $CC --target=wasm32-wasip1 "$input" -o "$output"
  fi
done
