/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */
import Component from '@glimmer/component';
import type { HdsApplicationStateSignature } from '@hashicorp/design-system-components/components/hds/application-state/index';
import './secrets-sync.scss';
export interface SecretsSyncSignature {
    Args: {
        totalDestinations: number;
        destinations: Record<string, number>;
    };
    Blocks: {
        default: [];
        /** We optionally yield application state to allow for overrides on empty state eg:
         * <SSUReportingSecretsSync ...>
         *   <:empty as |A|>
         *     <A.Header @title="Custom Title" />
         *     <A.Body @text="Custom description" />
         *   </:empty>
         * </SSUReportingSecretsSync>
         * */
        empty: HdsApplicationStateSignature['Blocks']['default'];
    };
    Element: HTMLElement;
}
export default class SecretsSync extends Component<SecretsSyncSignature> {
    get hasData(): boolean;
    get description(): import("@ember/template").SafeString | undefined;
    get linkRoute(): "vault.cluster.sync" | undefined;
    get totalDestinations(): number;
    get destinationsList(): {
        name: string;
        count: number;
    }[];
}
