/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */
import './searchable-multi-select.scss';
import Component from '@glimmer/component';
import type { Filter } from '../../../utils/filters';
import type ReportingApiService from '../../../services/reporting-api';
import type Owner from '@ember/owner';
export interface DynamicMultiSelectSignature {
    Args: {
        appliedFilters: Record<string, Filter>;
        name: string;
        label: string;
        placeholder?: string;
        onSearch?: (search: string) => Promise<{
            name: string;
            value: string;
        }[]>;
    };
    Blocks: {
        default: [];
    };
    Element: HTMLElement;
}
export default class DynamicMultiSelect extends Component<DynamicMultiSelectSignature> {
    readonly reportingApi: ReportingApiService;
    results: {
        name: string;
        value: string;
    }[];
    search: string;
    isLoading: boolean;
    private timer?;
    constructor(owner: Owner, args: DynamicMultiSelectSignature['Args']);
    private handleSearch;
    handleDebouncedSearch: (search: string) => void;
    handleSearchInput: (event: Event) => void;
    handleSearchKeyDown: (event: KeyboardEvent) => void;
    isCheckboxChecked: (name: string, value: string) => boolean;
    get combinedResults(): {
        name: string | number | boolean | undefined;
        value: string;
    }[];
    get isEmpty(): boolean;
}
