
import Controller from '@ember/controller';
import { tracked } from '@glimmer/tracking';
import { g, i } from 'decorator-transforms/runtime';

/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */

class ReportingInventoryController extends Controller {
  queryParams = ['cluster', 'filters', 'sortingOrderBy', 'visibleColumns', 'pagination.page_size', 'pagination.next_page_token', 'pagination.previous_page_token'];
  static {
    g(this.prototype, "cluster", [tracked], function () {
      return '';
    });
  }
  #cluster = (i(this, "cluster"), void 0);
  static {
    g(this.prototype, "filters", [tracked], function () {
      return [];
    });
  }
  #filters = (i(this, "filters"), void 0);
  static {
    g(this.prototype, "pagination", [tracked], function () {
      return {
        page_size: 10
      };
    });
  }
  #pagination = (i(this, "pagination"), void 0);
  static {
    g(this.prototype, "sortingOrderBy", [tracked], function () {
      return [];
    });
  }
  #sortingOrderBy = (i(this, "sortingOrderBy"), void 0);
  static {
    g(this.prototype, "visibleColumns", [tracked], function () {
      return [];
    });
  }
  #visibleColumns = (i(this, "visibleColumns"), void 0);
  handleApplyFilter = filters => {
    this.filters = filters;
    // Reset pagination when filters change
    this.resetPagination();
  };
  resetPagination = () => {
    this.pagination = {
      page_size: 10
    };
  };
  handlePageChange = pagination => {
    this.pagination = pagination;
  };
  handleApplySort = orderBy => {
    this.sortingOrderBy = orderBy;
    this.resetPagination();
  };
  handleColumnsChanged = visibleColumns => {
    this.visibleColumns = visibleColumns;
  };
  getClusterLinkParams = cluster => {
    return {
      filters: [],
      sortingOrderBy: [],
      pagination: {
        page_size: 10
      },
      cluster
    };
  };
}

export { ReportingInventoryController as default };
//# sourceMappingURL=secrets-inventory.js.map
