/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */
import './secret-inventory.scss';
import Component from '@glimmer/component';
import { type Filter } from '../../..//utils/filters.ts';
import { type InventoryTableColumn, type QuickFilter } from '../inventory-table';
import { type FilterFieldDefinition } from '../filter-bar';
import type ReportingApiService from '../../../services/reporting-api.ts';
import type { VaultReportingServiceApiFetchSecretsInventoryRequest } from '../../../clients/cloud-vault-reporting/src';
type SecretInventoryFilter = Filter<VaultReportingServiceApiFetchSecretsInventoryRequest>;
export interface SecretInventorySignature {
    Args: {
        onFilterApplied: (value: SecretInventoryFilter[]) => void;
        onSortApplied: (sort: string[]) => void;
        appliedFilters: SecretInventoryFilter[];
        appliedSort: string[];
        onPageChange: (pagination: {
            next_page_token?: string;
            previous_page_token?: string;
            page_size: number;
        }) => void;
        pageSize: number;
        nextPageToken?: string;
        previousPageToken?: string;
        activeCluster: string;
        visibleColumns?: string[];
        onColumnsChanged?: (visibleColumns: string[]) => void;
    };
    Blocks: {
        actions: [];
    };
    Element: HTMLElement;
}
export default class SecretInventory extends Component<SecretInventorySignature> {
    readonly reportingApi: ReportingApiService;
    page: Record<string, unknown>[];
    isLoading: boolean;
    isError: boolean;
    isEmpty: boolean;
    nextPageToken?: string;
    previousPageToken?: string;
    pageSize: number;
    totalUnfilteredCount: number;
    isDownloadModalOpen: boolean;
    lastRequest?: VaultReportingServiceApiFetchSecretsInventoryRequest;
    handlePageSizeChange: (newPageSize: number) => void;
    lastUpdatedTime: string;
    quickFilters: QuickFilter[];
    filterFieldDefinitions: FilterFieldDefinition<VaultReportingServiceApiFetchSecretsInventoryRequest>[];
    columns: InventoryTableColumn[];
    get visibleColumnKeys(): string[];
    handleColumnsChanged: (visibleColumnKeys: string[]) => void;
    get visibleColumns(): InventoryTableColumn[];
    fetchQuickFilterCount: (filter: QuickFilter) => Promise<QuickFilter>;
    fetchQuickFilterCounts: () => Promise<void>;
    handleDataUpdate: (filters: Filter[]) => Promise<void>;
    handleDownload: () => Promise<Record<string, unknown>[]>;
    closeDownloadModal: () => void;
    openDownloadModal: () => void;
}
export {};
