/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */
import Component from '@glimmer/component';
import './namespace-picker.scss';
export interface SSUNamespacePickerSignature {
    Args: {
        namespaces: string[];
        onNamespaceChange: (namespace: string) => void;
    };
    Blocks: {
        default: [];
    };
    Element: HTMLElement;
}
export default class SSUNamespacePicker extends Component<SSUNamespacePickerSignature> {
    selectedNamespace: string;
    search: string;
    get filteredNamespaces(): string[];
    handleNamespaceSelection: (namespace: string, close?: () => void) => void;
    handleSearchInput: (event: Event) => void;
}
