
import Route from '@ember/routing/route';

/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */

class ReportingInventoryRoute extends Route {
  queryParams = {
    cluster: {
      replace: true,
      refreshModel: false
    },
    filters: {
      replace: true,
      refreshModel: false
    },
    pagination: {
      replace: true,
      refreshModel: false
    },
    sortingOrderBy: {
      replace: true,
      refreshModel: false
    },
    visibleColumns: {
      replace: true,
      refreshModel: false
    }
  };
  resetController(controller, isExiting) {
    if (isExiting) {
      // reset params
      controller.set('cluster', '');
      controller.set('filters', []);
      controller.set('pagination', {
        page_size: null,
        next_page_token: null,
        previous_page_token: null
      });
      controller.set('sortingOrderBy', []);
      controller.set('visibleColumns', []);
    }
  }
}

export { ReportingInventoryRoute as default };
//# sourceMappingURL=secrets-inventory.js.map
