/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */
import type { FilterFieldName } from '../components/vault-reporting/filter-bar';
export interface Filter<T = Record<string, unknown>> {
    field: Extract<keyof FilterFieldName<T>, string>;
    operator: '>' | '<' | '=';
    value: {
        type: 'string' | 'date' | 'duration' | 'list' | 'boolean';
        value: string | number | string[] | boolean;
    };
}
type FilterMap = {
    [key: string]: string | number | Date;
};
export declare const flattenFilters: <T = FilterMap>(filters?: Filter[]) => T;
declare const filters: {
    flattenFilters: <T = FilterMap>(filters?: Filter[]) => T;
};
export default filters;
