
/**
 * Returns a route name that is safe to use with @route.
 * - If the provided route exists, returns it.
 * - If it does not exist, returns the fallback.
 * - If route is undefined/empty, returns undefined.
 *
 * NOTE: The links will render but they won't actually work within this repo. This is
 * intentional so that design/layout can be validated without running into errors.
 */
function safeRoute(router, route, fallback = 'application') {
  if (!route) return undefined;
  try {
    router.urlFor(route);
    return route;
  } catch {
    return fallback;
  }
}

export { safeRoute as default, safeRoute };
//# sourceMappingURL=safe-route.js.map
