
import Component from '@glimmer/component';
import { HdsFormTextInputField, HdsDropdown } from '@hashicorp/design-system-components/components';
import { tracked } from '@glimmer/tracking';
import { on } from '@ember/modifier';
import { fn } from '@ember/helper';
import { eq } from '../../utils/helpers.js';
import { precompileTemplate } from '@ember/template-compilation';
import { setComponentTemplate } from '@ember/component';
import { g, i } from 'decorator-transforms/runtime';

/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */
class SSUNamespacePicker extends Component {
  static {
    g(this.prototype, "selectedNamespace", [tracked], function () {
      return this.args.namespaces[0] || '';
    });
  }
  #selectedNamespace = (i(this, "selectedNamespace"), void 0);
  static {
    g(this.prototype, "search", [tracked], function () {
      return '';
    });
  }
  #search = (i(this, "search"), void 0);
  get filteredNamespaces() {
    if (!this.search) return this.args.namespaces;
    return this.args.namespaces.filter(ns => ns.toLowerCase().includes(this.search.toLowerCase()));
  }
  handleNamespaceSelection = (namespace, close = () => {}) => {
    this.selectedNamespace = namespace;
    this.args.onNamespaceChange(namespace);
    close();
  };
  handleSearchInput = event => {
    const input = event.target;
    this.search = input.value;
  };
  static {
    setComponentTemplate(precompileTemplate("\n    <HdsDropdown data-test-vault-reporting-namespace-picker class=\"ssu-namespace-picker\" @height=\"300px\" @listPosition=\"bottom-left\" as |D|>\n      <D.ToggleButton @color=\"secondary\" @text={{this.selectedNamespace}} />\n      <D.Header class=\"ssu-namespace-picker__header\" @hasDivider={{true}}>\n        <HdsFormTextInputField data-test-vault-reporting-namespace-search @type=\"search\" placeholder=\"Search\" @value={{this.search}} {{on \"input\" this.handleSearchInput}} />\n      </D.Header>\n\n      {{#each this.filteredNamespaces as |ns|}}\n        <D.Checkmark data-test-vault-reporting-namespace-menu-item={{ns}} @selected={{eq ns this.selectedNamespace}} {{on \"click\" (fn this.handleNamespaceSelection ns D.close)}}>\n          {{ns}}\n        </D.Checkmark>\n      {{/each}}\n    </HdsDropdown>\n  ", {
      strictMode: true,
      scope: () => ({
        HdsDropdown,
        HdsFormTextInputField,
        on,
        eq,
        fn
      })
    }), this);
  }
}

export { SSUNamespacePicker as default };
//# sourceMappingURL=namespace-picker.js.map
