import Component from '@glimmer/component';
import type { FilterFieldControl } from '../filter-bar';
import type { Filter } from '../../../utils/filters';
export interface FilterControlSignature {
    Args: {
        filter: FilterFieldControl;
        appliedFilters: Record<string, Filter>;
    };
    Blocks: {
        default: [];
    };
    Element: HTMLElement;
}
export default class FilterControl extends Component<FilterControlSignature> {
    isCheckboxChecked: (name: string, value: string) => boolean;
    isLookbackChecked: (name: string, value: string) => boolean;
    getValue: (name: string) => string;
    getOperator: (name: string) => "" | ">" | "<" | "=";
}
