
import { FetchSecretsInventoryFilterConfigLastModifiedAtOperatorEnum } from '../clients/cloud-vault-reporting/src/apis/VaultReportingServiceApi.js';

/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */

const flattenFilters = (filters = []) => {
  return filters.reduce((acc, filter) => {
    const {
      field,
      operator,
      value
    } = filter;
    const key = `filter${field.charAt(0).toUpperCase()}${field.slice(1)}`;
    const dateOperators = {
      '>': FetchSecretsInventoryFilterConfigLastModifiedAtOperatorEnum.GREATER_THAN,
      '<': FetchSecretsInventoryFilterConfigLastModifiedAtOperatorEnum.LESS_THAN
    };
    if (value.type === 'duration') {
      const serializedOperator = dateOperators[operator];
      acc[`${key}Operator`] = serializedOperator;
      acc[`${key}RelativeToNow`] = value.value;
    } else {
      acc[key] = value.value;
    }
    return acc;
  }, {});
};

// Export both named and default to satisfy different import patterns
const filters = {
  flattenFilters
};

export { filters as default, flattenFilters };
//# sourceMappingURL=filters.js.map
