
import Component from '@glimmer/component';
import { HdsFormCheckboxGroup, HdsFormTextInputField } from '@hashicorp/design-system-components/components';
import { tracked } from '@glimmer/tracking';
import { on } from '@ember/modifier';
import { service } from '@ember/service';
import { precompileTemplate } from '@ember/template-compilation';
import { setComponentTemplate } from '@ember/component';
import { g, i } from 'decorator-transforms/runtime';

/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */
const DEBOUNCE_DELAY = 500;
class DynamicMultiSelect extends Component {
  static {
    g(this.prototype, "reportingApi", [service]);
  }
  #reportingApi = (i(this, "reportingApi"), void 0);
  static {
    g(this.prototype, "results", [tracked], function () {
      return [];
    });
  }
  #results = (i(this, "results"), void 0);
  static {
    g(this.prototype, "search", [tracked], function () {
      return '';
    });
  }
  #search = (i(this, "search"), void 0);
  static {
    g(this.prototype, "isLoading", [tracked], function () {
      return false;
    });
  }
  #isLoading = (i(this, "isLoading"), void 0);
  timer;
  constructor(owner, args) {
    super(owner, args);
    void this.handleSearch('');
  }
  handleSearch = async search => {
    if (!this.args.onSearch) {
      this.results = [];
      return;
    }
    this.isLoading = true;
    try {
      this.results = await this.args.onSearch(search);
    } finally {
      this.isLoading = false;
    }
  };
  handleDebouncedSearch = search => {
    if (this.timer) {
      clearTimeout(this.timer);
      this.timer = undefined;
    }
    this.timer = setTimeout(() => {
      void this.handleSearch(search);
    }, DEBOUNCE_DELAY);
  };
  handleSearchInput = event => {
    const input = event.target;
    this.handleDebouncedSearch(input.value);
  };
  handleSearchKeyDown = event => {
    if (event.key === 'Enter') {
      event.preventDefault();
      // skip debouncing when enter is pressed
      void this.handleSearch(this.search);
    }
  };
  isCheckboxChecked = (name, value) => {
    const appliedFilter = this.args.appliedFilters[name];
    const rawValue = appliedFilter?.value?.value;
    if (!rawValue) {
      return false;
    }
    if (Array.isArray(rawValue)) {
      return rawValue.includes(value);
    }
    if (typeof rawValue === 'string') {
      return rawValue === value;
    }
    return false;
  };
  // If there were previously applied filters they might not exist in the search results so we want to include them
  // in the displayed values and deduplicate from the search results themselves
  get combinedResults() {
    const appliedValues = [this.args.appliedFilters[this.args.name]?.value?.value].flat().map(value => {
      return {
        name: value,
        value: value
      };
    }).filter(item => item.name && item.value);
    return [...appliedValues, ...this.results.filter(result => {
      return !appliedValues.some(applied => applied.value === result.value);
    })];
  }
  static {
    setComponentTemplate(precompileTemplate("\n    <div class=\"searchable-multi-select\" data-test-vault-reporting-searchable-multi-select>\n      <HdsFormTextInputField data-test-vault-reporting-searchable-multi-select-search-input class=\"searchable-multi-select__search\" @type=\"search\" placeholder={{@placeholder}} @value={{this.search}} @isLoading={{this.isLoading}} {{on \"keydown\" this.handleSearchKeyDown}} {{on \"input\" this.handleSearchInput}} />\n      <HdsFormCheckboxGroup as |G|>\n        {{#each this.combinedResults as |option|}}\n          <G.CheckboxField data-test-vault-reporting-searchable-multi-select-option={{option.value}} class=\"searchable-multi-select__option\" name={{@name}} @value={{option.value}} checked={{this.isCheckboxChecked @name option.value}} as |F|><F.Label data-test-vault-reporting-searchable-multi-select-label={{option.value}}>{{option.name}}</F.Label></G.CheckboxField>\n        {{/each}}\n      </HdsFormCheckboxGroup>\n    </div>\n  ", {
      strictMode: true,
      scope: () => ({
        HdsFormTextInputField,
        on,
        HdsFormCheckboxGroup
      })
    }), this);
  }
}

export { DynamicMultiSelect as default };
//# sourceMappingURL=searchable-multi-select.js.map
