import type { OptionsReader } from "../options.js";
import type { Options } from "../options.js";
import { type Logger } from "#utils";
/**
 * Obtains option values from typedoc.json
 */
export declare class TypeDocReader implements OptionsReader {
    /**
     * Should run before the tsconfig reader so that it can specify a tsconfig file to read.
     */
    order: number;
    name: string;
    supportsPackages: boolean;
    /**
     * Read user configuration from a typedoc.json or typedoc.js configuration file.
     */
    read(container: Options, logger: Logger, cwd: string, usedFile: (path: string) => void): Promise<void>;
    /**
     * Read the given options file + any extended files.
     * @param file
     * @param container
     * @param logger
     */
    private readFile;
    /**
     * Search for the configuration file given path
     *
     * @param  path Path to the typedoc.(js|json) file. If path is a directory
     *   typedoc file will be attempted to be found at the root of this path
     * @returns the typedoc.(js|json) file path or undefined
     */
    private findTypedocFile;
}
