import { ConverterComponent } from "../components.js";
import type { CommentDisplayPart, Reflection } from "../../models/index.js";
import type { Converter } from "../converter.js";
/**
 * Handles `@include` and `@includeCode` within comments/documents.
 */
export declare class IncludePlugin extends ConverterComponent {
    get logger(): import("#utils").Logger;
    constructor(owner: Converter);
    private onCreate;
    checkIncludeTagsParts(refl: Reflection, relative: string, parts: CommentDisplayPart[], included?: string[]): void;
    getRegions(refl: Reflection, file: string, ext: string, textPart: string, text: string, regionTargets: string, tag: string, ignoreIndent: boolean): string;
    getLines(refl: Reflection, file: string, textPart: string, text: string, requestedLines: string, tag: string): string;
}
