package mpeg4video

import (
	"testing"

	"github.com/stretchr/testify/require"
)

var casesIsValidConfig = []struct {
	name string
	byts []byte
}{
	{
		"a",
		[]byte{
			0x00, 0x00, 0x01, 0xb0, 0x01, 0x00, 0x00, 0x01,
			0xb5, 0x89, 0x13, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x01, 0x20, 0x00, 0xc4, 0x8d, 0x88, 0x00,
			0xf5, 0x3c, 0x04, 0x87, 0x14, 0x43, 0x00, 0x00,
			0x01, 0xb2, 0x4c, 0x61, 0x76, 0x63, 0x36, 0x30,
			0x2e, 0x32, 0x33, 0x2e, 0x31, 0x30, 0x30,
		},
	},
	{
		"b",
		[]byte{
			0x00, 0x00, 0x01, 0xb0, 0x01, 0x00, 0x00, 0x01,
			0xb5, 0x89, 0x13, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x01, 0x20, 0x00, 0xc4, 0x8d, 0x88, 0x00,
			0xcd, 0x0c, 0x04, 0x24, 0x14, 0x63, 0x00, 0x00,
			0x01, 0xb2, 0x4c, 0x61, 0x76, 0x63, 0x35, 0x32,
			0x2e, 0x35, 0x39, 0x2e, 0x30,
		},
	},
}

func TestIsValidConfig(t *testing.T) {
	for _, ca := range casesIsValidConfig {
		t.Run(ca.name, func(t *testing.T) {
			err := IsValidConfig(ca.byts)
			require.NoError(t, err)
		})
	}
}

func FuzzIsValidConfig(f *testing.F) {
	for _, ca := range casesIsValidConfig {
		f.Add(ca.byts)
	}

	f.Fuzz(func(_ *testing.T, b []byte) {
		IsValidConfig(b) //nolint:errcheck
	})
}
